/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_CLIENT_INTERFACE_H_
#define __LADCCA_CLIENT_INTERFACE_H_

#include <ladcca/types.h>
#include <ladcca/protocol.h>

#ifdef __cplusplus
extern "C" {
#endif

#define cca_enabled(client)  ((client) && cca_server_connected (client))

/** extract ladcca-specific arguments from argc/argv.
 * this should be done before the client checks them, obviously
 */
cca_args_t   * cca_extract_args (int * argc, char *** argv);

/** open a connection to the server
 * returns NULL on failure
 */
cca_client_t * cca_init (cca_args_t * args, const char * client_class, int client_flags, cca_protocol_t protocol); 

/** get the hostname of the server
 */
const char * cca_get_server_name (cca_client_t * client);

/** get the number of pending events
 */
unsigned int   cca_get_pending_event_count (cca_client_t * client);

/** retrieve an event
 * the event must be freed using cca_event_destroy
 * returns NULL if there are no events pending
 */
cca_event_t *  cca_get_event (cca_client_t * client);

/** get the number of pending configs
 */
unsigned int   cca_get_pending_config_count (cca_client_t * client);

/** retrieve a config
 * the config must be freed using cca_config_destroy
 * returns NULL if there are no configs pending
 */
cca_config_t * cca_get_config (cca_client_t * client);

/** send an event to the server
 * the event must be created using cca_event_new or cca_event_new_with_type.
 * the program takes over ownership of the memory and it should not be freed
 * by the client.
 */
void cca_send_event  (cca_client_t * client, cca_event_t * event);

/** send some data to the server
 * the config must be created using cca_config_new, cca_config_new_with_key
 * or cca_config_dup.  the program takes over ownership of the memory and
 * it should not be freed by the client.
 */
void cca_send_config (cca_client_t * client, cca_config_t * config);

/** check whether the server is connected
 * returns 1 if the server is still connected or 0 if it isn't
 */
int cca_server_connected (cca_client_t * client);

/** tell the server the client's jack client name */
void cca_jack_client_name (cca_client_t * client, const char * name);

/** tell the server the client's alsa client id */
void cca_alsa_client_id (cca_client_t * client, unsigned char id);

#ifdef __cplusplus
}
#endif


#endif /* __LADCCA_CLIENT_INTERFACE_H_ */
