/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_CONFIG_H__
#define __LADCCA_CONFIG_H__

#include <stdlib.h>
#include <stdint.h>
#include <sys/types.h>

#include <ladcca/ladcca.h>

#ifdef __cplusplus
extern "C" {
#endif

cca_config_t * cca_config_new          (void);
cca_config_t * cca_config_dup          (const cca_config_t * config);
cca_config_t * cca_config_new_with_key (const char * key);
void           cca_config_destroy      (cca_config_t * config);


const char * cca_config_get_key        (const cca_config_t * config);
const void * cca_config_get_value      (const cca_config_t * config);
size_t       cca_config_get_value_size (const cca_config_t * config);

void cca_config_set_key   (cca_config_t * config, const char * key);
void cca_config_set_value (cca_config_t * config, const void * value, size_t value_size);



/*
 * with these functions, no type checking is done; you can do
 * cca_config_get_value_int on a config that was set with
 * cca_config_set_value_float.
 *
 * the int values are converted to and from network byte order as
 * appropriate
 */
uint32_t     cca_config_get_value_int    (const cca_config_t * config);
float        cca_config_get_value_float  (const cca_config_t * config);
double       cca_config_get_value_double (const cca_config_t * config);
const char * cca_config_get_value_string (const cca_config_t * config);

void cca_config_set_value_int    (cca_config_t * config, uint32_t value);
void cca_config_set_value_float  (cca_config_t * config, float value);
void cca_config_set_value_double (cca_config_t * config, double value);
void cca_config_set_value_string (cca_config_t * config, const char * value);

#ifdef __cplusplus
}
#endif

#endif /* __LADCCA_CONFIG_H__ */
