#define LDMSTRSZ 256

#include "ldm-getenv-bool.h"

struct ldm_info {
    char    server[LDMSTRSZ];
    char    vty[LDMSTRSZ];
    char    display[LDMSTRSZ];
    char    override_port[LDMSTRSZ];
    char    authfile[LDMSTRSZ];
    char    username[LDMSTRSZ];
    char    password[LDMSTRSZ];
    char    lang[LDMSTRSZ];
    char    session[LDMSTRSZ];
    char    sound_daemon[LDMSTRSZ];
    char    greeter_prog[LDMSTRSZ];
    char    control_socket[LDMSTRSZ];
    char    ipaddr[LDMSTRSZ];
    int     autologin;
    int     allowguest;
    int     sound;
    int     localdev;
    int     directx;
    int     sshfd;
    int     greeterrfd;
    int     greeterwfd;
    pid_t   sshpid;
    GPid    xserverpid;
    GPid    greeterpid;
};

/* forward decls */

void usage();
void die(char *msg);
void dump_cmdline(char *argv[]);
pid_t ldm_spawn (char **argv);
char *scopy(char *dest, char *source);
int ldm_wait (pid_t pid);
void create_xauth();
void launch_x();
int get_userid();
int get_passwd();
void spawn_ssh(int fd);
int ssh_session();
int ssh_endsession();
void get_ipaddr();
void clean_username();
void clean_password();
void spawn_greeter();
int get_host();
int get_language();
int get_session();
void set_message(char *message);
void close_greeter();

extern struct ldm_info ldminfo;
extern FILE *ldmlog;

#define NOWAIT 0
#define WAIT 1
#define MAXARGS 32
#define SENTINEL "LTSPROCKS"
#define MAXEXP 4096
#define ENVSIZE 64
