/* ----------------------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under 
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(store/force,FixStoreForce)

#else

#ifndef LMP_FIX_STORE_FORCE_H
#define LMP_FIX_STORE_FORCE_H

#include "fix.h"

namespace LAMMPS_NS {

class FixStoreForce : public Fix {
 public:
  FixStoreForce(class LAMMPS *, int, char **);
  ~FixStoreForce();
  int setmask();
  void init();
  void setup(int);
  void min_setup(int);
  void post_force(int);
  void post_force_respa(int, int, int);
  void min_post_force(int);
  double memory_usage();

 private:
  int nlevels_respa;
  int nmax;
  double **foriginal;         // stored force on atoms
};

}

#endif
#endif
