/* ----------------------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under 
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(print,FixPrint)

#else

#ifndef LMP_FIX_PRINT_H
#define LMP_FIX_PRINT_H

#include "stdio.h"
#include "fix.h"

namespace LAMMPS_NS {

class FixPrint : public Fix {
 public:
  FixPrint(class LAMMPS *, int, char **);
  ~FixPrint();
  int setmask();
  void end_of_step();

 private:
  int me,screenflag;
  FILE *fp;
  char *string,*copy,*work;
};

}

#endif
#endif
