// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

// QT
#include <qmessagebox.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qfile.h>
#include <qlabel.h>

#include "utils.h"

// Classess
extern TUtils *Util;
extern TAutoMark *AutoMark;

// Global variables
extern idx_record AutoMarkTable[20];
extern TAttrs FormAttrsTb[10];
extern QString PrgPath;

void TAutoMark::showEvent( QShowEvent *evt )
{
  int i,j;
  
  if ( ! evt->spontaneous ()  )
  {
    QFont fi;
    QColor color; //(MsgList->paletteBackgroundColor());
  
    fi.setFamily(FormAttrsTb[7].FontAttrs.Name);
    fi.setPointSize(FormAttrsTb[7].FontAttrs.Size);
  
    fi.setFixedPitch(FormAttrsTb[7].FontAttrs.Pitch);
    fi.setBold(FormAttrsTb[7].FontAttrs.Bold);
    fi.setItalic(FormAttrsTb[7].FontAttrs.Italic);
    AutoMarkTbl->setFont( fi );

    color.setNamedColor(FormAttrsTb[7].FormAttrs.Color);
    AutoMarkTbl->setPaletteBackgroundColor(color);
    AutoMarkTbl->setPaletteForegroundColor (FormAttrsTb[7].FontAttrs.Color); // Font Color
  
    move( FormAttrsTb[7].FormAttrs.x, FormAttrsTb[7].FormAttrs.y );
    resize( FormAttrsTb[7].FormAttrs.width, FormAttrsTb[7].FormAttrs.height );
    
    while (AutoMarkTbl->numRows() > 0) AutoMarkTbl->removeRow(0);
    
    j = Util->LoadAutoMarkTbl();
    AutoMarkTbl->insertRows( 0,1 );
    
    for (i=0;i<j;i++)
    {
      AutoMarkTbl->setText(i,0, AutoMarkTable[i].to_a);
      AutoMarkTbl->setText(i,1, AutoMarkTable[i].at);
      AutoMarkTbl->setText(i,2, AutoMarkTable[i].from);
      AutoMarkTbl->setText(i,3, AutoMarkTable[i].subject);
      AutoMarkTbl->insertRows( i+1,1 );
    }
  } 

/*  AutoMarkTbl->adjustColumn(0);
  AutoMarkTbl->adjustColumn(1);
  AutoMarkTbl->adjustColumn(2);
  AutoMarkTbl->adjustColumn(3);*/
}



void TAutoMark::hideEvent( QHideEvent *e )
{
  QString tmp;
  int row;

  if ( ! e->spontaneous ()  )    UpdateFormAttrs();
  
  QFile fl ( PrgPath + "conf/AutoMark_new" );
  if ( fl.open( IO_WriteOnly ) )
  {
	  QTextStream stream ( &fl );
	  for (row = 0;row<=AutoMarkTbl->numRows()-1;row++)
	  {
		  tmp =  AutoMarkTbl->text(row, 0) + ";";
		  tmp += AutoMarkTbl->text(row, 1) + ";";
		  tmp += AutoMarkTbl->text(row, 2) + ";";
		  tmp += AutoMarkTbl->text(row, 3);
		  if (tmp != ";;;") stream << tmp << "\n";
	  }
	  fl.close();   
  }

}


void TAutoMark::UpdateFormAttrs()
{
  QFontInfo fi (AutoMarkTbl->font());
  QColor font_color(AutoMarkTbl->foregroundColor());
  QColor background(AutoMarkTbl->paletteBackgroundColor());
  
  FormAttrsTb[7].FontAttrs.Name      =  fi.family();
  FormAttrsTb[7].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[7].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[7].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[7].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[7].FontAttrs.Italic    =  fi.italic();

  FormAttrsTb[7].FormAttrs.Color  =  AutoMarkTbl->paletteBackgroundColor().name();
  FormAttrsTb[7].FormAttrs.x      =  AutoMark->x();
  FormAttrsTb[7].FormAttrs.y      =  AutoMark->y();
  FormAttrsTb[7].FormAttrs.height =  AutoMark->height();
  FormAttrsTb[7].FormAttrs.width  =  AutoMark->width();

}


void TAutoMark::addRow( int row )
{
	AutoMarkTbl->insertRows(row,1);
}


void TAutoMark::deleteRow( int row )
{
	AutoMarkTbl->removeRow(row);
}


void TAutoMark::contextMenuRequested( int row, int , const QPoint & )
{
	int i;
	
	QPopupMenu* contextMenu = new QPopupMenu( this );
	Q_CHECK_PTR( contextMenu );
	QLabel *caption = new QLabel( "AutoMark actions", this );
	caption->setAlignment( Qt::AlignCenter );
	contextMenu->insertItem( caption );
	contextMenu->insertSeparator();
	i = contextMenu->insertItem( "&New entry",  this, SLOT(addRow(int)), CTRL+Key_N );
	contextMenu->setItemParameter ( i, row );
	i = contextMenu->insertItem( "&Delete entry",  this, SLOT(deleteRow(int)), CTRL+Key_D );
	contextMenu->setItemParameter ( i, row );
	contextMenu->insertSeparator();
	contextMenu->insertItem( "Change Background &color",  this, SLOT(colorChange()), CTRL+Key_C );
	contextMenu->insertItem( "Change &font",  this, SLOT(fontChange()), CTRL+Key_F );
	contextMenu->exec( QCursor::pos() );
	delete contextMenu;

}


void TAutoMark::colorChange()
{
	QColor colorTmp = QColorDialog::getColor( AutoMarkTbl->paletteBackgroundColor () );
	if ( colorTmp.isValid() ) AutoMarkTbl->setPaletteBackgroundColor( colorTmp );
	UpdateFormAttrs();

}


void TAutoMark::fontChange()
{
	AutoMarkTbl->setFont( QFontDialog::getFont( 0, AutoMarkTbl->font() ) );
	UpdateFormAttrs();

}
