#include <stdio.h>
#include <fcntl.h>
#ifdef GSM
#	include <gsm.h>
#endif
#include "wav_lib.h"
#include "version.h"
#include "tellhow.h"
#include "timer.h"

wav_sig *file_info;
long count;

/* GSM stuff */

#ifdef GSM

struct {
	gsm handle;
	gsm_frame buf;
	gsm_signal sample[160];
} gsm_info;

#endif

void tellhow(int argc, char *argv[]){
	printf(BRAG, MAJ, MIN);
	printf(WAVP, argv[0]);
}

void report(){
	printf(BRAG, MAJ, MIN);

 	printf(PLAYING,
	file_info->name,
	file_info->len,
	file_info->srate,
	file_info->bps,
	file_info->depth,
	file_info->chans);

}

int init_dsp(wav_sig *file_info){
	int i, p;

	dsp_fd = open("/dev/dsp", O_WRONLY, 0);

	ioctl(dsp_fd, SNDCTL_DSP_RESET, 0);

	p =  file_info->depth;
	i =  ioctl(dsp_fd, SOUND_PCM_WRITE_BITS, &p);

	p =  file_info->chans;
	i += ioctl(dsp_fd, SOUND_PCM_WRITE_CHANNELS, &p);

	p =  file_info->srate;
	i += ioctl(dsp_fd, SOUND_PCM_WRITE_RATE, &p);

	i += ioctl(dsp_fd, SNDCTL_DSP_GETBLKSIZE, &bsize);
	
	ioctl(dsp_fd, SNDCTL_DSP_SYNC, 0);

	return(i);
}

void play_buffer(){

#ifndef GSM

	if (file_info->len < bsize){
		count = read(file_info->handle, buffer, file_info->len);
		file_info->len -= count;
	} else {
		count = read(file_info->handle, (int *)buffer, bsize);
		file_info->len -= count;
	}
	write(dsp_fd, buffer, count);

#else

	read(file_info->handle, (char *) gsm_info.buf, sizeof(gsm_info.buf));
	gsm_decode(gsm_info.handle, gsm_info.buf, gsm_info.sample);
	count = write(dsp_fd, gsm_info.sample, sizeof(gsm_info.sample));
	file_info->len -= count;
	
	count = 0;
#endif
}
#ifdef SOUND
int play_file (char *filename) {
        long i;
#else 
int main(int argc, char *argv[]) {
        char *filename;
        long i;

	if (argc == 1){
	  tellhow(argc, argv);
	  exit(-1);
	}
	filename = argv[1];
#endif 	
	file_info = (wav_sig *)malloc(sizeof(wav_sig));
	buffer = (int *)malloc(32767);

	if (init_wav_read(filename, file_info) == -1){
		fprintf(stderr,"Error opening file: %s\n", file_info->name);
		exit(0);
	}

	if (i = init_dsp(file_info) != 0){
		fprintf(stderr,"Cannot initialize DSP\n");
#ifdef SOUND
		exit(0);
#endif
	}
	
	report();

#ifdef GSM	
	gsm_info.handle = gsm_create();
#endif
	while (file_info->len > 0){
		play_buffer();
		update_timer(file_info, 1);
	}
#ifdef GSM
	gsm_destroy(gsm_info.handle);
#endif

	close(dsp_fd);
	close(file_info->handle);
	puts("\n");
}
