/*
 * Copyright (C) 2010 Ken VanDine
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

static int main(string[] args) {
/*
    if (args.length < 2) {
        PrintUsage ();
        return 1;
    }
*/
    var service = new Gwibber.Service();
    var accounts = new Gwibber.Accounts();
    var streams = new Gwibber.Streams();

    switch (args[1]) {
        case "--refresh":
            stdout.printf("Refreshing gwibber\n");
            service.refresh();
            return 0;
        case "--start":
            stdout.printf("Starting the gwibber service\n");
            service.start();
            return 0;
        case "--shutdown":
            stdout.printf("Shutting down the gwibber service\n");
            service.quit();
            return 0;
        case "--version":
            string version = service.version();
            stdout.printf("Gwibber version is: %s\n", version);
            return 0;
	/*
        case "--messages":
            string messages = streams.messages();
            stdout.printf("Gwibber messages: %s\n", messages);
            return 0;
	*/
        case "--accounts":
            GLib.List<Gwibber.Account> accounts_list = accounts.list ();
            foreach (Gwibber.Account account in accounts_list) {
                GLib.Value? value = null;
                stdout.printf("ID is %s\n", account.id);
                stdout.printf("username is %s\n", account.username);
                stdout.printf("color is %s\n", account.color);
                stdout.printf("service is %s\n", account.service);
                stdout.printf ("\tsend_enabled: %s\n", (account.send_enabled == "1")?"true":"false");
                stdout.printf ("\treceive_enabled: %s\n", (account.receive_enabled == "1")?"true":"false");
            }
            return 0;
        case "--features":
            HashTable<string,HashTable> features_table = service.features ();
            GLib.List<string> k = features_table.get_keys();
            foreach (string s in k) {
                stdout.printf ("Feature: %s\n",s);
                HashTable<string,Value?> feature_table = features_table.lookup(s);
                GLib.List<string> kk = feature_table.get_keys();
                foreach (string ss in kk) {
                    if (feature_table.lookup(ss).type_name() == "gboolean")
                       stdout.printf ("\t%s: %s\n", ss, (feature_table.lookup(ss).get_boolean())?"true":"false");
                    else if (feature_table.lookup(ss).type_name() == "gchararray")
                       stdout.printf ("\t%s: %s\n", ss, (string)feature_table.lookup(ss));
                }
            }
            return 0;
        case "--services":
            HashTable<string,HashTable> services_table = service.services ();
            GLib.List<string> k = services_table.get_keys();
            foreach (string s in k) {
                stdout.printf ("Service: %s\n",s);
                HashTable<string,Value?> service_table = services_table.lookup(s);
                GLib.List<string> kk = service_table.get_keys();
                foreach (string ss in kk) {
                    if (service_table.lookup(ss).type_name() == "GHashTable") {
                        HashTable<string,Value?> service_attr_table = (HashTable)service_table.lookup(ss);
                        if (service_attr_table != null) {
                            GLib.List<string> kkk = service_attr_table.get_keys();
                            foreach (string sss in kkk) {
                                if (service_attr_table.lookup(ss).type_name() == "gboolean")
                                   stdout.printf ("\t%s: %s\n", sss, (service_attr_table.lookup(ss).get_boolean())?"true":"false");
                                else if (service_attr_table.lookup(ss).type_name() == "gchararray")
                                   stdout.printf ("\t%s: %s\n", sss, (string)service_attr_table.lookup(ss));
                            }
                        continue;
                        }
                    } else if (service_table.lookup(ss).type_name() == "gboolean")
                       stdout.printf ("\t%s: %s\n", ss, (service_table.lookup(ss).get_boolean())?"true":"false");
                    else if (service_table.lookup(ss).type_name() == "gchararray")
                       stdout.printf ("\t%s: %s\n", ss, (string)service_table.lookup(ss));
                }
            }
            return 0;

        case "--send-message":
            if (args.length < 3) {
                PrintUsage ();
                return 1;
            }
            for(int i=1; i<args.length; i++) {
                if (args[i] == "--send-message") 
                    if (args[1+1] != null) {
                        string message = args[i+1];
                        stdout.printf("Posting...\n");
                        service.send_message(message);
                    } else {
                        PrintUsage ();
                        return 1;
                    }
            }
            return 0;
        case "--help":
            PrintUsage ();
            return 0;

        default:
        
            return 1;
    }
}

private static void PrintUsage () {
    string usage = "Usage:\n" +
        "  --help\t\t\tPrint this usage message.\n" +
        "  --start\t\t\tStart the gwibber-service\n" +
        "  --shutdown\t\t\tShutdown the gwibber-service\n" +
        "  --refresh\t\t\tRefresh the gwibber-service\n" +
        "  --send-message [message]\t\tMessage to post\n" +
        "  --accounts\t\t\tReturns list of accounts\n" +
        "  --services\t\t\tReturns list of services\n" +
        "  --features\t\t\tReturns list of features\n" +
        "  --version\t\t\tReturns the version of the gwibber-service\n";
        stdout.printf ("%s\n".printf(usage));
}
