package Locales::DB::Language::om;

# Auto generated from CLDR

$Locales::DB::Language::om::VERSION = '0.06';

$Locales::DB::Language::om::cldr_version = '1.7.2';

%Locales::DB::Language::om::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => undef,
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Language\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0\%",
        'territory'               => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::om::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikoota',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "Afaan\ Sidaamaa",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Arabiffaa',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => "Afaan\ Azerbaijani",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => "Afaan\ Belarusia",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => "Afaan\ Bulgariya",
    'bh'    => "Afaan\ Bihari",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "Afaan\ Baangladeshi",
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'bs'    => "Afaan\ Bosniyaa",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "Afaan\ Katalaa",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "Afaan\ Czech",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Welishiffaa',
    'da'    => "Afaan\ Deenmaark",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => "Afaan\ Jarmanii",
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => "Afaan\ Giriiki",
    'elx'   => 'Elamite',
    'en'    => 'Ingliffa',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => "Afaan\ Esperantoo",
    'es'    => "Afaan\ Ispeen",
    'es_es' => "Iberian\ Spanish",
    'et'    => "Afaan\ Istooniya",
    'eu'    => "Afaan\ Baskuu",
    'ewo'   => 'Ewondo',
    'fa'    => "Afaan\ Persia",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => "Afaan\ Fiilaandi",
    'fil'   => "Afaan\ Filippinii",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => "Afaan\ Faroese",
    'fon'   => 'Fon',
    'fr'    => "Afaan\ Faransaayii",
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Afaan\ Firisiyaani",
    'ga'    => "Afaan\ Ayirishii",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scots\ Gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => "Afaan\ Galishii",
    'gmh'   => "Middle\ High\ German",
    'gn'    => "Afaan\ Guarani",
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => "Afaan\ Gujarati",
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => "Afaan\ Hebrew",
    'hi'    => "Afaan\ Hindii",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Afaan\ Croatian",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => "Afaan\ Hangaari",
    'hup'   => 'Hupa',
    'hy'    => 'Armenian',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => "Afaan\ Indoneziya",
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Ayiislandiffaa',
    'it'    => "Afaan\ Xaaliyaani",
    'iu'    => 'Inuktitut',
    'ja'    => "Afaan\ Japanii",
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "Afaan\ Java",
    'ka'    => "Afaan\ Georgian",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => "Afaan\ Kannada",
    'ko'    => "Afaan\ Korea",
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => "Afaan\ Laatini",
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "Afaan\ Liituniyaa",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => "Afaan\ Lativiyaa",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => "Afaan\ Macedooniyaa",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayaalamiffaa',
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "Afaan\ Maratii",
    'ms'    => 'Malaayiffaa',
    'mt'    => "Afaan\ Maltesii",
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => "Afaan\ Nepalii",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => "Afaan\ Dachii",
    'nl_be' => 'Flemish',
    'nn'    => "Afaan\ Norwegian",
    'no'    => "Afaan\ Norweyii",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Afaan\ Occit",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromoo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "Afaan\ Punjabii",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "Afaan\ Polandii",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => "Afaan\ Porchugaal",
    'pt_br' => "Afaan\ Portugali\ \(Braazil\)",
    'pt_pt' => "Afaan\ Protuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => "Afaan\ Romaniyaa",
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => "Afaan\ Rushiyaa",
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Shan',
    'si'    => "Afaan\ Sinhalese",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "Afaan\ Slovak",
    'sl'    => "Afaan\ Islovaniyaa",
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "Afaan\ Albaniyaa",
    'sr'    => "Afaan\ Serbiya",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Southern\ Sotho",
    'su'    => "Afaan\ Sudaanii",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => "Afaan\ Suwidiin",
    'sw'    => 'Suwahilii',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "Afaan\ Tamilii",
    'tai'   => "Tai\ Language",
    'te'    => "Afaan\ Telugu",
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => "Afaan\ Tayii",
    'ti'    => "Afaan\ Tigiree",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => "Lammii\ Turkii",
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => "Afaan\ Kilingon",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => "Afaan\ Turkii",
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => "Afaan\ Ukreenii",
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => "Afaan\ Urdu",
    'uz'    => "Afaan\ Uzbek",
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => "Afaan\ Veetinam",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => "Afaan\ Xhosa",
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => "Afaan\ Zuulu",
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::om::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afaanalbaniyaa'                => 'sq',
    'afaanayirishii'                => 'ga',
    'afaanazerbaijani'              => 'az',
    'afaanbaangladeshi'             => 'bn',
    'afaanbaskuu'                   => 'eu',
    'afaanbelarusia'                => 'be',
    'afaanbihari'                   => 'bh',
    'afaanbosniyaa'                 => 'bs',
    'afaanbulgariya'                => 'bg',
    'afaancroatian'                 => 'hr',
    'afaanczech'                    => 'cs',
    'afaandachii'                   => 'nl',
    'afaandeenmaark'                => 'da',
    'afaanesperantoo'               => 'eo',
    'afaanfaransaayii'              => 'fr',
    'afaanfaroese'                  => 'fo',
    'afaanfiilaandi'                => 'fi',
    'afaanfilippinii'               => 'fil',
    'afaanfirisiyaani'              => 'fy',
    'afaangalishii'                 => 'gl',
    'afaangeorgian'                 => 'ka',
    'afaangiriiki'                  => 'el',
    'afaanguarani'                  => 'gn',
    'afaangujarati'                 => 'gu',
    'afaanhangaari'                 => 'hu',
    'afaanhebrew'                   => 'he',
    'afaanhindii'                   => 'hi',
    'afaanindoneziya'               => 'id',
    'afaanislovaniyaa'              => 'sl',
    'afaanispeen'                   => 'es',
    'afaanistooniya'                => 'et',
    'afaanjapanii'                  => 'ja',
    'afaanjarmanii'                 => 'de',
    'afaanjava'                     => 'jv',
    'afaankannada'                  => 'kn',
    'afaankatalaa'                  => 'ca',
    'afaankilingon'                 => 'tlh',
    'afaankorea'                    => 'ko',
    'afaanlaatini'                  => 'la',
    'afaanlativiyaa'                => 'lv',
    'afaanliituniyaa'               => 'lt',
    'afaanmacedooniyaa'             => 'mk',
    'afaanmaltesii'                 => 'mt',
    'afaanmaratii'                  => 'mr',
    'afaannepalii'                  => 'ne',
    'afaannorwegian'                => 'nn',
    'afaannorweyii'                 => 'no',
    'afaanoccit'                    => 'oc',
    'afaanpersia'                   => 'fa',
    'afaanpolandii'                 => 'pl',
    'afaanporchugaal'               => 'pt',
    'afaanportugalibraazil'         => 'pt_br',
    'afaanprotuguese'               => 'pt_pt',
    'afaanpunjabii'                 => 'pa',
    'afaanromaniyaa'                => 'ro',
    'afaanrushiyaa'                 => 'ru',
    'afaanserbiya'                  => 'sr',
    'afaansidaamaa'                 => 'am',
    'afaansinhalese'                => 'si',
    'afaanslovak'                   => 'sk',
    'afaansudaanii'                 => 'su',
    'afaansuwidiin'                 => 'sv',
    'afaantamilii'                  => 'ta',
    'afaantayii'                    => 'th',
    'afaantelugu'                   => 'te',
    'afaantigiree'                  => 'ti',
    'afaanturkii'                   => 'tr',
    'afaanukreenii'                 => 'uk',
    'afaanurdu'                     => 'ur',
    'afaanuzbek'                    => 'uz',
    'afaanveetinam'                 => 'vi',
    'afaanxaaliyaani'               => 'it',
    'afaanxhosa'                    => 'xh',
    'afaanzuulu'                    => 'zu',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikoota'                     => 'af',
    'afroasiaticlanguage'           => 'afa',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'arabiffaa'                     => 'ar',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armenian'                      => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'assamese'                      => 'as',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'ayiislandiffaa'                => 'is',
    'aymara'                        => 'ay',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'braj'                          => 'bra',
    'breton'                        => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'burmese'                       => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinese'                       => 'zh',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fijian'                        => 'fj',
    'finnougrianlanguage'           => 'fiu',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'ingliffa'                      => 'en',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'jju'                           => 'kaj',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'kirghiz'                       => 'ky',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdish'                       => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'lammiiturkii'                  => 'tk',
    'lao'                           => 'lo',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'malaayiffaa'                   => 'ms',
    'malagasy'                      => 'mg',
    'malayaalamiffaa'               => 'ml',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongolian'                     => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'nubianlanguage'                => 'nub',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromoo'                        => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'pushto'                        => 'ps',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'rhaetoromance'                 => 'rm',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rundi'                         => 'rn',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'scotsgaelic'                   => 'gd',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'serbocroatian'                 => 'sh',
    'serer'                         => 'srr',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southernsotho'                 => 'st',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'suwahilii'                     => 'sw',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'taroko'                        => 'trv',
    'tatar'                         => 'tt',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'umbundu'                       => 'umb',
    'unknownorinvalidlanguage'      => 'und',
    'uppersorbian'                  => 'hsb',
    'uyghur'                        => 'ug',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'welishiffaa'                   => 'cy',
    'wolof'                         => 'wo',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
);

1;
