//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qsize_c.h"

QSizeH QSize_create()
{
	return (QSizeH) new QSize();
}

void QSize_destroy(QSizeH handle)
{
	delete (QSize *)handle;
}

QSizeH QSize_create2(int w, int h)
{
	return (QSizeH) new QSize(w, h);
}

bool QSize_isNull(QSizeH handle)
{
	return (bool) ((QSize *)handle)->isNull();
}

bool QSize_isEmpty(QSizeH handle)
{
	return (bool) ((QSize *)handle)->isEmpty();
}

bool QSize_isValid(QSizeH handle)
{
	return (bool) ((QSize *)handle)->isValid();
}

int QSize_width(QSizeH handle)
{
	return (int) ((QSize *)handle)->width();
}

int QSize_height(QSizeH handle)
{
	return (int) ((QSize *)handle)->height();
}

void QSize_setWidth(QSizeH handle, int w)
{
	((QSize *)handle)->setWidth(w);
}

void QSize_setHeight(QSizeH handle, int h)
{
	((QSize *)handle)->setHeight(h);
}

void QSize_transpose(QSizeH handle)
{
	((QSize *)handle)->transpose();
}

void QSize_scale(QSizeH handle, int w, int h, Qt::AspectRatioMode mode)
{
	((QSize *)handle)->scale(w, h, mode);
}

void QSize_scale2(QSizeH handle, const QSizeH s, Qt::AspectRatioMode mode)
{
	((QSize *)handle)->scale(*(const QSize*)s, mode);
}

void QSize_expandedTo(QSizeH handle, PSize retval, const QSizeH p1)
{
	*(QSize *)retval = ((QSize *)handle)->expandedTo(*(const QSize*)p1);
}

void QSize_boundedTo(QSizeH handle, PSize retval, const QSizeH p1)
{
	*(QSize *)retval = ((QSize *)handle)->boundedTo(*(const QSize*)p1);
}

int* QSize_rwidth(QSizeH handle)
{
	return (int*) &((QSize *)handle)->rwidth();
}

int* QSize_rheight(QSizeH handle)
{
	return (int*) &((QSize *)handle)->rheight();
}

QSizeFH QSizeF_create()
{
	return (QSizeFH) new QSizeF();
}

void QSizeF_destroy(QSizeFH handle)
{
	delete (QSizeF *)handle;
}

QSizeFH QSizeF_create2(const QSizeH sz)
{
	return (QSizeFH) new QSizeF(*(const QSize*)sz);
}

QSizeFH QSizeF_create3(qreal w, qreal h)
{
	return (QSizeFH) new QSizeF(w, h);
}

bool QSizeF_isNull(QSizeFH handle)
{
	return (bool) ((QSizeF *)handle)->isNull();
}

bool QSizeF_isEmpty(QSizeFH handle)
{
	return (bool) ((QSizeF *)handle)->isEmpty();
}

bool QSizeF_isValid(QSizeFH handle)
{
	return (bool) ((QSizeF *)handle)->isValid();
}

qreal QSizeF_width(QSizeFH handle)
{
	return (qreal) ((QSizeF *)handle)->width();
}

qreal QSizeF_height(QSizeFH handle)
{
	return (qreal) ((QSizeF *)handle)->height();
}

void QSizeF_setWidth(QSizeFH handle, qreal w)
{
	((QSizeF *)handle)->setWidth(w);
}

void QSizeF_setHeight(QSizeFH handle, qreal h)
{
	((QSizeF *)handle)->setHeight(h);
}

void QSizeF_transpose(QSizeFH handle)
{
	((QSizeF *)handle)->transpose();
}

void QSizeF_scale(QSizeFH handle, qreal w, qreal h, Qt::AspectRatioMode mode)
{
	((QSizeF *)handle)->scale(w, h, mode);
}

void QSizeF_scale2(QSizeFH handle, const QSizeFH s, Qt::AspectRatioMode mode)
{
	((QSizeF *)handle)->scale(*(const QSizeF*)s, mode);
}

void QSizeF_expandedTo(QSizeFH handle, QSizeFH retval, const QSizeFH p1)
{
	*(QSizeF *)retval = ((QSizeF *)handle)->expandedTo(*(const QSizeF*)p1);
}

void QSizeF_boundedTo(QSizeFH handle, QSizeFH retval, const QSizeFH p1)
{
	*(QSizeF *)retval = ((QSizeF *)handle)->boundedTo(*(const QSizeF*)p1);
}

qreal* QSizeF_rwidth(QSizeFH handle)
{
	return (qreal*) &((QSizeF *)handle)->rwidth();
}

qreal* QSizeF_rheight(QSizeFH handle)
{
	return (qreal*) &((QSizeF *)handle)->rheight();
}

void QSizeF_toSize(QSizeFH handle, PSize retval)
{
	*(QSize *)retval = ((QSizeF *)handle)->toSize();
}

