//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QUDPSOCKET_C_H
#define QUDPSOCKET_C_H

#include <QtNetwork>
#include "pascalbind.h"

C_EXPORT QUdpSocketH QUdpSocket_create(QObjectH parent);
C_EXPORT void QUdpSocket_destroy(QUdpSocketH handle);
C_EXPORT bool QUdpSocket_bind(QUdpSocketH handle, const QHostAddressH address, quint16 port);
C_EXPORT bool QUdpSocket_bind2(QUdpSocketH handle, quint16 port);
C_EXPORT bool QUdpSocket_bind3(QUdpSocketH handle, const QHostAddressH address, quint16 port, unsigned int mode);
C_EXPORT bool QUdpSocket_bind4(QUdpSocketH handle, quint16 port, unsigned int mode);
C_EXPORT bool QUdpSocket_hasPendingDatagrams(QUdpSocketH handle);
C_EXPORT qint64 QUdpSocket_pendingDatagramSize(QUdpSocketH handle);
C_EXPORT qint64 QUdpSocket_readDatagram(QUdpSocketH handle, char* data, qint64 maxlen, QHostAddressH host, quint16* port);
C_EXPORT qint64 QUdpSocket_writeDatagram(QUdpSocketH handle, const char* data, qint64 len, const QHostAddressH host, quint16 port);
C_EXPORT qint64 QUdpSocket_writeDatagram2(QUdpSocketH handle, const QByteArrayH datagram, const QHostAddressH host, quint16 port);

#endif
