//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qboxlayout_c.h"

QBoxLayoutH QBoxLayout_create(QBoxLayout::Direction p1, QWidgetH parent)
{
	return (QBoxLayoutH) new QBoxLayout(p1, (QWidget*)parent);
}

void QBoxLayout_destroy(QBoxLayoutH handle)
{
	delete (QBoxLayout *)handle;
}

QBoxLayout::Direction QBoxLayout_direction(QBoxLayoutH handle)
{
	return (QBoxLayout::Direction) ((QBoxLayout *)handle)->direction();
}

void QBoxLayout_setDirection(QBoxLayoutH handle, QBoxLayout::Direction p1)
{
	((QBoxLayout *)handle)->setDirection(p1);
}

void QBoxLayout_addSpacing(QBoxLayoutH handle, int size)
{
	((QBoxLayout *)handle)->addSpacing(size);
}

void QBoxLayout_addStretch(QBoxLayoutH handle, int stretch)
{
	((QBoxLayout *)handle)->addStretch(stretch);
}

void QBoxLayout_addSpacerItem(QBoxLayoutH handle, QSpacerItemH spacerItem)
{
	((QBoxLayout *)handle)->addSpacerItem((QSpacerItem*)spacerItem);
}

void QBoxLayout_addWidget(QBoxLayoutH handle, QWidgetH p1, int stretch, unsigned int alignment)
{
	((QBoxLayout *)handle)->addWidget((QWidget*)p1, stretch, (Qt::Alignment)alignment);
}

void QBoxLayout_addLayout(QBoxLayoutH handle, QLayoutH layout, int stretch)
{
	((QBoxLayout *)handle)->addLayout((QLayout*)layout, stretch);
}

void QBoxLayout_addStrut(QBoxLayoutH handle, int p1)
{
	((QBoxLayout *)handle)->addStrut(p1);
}

void QBoxLayout_addItem(QBoxLayoutH handle, QLayoutItemH p1)
{
	((QBoxLayout *)handle)->addItem((QLayoutItem*)p1);
}

void QBoxLayout_insertSpacing(QBoxLayoutH handle, int index, int size)
{
	((QBoxLayout *)handle)->insertSpacing(index, size);
}

void QBoxLayout_insertStretch(QBoxLayoutH handle, int index, int stretch)
{
	((QBoxLayout *)handle)->insertStretch(index, stretch);
}

void QBoxLayout_insertSpacerItem(QBoxLayoutH handle, int index, QSpacerItemH spacerItem)
{
	((QBoxLayout *)handle)->insertSpacerItem(index, (QSpacerItem*)spacerItem);
}

void QBoxLayout_insertWidget(QBoxLayoutH handle, int index, QWidgetH widget, int stretch, unsigned int alignment)
{
	((QBoxLayout *)handle)->insertWidget(index, (QWidget*)widget, stretch, (Qt::Alignment)alignment);
}

void QBoxLayout_insertLayout(QBoxLayoutH handle, int index, QLayoutH layout, int stretch)
{
	((QBoxLayout *)handle)->insertLayout(index, (QLayout*)layout, stretch);
}

int QBoxLayout_spacing(QBoxLayoutH handle)
{
	return (int) ((QBoxLayout *)handle)->spacing();
}

void QBoxLayout_setSpacing(QBoxLayoutH handle, int spacing)
{
	((QBoxLayout *)handle)->setSpacing(spacing);
}

bool QBoxLayout_setStretchFactor(QBoxLayoutH handle, QWidgetH w, int stretch)
{
	return (bool) ((QBoxLayout *)handle)->setStretchFactor((QWidget*)w, stretch);
}

bool QBoxLayout_setStretchFactor2(QBoxLayoutH handle, QLayoutH l, int stretch)
{
	return (bool) ((QBoxLayout *)handle)->setStretchFactor((QLayout*)l, stretch);
}

void QBoxLayout_setStretch(QBoxLayoutH handle, int index, int stretch)
{
	((QBoxLayout *)handle)->setStretch(index, stretch);
}

int QBoxLayout_stretch(QBoxLayoutH handle, int index)
{
	return (int) ((QBoxLayout *)handle)->stretch(index);
}

void QBoxLayout_sizeHint(QBoxLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QBoxLayout *)handle)->sizeHint();
}

void QBoxLayout_minimumSize(QBoxLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QBoxLayout *)handle)->minimumSize();
}

void QBoxLayout_maximumSize(QBoxLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QBoxLayout *)handle)->maximumSize();
}

bool QBoxLayout_hasHeightForWidth(QBoxLayoutH handle)
{
	return (bool) ((QBoxLayout *)handle)->hasHeightForWidth();
}

int QBoxLayout_heightForWidth(QBoxLayoutH handle, int p1)
{
	return (int) ((QBoxLayout *)handle)->heightForWidth(p1);
}

int QBoxLayout_minimumHeightForWidth(QBoxLayoutH handle, int p1)
{
	return (int) ((QBoxLayout *)handle)->minimumHeightForWidth(p1);
}

unsigned int QBoxLayout_expandingDirections(QBoxLayoutH handle)
{
	return (unsigned int) ((QBoxLayout *)handle)->expandingDirections();
}

void QBoxLayout_invalidate(QBoxLayoutH handle)
{
	((QBoxLayout *)handle)->invalidate();
}

QLayoutItemH QBoxLayout_itemAt(QBoxLayoutH handle, int p1)
{
	return (QLayoutItemH) ((QBoxLayout *)handle)->itemAt(p1);
}

QLayoutItemH QBoxLayout_takeAt(QBoxLayoutH handle, int p1)
{
	return (QLayoutItemH) ((QBoxLayout *)handle)->takeAt(p1);
}

int QBoxLayout_count(QBoxLayoutH handle)
{
	return (int) ((QBoxLayout *)handle)->count();
}

void QBoxLayout_setGeometry(QBoxLayoutH handle, PRect p1)
{
	QRect t_p1;
	copyPRectToQRect(p1, t_p1);
	((QBoxLayout *)handle)->setGeometry(t_p1);
}

QHBoxLayoutH QHBoxLayout_create()
{
	return (QHBoxLayoutH) new QHBoxLayout();
}

void QHBoxLayout_destroy(QHBoxLayoutH handle)
{
	delete (QHBoxLayout *)handle;
}

QHBoxLayoutH QHBoxLayout_create2(QWidgetH parent)
{
	return (QHBoxLayoutH) new QHBoxLayout((QWidget*)parent);
}

QVBoxLayoutH QVBoxLayout_create()
{
	return (QVBoxLayoutH) new QVBoxLayout();
}

void QVBoxLayout_destroy(QVBoxLayoutH handle)
{
	delete (QVBoxLayout *)handle;
}

QVBoxLayoutH QVBoxLayout_create2(QWidgetH parent)
{
	return (QVBoxLayoutH) new QVBoxLayout((QWidget*)parent);
}

