//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qcoreapplication_c.h"

QCoreApplicationH QCoreApplication_create(int* argc, char** argv)
{
	return (QCoreApplicationH) new QCoreApplication(*(int*)argc, argv);
}

void QCoreApplication_destroy(QCoreApplicationH handle)
{
	delete (QCoreApplication *)handle;
}

void QCoreApplication_arguments(QStringListH retval)
{
	*(QStringList *)retval = QCoreApplication::arguments();
}

void QCoreApplication_setAttribute(Qt::ApplicationAttribute attribute, bool on)
{
	QCoreApplication::setAttribute(attribute, on);
}

bool QCoreApplication_testAttribute(Qt::ApplicationAttribute attribute)
{
	return (bool) QCoreApplication::testAttribute(attribute);
}

void QCoreApplication_setOrganizationDomain(PWideString orgDomain)
{
	QString t_orgDomain;
	copyPWideStringToQString(orgDomain, t_orgDomain);
	QCoreApplication::setOrganizationDomain(t_orgDomain);
}

void QCoreApplication_organizationDomain(PWideString retval)
{
	QString t_retval;
	t_retval = QCoreApplication::organizationDomain();
	copyQStringToPWideString(t_retval, retval);
}

void QCoreApplication_setOrganizationName(PWideString orgName)
{
	QString t_orgName;
	copyPWideStringToQString(orgName, t_orgName);
	QCoreApplication::setOrganizationName(t_orgName);
}

void QCoreApplication_organizationName(PWideString retval)
{
	QString t_retval;
	t_retval = QCoreApplication::organizationName();
	copyQStringToPWideString(t_retval, retval);
}

void QCoreApplication_setApplicationName(PWideString application)
{
	QString t_application;
	copyPWideStringToQString(application, t_application);
	QCoreApplication::setApplicationName(t_application);
}

void QCoreApplication_applicationName(PWideString retval)
{
	QString t_retval;
	t_retval = QCoreApplication::applicationName();
	copyQStringToPWideString(t_retval, retval);
}

void QCoreApplication_setApplicationVersion(PWideString version)
{
	QString t_version;
	copyPWideStringToQString(version, t_version);
	QCoreApplication::setApplicationVersion(t_version);
}

void QCoreApplication_applicationVersion(PWideString retval)
{
	QString t_retval;
	t_retval = QCoreApplication::applicationVersion();
	copyQStringToPWideString(t_retval, retval);
}

QCoreApplicationH QCoreApplication_instance()
{
	return (QCoreApplicationH) QCoreApplication::instance();
}

int QCoreApplication_exec()
{
	return (int) QCoreApplication::exec();
}

void QCoreApplication_processEvents(unsigned int flags)
{
	QCoreApplication::processEvents((QEventLoop::ProcessEventsFlags)flags);
}

void QCoreApplication_processEvents2(unsigned int flags, int maxtime)
{
	QCoreApplication::processEvents((QEventLoop::ProcessEventsFlags)flags, maxtime);
}

void QCoreApplication_exit(int retcode)
{
	QCoreApplication::exit(retcode);
}

bool QCoreApplication_sendEvent(QObjectH receiver, QEventH event)
{
	return (bool) QCoreApplication::sendEvent((QObject*)receiver, (QEvent*)event);
}

void QCoreApplication_postEvent(QObjectH receiver, QEventH event)
{
	QCoreApplication::postEvent((QObject*)receiver, (QEvent*)event);
}

void QCoreApplication_postEvent2(QObjectH receiver, QEventH event, int priority)
{
	QCoreApplication::postEvent((QObject*)receiver, (QEvent*)event, priority);
}

void QCoreApplication_sendPostedEvents(QObjectH receiver, int event_type)
{
	QCoreApplication::sendPostedEvents((QObject*)receiver, event_type);
}

void QCoreApplication_sendPostedEvents2()
{
	QCoreApplication::sendPostedEvents();
}

void QCoreApplication_removePostedEvents(QObjectH receiver)
{
	QCoreApplication::removePostedEvents((QObject*)receiver);
}

void QCoreApplication_removePostedEvents2(QObjectH receiver, int eventType)
{
	QCoreApplication::removePostedEvents((QObject*)receiver, eventType);
}

bool QCoreApplication_hasPendingEvents()
{
	return (bool) QCoreApplication::hasPendingEvents();
}

bool QCoreApplication_notify(QCoreApplicationH handle, QObjectH p1, QEventH p2)
{
	return (bool) ((QCoreApplication *)handle)->notify((QObject*)p1, (QEvent*)p2);
}

bool QCoreApplication_startingUp()
{
	return (bool) QCoreApplication::startingUp();
}

bool QCoreApplication_closingDown()
{
	return (bool) QCoreApplication::closingDown();
}

void QCoreApplication_applicationDirPath(PWideString retval)
{
	QString t_retval;
	t_retval = QCoreApplication::applicationDirPath();
	copyQStringToPWideString(t_retval, retval);
}

void QCoreApplication_applicationFilePath(PWideString retval)
{
	QString t_retval;
	t_retval = QCoreApplication::applicationFilePath();
	copyQStringToPWideString(t_retval, retval);
}

qint64 QCoreApplication_applicationPid()
{
	return (qint64) QCoreApplication::applicationPid();
}

void QCoreApplication_setLibraryPaths(const QStringListH p1)
{
	QCoreApplication::setLibraryPaths(*(const QStringList*)p1);
}

void QCoreApplication_libraryPaths(QStringListH retval)
{
	*(QStringList *)retval = QCoreApplication::libraryPaths();
}

void QCoreApplication_addLibraryPath(PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	QCoreApplication::addLibraryPath(t_p1);
}

void QCoreApplication_removeLibraryPath(PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	QCoreApplication::removeLibraryPath(t_p1);
}

void QCoreApplication_installTranslator(QTranslatorH messageFile)
{
	QCoreApplication::installTranslator((QTranslator*)messageFile);
}

void QCoreApplication_removeTranslator(QTranslatorH messageFile)
{
	QCoreApplication::removeTranslator((QTranslator*)messageFile);
}

void QCoreApplication_translate(PWideString retval, const char* context, const char* key, const char* disambiguation, QCoreApplication::Encoding encoding)
{
	QString t_retval;
	t_retval = QCoreApplication::translate(context, key, disambiguation, encoding);
	copyQStringToPWideString(t_retval, retval);
}

void QCoreApplication_translate2(PWideString retval, const char* context, const char* key, const char* disambiguation, QCoreApplication::Encoding encoding, int n)
{
	QString t_retval;
	t_retval = QCoreApplication::translate(context, key, disambiguation, encoding, n);
	copyQStringToPWideString(t_retval, retval);
}

void QCoreApplication_flush()
{
	QCoreApplication::flush();
}

#if defined BINUX || DARWIN || QTOPIA
void QCoreApplication_watchUnixSignal(int signal, bool watch)
{
	QCoreApplication::watchUnixSignal(signal, watch);
}

#endif
EventFilter QCoreApplication_setEventFilter(QCoreApplicationH handle, EventFilter filter)
{
	return (EventFilter) ((QCoreApplication *)handle)->setEventFilter(filter);
}

bool QCoreApplication_filterEvent(QCoreApplicationH handle, void* message, long* result)
{
	return (bool) ((QCoreApplication *)handle)->filterEvent(message, result);
}

void QCoreApplication_quit()
{
	QCoreApplication::quit();
}

#if defined MSWINDOWS
bool QCoreApplication_winEventFilter(QCoreApplicationH handle, MSG* message, long* result)
{
	return (bool) ((QCoreApplication *)handle)->winEventFilter(message, result);
}

#endif
