//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qfont_c.h"

QFontH QFont_create()
{
	return (QFontH) new QFont();
}

void QFont_destroy(QFontH handle)
{
	delete (QFont *)handle;
}

QFontH QFont_create2(PWideString family, int pointSize, int weight, bool italic)
{
	QString t_family;
	copyPWideStringToQString(family, t_family);
	return (QFontH) new QFont(t_family, pointSize, weight, italic);
}

QFontH QFont_create3(const QFontH p1, QPaintDeviceH pd)
{
	return (QFontH) new QFont(*(const QFont*)p1, (QPaintDevice*)pd);
}

QFontH QFont_create4(const QFontH p1)
{
	return (QFontH) new QFont(*(const QFont*)p1);
}

void QFont_family(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->family();
	copyQStringToPWideString(t_retval, retval);
}

void QFont_setFamily(QFontH handle, PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	((QFont *)handle)->setFamily(t_p1);
}

int QFont_pointSize(QFontH handle)
{
	return (int) ((QFont *)handle)->pointSize();
}

void QFont_setPointSize(QFontH handle, int p1)
{
	((QFont *)handle)->setPointSize(p1);
}

qreal QFont_pointSizeF(QFontH handle)
{
	return (qreal) ((QFont *)handle)->pointSizeF();
}

void QFont_setPointSizeF(QFontH handle, qreal p1)
{
	((QFont *)handle)->setPointSizeF(p1);
}

int QFont_pixelSize(QFontH handle)
{
	return (int) ((QFont *)handle)->pixelSize();
}

void QFont_setPixelSize(QFontH handle, int p1)
{
	((QFont *)handle)->setPixelSize(p1);
}

int QFont_weight(QFontH handle)
{
	return (int) ((QFont *)handle)->weight();
}

void QFont_setWeight(QFontH handle, int p1)
{
	((QFont *)handle)->setWeight(p1);
}

bool QFont_bold(QFontH handle)
{
	return (bool) ((QFont *)handle)->bold();
}

void QFont_setBold(QFontH handle, bool p1)
{
	((QFont *)handle)->setBold(p1);
}

void QFont_setStyle(QFontH handle, QFont::Style style)
{
	((QFont *)handle)->setStyle(style);
}

QFont::Style QFont_style(QFontH handle)
{
	return (QFont::Style) ((QFont *)handle)->style();
}

bool QFont_italic(QFontH handle)
{
	return (bool) ((QFont *)handle)->italic();
}

void QFont_setItalic(QFontH handle, bool b)
{
	((QFont *)handle)->setItalic(b);
}

bool QFont_underline(QFontH handle)
{
	return (bool) ((QFont *)handle)->underline();
}

void QFont_setUnderline(QFontH handle, bool p1)
{
	((QFont *)handle)->setUnderline(p1);
}

bool QFont_overline(QFontH handle)
{
	return (bool) ((QFont *)handle)->overline();
}

void QFont_setOverline(QFontH handle, bool p1)
{
	((QFont *)handle)->setOverline(p1);
}

bool QFont_strikeOut(QFontH handle)
{
	return (bool) ((QFont *)handle)->strikeOut();
}

void QFont_setStrikeOut(QFontH handle, bool p1)
{
	((QFont *)handle)->setStrikeOut(p1);
}

bool QFont_fixedPitch(QFontH handle)
{
	return (bool) ((QFont *)handle)->fixedPitch();
}

void QFont_setFixedPitch(QFontH handle, bool p1)
{
	((QFont *)handle)->setFixedPitch(p1);
}

bool QFont_kerning(QFontH handle)
{
	return (bool) ((QFont *)handle)->kerning();
}

void QFont_setKerning(QFontH handle, bool p1)
{
	((QFont *)handle)->setKerning(p1);
}

QFont::StyleHint QFont_styleHint(QFontH handle)
{
	return (QFont::StyleHint) ((QFont *)handle)->styleHint();
}

QFont::StyleStrategy QFont_styleStrategy(QFontH handle)
{
	return (QFont::StyleStrategy) ((QFont *)handle)->styleStrategy();
}

void QFont_setStyleHint(QFontH handle, QFont::StyleHint p1, QFont::StyleStrategy p2)
{
	((QFont *)handle)->setStyleHint(p1, p2);
}

void QFont_setStyleStrategy(QFontH handle, QFont::StyleStrategy s)
{
	((QFont *)handle)->setStyleStrategy(s);
}

int QFont_stretch(QFontH handle)
{
	return (int) ((QFont *)handle)->stretch();
}

void QFont_setStretch(QFontH handle, int p1)
{
	((QFont *)handle)->setStretch(p1);
}

qreal QFont_letterSpacing(QFontH handle)
{
	return (qreal) ((QFont *)handle)->letterSpacing();
}

QFont::SpacingType QFont_letterSpacingType(QFontH handle)
{
	return (QFont::SpacingType) ((QFont *)handle)->letterSpacingType();
}

void QFont_setLetterSpacing(QFontH handle, QFont::SpacingType type, qreal spacing)
{
	((QFont *)handle)->setLetterSpacing(type, spacing);
}

qreal QFont_wordSpacing(QFontH handle)
{
	return (qreal) ((QFont *)handle)->wordSpacing();
}

void QFont_setWordSpacing(QFontH handle, qreal spacing)
{
	((QFont *)handle)->setWordSpacing(spacing);
}

void QFont_setCapitalization(QFontH handle, QFont::Capitalization p1)
{
	((QFont *)handle)->setCapitalization(p1);
}

QFont::Capitalization QFont_capitalization(QFontH handle)
{
	return (QFont::Capitalization) ((QFont *)handle)->capitalization();
}

bool QFont_rawMode(QFontH handle)
{
	return (bool) ((QFont *)handle)->rawMode();
}

void QFont_setRawMode(QFontH handle, bool p1)
{
	((QFont *)handle)->setRawMode(p1);
}

bool QFont_exactMatch(QFontH handle)
{
	return (bool) ((QFont *)handle)->exactMatch();
}

bool QFont_isCopyOf(QFontH handle, const QFontH p1)
{
	return (bool) ((QFont *)handle)->isCopyOf(*(const QFont*)p1);
}

#if defined BINUX || DARWIN || QTOPIA
Qt::HANDLE QFont_handle(QFontH handle)
{
	return (Qt::HANDLE) ((QFont *)handle)->handle();
}

#endif
void QFont_setRawName(QFontH handle, PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	((QFont *)handle)->setRawName(t_p1);
}

void QFont_rawName(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->rawName();
	copyQStringToPWideString(t_retval, retval);
}

void QFont_key(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->key();
	copyQStringToPWideString(t_retval, retval);
}

void QFont_toString(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->toString();
	copyQStringToPWideString(t_retval, retval);
}

bool QFont_fromString(QFontH handle, PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	return (bool) ((QFont *)handle)->fromString(t_p1);
}

void QFont_substitute(PWideString retval, PWideString p1)
{
	QString t_retval;
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	t_retval = QFont::substitute(t_p1);
	copyQStringToPWideString(t_retval, retval);
}

void QFont_substitutes(QStringListH retval, PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	*(QStringList *)retval = QFont::substitutes(t_p1);
}

void QFont_substitutions(QStringListH retval)
{
	*(QStringList *)retval = QFont::substitutions();
}

void QFont_insertSubstitution(PWideString p1, PWideString p2)
{
	QString t_p1;
	QString t_p2;
	copyPWideStringToQString(p1, t_p1);
	copyPWideStringToQString(p2, t_p2);
	QFont::insertSubstitution(t_p1, t_p2);
}

void QFont_insertSubstitutions(PWideString p1, const QStringListH p2)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	QFont::insertSubstitutions(t_p1, *(const QStringList*)p2);
}

void QFont_removeSubstitution(PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	QFont::removeSubstitution(t_p1);
}

void QFont_initialize()
{
	QFont::initialize();
}

void QFont_cleanup()
{
	QFont::cleanup();
}

#if defined BINUX || MSWINDOWS || DARWIN
void QFont_cacheStatistics()
{
	QFont::cacheStatistics();
}

#endif
void QFont_defaultFamily(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->defaultFamily();
	copyQStringToPWideString(t_retval, retval);
}

void QFont_lastResortFamily(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->lastResortFamily();
	copyQStringToPWideString(t_retval, retval);
}

void QFont_lastResortFont(QFontH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QFont *)handle)->lastResortFont();
	copyQStringToPWideString(t_retval, retval);
}

void QFont_resolve(QFontH handle, QFontH retval, const QFontH p1)
{
	*(QFont *)retval = ((QFont *)handle)->resolve(*(const QFont*)p1);
}

uint QFont_resolve2(QFontH handle)
{
	return (uint) ((QFont *)handle)->resolve();
}

void QFont_resolve3(QFontH handle, uint mask)
{
	((QFont *)handle)->resolve(mask);
}

#if defined MSWINDOWS
HFONT QFont_handle2(QFontH handle)
{
	return (HFONT) ((QFont *)handle)->handle();
}

#endif
#if defined DARWIN
quint32 QFont_macFontID(QFontH handle)
{
	return (quint32) ((QFont *)handle)->macFontID();
}

#endif
