/* libwpg
 * Copyright (C) 2006 Ariya Hidayat (ariya@kde.org)
 * Copyright (C) 2004 Marc Oude Kotte (marc@solcon.nl)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02111-1301 USA
 *
 * For further information visit http://libwpg.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef __WPGPAINTINTERFACE_H__
#define __WPGPAINTINTERFACE_H__

#include <libwpd/libwpd.h>

namespace libwpg
{

class WPGPaintInterface {
public:
	virtual ~WPGPaintInterface() {}

	// none of the other callback functions will be called before this function is called
	virtual void startGraphics(const ::WPXPropertyList &propList) = 0;

	// none of the other callback functions will be called after this function is called
	virtual void endGraphics() = 0;

	virtual void setStyle(const ::WPXPropertyList &propList, const ::WPXPropertyListVector &gradient) = 0;

	virtual void startLayer(const ::WPXPropertyList &propList) = 0;

	virtual void endLayer() = 0;
	
	virtual void startEmbeddedGraphics(const ::WPXPropertyList &propList) = 0;
	
	virtual void endEmbeddedGraphics() = 0;

	// Different primitive shapes
	virtual void drawRectangle(const ::WPXPropertyList& propList) = 0;

	virtual void drawEllipse(const ::WPXPropertyList& propList) = 0;

	virtual void drawPolygon(const ::WPXPropertyListVector &vertices) = 0;

	virtual void drawPolyline(const ::WPXPropertyListVector &vertices) = 0;

	virtual void drawPath(const ::WPXPropertyListVector &path) = 0;

	// Embedded binary/raster data
	virtual void drawGraphicObject(const ::WPXPropertyList &propList, const ::WPXBinaryData &binaryData) = 0;
	
	// Embedded text object
	virtual void startTextObject(const ::WPXPropertyList &propList, const ::WPXPropertyListVector &path) = 0;
	virtual void endTextObject() = 0;
	
	virtual void startTextLine(const ::WPXPropertyList &propList) = 0;
	virtual void endTextLine() = 0;
	
	virtual void startTextSpan(const ::WPXPropertyList &propList) = 0;
	virtual void endTextSpan() = 0;
	
	virtual void insertText(const ::WPXString &str) = 0;
};

} // namespace libwpg

#endif // __WPGPAINTINTERFACE_H__

