/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet;

import java.io.Serializable;

/**
 * Allows to set configuration parameters that will be included in the element as attribute value pair.<br/>
 * The following input<p/>
 *
 * &lt;configParam name="foo" value="bar"/&gt;<p/>
 *
 * will give <p/>
 *
 * &lt;foo&gt;bar&lt;/foo&gt;
 *
 * @author        Ara Abrahamian (ara_e@email.com)
 * @created       Jan 21, 2002
 * @version       $Revision: 1.7 $
 * @ant.element   name="configParam"
 */
public final class ConfigParameter implements Serializable
{
    private String  name = null;
    private String  value = null;

    /**
     * Gets the Name attribute of the ConfigParameter object
     *
     * @return   The Name value
     */
    public String getName()
    {
        return name;
    }

    /**
     * Gets the Value attribute of the ConfigParameter object
     *
     * @return   The Value value
     */
    public String getValue()
    {
        return value;
    }

    /**
     * The name of the parameter.
     *
     * @param name     The new Name value
     * @ant.required   Yes
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * The value of the parameter.
     *
     * @param value    The new Value value
     * @ant.required   Yes
     */
    public void setValue(String value)
    {
        this.value = value;
    }
}
