#include "crossTrainer.h"
#include "FTT1pnode.h"
#include "FTTpres.h"
#include "nodeMsg.h"
#include "Ftime.h"
#include "FGLink.h"
#include "FTT1pSubnode.h"
#include "FfreeList.h"
#include <stdio.h>

FTT1pnode::FTT1pnode(FGLnode *aSupervisor,FpTree *apTree,FTTpres *currentPres)
	:FTTnode(aSupervisor,apTree,currentPres,t1p){

// zero Fobject* members for proper deletion in case of 
// initialization failure		
	newPres=ZERO;
	newPresDispose=FALSE;
	itsSubnodes=ZERO;

// check to see if base class initialization succeeded
	if(!initOK)return;

// check for trivial presentation
	if(!currentPres->f->numItems){
		pTree->D.initInfo.TT1p.done=TRUE;
		initOK=FALSE;
		return;
	}
	
	currentNode=1;
	long size=currentPres->f->numItems;

// allocate and initialize loadRel if it is
// not already allocated.
	if(isNull(pTree->D.initInfo.TT1p.loadRel)){
		GLref ref;
		pTree->allocateSpace(ref,size);
		pTree->D.initInfo.TT1p.loadRel=ref;
		Ptr DEREF=pTree&ref;
		Ptr lastDEREF=&DEREF[size];
		for(;DEREF<lastDEREF;++DEREF) *DEREF=TRUE;
		pTree-ref;
	}
	
	// set the time limit
	// we have a little fudge here to give all the Subnodes a better
	// chance of being called even if some of the nodes are tardy
	
	long fudge=4;
	timeLimit=pTree->D.bank.TT1paccount.balance/(size+fudge);

// create itsSubnodes
// initialize a FTT1pSubnode for each TRUE entry in loadRel
// append to itsSubnodes;

	itsSubnodes= new FList(size);
	GLref ref=pTree->D.initInfo.TT1p.loadRel;
	Ptr DEREF=pTree&ref;
	--DEREF;  // we bias the pointer to compensate for 1-based index
	for(long i=1;i<=size;++i){
		if(DEREF[i]){
			FTT1pSubnode *sub
				=new FTT1pSubnode(this,currentPres,i,timeLimit);
			itsSubnodes->Append(sub);
		}
	}
	pTree-ref;
	
	
// startup
	func=TT1pFunc;
	currentNode=1;	
}


FTT1pnode::~FTT1pnode(void){
	if(itsSubnodes){
		long num=itsSubnodes->numItems;
		for(long i=1;i<=num;++i){
			FTT1pSubnode* sub=(FTT1pSubnode*)itsSubnodes->NthItem(i);
			delete sub;
		}
		delete itsSubnodes; itsSubnodes=0;
	}
	if(newPresDispose){delete newPres; newPres=0;}
}

Boolean FTT1pnode::TT1pFunc(FGLnode *node){
	return ((FTT1pnode*)node)->go();
}

Boolean FTT1pnode::go(void){
	FTT1pSubnode *sub=(FTT1pSubnode*)itsSubnodes->NthItem(currentNode);
	if(!sub){
		nodeErr(32);
	}
	Boolean returnVal=TRUE,advanceToNextNode=FALSE;

#ifdef Frank_GenuineMac
	TRY{
#endif
		if(!sub->run()){
			advanceToNextNode=TRUE;
			if(!sub->func){
				// the subnode has terminated voluntarily
				if(newPres){
					// the fat lady is singing!
					// ownership of newPres passes
					// to the driver and the distinguished
					// subnode is removed from the list.
					// Control passes to the driver.

					newPresDispose=FALSE;
					removeSubnode();
					returnVal=FALSE;
				}
				else{
					// the  distinguished relator is not a consequence
					// this can only be positively determined if the group
					// generated by the other relators is finite.  The node
					// is removed from this list.  Control passes to driver
					// if there are no nodes on the list.

					returnVal=removeSubnode();
				}
			}
		}
#ifdef Frank_GenuineMac
	}
	CATCH{
		if(gLastError==memFullErr){
			NO_PROPAGATE;
			
			// The subnode has run out of memory.  If no other subnodes
			// are suspended, then the subnode failed while using all
			// available memory.  In this case, the node is removed
			// and the the algorithm is compromised.  
			
			// If there are other active subnodes, then the subnode is
			// disposed and reinitialized and the list of subnodes
			// is updated.  This frees up memory for the remaining active
			// subnodes and gives the current subnode a chance to run
			// again at a future date and perhaps have better luck.
			
			long num=itsSubnodes->numItems;
			Boolean otherNodeSuspended=FALSE;
			for(long i=1;i<=num && !otherNodeSuspended; ++i){
				FTT1pSubnode *aSubnode;
				aSubnode=(FTT1pSubnode*)itsSubnodes->NthItem(i);
				if(i!=currentNode){
					otherNodeSuspended= aSubnode->func!=0;
				}
			}
			if(otherNodeSuspended){
				long distinguishedRel=sub->distinguishedRel;
				delete sub;sub=0;
				sub= new FTT1pSubnode(this,currentPres,distinguishedRel,timeLimit);
				itsSubnodes->SetItem(&sub,currentNode);
			}
			else{
				returnVal=removeSubnode();
			}
		}
	}
	ENDTRY;
#endif

	if(advanceToNextNode){
		++currentNode;
		if(currentNode>itsSubnodes->numItems) currentNode=1;
	}
	return returnVal;
}



void FTT1pnode::auRevoir(void){
	FTTnode::auRevoir();
	send(TT1pAuRevoirMsg);
}

void FTT1pnode::goodbyeKiss(void){
	FTTnode::goodbyeKiss();
	send(TT1pGoodbyeKissMsg);
}

Boolean FTT1pnode::removeSubnode(void){
	if(itsSubnodes->numItems==1){
		pTree->D.initInfo.TT1p.done=TRUE;
		return FALSE;
	}
	FTT1pSubnode *sub=(FTT1pSubnode*)itsSubnodes->NthItem(currentNode);
	itsSubnodes->DeleteItem(currentNode);
	Ptr DEREF=pTree&pTree->D.initInfo.TT1p.loadRel;
	DEREF[sub->distinguishedRel-1]=FALSE;  // offset into loadRel is zero based
	pTree-pTree->D.initInfo.TT1p.loadRel;
	--currentNode;
	delete sub;sub=0;
	return TRUE;
}

void FTT1pnode::respond(short aMessage){
	switch (aMessage){
		case presGoodbyeKissMsg:{
			// the fat lady is stepping out onto the stage.
			// the construction of newPres is now complete.
			// ownership passes to FTT1pnode
			
			FTT1pSubnode *sub=(FTT1pSubnode*)itsSubnodes->NthItem(currentNode);
			newPres=sub->newPres;
			newPresDispose=TRUE;
		}
		break;
		case TT1pSubGoodbyeKissMsg:{
			FTT1pSubnode *sub;
			sub=(FTT1pSubnode*)itsSubnodes->NthItem(currentNode);
			sub->timeRemaining=timeLimit;
		}
		break;
		default: send(aMessage);
	
	}
}


