#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@" || echo "0"; exit 1

# --------------------------------------------------------
# Copyright (C) Martin Ošmera <P16F87504SP@seznam.cz>
# Licence: GPL
# Version: 1.0
# Homepage: http://sourceforge.net/projects/mcu8051ide
# --------------------------------------------------------
#
# Test for presence of a Tcl library
# Usage:
#	./test-lib LIBRARY [VERSION]
#
# --------------------------------------------------------

if {$argv == {--help}} {
	puts "Test for presence of Tcl library"
	puts "Usage:"
	puts "\t./test-lib LIBRARY [VERSION]"
}

if {$argc == 2} {
	if [catch {package require [lindex $argv 0] [lindex $argv 1]}] {
		puts {0}
		exit 1
	}
} elseif {$argc == 1} {
	if [catch {package require [lindex $argv 0]}] {
		puts {0}
		exit 1
	}
} else {
	puts {0}
	exit 1
}

puts {1}
exit 0

