/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Constants;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.jcraft.jogg.Buffer;

public class Quant {
    private static final int MIN_DEQUANT_VAL = 2;
    private static final int IDCT_SCALE_FACTOR = 2;

    private static int ilog(long l) {
        int n = 0;
        while (l != 0L) {
            ++n;
            l >>= 1;
        }
        return n;
    }

    private static int _read_qtable_range(Info info, Buffer buffer, int n) {
        int n2 = 0;
        buffer.readB(Quant.ilog(n - 1));
        while (n2 < 63) {
            int n3 = buffer.readB(Quant.ilog(62 - n2));
            if (++n3 <= 0) {
                return -20;
            }
            n2 += n3;
            buffer.readB(Quant.ilog(n - 1));
        }
        return 0;
    }

    public static int readQTables(Info info, Buffer buffer) {
        long l;
        long l2 = buffer.readB(4);
        ++l2;
        int n = 0;
        while (n < 64) {
            l = buffer.readB((int)l2);
            if (l2 < 0L) {
                return -20;
            }
            info.QThreshTable[n] = (int)l;
            ++n;
        }
        l2 = buffer.readB(4);
        ++l2;
        n = 0;
        while (n < 64) {
            l = buffer.readB((int)l2);
            if (l2 < 0L) {
                return -20;
            }
            info.DcScaleFactorTable[n] = (short)l;
            ++n;
        }
        int n2 = buffer.readB(9);
        if (++n2 != 3) {
            return -20;
        }
        info.qmats = new short[n2 * 64];
        info.MaxQMatrixIndex = n2;
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < 64) {
                l = buffer.readB(8);
                if (l2 < 0L) {
                    return -20;
                }
                info.qmats[(n3 << 6) + n] = (short)l;
                ++n;
            }
            ++n3;
        }
        int n4 = Quant._read_qtable_range(info, buffer, n2);
        if (n4 < 0) {
            return n4;
        }
        int n5 = buffer.readB(1);
        if (n5 < 0) {
            return -20;
        }
        if (n5 != 0 && (n4 = Quant._read_qtable_range(info, buffer, n2)) < 0) {
            return n4;
        }
        n5 = buffer.readB(1);
        if (n5 < 0) {
            return -20;
        }
        if (n5 != 0 && (n4 = Quant._read_qtable_range(info, buffer, n2)) < 0) {
            return n4;
        }
        n5 = buffer.readB(1);
        if (n5 < 0) {
            return -20;
        }
        if (n5 != 0) {
            n4 = Quant._read_qtable_range(info, buffer, n2);
            if (n4 < 0) {
                return n4;
            }
        } else {
            n5 = buffer.readB(1);
            if (n5 < 0) {
                return -20;
            }
        }
        if ((n5 = buffer.readB(1)) < 0) {
            return -20;
        }
        if (n5 != 0) {
            n4 = Quant._read_qtable_range(info, buffer, n2);
            if (n4 < 0) {
                return n4;
            }
        } else {
            n5 = buffer.readB(1);
            if (n5 < 0) {
                return -20;
            }
        }
        if ((n5 = buffer.readB(1)) < 0) {
            return -20;
        }
        if (n5 != 0) {
            n4 = Quant._read_qtable_range(info, buffer, n2);
            if (n4 < 0) {
                return n4;
            }
        } else {
            n5 = buffer.readB(1);
            if (n5 < 0) {
                return -20;
            }
        }
        System.arraycopy(info.qmats, 0, info.Y_coeffs, 0, 64);
        System.arraycopy(info.qmats, 64, info.UV_coeffs, 0, 64);
        System.arraycopy(info.qmats, 128, info.Inter_coeffs, 0, 64);
        return 0;
    }

    static void BuildQuantIndex_Generic(Playback playback) {
        int n = 0;
        while (n < 64) {
            int n2 = Constants.dequant_index[n];
            playback.quant_index[n2] = n++;
        }
    }

    static void init_dequantizer(Playback playback, int n, byte by) {
        short[] sArray = playback.Inter_coeffs;
        short[] sArray2 = playback.Y_coeffs;
        short[] sArray3 = playback.UV_coeffs;
        short[] sArray4 = playback.DcScaleFactorTable;
        short[] sArray5 = playback.DcScaleFactorTable;
        Quant.BuildQuantIndex_Generic(playback);
        int n2 = 0;
        while (n2 < 64) {
            int n3 = playback.quant_index[n2];
            playback.dequant_Y_coeffs[n3] = sArray2[n2];
            playback.dequant_Inter_coeffs[n3] = sArray[n2];
            playback.dequant_UV_coeffs[n3] = sArray3[n2];
            playback.dequant_InterUV_coeffs[n3] = sArray[n2];
            ++n2;
        }
        playback.dequant_Y_coeffs[0] = (short)(sArray4[by] * playback.dequant_Y_coeffs[0] / 100);
        if (playback.dequant_Y_coeffs[0] < 4) {
            playback.dequant_Y_coeffs[0] = 4;
        }
        playback.dequant_Y_coeffs[0] = (short)(playback.dequant_Y_coeffs[0] << 2);
        playback.dequant_UV_coeffs[0] = (short)(sArray5[by] * playback.dequant_UV_coeffs[0] / 100);
        if (playback.dequant_UV_coeffs[0] < 4) {
            playback.dequant_UV_coeffs[0] = 4;
        }
        playback.dequant_UV_coeffs[0] = (short)(playback.dequant_UV_coeffs[0] << 2);
        playback.dequant_Inter_coeffs[0] = (short)(sArray4[by] * playback.dequant_Inter_coeffs[0] / 100);
        if (playback.dequant_Inter_coeffs[0] < 8) {
            playback.dequant_Inter_coeffs[0] = 8;
        }
        playback.dequant_Inter_coeffs[0] = (short)(playback.dequant_Inter_coeffs[0] << 2);
        playback.dequant_InterUV_coeffs[0] = (short)(sArray5[by] * playback.dequant_InterUV_coeffs[0] / 100);
        if (playback.dequant_InterUV_coeffs[0] < 8) {
            playback.dequant_InterUV_coeffs[0] = 8;
        }
        playback.dequant_InterUV_coeffs[0] = (short)(playback.dequant_InterUV_coeffs[0] << 2);
        n2 = 1;
        while (n2 < 64) {
            playback.dequant_Y_coeffs[n2] = (short)(n * playback.dequant_Y_coeffs[n2] / 100);
            if (playback.dequant_Y_coeffs[n2] < 2) {
                playback.dequant_Y_coeffs[n2] = 2;
            }
            playback.dequant_Y_coeffs[n2] = (short)(playback.dequant_Y_coeffs[n2] << 2);
            playback.dequant_UV_coeffs[n2] = (short)(n * playback.dequant_UV_coeffs[n2] / 100);
            if (playback.dequant_UV_coeffs[n2] < 2) {
                playback.dequant_UV_coeffs[n2] = 2;
            }
            playback.dequant_UV_coeffs[n2] = (short)(playback.dequant_UV_coeffs[n2] << 2);
            playback.dequant_Inter_coeffs[n2] = (short)(n * playback.dequant_Inter_coeffs[n2] / 100);
            if (playback.dequant_Inter_coeffs[n2] < 4) {
                playback.dequant_Inter_coeffs[n2] = 4;
            }
            playback.dequant_Inter_coeffs[n2] = (short)(playback.dequant_Inter_coeffs[n2] << 2);
            playback.dequant_InterUV_coeffs[n2] = (short)(n * playback.dequant_InterUV_coeffs[n2] / 100);
            if (playback.dequant_InterUV_coeffs[n2] < 4) {
                playback.dequant_InterUV_coeffs[n2] = 4;
            }
            playback.dequant_InterUV_coeffs[n2] = (short)(playback.dequant_InterUV_coeffs[n2] << 2);
            ++n2;
        }
    }

    public static void UpdateQ(Playback playback, int n) {
        int n2 = n;
        if (n2 < playback.QThreshTable[63]) {
            n2 = playback.QThreshTable[63];
        } else if (n2 > playback.QThreshTable[0]) {
            n2 = playback.QThreshTable[0];
        }
        playback.FrameQIndex = 63;
        while (playback.FrameQIndex >= 0) {
            if (playback.FrameQIndex == 0 || playback.QThreshTable[playback.FrameQIndex] >= n) break;
            --playback.FrameQIndex;
        }
        Quant.init_dequantizer(playback, n2, (byte)playback.FrameQIndex);
    }
}

