#include <qlistview.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <stdio.h>
#include "schema.h"
#include "schemalistviewitem.h"
#include "database.xpm"
#include "expand.xpm"
#include "collapse.xpm"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"


void Schema::slot_expand(QListViewItem *data)
{
	if(data == NULL)
		return;

	if(data->childCount() == 0)
		return;

	if(((SchemaListViewItem *)data)->flag == FLAG_USER_ROOT)
	{
		user_flag = FLAG_EXPAND;
		return;
	}

	if(((SchemaListViewItem *)data)->flag == FLAG_DATABASE)
		status.replace(data->text(0), TRUE);

	if(((SchemaListViewItem *)data)->flag == FLAG_TABLE)
	{
		QString database = ((SchemaListViewItem *)data)->database;

		struct table_value value;
		memset((void *)&value, 0, sizeof(struct table_value));

		QMap<QString, struct table_value> s = table_map.find(database).data();
		sprintf(value.table, "%s", data->text(0).latin1());
		value.value = FLAG_EXPAND;
		s.replace(data->text(0), value);
			
		table_map.replace(database, s);
	}
}

void Schema::slot_collapse(QListViewItem *data)
{
	if(data == NULL)
		return;

	if(data->childCount() == 0)
		return;

	if(((SchemaListViewItem *)data)->flag == FLAG_USER_ROOT)
	{
		user_flag = FLAG_COLLAPSE;
		return;
	}

	if(((SchemaListViewItem *)data)->flag == FLAG_DATABASE)
		status.replace(data->text(0), FALSE);

	if(((SchemaListViewItem *)data)->flag == FLAG_TABLE)
	{
		QString database = ((SchemaListViewItem *)data)->database;

		struct table_value value;
		memset((void *)&value, 0, sizeof(struct table_value));

		QMap<QString, struct table_value> s = table_map.find(database).data();
		sprintf(value.table, "%s", data->text(0).latin1());
		value.value = FLAG_COLLAPSE;
		s.replace(data->text(0), value);

		table_map.replace(database, s);
	}
}

void Schema::slot_schema()
{
	MYSQL_RES *result;	
	MYSQL_ROW row;

	clear();

	// database
	SchemaListViewItem *host=new SchemaListViewItem(this, NULL, QString(this->host), FLAG_HOST);
	SchemaListViewItem *z = new SchemaListViewItem(host, NULL, tr("Database"), FLAG_DATABASE_ROOT);
	host->setOpen(TRUE);
	z->setOpen(TRUE);

	SchemaListViewItem *database;

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		debug("mysql_list_dbs failed");
		return ;
	}

	database = NULL;

	while((row = mysql_fetch_row(result)))
	{
		database = new SchemaListViewItem(z, database, row[0], FLAG_DATABASE);
		database->setPixmap(0, QPixmap(database_xpm));
		set_table(database);

		if(status.find(row[0]) != status.end())
			if(status.find(row[0]).data())
				database->setOpen(TRUE);
	}
	mysql_free_result(result);

	// user
	z = new SchemaListViewItem(host, z, tr("User"), FLAG_USER_ROOT);
		
	if(mysql_select_db(mysql, "mysql"))
		return;
	
	if(SQL::sql_query("select host, user from user"))
		return;
	
	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	SchemaListViewItem *user = NULL;

	while((row = mysql_fetch_row(result)))
	{
		 user = new SchemaListViewItem(z, user, QString(row[1]) + "@" + row[0], FLAG_USER, "", "", row[0], row[1]);
		 user->setPixmap(0, QPixmap(database_xpm));
	}
	mysql_free_result(result);

	if(user_flag == FLAG_EXPAND)
		setOpen(z, TRUE);
}

void Schema::slot_pressed(int button, QListViewItem *value, const QPoint &, int z)
{
	if(value == NULL)
		return;

	if(((SchemaListViewItem *)value)->flag == FLAG_TABLE)
	{
		QString database = ((SchemaListViewItem *)value)->database;

		if(button == LeftButton)
		{
			if(z == 1)
			{
				QMap<QString, struct table_value> s = table_map.find(database).data();
				if(s.find(value->text(0)) == s.end())
				{
					((MainWindow *)qApp->mainWidget())->hay = value;
					((MainWindow *)qApp->mainWidget())->slot_list_fields(0);
					value->setText(1, "-");
					//value->setText(1, QChar(0x91, 0x21));
					//value->setPixmap(1, QPixmap(collapse_xpm));
				}
				else
				{
					((MainWindow *)qApp->mainWidget())->hay = value;
					((MainWindow *)qApp->mainWidget())->slot_unlist_fields(0);
					value->setText(1, "+");
					//value->setText(1, QChar(0x93, 0x21));
					//value->setPixmap(1, QPixmap(expand_xpm));
				}
			}
		}
	}
}
