/** \file unicode.cpp
 * Unicode functions
 *
 * $Id: unicode.cpp,v 1.2 2004-10-26 16:08:47 corvazier Exp $
 */

/* Copyright, 2001 Nevrax Ltd.
 *
 * This file is part of NEVRAX NEL.
 * NEVRAX NEL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * NEVRAX NEL is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with NEVRAX NEL; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "stdmisc.h"
#include "nel/misc/ucstring.h"

namespace	NLMISC
{

// Uppercase to lowercase 16 bits unicode. This table must be sorted. First entry must be unique.
static const ucchar UnicodeUpperToLower[]=
{
	0x0041, 0x0061,	// LATIN CAPITAL LETTER A
	0x0042, 0x0062,	// LATIN CAPITAL LETTER B
	0x0043, 0x0063,	// LATIN CAPITAL LETTER C
	0x0044, 0x0064,	// LATIN CAPITAL LETTER D
	0x0045, 0x0065,	// LATIN CAPITAL LETTER E
	0x0046, 0x0066,	// LATIN CAPITAL LETTER F
	0x0047, 0x0067,	// LATIN CAPITAL LETTER G
	0x0048, 0x0068, // LATIN CAPITAL LETTER H
	0x0049, 0x0069, // LATIN CAPITAL LETTER I
	0x004A, 0x006A, // LATIN CAPITAL LETTER J
	0x004B, 0x006B, // LATIN CAPITAL LETTER K
	0x004C, 0x006C, // LATIN CAPITAL LETTER L
	0x004D, 0x006D, // LATIN CAPITAL LETTER M
	0x004E, 0x006E, // LATIN CAPITAL LETTER N
	0x004F, 0x006F, // LATIN CAPITAL LETTER O
	0x0050, 0x0070, // LATIN CAPITAL LETTER P
	0x0051, 0x0071, // LATIN CAPITAL LETTER Q
	0x0052, 0x0072, // LATIN CAPITAL LETTER R
	0x0053, 0x0073, // LATIN CAPITAL LETTER S
	0x0054, 0x0074, // LATIN CAPITAL LETTER T
	0x0055, 0x0075, // LATIN CAPITAL LETTER U
	0x0056, 0x0076, // LATIN CAPITAL LETTER V
	0x0057, 0x0077, // LATIN CAPITAL LETTER W
	0x0058, 0x0078, // LATIN CAPITAL LETTER X
	0x0059, 0x0079, // LATIN CAPITAL LETTER Y
	0x005A, 0x007A, // LATIN CAPITAL LETTER Z
	0x00B5, 0x03BC, // MICRO SIGN
	0x00C0, 0x00E0, // LATIN CAPITAL LETTER A WITH GRAVE
	0x00C1, 0x00E1, // LATIN CAPITAL LETTER A WITH ACUTE
	0x00C2, 0x00E2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	0x00C3, 0x00E3, // LATIN CAPITAL LETTER A WITH TILDE
	0x00C4, 0x00E4, // LATIN CAPITAL LETTER A WITH DIAERESIS
	0x00C5, 0x00E5, // LATIN CAPITAL LETTER A WITH RING ABOVE
	0x00C6, 0x00E6, // LATIN CAPITAL LETTER AE
	0x00C7, 0x00E7, // LATIN CAPITAL LETTER C WITH CEDILLA
	0x00C8, 0x00E8, // LATIN CAPITAL LETTER E WITH GRAVE
	0x00C9, 0x00E9, // LATIN CAPITAL LETTER E WITH ACUTE
	0x00CA, 0x00EA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	0x00CB, 0x00EB, // LATIN CAPITAL LETTER E WITH DIAERESIS
	0x00CC, 0x00EC, // LATIN CAPITAL LETTER I WITH GRAVE
	0x00CD, 0x00ED, // LATIN CAPITAL LETTER I WITH ACUTE
	0x00CE, 0x00EE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	0x00CF, 0x00EF, // LATIN CAPITAL LETTER I WITH DIAERESIS
	0x00D0, 0x00F0, // LATIN CAPITAL LETTER ETH
	0x00D1, 0x00F1, // LATIN CAPITAL LETTER N WITH TILDE
	0x00D2, 0x00F2, // LATIN CAPITAL LETTER O WITH GRAVE
	0x00D3, 0x00F3, // LATIN CAPITAL LETTER O WITH ACUTE
	0x00D4, 0x00F4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	0x00D5, 0x00F5, // LATIN CAPITAL LETTER O WITH TILDE
	0x00D6, 0x00F6, // LATIN CAPITAL LETTER O WITH DIAERESIS
	0x00D8, 0x00F8, // LATIN CAPITAL LETTER O WITH STROKE
	0x00D9, 0x00F9, // LATIN CAPITAL LETTER U WITH GRAVE
	0x00DA, 0x00FA, // LATIN CAPITAL LETTER U WITH ACUTE
	0x00DB, 0x00FB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	0x00DC, 0x00FC, // LATIN CAPITAL LETTER U WITH DIAERESIS
	0x00DD, 0x00FD, // LATIN CAPITAL LETTER Y WITH ACUTE
	0x00DE, 0x00FE, // LATIN CAPITAL LETTER THORN
	0x00DF, 0x0073 , // # LATIN SMALL LETTER SHARP S
	0x0100, 0x0101, // LATIN CAPITAL LETTER A WITH MACRON
	0x0102, 0x0103, // LATIN CAPITAL LETTER A WITH BREVE
	0x0104, 0x0105, // LATIN CAPITAL LETTER A WITH OGONEK
	0x0106, 0x0107, // LATIN CAPITAL LETTER C WITH ACUTE
	0x0108, 0x0109, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
	0x010A, 0x010B, // LATIN CAPITAL LETTER C WITH DOT ABOVE
	0x010C, 0x010D, // LATIN CAPITAL LETTER C WITH CARON
	0x010E, 0x010F, // LATIN CAPITAL LETTER D WITH CARON
	0x0110, 0x0111, // LATIN CAPITAL LETTER D WITH STROKE
	0x0112, 0x0113, // LATIN CAPITAL LETTER E WITH MACRON
	0x0114, 0x0115, // LATIN CAPITAL LETTER E WITH BREVE
	0x0116, 0x0117, // LATIN CAPITAL LETTER E WITH DOT ABOVE
	0x0118, 0x0119, // LATIN CAPITAL LETTER E WITH OGONEK
	0x011A, 0x011B, // LATIN CAPITAL LETTER E WITH CARON
	0x011C, 0x011D, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
	0x011E, 0x011F, // LATIN CAPITAL LETTER G WITH BREVE
	0x0120, 0x0121, // LATIN CAPITAL LETTER G WITH DOT ABOVE
	0x0122, 0x0123, // LATIN CAPITAL LETTER G WITH CEDILLA
	0x0124, 0x0125, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
	0x0126, 0x0127, // LATIN CAPITAL LETTER H WITH STROKE
	0x0128, 0x0129, // LATIN CAPITAL LETTER I WITH TILDE
	0x012A, 0x012B, // LATIN CAPITAL LETTER I WITH MACRON
	0x012C, 0x012D, // LATIN CAPITAL LETTER I WITH BREVE
	0x012E, 0x012F, // LATIN CAPITAL LETTER I WITH OGONEK
	0x0130, 0x0069, // LATIN CAPITAL LETTER I WITH DOT ABOVE
	0x0132, 0x0133, // LATIN CAPITAL LIGATURE IJ
	0x0134, 0x0135, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
	0x0136, 0x0137, // LATIN CAPITAL LETTER K WITH CEDILLA
	0x0139, 0x013A, // LATIN CAPITAL LETTER L WITH ACUTE
	0x013B, 0x013C, // LATIN CAPITAL LETTER L WITH CEDILLA
	0x013D, 0x013E, // LATIN CAPITAL LETTER L WITH CARON
	0x013F, 0x0140, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
	0x0141, 0x0142, // LATIN CAPITAL LETTER L WITH STROKE
	0x0143, 0x0144, // LATIN CAPITAL LETTER N WITH ACUTE
	0x0145, 0x0146, // LATIN CAPITAL LETTER N WITH CEDILLA
	0x0147, 0x0148, // LATIN CAPITAL LETTER N WITH CARON
	0x0149, 0x02BC , // # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
	0x014A, 0x014B, // LATIN CAPITAL LETTER ENG
	0x014C, 0x014D, // LATIN CAPITAL LETTER O WITH MACRON
	0x014E, 0x014F, // LATIN CAPITAL LETTER O WITH BREVE
	0x0150, 0x0151, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
	0x0152, 0x0153, // LATIN CAPITAL LIGATURE OE
	0x0154, 0x0155, // LATIN CAPITAL LETTER R WITH ACUTE
	0x0156, 0x0157, // LATIN CAPITAL LETTER R WITH CEDILLA
	0x0158, 0x0159, // LATIN CAPITAL LETTER R WITH CARON
	0x015A, 0x015B, // LATIN CAPITAL LETTER S WITH ACUTE
	0x015C, 0x015D, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
	0x015E, 0x015F, // LATIN CAPITAL LETTER S WITH CEDILLA
	0x0160, 0x0161, // LATIN CAPITAL LETTER S WITH CARON
	0x0162, 0x0163, // LATIN CAPITAL LETTER T WITH CEDILLA
	0x0164, 0x0165, // LATIN CAPITAL LETTER T WITH CARON
	0x0166, 0x0167, // LATIN CAPITAL LETTER T WITH STROKE
	0x0168, 0x0169, // LATIN CAPITAL LETTER U WITH TILDE
	0x016A, 0x016B, // LATIN CAPITAL LETTER U WITH MACRON
	0x016C, 0x016D, // LATIN CAPITAL LETTER U WITH BREVE
	0x016E, 0x016F, // LATIN CAPITAL LETTER U WITH RING ABOVE
	0x0170, 0x0171, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
	0x0172, 0x0173, // LATIN CAPITAL LETTER U WITH OGONEK
	0x0174, 0x0175, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
	0x0176, 0x0177, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
	0x0178, 0x00FF, // LATIN CAPITAL LETTER Y WITH DIAERESIS
	0x0179, 0x017A, // LATIN CAPITAL LETTER Z WITH ACUTE
	0x017B, 0x017C, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
	0x017D, 0x017E, // LATIN CAPITAL LETTER Z WITH CARON
	0x017F, 0x0073, // LATIN SMALL LETTER LONG S
	0x0181, 0x0253, // LATIN CAPITAL LETTER B WITH HOOK
	0x0182, 0x0183, // LATIN CAPITAL LETTER B WITH TOPBAR
	0x0184, 0x0185, // LATIN CAPITAL LETTER TONE SIX
	0x0186, 0x0254, // LATIN CAPITAL LETTER OPEN O
	0x0187, 0x0188, // LATIN CAPITAL LETTER C WITH HOOK
	0x0189, 0x0256, // LATIN CAPITAL LETTER AFRICAN D
	0x018A, 0x0257, // LATIN CAPITAL LETTER D WITH HOOK
	0x018B, 0x018C, // LATIN CAPITAL LETTER D WITH TOPBAR
	0x018E, 0x01DD, // LATIN CAPITAL LETTER REVERSED E
	0x018F, 0x0259, // LATIN CAPITAL LETTER SCHWA
	0x0190, 0x025B, // LATIN CAPITAL LETTER OPEN E
	0x0191, 0x0192, // LATIN CAPITAL LETTER F WITH HOOK
	0x0193, 0x0260, // LATIN CAPITAL LETTER G WITH HOOK
	0x0194, 0x0263, // LATIN CAPITAL LETTER GAMMA
	0x0196, 0x0269, // LATIN CAPITAL LETTER IOTA
	0x0197, 0x0268, // LATIN CAPITAL LETTER I WITH STROKE
	0x0198, 0x0199, // LATIN CAPITAL LETTER K WITH HOOK
	0x019C, 0x026F, // LATIN CAPITAL LETTER TURNED M
	0x019D, 0x0272, // LATIN CAPITAL LETTER N WITH LEFT HOOK
	0x019F, 0x0275, // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
	0x01A0, 0x01A1, // LATIN CAPITAL LETTER O WITH HORN
	0x01A2, 0x01A3, // LATIN CAPITAL LETTER OI
	0x01A4, 0x01A5, // LATIN CAPITAL LETTER P WITH HOOK
	0x01A6, 0x0280, // LATIN LETTER YR
	0x01A7, 0x01A8, // LATIN CAPITAL LETTER TONE TWO
	0x01A9, 0x0283, // LATIN CAPITAL LETTER ESH
	0x01AC, 0x01AD, // LATIN CAPITAL LETTER T WITH HOOK
	0x01AE, 0x0288, // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
	0x01AF, 0x01B0, // LATIN CAPITAL LETTER U WITH HORN
	0x01B1, 0x028A, // LATIN CAPITAL LETTER UPSILON
	0x01B2, 0x028B, // LATIN CAPITAL LETTER V WITH HOOK
	0x01B3, 0x01B4, // LATIN CAPITAL LETTER Y WITH HOOK
	0x01B5, 0x01B6, // LATIN CAPITAL LETTER Z WITH STROKE
	0x01B7, 0x0292, // LATIN CAPITAL LETTER EZH
	0x01B8, 0x01B9, // LATIN CAPITAL LETTER EZH REVERSED
	0x01BC, 0x01BD, // LATIN CAPITAL LETTER TONE FIVE
	0x01C4, 0x01C6, // LATIN CAPITAL LETTER DZ WITH CARON
	0x01C5, 0x01C6, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
	0x01C7, 0x01C9, // LATIN CAPITAL LETTER LJ
	0x01C8, 0x01C9, // LATIN CAPITAL LETTER L WITH SMALL LETTER J
	0x01CA, 0x01CC, // LATIN CAPITAL LETTER NJ
	0x01CB, 0x01CC, // LATIN CAPITAL LETTER N WITH SMALL LETTER J
	0x01CD, 0x01CE, // LATIN CAPITAL LETTER A WITH CARON
	0x01CF, 0x01D0, // LATIN CAPITAL LETTER I WITH CARON
	0x01D1, 0x01D2, // LATIN CAPITAL LETTER O WITH CARON
	0x01D3, 0x01D4, // LATIN CAPITAL LETTER U WITH CARON
	0x01D5, 0x01D6, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	0x01D7, 0x01D8, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	0x01D9, 0x01DA, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	0x01DB, 0x01DC, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	0x01DE, 0x01DF, // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
	0x01E0, 0x01E1, // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
	0x01E2, 0x01E3, // LATIN CAPITAL LETTER AE WITH MACRON
	0x01E4, 0x01E5, // LATIN CAPITAL LETTER G WITH STROKE
	0x01E6, 0x01E7, // LATIN CAPITAL LETTER G WITH CARON
	0x01E8, 0x01E9, // LATIN CAPITAL LETTER K WITH CARON
	0x01EA, 0x01EB, // LATIN CAPITAL LETTER O WITH OGONEK
	0x01EC, 0x01ED, // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
	0x01EE, 0x01EF, // LATIN CAPITAL LETTER EZH WITH CARON
	0x01F0, 0x006A , // # LATIN SMALL LETTER J WITH CARON
	0x01F1, 0x01F3, // LATIN CAPITAL LETTER DZ
	0x01F2, 0x01F3, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
	0x01F4, 0x01F5, // LATIN CAPITAL LETTER G WITH ACUTE
	0x01F6, 0x0195, // LATIN CAPITAL LETTER HWAIR
	0x01F7, 0x01BF, // LATIN CAPITAL LETTER WYNN
	0x01F8, 0x01F9, // LATIN CAPITAL LETTER N WITH GRAVE
	0x01FA, 0x01FB, // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
	0x01FC, 0x01FD, // LATIN CAPITAL LETTER AE WITH ACUTE
	0x01FE, 0x01FF, // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
	0x0200, 0x0201, // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
	0x0202, 0x0203, // LATIN CAPITAL LETTER A WITH INVERTED BREVE
	0x0204, 0x0205, // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
	0x0206, 0x0207, // LATIN CAPITAL LETTER E WITH INVERTED BREVE
	0x0208, 0x0209, // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
	0x020A, 0x020B, // LATIN CAPITAL LETTER I WITH INVERTED BREVE
	0x020C, 0x020D, // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
	0x020E, 0x020F, // LATIN CAPITAL LETTER O WITH INVERTED BREVE
	0x0210, 0x0211, // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
	0x0212, 0x0213, // LATIN CAPITAL LETTER R WITH INVERTED BREVE
	0x0214, 0x0215, // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
	0x0216, 0x0217, // LATIN CAPITAL LETTER U WITH INVERTED BREVE
	0x0218, 0x0219, // LATIN CAPITAL LETTER S WITH COMMA BELOW
	0x021A, 0x021B, // LATIN CAPITAL LETTER T WITH COMMA BELOW
	0x021C, 0x021D, // LATIN CAPITAL LETTER YOGH
	0x021E, 0x021F, // LATIN CAPITAL LETTER H WITH CARON
	0x0220, 0x019E, // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
	0x0222, 0x0223, // LATIN CAPITAL LETTER OU
	0x0224, 0x0225, // LATIN CAPITAL LETTER Z WITH HOOK
	0x0226, 0x0227, // LATIN CAPITAL LETTER A WITH DOT ABOVE
	0x0228, 0x0229, // LATIN CAPITAL LETTER E WITH CEDILLA
	0x022A, 0x022B, // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
	0x022C, 0x022D, // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
	0x022E, 0x022F, // LATIN CAPITAL LETTER O WITH DOT ABOVE
	0x0230, 0x0231, // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
	0x0232, 0x0233, // LATIN CAPITAL LETTER Y WITH MACRON
	0x0345, 0x03B9, // COMBINING GREEK YPOGEGRAMMENI
	0x0386, 0x03AC, // GREEK CAPITAL LETTER ALPHA WITH TONOS
	0x0388, 0x03AD, // GREEK CAPITAL LETTER EPSILON WITH TONOS
	0x0389, 0x03AE, // GREEK CAPITAL LETTER ETA WITH TONOS
	0x038A, 0x03AF, // GREEK CAPITAL LETTER IOTA WITH TONOS
	0x038C, 0x03CC, // GREEK CAPITAL LETTER OMICRON WITH TONOS
	0x038E, 0x03CD, // GREEK CAPITAL LETTER UPSILON WITH TONOS
	0x038F, 0x03CE, // GREEK CAPITAL LETTER OMEGA WITH TONOS
	0x0390, 0x03B9 , // ; # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
	0x0391, 0x03B1, // GREEK CAPITAL LETTER ALPHA
	0x0392, 0x03B2, // GREEK CAPITAL LETTER BETA
	0x0393, 0x03B3, // GREEK CAPITAL LETTER GAMMA
	0x0394, 0x03B4, // GREEK CAPITAL LETTER DELTA
	0x0395, 0x03B5, // GREEK CAPITAL LETTER EPSILON
	0x0396, 0x03B6, // GREEK CAPITAL LETTER ZETA
	0x0397, 0x03B7, // GREEK CAPITAL LETTER ETA
	0x0398, 0x03B8, // GREEK CAPITAL LETTER THETA
	0x0399, 0x03B9, // GREEK CAPITAL LETTER IOTA
	0x039A, 0x03BA, // GREEK CAPITAL LETTER KAPPA
	0x039B, 0x03BB, // GREEK CAPITAL LETTER LAMDA
	0x039C, 0x03BC, // GREEK CAPITAL LETTER MU
	0x039D, 0x03BD, // GREEK CAPITAL LETTER NU
	0x039E, 0x03BE, // GREEK CAPITAL LETTER XI
	0x039F, 0x03BF, // GREEK CAPITAL LETTER OMICRON
	0x03A0, 0x03C0, // GREEK CAPITAL LETTER PI
	0x03A1, 0x03C1, // GREEK CAPITAL LETTER RHO
	0x03A3, 0x03C3, // GREEK CAPITAL LETTER SIGMA
	0x03A4, 0x03C4, // GREEK CAPITAL LETTER TAU
	0x03A5, 0x03C5, // GREEK CAPITAL LETTER UPSILON
	0x03A6, 0x03C6, // GREEK CAPITAL LETTER PHI
	0x03A7, 0x03C7, // GREEK CAPITAL LETTER CHI
	0x03A8, 0x03C8, // GREEK CAPITAL LETTER PSI
	0x03A9, 0x03C9, // GREEK CAPITAL LETTER OMEGA
	0x03AA, 0x03CA, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
	0x03AB, 0x03CB, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
	0x03B0, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
	0x03C2, 0x03C3, // GREEK SMALL LETTER FINAL SIGMA
	0x03D0, 0x03B2, // GREEK BETA SYMBOL
	0x03D1, 0x03B8, // GREEK THETA SYMBOL
	0x03D5, 0x03C6, // GREEK PHI SYMBOL
	0x03D6, 0x03C0, // GREEK PI SYMBOL
	0x03D8, 0x03D9, // GREEK LETTER ARCHAIC KOPPA
	0x03DA, 0x03DB, // GREEK LETTER STIGMA
	0x03DC, 0x03DD, // GREEK LETTER DIGAMMA
	0x03DE, 0x03DF, // GREEK LETTER KOPPA
	0x03E0, 0x03E1, // GREEK LETTER SAMPI
	0x03E2, 0x03E3, // COPTIC CAPITAL LETTER SHEI
	0x03E4, 0x03E5, // COPTIC CAPITAL LETTER FEI
	0x03E6, 0x03E7, // COPTIC CAPITAL LETTER KHEI
	0x03E8, 0x03E9, // COPTIC CAPITAL LETTER HORI
	0x03EA, 0x03EB, // COPTIC CAPITAL LETTER GANGIA
	0x03EC, 0x03ED, // COPTIC CAPITAL LETTER SHIMA
	0x03EE, 0x03EF, // COPTIC CAPITAL LETTER DEI
	0x03F0, 0x03BA, // GREEK KAPPA SYMBOL
	0x03F1, 0x03C1, // GREEK RHO SYMBOL
	0x03F4, 0x03B8, // GREEK CAPITAL THETA SYMBOL
	0x03F5, 0x03B5, // GREEK LUNATE EPSILON SYMBOL
	0x03F7, 0x03F8, // GREEK CAPITAL LETTER SHO
	0x03F9, 0x03F2, // GREEK CAPITAL LUNATE SIGMA SYMBOL
	0x03FA, 0x03FB, // GREEK CAPITAL LETTER SAN
	0x0400, 0x0450, // CYRILLIC CAPITAL LETTER IE WITH GRAVE
	0x0401, 0x0451, // CYRILLIC CAPITAL LETTER IO
	0x0402, 0x0452, // CYRILLIC CAPITAL LETTER DJE
	0x0403, 0x0453, // CYRILLIC CAPITAL LETTER GJE
	0x0404, 0x0454, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
	0x0405, 0x0455, // CYRILLIC CAPITAL LETTER DZE
	0x0406, 0x0456, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
	0x0407, 0x0457, // CYRILLIC CAPITAL LETTER YI
	0x0408, 0x0458, // CYRILLIC CAPITAL LETTER JE
	0x0409, 0x0459, // CYRILLIC CAPITAL LETTER LJE
	0x040A, 0x045A, // CYRILLIC CAPITAL LETTER NJE
	0x040B, 0x045B, // CYRILLIC CAPITAL LETTER TSHE
	0x040C, 0x045C, // CYRILLIC CAPITAL LETTER KJE
	0x040D, 0x045D, // CYRILLIC CAPITAL LETTER I WITH GRAVE
	0x040E, 0x045E, // CYRILLIC CAPITAL LETTER SHORT U
	0x040F, 0x045F, // CYRILLIC CAPITAL LETTER DZHE
	0x0410, 0x0430, // CYRILLIC CAPITAL LETTER A
	0x0411, 0x0431, // CYRILLIC CAPITAL LETTER BE
	0x0412, 0x0432, // CYRILLIC CAPITAL LETTER VE
	0x0413, 0x0433, // CYRILLIC CAPITAL LETTER GHE
	0x0414, 0x0434, // CYRILLIC CAPITAL LETTER DE
	0x0415, 0x0435, // CYRILLIC CAPITAL LETTER IE
	0x0416, 0x0436, // CYRILLIC CAPITAL LETTER ZHE
	0x0417, 0x0437, // CYRILLIC CAPITAL LETTER ZE
	0x0418, 0x0438, // CYRILLIC CAPITAL LETTER I
	0x0419, 0x0439, // CYRILLIC CAPITAL LETTER SHORT I
	0x041A, 0x043A, // CYRILLIC CAPITAL LETTER KA
	0x041B, 0x043B, // CYRILLIC CAPITAL LETTER EL
	0x041C, 0x043C, // CYRILLIC CAPITAL LETTER EM
	0x041D, 0x043D, // CYRILLIC CAPITAL LETTER EN
	0x041E, 0x043E, // CYRILLIC CAPITAL LETTER O
	0x041F, 0x043F, // CYRILLIC CAPITAL LETTER PE
	0x0420, 0x0440, // CYRILLIC CAPITAL LETTER ER
	0x0421, 0x0441, // CYRILLIC CAPITAL LETTER ES
	0x0422, 0x0442, // CYRILLIC CAPITAL LETTER TE
	0x0423, 0x0443, // CYRILLIC CAPITAL LETTER U
	0x0424, 0x0444, // CYRILLIC CAPITAL LETTER EF
	0x0425, 0x0445, // CYRILLIC CAPITAL LETTER HA
	0x0426, 0x0446, // CYRILLIC CAPITAL LETTER TSE
	0x0427, 0x0447, // CYRILLIC CAPITAL LETTER CHE
	0x0428, 0x0448, // CYRILLIC CAPITAL LETTER SHA
	0x0429, 0x0449, // CYRILLIC CAPITAL LETTER SHCHA
	0x042A, 0x044A, // CYRILLIC CAPITAL LETTER HARD SIGN
	0x042B, 0x044B, // CYRILLIC CAPITAL LETTER YERU
	0x042C, 0x044C, // CYRILLIC CAPITAL LETTER SOFT SIGN
	0x042D, 0x044D, // CYRILLIC CAPITAL LETTER E
	0x042E, 0x044E, // CYRILLIC CAPITAL LETTER YU
	0x042F, 0x044F, // CYRILLIC CAPITAL LETTER YA
	0x0460, 0x0461, // CYRILLIC CAPITAL LETTER OMEGA
	0x0462, 0x0463, // CYRILLIC CAPITAL LETTER YAT
	0x0464, 0x0465, // CYRILLIC CAPITAL LETTER IOTIFIED E
	0x0466, 0x0467, // CYRILLIC CAPITAL LETTER LITTLE YUS
	0x0468, 0x0469, // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
	0x046A, 0x046B, // CYRILLIC CAPITAL LETTER BIG YUS
	0x046C, 0x046D, // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
	0x046E, 0x046F, // CYRILLIC CAPITAL LETTER KSI
	0x0470, 0x0471, // CYRILLIC CAPITAL LETTER PSI
	0x0472, 0x0473, // CYRILLIC CAPITAL LETTER FITA
	0x0474, 0x0475, // CYRILLIC CAPITAL LETTER IZHITSA
	0x0476, 0x0477, // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
	0x0478, 0x0479, // CYRILLIC CAPITAL LETTER UK
	0x047A, 0x047B, // CYRILLIC CAPITAL LETTER ROUND OMEGA
	0x047C, 0x047D, // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
	0x047E, 0x047F, // CYRILLIC CAPITAL LETTER OT
	0x0480, 0x0481, // CYRILLIC CAPITAL LETTER KOPPA
	0x048A, 0x048B, // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
	0x048C, 0x048D, // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
	0x048E, 0x048F, // CYRILLIC CAPITAL LETTER ER WITH TICK
	0x0490, 0x0491, // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
	0x0492, 0x0493, // CYRILLIC CAPITAL LETTER GHE WITH STROKE
	0x0494, 0x0495, // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
	0x0496, 0x0497, // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
	0x0498, 0x0499, // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
	0x049A, 0x049B, // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
	0x049C, 0x049D, // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
	0x049E, 0x049F, // CYRILLIC CAPITAL LETTER KA WITH STROKE
	0x04A0, 0x04A1, // CYRILLIC CAPITAL LETTER BASHKIR KA
	0x04A2, 0x04A3, // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
	0x04A4, 0x04A5, // CYRILLIC CAPITAL LIGATURE EN GHE
	0x04A6, 0x04A7, // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
	0x04A8, 0x04A9, // CYRILLIC CAPITAL LETTER ABKHASIAN HA
	0x04AA, 0x04AB, // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
	0x04AC, 0x04AD, // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
	0x04AE, 0x04AF, // CYRILLIC CAPITAL LETTER STRAIGHT U
	0x04B0, 0x04B1, // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
	0x04B2, 0x04B3, // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
	0x04B4, 0x04B5, // CYRILLIC CAPITAL LIGATURE TE TSE
	0x04B6, 0x04B7, // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
	0x04B8, 0x04B9, // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
	0x04BA, 0x04BB, // CYRILLIC CAPITAL LETTER SHHA
	0x04BC, 0x04BD, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
	0x04BE, 0x04BF, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
	0x04C1, 0x04C2, // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
	0x04C3, 0x04C4, // CYRILLIC CAPITAL LETTER KA WITH HOOK
	0x04C5, 0x04C6, // CYRILLIC CAPITAL LETTER EL WITH TAIL
	0x04C7, 0x04C8, // CYRILLIC CAPITAL LETTER EN WITH HOOK
	0x04C9, 0x04CA, // CYRILLIC CAPITAL LETTER EN WITH TAIL
	0x04CB, 0x04CC, // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
	0x04CD, 0x04CE, // CYRILLIC CAPITAL LETTER EM WITH TAIL
	0x04D0, 0x04D1, // CYRILLIC CAPITAL LETTER A WITH BREVE
	0x04D2, 0x04D3, // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
	0x04D4, 0x04D5, // CYRILLIC CAPITAL LIGATURE A IE
	0x04D6, 0x04D7, // CYRILLIC CAPITAL LETTER IE WITH BREVE
	0x04D8, 0x04D9, // CYRILLIC CAPITAL LETTER SCHWA
	0x04DA, 0x04DB, // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
	0x04DC, 0x04DD, // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
	0x04DE, 0x04DF, // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
	0x04E0, 0x04E1, // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
	0x04E2, 0x04E3, // CYRILLIC CAPITAL LETTER I WITH MACRON
	0x04E4, 0x04E5, // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
	0x04E6, 0x04E7, // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
	0x04E8, 0x04E9, // CYRILLIC CAPITAL LETTER BARRED O
	0x04EA, 0x04EB, // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
	0x04EC, 0x04ED, // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
	0x04EE, 0x04EF, // CYRILLIC CAPITAL LETTER U WITH MACRON
	0x04F0, 0x04F1, // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
	0x04F2, 0x04F3, // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
	0x04F4, 0x04F5, // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
	0x04F8, 0x04F9, // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
	0x0500, 0x0501, // CYRILLIC CAPITAL LETTER KOMI DE
	0x0502, 0x0503, // CYRILLIC CAPITAL LETTER KOMI DJE
	0x0504, 0x0505, // CYRILLIC CAPITAL LETTER KOMI ZJE
	0x0506, 0x0507, // CYRILLIC CAPITAL LETTER KOMI DZJE
	0x0508, 0x0509, // CYRILLIC CAPITAL LETTER KOMI LJE
	0x050A, 0x050B, // CYRILLIC CAPITAL LETTER KOMI NJE
	0x050C, 0x050D, // CYRILLIC CAPITAL LETTER KOMI SJE
	0x050E, 0x050F, // CYRILLIC CAPITAL LETTER KOMI TJE
	0x0531, 0x0561, // ARMENIAN CAPITAL LETTER AYB
	0x0532, 0x0562, // ARMENIAN CAPITAL LETTER BEN
	0x0533, 0x0563, // ARMENIAN CAPITAL LETTER GIM
	0x0534, 0x0564, // ARMENIAN CAPITAL LETTER DA
	0x0535, 0x0565, // ARMENIAN CAPITAL LETTER ECH
	0x0536, 0x0566, // ARMENIAN CAPITAL LETTER ZA
	0x0537, 0x0567, // ARMENIAN CAPITAL LETTER EH
	0x0538, 0x0568, // ARMENIAN CAPITAL LETTER ET
	0x0539, 0x0569, // ARMENIAN CAPITAL LETTER TO
	0x053A, 0x056A, // ARMENIAN CAPITAL LETTER ZHE
	0x053B, 0x056B, // ARMENIAN CAPITAL LETTER INI
	0x053C, 0x056C, // ARMENIAN CAPITAL LETTER LIWN
	0x053D, 0x056D, // ARMENIAN CAPITAL LETTER XEH
	0x053E, 0x056E, // ARMENIAN CAPITAL LETTER CA
	0x053F, 0x056F, // ARMENIAN CAPITAL LETTER KEN
	0x0540, 0x0570, // ARMENIAN CAPITAL LETTER HO
	0x0541, 0x0571, // ARMENIAN CAPITAL LETTER JA
	0x0542, 0x0572, // ARMENIAN CAPITAL LETTER GHAD
	0x0543, 0x0573, // ARMENIAN CAPITAL LETTER CHEH
	0x0544, 0x0574, // ARMENIAN CAPITAL LETTER MEN
	0x0545, 0x0575, // ARMENIAN CAPITAL LETTER YI
	0x0546, 0x0576, // ARMENIAN CAPITAL LETTER NOW
	0x0547, 0x0577, // ARMENIAN CAPITAL LETTER SHA
	0x0548, 0x0578, // ARMENIAN CAPITAL LETTER VO
	0x0549, 0x0579, // ARMENIAN CAPITAL LETTER CHA
	0x054A, 0x057A, // ARMENIAN CAPITAL LETTER PEH
	0x054B, 0x057B, // ARMENIAN CAPITAL LETTER JHEH
	0x054C, 0x057C, // ARMENIAN CAPITAL LETTER RA
	0x054D, 0x057D, // ARMENIAN CAPITAL LETTER SEH
	0x054E, 0x057E, // ARMENIAN CAPITAL LETTER VEW
	0x054F, 0x057F, // ARMENIAN CAPITAL LETTER TIWN
	0x0550, 0x0580, // ARMENIAN CAPITAL LETTER REH
	0x0551, 0x0581, // ARMENIAN CAPITAL LETTER CO
	0x0552, 0x0582, // ARMENIAN CAPITAL LETTER YIWN
	0x0553, 0x0583, // ARMENIAN CAPITAL LETTER PIWR
	0x0554, 0x0584, // ARMENIAN CAPITAL LETTER KEH
	0x0555, 0x0585, // ARMENIAN CAPITAL LETTER OH
	0x0556, 0x0586, // ARMENIAN CAPITAL LETTER FEH
	0x0587, 0x0565 , // # ARMENIAN SMALL LIGATURE ECH YIWN
	0x1E00, 0x1E01, // LATIN CAPITAL LETTER A WITH RING BELOW
	0x1E02, 0x1E03, // LATIN CAPITAL LETTER B WITH DOT ABOVE
	0x1E04, 0x1E05, // LATIN CAPITAL LETTER B WITH DOT BELOW
	0x1E06, 0x1E07, // LATIN CAPITAL LETTER B WITH LINE BELOW
	0x1E08, 0x1E09, // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
	0x1E0A, 0x1E0B, // LATIN CAPITAL LETTER D WITH DOT ABOVE
	0x1E0C, 0x1E0D, // LATIN CAPITAL LETTER D WITH DOT BELOW
	0x1E0E, 0x1E0F, // LATIN CAPITAL LETTER D WITH LINE BELOW
	0x1E10, 0x1E11, // LATIN CAPITAL LETTER D WITH CEDILLA
	0x1E12, 0x1E13, // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
	0x1E14, 0x1E15, // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
	0x1E16, 0x1E17, // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
	0x1E18, 0x1E19, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
	0x1E1A, 0x1E1B, // LATIN CAPITAL LETTER E WITH TILDE BELOW
	0x1E1C, 0x1E1D, // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
	0x1E1E, 0x1E1F, // LATIN CAPITAL LETTER F WITH DOT ABOVE
	0x1E20, 0x1E21, // LATIN CAPITAL LETTER G WITH MACRON
	0x1E22, 0x1E23, // LATIN CAPITAL LETTER H WITH DOT ABOVE
	0x1E24, 0x1E25, // LATIN CAPITAL LETTER H WITH DOT BELOW
	0x1E26, 0x1E27, // LATIN CAPITAL LETTER H WITH DIAERESIS
	0x1E28, 0x1E29, // LATIN CAPITAL LETTER H WITH CEDILLA
	0x1E2A, 0x1E2B, // LATIN CAPITAL LETTER H WITH BREVE BELOW
	0x1E2C, 0x1E2D, // LATIN CAPITAL LETTER I WITH TILDE BELOW
	0x1E2E, 0x1E2F, // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
	0x1E30, 0x1E31, // LATIN CAPITAL LETTER K WITH ACUTE
	0x1E32, 0x1E33, // LATIN CAPITAL LETTER K WITH DOT BELOW
	0x1E34, 0x1E35, // LATIN CAPITAL LETTER K WITH LINE BELOW
	0x1E36, 0x1E37, // LATIN CAPITAL LETTER L WITH DOT BELOW
	0x1E38, 0x1E39, // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
	0x1E3A, 0x1E3B, // LATIN CAPITAL LETTER L WITH LINE BELOW
	0x1E3C, 0x1E3D, // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
	0x1E3E, 0x1E3F, // LATIN CAPITAL LETTER M WITH ACUTE
	0x1E40, 0x1E41, // LATIN CAPITAL LETTER M WITH DOT ABOVE
	0x1E42, 0x1E43, // LATIN CAPITAL LETTER M WITH DOT BELOW
	0x1E44, 0x1E45, // LATIN CAPITAL LETTER N WITH DOT ABOVE
	0x1E46, 0x1E47, // LATIN CAPITAL LETTER N WITH DOT BELOW
	0x1E48, 0x1E49, // LATIN CAPITAL LETTER N WITH LINE BELOW
	0x1E4A, 0x1E4B, // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
	0x1E4C, 0x1E4D, // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
	0x1E4E, 0x1E4F, // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
	0x1E50, 0x1E51, // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
	0x1E52, 0x1E53, // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
	0x1E54, 0x1E55, // LATIN CAPITAL LETTER P WITH ACUTE
	0x1E56, 0x1E57, // LATIN CAPITAL LETTER P WITH DOT ABOVE
	0x1E58, 0x1E59, // LATIN CAPITAL LETTER R WITH DOT ABOVE
	0x1E5A, 0x1E5B, // LATIN CAPITAL LETTER R WITH DOT BELOW
	0x1E5C, 0x1E5D, // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
	0x1E5E, 0x1E5F, // LATIN CAPITAL LETTER R WITH LINE BELOW
	0x1E60, 0x1E61, // LATIN CAPITAL LETTER S WITH DOT ABOVE
	0x1E62, 0x1E63, // LATIN CAPITAL LETTER S WITH DOT BELOW
	0x1E64, 0x1E65, // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
	0x1E66, 0x1E67, // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
	0x1E68, 0x1E69, // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
	0x1E6A, 0x1E6B, // LATIN CAPITAL LETTER T WITH DOT ABOVE
	0x1E6C, 0x1E6D, // LATIN CAPITAL LETTER T WITH DOT BELOW
	0x1E6E, 0x1E6F, // LATIN CAPITAL LETTER T WITH LINE BELOW
	0x1E70, 0x1E71, // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
	0x1E72, 0x1E73, // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
	0x1E74, 0x1E75, // LATIN CAPITAL LETTER U WITH TILDE BELOW
	0x1E76, 0x1E77, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
	0x1E78, 0x1E79, // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
	0x1E7A, 0x1E7B, // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
	0x1E7C, 0x1E7D, // LATIN CAPITAL LETTER V WITH TILDE
	0x1E7E, 0x1E7F, // LATIN CAPITAL LETTER V WITH DOT BELOW
	0x1E80, 0x1E81, // LATIN CAPITAL LETTER W WITH GRAVE
	0x1E82, 0x1E83, // LATIN CAPITAL LETTER W WITH ACUTE
	0x1E84, 0x1E85, // LATIN CAPITAL LETTER W WITH DIAERESIS
	0x1E86, 0x1E87, // LATIN CAPITAL LETTER W WITH DOT ABOVE
	0x1E88, 0x1E89, // LATIN CAPITAL LETTER W WITH DOT BELOW
	0x1E8A, 0x1E8B, // LATIN CAPITAL LETTER X WITH DOT ABOVE
	0x1E8C, 0x1E8D, // LATIN CAPITAL LETTER X WITH DIAERESIS
	0x1E8E, 0x1E8F, // LATIN CAPITAL LETTER Y WITH DOT ABOVE
	0x1E90, 0x1E91, // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
	0x1E92, 0x1E93, // LATIN CAPITAL LETTER Z WITH DOT BELOW
	0x1E94, 0x1E95, // LATIN CAPITAL LETTER Z WITH LINE BELOW
	0x1E96, 0x0068 , // # LATIN SMALL LETTER H WITH LINE BELOW
	0x1E97, 0x0074 , // # LATIN SMALL LETTER T WITH DIAERESIS
	0x1E98, 0x0077 , // # LATIN SMALL LETTER W WITH RING ABOVE
	0x1E99, 0x0079 , // # LATIN SMALL LETTER Y WITH RING ABOVE
	0x1E9A, 0x0061 , // # LATIN SMALL LETTER A WITH RIGHT HALF RING
	0x1E9B, 0x1E61, // LATIN SMALL LETTER LONG S WITH DOT ABOVE
	0x1EA0, 0x1EA1, // LATIN CAPITAL LETTER A WITH DOT BELOW
	0x1EA2, 0x1EA3, // LATIN CAPITAL LETTER A WITH HOOK ABOVE
	0x1EA4, 0x1EA5, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
	0x1EA6, 0x1EA7, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
	0x1EA8, 0x1EA9, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
	0x1EAA, 0x1EAB, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
	0x1EAC, 0x1EAD, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
	0x1EAE, 0x1EAF, // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
	0x1EB0, 0x1EB1, // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
	0x1EB2, 0x1EB3, // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
	0x1EB4, 0x1EB5, // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
	0x1EB6, 0x1EB7, // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
	0x1EB8, 0x1EB9, // LATIN CAPITAL LETTER E WITH DOT BELOW
	0x1EBA, 0x1EBB, // LATIN CAPITAL LETTER E WITH HOOK ABOVE
	0x1EBC, 0x1EBD, // LATIN CAPITAL LETTER E WITH TILDE
	0x1EBE, 0x1EBF, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
	0x1EC0, 0x1EC1, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
	0x1EC2, 0x1EC3, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
	0x1EC4, 0x1EC5, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
	0x1EC6, 0x1EC7, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
	0x1EC8, 0x1EC9, // LATIN CAPITAL LETTER I WITH HOOK ABOVE
	0x1ECA, 0x1ECB, // LATIN CAPITAL LETTER I WITH DOT BELOW
	0x1ECC, 0x1ECD, // LATIN CAPITAL LETTER O WITH DOT BELOW
	0x1ECE, 0x1ECF, // LATIN CAPITAL LETTER O WITH HOOK ABOVE
	0x1ED0, 0x1ED1, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
	0x1ED2, 0x1ED3, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
	0x1ED4, 0x1ED5, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
	0x1ED6, 0x1ED7, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
	0x1ED8, 0x1ED9, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
	0x1EDA, 0x1EDB, // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
	0x1EDC, 0x1EDD, // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
	0x1EDE, 0x1EDF, // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
	0x1EE0, 0x1EE1, // LATIN CAPITAL LETTER O WITH HORN AND TILDE
	0x1EE2, 0x1EE3, // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
	0x1EE4, 0x1EE5, // LATIN CAPITAL LETTER U WITH DOT BELOW
	0x1EE6, 0x1EE7, // LATIN CAPITAL LETTER U WITH HOOK ABOVE
	0x1EE8, 0x1EE9, // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
	0x1EEA, 0x1EEB, // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
	0x1EEC, 0x1EED, // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
	0x1EEE, 0x1EEF, // LATIN CAPITAL LETTER U WITH HORN AND TILDE
	0x1EF0, 0x1EF1, // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
	0x1EF2, 0x1EF3, // LATIN CAPITAL LETTER Y WITH GRAVE
	0x1EF4, 0x1EF5, // LATIN CAPITAL LETTER Y WITH DOT BELOW
	0x1EF6, 0x1EF7, // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
	0x1EF8, 0x1EF9, // LATIN CAPITAL LETTER Y WITH TILDE
	0x1F08, 0x1F00, // GREEK CAPITAL LETTER ALPHA WITH PSILI
	0x1F09, 0x1F01, // GREEK CAPITAL LETTER ALPHA WITH DASIA
	0x1F0A, 0x1F02, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
	0x1F0B, 0x1F03, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
	0x1F0C, 0x1F04, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
	0x1F0D, 0x1F05, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
	0x1F0E, 0x1F06, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
	0x1F0F, 0x1F07, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
	0x1F18, 0x1F10, // GREEK CAPITAL LETTER EPSILON WITH PSILI
	0x1F19, 0x1F11, // GREEK CAPITAL LETTER EPSILON WITH DASIA
	0x1F1A, 0x1F12, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
	0x1F1B, 0x1F13, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
	0x1F1C, 0x1F14, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
	0x1F1D, 0x1F15, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
	0x1F28, 0x1F20, // GREEK CAPITAL LETTER ETA WITH PSILI
	0x1F29, 0x1F21, // GREEK CAPITAL LETTER ETA WITH DASIA
	0x1F2A, 0x1F22, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
	0x1F2B, 0x1F23, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
	0x1F2C, 0x1F24, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
	0x1F2D, 0x1F25, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
	0x1F2E, 0x1F26, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
	0x1F2F, 0x1F27, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
	0x1F38, 0x1F30, // GREEK CAPITAL LETTER IOTA WITH PSILI
	0x1F39, 0x1F31, // GREEK CAPITAL LETTER IOTA WITH DASIA
	0x1F3A, 0x1F32, // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
	0x1F3B, 0x1F33, // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
	0x1F3C, 0x1F34, // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
	0x1F3D, 0x1F35, // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
	0x1F3E, 0x1F36, // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
	0x1F3F, 0x1F37, // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
	0x1F48, 0x1F40, // GREEK CAPITAL LETTER OMICRON WITH PSILI
	0x1F49, 0x1F41, // GREEK CAPITAL LETTER OMICRON WITH DASIA
	0x1F4A, 0x1F42, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
	0x1F4B, 0x1F43, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
	0x1F4C, 0x1F44, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
	0x1F4D, 0x1F45, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
	0x1F50, 0x03C5 , // # GREEK SMALL LETTER UPSILON WITH PSILI
	0x1F52, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
	0x1F54, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
	0x1F56, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
	0x1F59, 0x1F51, // GREEK CAPITAL LETTER UPSILON WITH DASIA
	0x1F5B, 0x1F53, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
	0x1F5D, 0x1F55, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
	0x1F5F, 0x1F57, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
	0x1F68, 0x1F60, // GREEK CAPITAL LETTER OMEGA WITH PSILI
	0x1F69, 0x1F61, // GREEK CAPITAL LETTER OMEGA WITH DASIA
	0x1F6A, 0x1F62, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
	0x1F6B, 0x1F63, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
	0x1F6C, 0x1F64, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
	0x1F6D, 0x1F65, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
	0x1F6E, 0x1F66, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
	0x1F6F, 0x1F67, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
	0x1F80, 0x1F00 , // # GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
	0x1F81, 0x1F01 , // # GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
	0x1F82, 0x1F02 , // # GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
	0x1F83, 0x1F03 , // # GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
	0x1F84, 0x1F04 , // # GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
	0x1F85, 0x1F05 , // # GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
	0x1F86, 0x1F06 , // # GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
	0x1F87, 0x1F07 , // # GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
	0x1F88, 0x1F80, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
	0x1F89, 0x1F81, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
	0x1F8A, 0x1F82, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
	0x1F8B, 0x1F83, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
	0x1F8C, 0x1F84, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
	0x1F8D, 0x1F85, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
	0x1F8E, 0x1F86, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
	0x1F8F, 0x1F87, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	0x1F90, 0x1F20 , // # GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
	0x1F91, 0x1F21 , // # GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
	0x1F92, 0x1F22 , // # GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
	0x1F93, 0x1F23 , // # GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
	0x1F94, 0x1F24 , // # GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
	0x1F95, 0x1F25 , // # GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
	0x1F96, 0x1F26 , // # GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
	0x1F97, 0x1F27 , // # GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
	0x1F98, 0x1F90, // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
	0x1F99, 0x1F91, // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
	0x1F9A, 0x1F92, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
	0x1F9B, 0x1F93, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
	0x1F9C, 0x1F94, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
	0x1F9D, 0x1F95, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
	0x1F9E, 0x1F96, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
	0x1F9F, 0x1F97, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	0x1FA0, 0x1F60 , // # GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
	0x1FA1, 0x1F61 , // # GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
	0x1FA2, 0x1F62 , // # GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
	0x1FA3, 0x1F63 , // # GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
	0x1FA4, 0x1F64 , // # GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
	0x1FA5, 0x1F65 , // # GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
	0x1FA6, 0x1F66 , // # GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
	0x1FA7, 0x1F67 , // # GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
	0x1FA8, 0x1FA0, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
	0x1FA9, 0x1FA1, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
	0x1FAA, 0x1FA2, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
	0x1FAB, 0x1FA3, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
	0x1FAC, 0x1FA4, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
	0x1FAD, 0x1FA5, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
	0x1FAE, 0x1FA6, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
	0x1FAF, 0x1FA7, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	0x1FB2, 0x1F70 , // # GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
	0x1FB3, 0x03B1 , // # GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
	0x1FB4, 0x03AC , // # GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
	0x1FB6, 0x03B1 , // # GREEK SMALL LETTER ALPHA WITH PERISPOMENI
	0x1FB7, 0x03B1 , // ; # GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
	0x1FB8, 0x1FB0, // GREEK CAPITAL LETTER ALPHA WITH VRACHY
	0x1FB9, 0x1FB1, // GREEK CAPITAL LETTER ALPHA WITH MACRON
	0x1FBA, 0x1F70, // GREEK CAPITAL LETTER ALPHA WITH VARIA
	0x1FBB, 0x1F71, // GREEK CAPITAL LETTER ALPHA WITH OXIA
	0x1FBC, 0x1FB3, // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
	0x1FBE, 0x03B9, // GREEK PROSGEGRAMMENI
	0x1FC2, 0x1F74 , // # GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
	0x1FC3, 0x03B7 , // # GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
	0x1FC4, 0x03AE , // # GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
	0x1FC6, 0x03B7 , // # GREEK SMALL LETTER ETA WITH PERISPOMENI
	0x1FC7, 0x03B7 , // ; # GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
	0x1FC8, 0x1F72, // GREEK CAPITAL LETTER EPSILON WITH VARIA
	0x1FC9, 0x1F73, // GREEK CAPITAL LETTER EPSILON WITH OXIA
	0x1FCA, 0x1F74, // GREEK CAPITAL LETTER ETA WITH VARIA
	0x1FCB, 0x1F75, // GREEK CAPITAL LETTER ETA WITH OXIA
	0x1FCC, 0x1FC3, // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
	0x1FD2, 0x03B9 , // ; # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
	0x1FD3, 0x03B9 , // ; # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
	0x1FD6, 0x03B9 , // # GREEK SMALL LETTER IOTA WITH PERISPOMENI
	0x1FD7, 0x03B9 , // ; # GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
	0x1FD8, 0x1FD0, // GREEK CAPITAL LETTER IOTA WITH VRACHY
	0x1FD9, 0x1FD1, // GREEK CAPITAL LETTER IOTA WITH MACRON
	0x1FDA, 0x1F76, // GREEK CAPITAL LETTER IOTA WITH VARIA
	0x1FDB, 0x1F77, // GREEK CAPITAL LETTER IOTA WITH OXIA
	0x1FE2, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
	0x1FE3, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
	0x1FE4, 0x03C1 , // # GREEK SMALL LETTER RHO WITH PSILI
	0x1FE6, 0x03C5 , // # GREEK SMALL LETTER UPSILON WITH PERISPOMENI
	0x1FE7, 0x03C5 , // ; # GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
	0x1FE8, 0x1FE0, // GREEK CAPITAL LETTER UPSILON WITH VRACHY
	0x1FE9, 0x1FE1, // GREEK CAPITAL LETTER UPSILON WITH MACRON
	0x1FEA, 0x1F7A, // GREEK CAPITAL LETTER UPSILON WITH VARIA
	0x1FEB, 0x1F7B, // GREEK CAPITAL LETTER UPSILON WITH OXIA
	0x1FEC, 0x1FE5, // GREEK CAPITAL LETTER RHO WITH DASIA
	0x1FF2, 0x1F7C , // # GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
	0x1FF3, 0x03C9 , // # GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
	0x1FF4, 0x03CE , // # GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
	0x1FF6, 0x03C9 , // # GREEK SMALL LETTER OMEGA WITH PERISPOMENI
	0x1FF7, 0x03C9 , // ; # GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
	0x1FF8, 0x1F78, // GREEK CAPITAL LETTER OMICRON WITH VARIA
	0x1FF9, 0x1F79, // GREEK CAPITAL LETTER OMICRON WITH OXIA
	0x1FFA, 0x1F7C, // GREEK CAPITAL LETTER OMEGA WITH VARIA
	0x1FFB, 0x1F7D, // GREEK CAPITAL LETTER OMEGA WITH OXIA
	0x1FFC, 0x1FF3, // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
	0x2126, 0x03C9, // OHM SIGN
	0x212A, 0x006B, // KELVIN SIGN
	0x212B, 0x00E5, // ANGSTROM SIGN
	0x2160, 0x2170, // ROMAN NUMERAL ONE
	0x2161, 0x2171, // ROMAN NUMERAL TWO
	0x2162, 0x2172, // ROMAN NUMERAL THREE
	0x2163, 0x2173, // ROMAN NUMERAL FOUR
	0x2164, 0x2174, // ROMAN NUMERAL FIVE
	0x2165, 0x2175, // ROMAN NUMERAL SIX
	0x2166, 0x2176, // ROMAN NUMERAL SEVEN
	0x2167, 0x2177, // ROMAN NUMERAL EIGHT
	0x2168, 0x2178, // ROMAN NUMERAL NINE
	0x2169, 0x2179, // ROMAN NUMERAL TEN
	0x216A, 0x217A, // ROMAN NUMERAL ELEVEN
	0x216B, 0x217B, // ROMAN NUMERAL TWELVE
	0x216C, 0x217C, // ROMAN NUMERAL FIFTY
	0x216D, 0x217D, // ROMAN NUMERAL ONE HUNDRED
	0x216E, 0x217E, // ROMAN NUMERAL FIVE HUNDRED
	0x216F, 0x217F, // ROMAN NUMERAL ONE THOUSAND
	0x24B6, 0x24D0, // CIRCLED LATIN CAPITAL LETTER A
	0x24B7, 0x24D1, // CIRCLED LATIN CAPITAL LETTER B
	0x24B8, 0x24D2, // CIRCLED LATIN CAPITAL LETTER C
	0x24B9, 0x24D3, // CIRCLED LATIN CAPITAL LETTER D
	0x24BA, 0x24D4, // CIRCLED LATIN CAPITAL LETTER E
	0x24BB, 0x24D5, // CIRCLED LATIN CAPITAL LETTER F
	0x24BC, 0x24D6, // CIRCLED LATIN CAPITAL LETTER G
	0x24BD, 0x24D7, // CIRCLED LATIN CAPITAL LETTER H
	0x24BE, 0x24D8, // CIRCLED LATIN CAPITAL LETTER I
	0x24BF, 0x24D9, // CIRCLED LATIN CAPITAL LETTER J
	0x24C0, 0x24DA, // CIRCLED LATIN CAPITAL LETTER K
	0x24C1, 0x24DB, // CIRCLED LATIN CAPITAL LETTER L
	0x24C2, 0x24DC, // CIRCLED LATIN CAPITAL LETTER M
	0x24C3, 0x24DD, // CIRCLED LATIN CAPITAL LETTER N
	0x24C4, 0x24DE, // CIRCLED LATIN CAPITAL LETTER O
	0x24C5, 0x24DF, // CIRCLED LATIN CAPITAL LETTER P
	0x24C6, 0x24E0, // CIRCLED LATIN CAPITAL LETTER Q
	0x24C7, 0x24E1, // CIRCLED LATIN CAPITAL LETTER R
	0x24C8, 0x24E2, // CIRCLED LATIN CAPITAL LETTER S
	0x24C9, 0x24E3, // CIRCLED LATIN CAPITAL LETTER T
	0x24CA, 0x24E4, // CIRCLED LATIN CAPITAL LETTER U
	0x24CB, 0x24E5, // CIRCLED LATIN CAPITAL LETTER V
	0x24CC, 0x24E6, // CIRCLED LATIN CAPITAL LETTER W
	0x24CD, 0x24E7, // CIRCLED LATIN CAPITAL LETTER X
	0x24CE, 0x24E8, // CIRCLED LATIN CAPITAL LETTER Y
	0x24CF, 0x24E9, // CIRCLED LATIN CAPITAL LETTER Z
	0xFB00, 0x0066 , // # LATIN SMALL LIGATURE FF
	0xFB01, 0x0066 , // # LATIN SMALL LIGATURE FI
	0xFB02, 0x0066 , // # LATIN SMALL LIGATURE FL
	0xFB03, 0x0066 , // ; # LATIN SMALL LIGATURE FFI
	0xFB04, 0x0066 , // ; # LATIN SMALL LIGATURE FFL
	0xFB05, 0x0073 , // # LATIN SMALL LIGATURE LONG S T
	0xFB06, 0x0073 , // # LATIN SMALL LIGATURE ST
	0xFB13, 0x0574 , // # ARMENIAN SMALL LIGATURE MEN NOW
	0xFB14, 0x0574 , // # ARMENIAN SMALL LIGATURE MEN ECH
	0xFB15, 0x0574 , // # ARMENIAN SMALL LIGATURE MEN INI
	0xFB16, 0x057E , // # ARMENIAN SMALL LIGATURE VEW NOW
	0xFB17, 0x0574 , // # ARMENIAN SMALL LIGATURE MEN XEH
	0xFF21, 0xFF41, // FULLWIDTH LATIN CAPITAL LETTER A
	0xFF22, 0xFF42, // FULLWIDTH LATIN CAPITAL LETTER B
	0xFF23, 0xFF43, // FULLWIDTH LATIN CAPITAL LETTER C
	0xFF24, 0xFF44, // FULLWIDTH LATIN CAPITAL LETTER D
	0xFF25, 0xFF45, // FULLWIDTH LATIN CAPITAL LETTER E
	0xFF26, 0xFF46, // FULLWIDTH LATIN CAPITAL LETTER F
	0xFF27, 0xFF47, // FULLWIDTH LATIN CAPITAL LETTER G
	0xFF28, 0xFF48, // FULLWIDTH LATIN CAPITAL LETTER H
	0xFF29, 0xFF49, // FULLWIDTH LATIN CAPITAL LETTER I
	0xFF2A, 0xFF4A, // FULLWIDTH LATIN CAPITAL LETTER J
	0xFF2B, 0xFF4B, // FULLWIDTH LATIN CAPITAL LETTER K
	0xFF2C, 0xFF4C, // FULLWIDTH LATIN CAPITAL LETTER L
	0xFF2D, 0xFF4D, // FULLWIDTH LATIN CAPITAL LETTER M
	0xFF2E, 0xFF4E, // FULLWIDTH LATIN CAPITAL LETTER N
	0xFF2F, 0xFF4F, // FULLWIDTH LATIN CAPITAL LETTER O
	0xFF30, 0xFF50, // FULLWIDTH LATIN CAPITAL LETTER P
	0xFF31, 0xFF51, // FULLWIDTH LATIN CAPITAL LETTER Q
	0xFF32, 0xFF52, // FULLWIDTH LATIN CAPITAL LETTER R
	0xFF33, 0xFF53, // FULLWIDTH LATIN CAPITAL LETTER S
	0xFF34, 0xFF54, // FULLWIDTH LATIN CAPITAL LETTER T
	0xFF35, 0xFF55, // FULLWIDTH LATIN CAPITAL LETTER U
	0xFF36, 0xFF56, // FULLWIDTH LATIN CAPITAL LETTER V
	0xFF37, 0xFF57, // FULLWIDTH LATIN CAPITAL LETTER W
	0xFF38, 0xFF58, // FULLWIDTH LATIN CAPITAL LETTER X
	0xFF39, 0xFF59, // FULLWIDTH LATIN CAPITAL LETTER Y
	0xFF3A, 0xFF5A, // FULLWIDTH LATIN CAPITAL LETTER Z
};

// ***************************************************************************

// Lowercase to uppercase 16 bits unicode. This table must be sorted. First entry must be unique.
static const ucchar UnicodeLowerToUpper[]=
{
	// 0x0061, 0x0041, // LATIN CAPITAL LETTER A
	0x0061, 'A', // LATIN CAPITAL LETTER A
	// 0x0062, 0x0042, // LATIN CAPITAL LETTER B
	0x0062, 'B', // LATIN CAPITAL LETTER B
	// 0x0063, 0x0043, // LATIN CAPITAL LETTER C
	0x0063, 'C', // LATIN CAPITAL LETTER C
	// 0x0064, 0x0044, // LATIN CAPITAL LETTER D
	0x0064, 'D', // LATIN CAPITAL LETTER D
	// 0x0065, 0x0045, // LATIN CAPITAL LETTER E
	0x0065, 'E', // LATIN CAPITAL LETTER E
	// 0x0066, 0x0046, // LATIN CAPITAL LETTER F
	0x0066, 'F', // LATIN CAPITAL LETTER F
	// 0x0067, 0x0047, // LATIN CAPITAL LETTER G
	0x0067, 'G', // LATIN CAPITAL LETTER G
	// 0x0068, 0x0048, // LATIN CAPITAL LETTER H
	0x0068, 'H', // LATIN CAPITAL LETTER H
	// 0x0069, 0x0049, // LATIN CAPITAL LETTER I
	0x0069, 'I', // LATIN CAPITAL LETTER I
	// 0x006A, 0x004A, // LATIN CAPITAL LETTER J
	0x006A, 'J', // LATIN CAPITAL LETTER J
	// 0x006B, 0x004B, // LATIN CAPITAL LETTER K
	0x006B, 'K', // LATIN CAPITAL LETTER K
	// 0x006C, 0x004C, // LATIN CAPITAL LETTER L
	0x006C, 'L', // LATIN CAPITAL LETTER L
	// 0x006D, 0x004D, // LATIN CAPITAL LETTER M
	0x006D, 'M', // LATIN CAPITAL LETTER M
	// 0x006E, 0x004E, // LATIN CAPITAL LETTER N
	0x006E, 'N', // LATIN CAPITAL LETTER N
	// 0x006F, 0x004F, // LATIN CAPITAL LETTER O
	0x006F, 'O', // LATIN CAPITAL LETTER O
	// 0x0070, 0x0050, // LATIN CAPITAL LETTER P
	0x0070, 'P', // LATIN CAPITAL LETTER P
	// 0x0071, 0x0051, // LATIN CAPITAL LETTER Q
	0x0071, 'Q', // LATIN CAPITAL LETTER Q
	// 0x0072, 0x0052, // LATIN CAPITAL LETTER R
	0x0072, 'R', // LATIN CAPITAL LETTER R
	// 0x0073, 0x0053, // LATIN CAPITAL LETTER S
	0x0073, 'S', // LATIN CAPITAL LETTER S
	// 0x0074, 0x0054, // LATIN CAPITAL LETTER T
	0x0074, 'T', // LATIN CAPITAL LETTER T
	// 0x0075, 0x0055, // LATIN CAPITAL LETTER U
	0x0075, 'U', // LATIN CAPITAL LETTER U
	// 0x0076, 0x0056, // LATIN CAPITAL LETTER V
	0x0076, 'V', // LATIN CAPITAL LETTER V
	// 0x0077, 0x0057, // LATIN CAPITAL LETTER W
	0x0077, 'W', // LATIN CAPITAL LETTER W
	// 0x0078, 0x0058, // LATIN CAPITAL LETTER X
	0x0078, 'X', // LATIN CAPITAL LETTER X
	// 0x0079, 0x0059, // LATIN CAPITAL LETTER Y
	0x0079, 'Y', // LATIN CAPITAL LETTER Y
	// 0x007A, 0x005A, // LATIN CAPITAL LETTER Z
	0x007A, 'Z', // LATIN CAPITAL LETTER Z
	// 0x00E0, 0x00C0, // LATIN CAPITAL LETTER A WITH GRAVE
	0x00E0, 'A', // LATIN CAPITAL LETTER A WITH GRAVE
	// 0x00E1, 0x00C1, // LATIN CAPITAL LETTER A WITH ACUTE
	0x00E1, 'A', // LATIN CAPITAL LETTER A WITH ACUTE
	// 0x00E2, 0x00C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	0x00E2, 'A', // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	// 0x00E3, 0x00C3, // LATIN CAPITAL LETTER A WITH TILDE
	0x00E3, 'A', // LATIN CAPITAL LETTER A WITH TILDE
	// 0x00E4, 0x00C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
	0x00E4, 'A', // LATIN CAPITAL LETTER A WITH DIAERESIS
	// 0x00E5, 0x00C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
	0x00E5, 'A', // LATIN CAPITAL LETTER A WITH RING ABOVE
	0x00E6, 0x00C6, // LATIN CAPITAL LETTER AE
	// 0x00E7, 0x00C7, // LATIN CAPITAL LETTER C WITH CEDILLA
	0x00E7, 'C', // LATIN CAPITAL LETTER C WITH CEDILLA
	// 0x00E8, 0x00C8, // LATIN CAPITAL LETTER E WITH GRAVE
	0x00E8, 'E', // LATIN CAPITAL LETTER E WITH GRAVE
	// 0x00E9, 0x00C9, // LATIN CAPITAL LETTER E WITH ACUTE
	0x00E9, 'E', // LATIN CAPITAL LETTER E WITH ACUTE
	// 0x00EA, 0x00CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	0x00EA, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	// 0x00EB, 0x00CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
	0x00EB, 'E', // LATIN CAPITAL LETTER E WITH DIAERESIS
	// 0x00EC, 0x00CC, // LATIN CAPITAL LETTER I WITH GRAVE
	0x00EC, 'I', // LATIN CAPITAL LETTER I WITH GRAVE
	// 0x00ED, 0x00CD, // LATIN CAPITAL LETTER I WITH ACUTE
	0x00ED, 'I', // LATIN CAPITAL LETTER I WITH ACUTE
	// 0x00EE, 0x00CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	0x00EE, 'I', // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	// 0x00EF, 0x00CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
	0x00EF, 'I', // LATIN CAPITAL LETTER I WITH DIAERESIS
	0x00F0, 0x00D0, // LATIN CAPITAL LETTER ETH
	// 0x00F1, 0x00D1, // LATIN CAPITAL LETTER N WITH TILDE
	0x00F1, 'N', // LATIN CAPITAL LETTER N WITH TILDE
	// 0x00F2, 0x00D2, // LATIN CAPITAL LETTER O WITH GRAVE
	0x00F2, 'O', // LATIN CAPITAL LETTER O WITH GRAVE
	// 0x00F3, 0x00D3, // LATIN CAPITAL LETTER O WITH ACUTE
	0x00F3, 'O', // LATIN CAPITAL LETTER O WITH ACUTE
	// 0x00F4, 0x00D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	0x00F4, 'O', // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	// 0x00F5, 0x00D5, // LATIN CAPITAL LETTER O WITH TILDE
	0x00F5, 'O', // LATIN CAPITAL LETTER O WITH TILDE
	// 0x00F6, 0x00D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
	0x00F6, 'O', // LATIN CAPITAL LETTER O WITH DIAERESIS
	// 0x00F8, 0x00D8, // LATIN CAPITAL LETTER O WITH STROKE
	0x00F8, 'O', // LATIN CAPITAL LETTER O WITH STROKE
	// 0x00F9, 0x00D9, // LATIN CAPITAL LETTER U WITH GRAVE
	0x00F9, 'U', // LATIN CAPITAL LETTER U WITH GRAVE
	// 0x00FA, 0x00DA, // LATIN CAPITAL LETTER U WITH ACUTE
	0x00FA, 'U', // LATIN CAPITAL LETTER U WITH ACUTE
	// 0x00FB, 0x00DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	0x00FB, 'U', // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	// 0x00FC, 0x00DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
	0x00FC, 'U', // LATIN CAPITAL LETTER U WITH DIAERESIS
	// 0x00FD, 0x00DD, // LATIN CAPITAL LETTER Y WITH ACUTE
	0x00FD, 'Y', // LATIN CAPITAL LETTER Y WITH ACUTE
	0x00FE, 0x00DE, // LATIN CAPITAL LETTER THORN
	// 0x00FF, 0x0178, // LATIN CAPITAL LETTER Y WITH DIAERESIS
	0x00FF, 'Y', // LATIN CAPITAL LETTER Y WITH DIAERESIS
	// 0x0101, 0x0100, // LATIN CAPITAL LETTER A WITH MACRON
	0x0101, 'A', // LATIN CAPITAL LETTER A WITH MACRON
	// 0x0103, 0x0102, // LATIN CAPITAL LETTER A WITH BREVE
	0x0103, 'A', // LATIN CAPITAL LETTER A WITH BREVE
	// 0x0105, 0x0104, // LATIN CAPITAL LETTER A WITH OGONEK
	0x0105, 'A', // LATIN CAPITAL LETTER A WITH OGONEK
	// 0x0107, 0x0106, // LATIN CAPITAL LETTER C WITH ACUTE
	0x0107, 'C', // LATIN CAPITAL LETTER C WITH ACUTE
	// 0x0109, 0x0108, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
	0x0109, 'C', // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
	// 0x010B, 0x010A, // LATIN CAPITAL LETTER C WITH DOT ABOVE
	0x010B, 'C', // LATIN CAPITAL LETTER C WITH DOT ABOVE
	// 0x010D, 0x010C, // LATIN CAPITAL LETTER C WITH CARON
	0x010D, 'C', // LATIN CAPITAL LETTER C WITH CARON
	// 0x010F, 0x010E, // LATIN CAPITAL LETTER D WITH CARON
	0x010F, 'D', // LATIN CAPITAL LETTER D WITH CARON
	// 0x0111, 0x0110, // LATIN CAPITAL LETTER D WITH STROKE
	0x0111, 'D', // LATIN CAPITAL LETTER D WITH STROKE
	// 0x0113, 0x0112, // LATIN CAPITAL LETTER E WITH MACRON
	0x0113, 'E', // LATIN CAPITAL LETTER E WITH MACRON
	// 0x0115, 0x0114, // LATIN CAPITAL LETTER E WITH BREVE
	0x0115, 'E', // LATIN CAPITAL LETTER E WITH BREVE
	// 0x0117, 0x0116, // LATIN CAPITAL LETTER E WITH DOT ABOVE
	0x0117, 'E', // LATIN CAPITAL LETTER E WITH DOT ABOVE
	// 0x0119, 0x0118, // LATIN CAPITAL LETTER E WITH OGONEK
	0x0119, 'E', // LATIN CAPITAL LETTER E WITH OGONEK
	// 0x011B, 0x011A, // LATIN CAPITAL LETTER E WITH CARON
	0x011B, 'E', // LATIN CAPITAL LETTER E WITH CARON
	// 0x011D, 0x011C, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
	0x011D, 'G', // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
	// 0x011F, 0x011E, // LATIN CAPITAL LETTER G WITH BREVE
	0x011F, 'G', // LATIN CAPITAL LETTER G WITH BREVE
	// 0x0121, 0x0120, // LATIN CAPITAL LETTER G WITH DOT ABOVE
	0x0121, 'G', // LATIN CAPITAL LETTER G WITH DOT ABOVE
	// 0x0123, 0x0122, // LATIN CAPITAL LETTER G WITH CEDILLA
	0x0123, 'G', // LATIN CAPITAL LETTER G WITH CEDILLA
	// 0x0125, 0x0124, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
	0x0125, 'H', // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
	// 0x0127, 0x0126, // LATIN CAPITAL LETTER H WITH STROKE
	0x0127, 'H', // LATIN CAPITAL LETTER H WITH STROKE
	// 0x0129, 0x0128, // LATIN CAPITAL LETTER I WITH TILDE
	0x0129, 'I', // LATIN CAPITAL LETTER I WITH TILDE
	// 0x012B, 0x012A, // LATIN CAPITAL LETTER I WITH MACRON
	0x012B, 'I', // LATIN CAPITAL LETTER I WITH MACRON
	// 0x012D, 0x012C, // LATIN CAPITAL LETTER I WITH BREVE
	0x012D, 'I', // LATIN CAPITAL LETTER I WITH BREVE
	// 0x012F, 0x012E, // LATIN CAPITAL LETTER I WITH OGONEK
	0x012F, 'I', // LATIN CAPITAL LETTER I WITH OGONEK
	// 0x0131, 0x0049, // LATIN CAPITAL LETTER I
	0x0131, 'I', // LATIN CAPITAL LETTER I
	0x0133, 0x0132, // LATIN CAPITAL LIGATURE IJ
	// 0x0135, 0x0134, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
	0x0135, 'J', // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
	// 0x0137, 0x0136, // LATIN CAPITAL LETTER K WITH CEDILLA
	0x0137, 'K', // LATIN CAPITAL LETTER K WITH CEDILLA
	// 0x013A, 0x0139, // LATIN CAPITAL LETTER L WITH ACUTE
	0x013A, 'L', // LATIN CAPITAL LETTER L WITH ACUTE
	// 0x013C, 0x013B, // LATIN CAPITAL LETTER L WITH CEDILLA
	0x013C, 'L', // LATIN CAPITAL LETTER L WITH CEDILLA
	// 0x013E, 0x013D, // LATIN CAPITAL LETTER L WITH CARON
	0x013E, 'L', // LATIN CAPITAL LETTER L WITH CARON
	// 0x0140, 0x013F, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
	0x0140, 'L', // LATIN CAPITAL LETTER L WITH MIDDLE DOT
	// 0x0142, 0x0141, // LATIN CAPITAL LETTER L WITH STROKE
	0x0142, 'L', // LATIN CAPITAL LETTER L WITH STROKE
	// 0x0144, 0x0143, // LATIN CAPITAL LETTER N WITH ACUTE
	0x0144, 'N', // LATIN CAPITAL LETTER N WITH ACUTE
	// 0x0146, 0x0145, // LATIN CAPITAL LETTER N WITH CEDILLA
	0x0146, 'N', // LATIN CAPITAL LETTER N WITH CEDILLA
	// 0x0148, 0x0147, // LATIN CAPITAL LETTER N WITH CARON
	0x0148, 'N', // LATIN CAPITAL LETTER N WITH CARON
	0x014B, 0x014A, // LATIN CAPITAL LETTER ENG
	// 0x014D, 0x014C, // LATIN CAPITAL LETTER O WITH MACRON
	0x014D, 'O', // LATIN CAPITAL LETTER O WITH MACRON
	// 0x014F, 0x014E, // LATIN CAPITAL LETTER O WITH BREVE
	0x014F, 'O', // LATIN CAPITAL LETTER O WITH BREVE
	// 0x0151, 0x0150, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
	0x0151, 'O', // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
	0x0153, 0x0152, // LATIN CAPITAL LIGATURE OE
	// 0x0155, 0x0154, // LATIN CAPITAL LETTER R WITH ACUTE
	0x0155, 'R', // LATIN CAPITAL LETTER R WITH ACUTE
	// 0x0157, 0x0156, // LATIN CAPITAL LETTER R WITH CEDILLA
	0x0157, 'R', // LATIN CAPITAL LETTER R WITH CEDILLA
	// 0x0159, 0x0158, // LATIN CAPITAL LETTER R WITH CARON
	0x0159, 'R', // LATIN CAPITAL LETTER R WITH CARON
	// 0x015B, 0x015A, // LATIN CAPITAL LETTER S WITH ACUTE
	0x015B, 'S', // LATIN CAPITAL LETTER S WITH ACUTE
	// 0x015D, 0x015C, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
	0x015D, 'S', // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
	// 0x015F, 0x015E, // LATIN CAPITAL LETTER S WITH CEDILLA
	0x015F, 'S', // LATIN CAPITAL LETTER S WITH CEDILLA
	// 0x0161, 0x0160, // LATIN CAPITAL LETTER S WITH CARON
	0x0161, 'S', // LATIN CAPITAL LETTER S WITH CARON
	// 0x0163, 0x0162, // LATIN CAPITAL LETTER T WITH CEDILLA
	0x0163, 'T', // LATIN CAPITAL LETTER T WITH CEDILLA
	// 0x0165, 0x0164, // LATIN CAPITAL LETTER T WITH CARON
	0x0165, 'T', // LATIN CAPITAL LETTER T WITH CARON
	// 0x0167, 0x0166, // LATIN CAPITAL LETTER T WITH STROKE
	0x0167, 'T', // LATIN CAPITAL LETTER T WITH STROKE
	// 0x0169, 0x0168, // LATIN CAPITAL LETTER U WITH TILDE
	0x0169, 'U', // LATIN CAPITAL LETTER U WITH TILDE
	// 0x016B, 0x016A, // LATIN CAPITAL LETTER U WITH MACRON
	0x016B, 'U', // LATIN CAPITAL LETTER U WITH MACRON
	// 0x016D, 0x016C, // LATIN CAPITAL LETTER U WITH BREVE
	0x016D, 'U', // LATIN CAPITAL LETTER U WITH BREVE
	// 0x016F, 0x016E, // LATIN CAPITAL LETTER U WITH RING ABOVE
	0x016F, 'U', // LATIN CAPITAL LETTER U WITH RING ABOVE
	// 0x0171, 0x0170, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
	0x0171, 'U', // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
	// 0x0173, 0x0172, // LATIN CAPITAL LETTER U WITH OGONEK
	0x0173, 'U', // LATIN CAPITAL LETTER U WITH OGONEK
	// 0x0175, 0x0174, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
	0x0175, 'W', // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
	// 0x0177, 0x0176, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
	0x0177, 'Y', // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
	// 0x017A, 0x0179, // LATIN CAPITAL LETTER Z WITH ACUTE
	0x017A, 'Z', // LATIN CAPITAL LETTER Z WITH ACUTE
	// 0x017C, 0x017B, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
	0x017C, 'Z', // LATIN CAPITAL LETTER Z WITH DOT ABOVE
	// 0x017E, 0x017D, // LATIN CAPITAL LETTER Z WITH CARON
	0x017E, 'Z', // LATIN CAPITAL LETTER Z WITH CARON
	// 0x0183, 0x0182, // LATIN CAPITAL LETTER B WITH TOPBAR
	0x0183, 'B', // LATIN CAPITAL LETTER B WITH TOPBAR
	0x0185, 0x0184, // LATIN CAPITAL LETTER TONE SIX
	// 0x0188, 0x0187, // LATIN CAPITAL LETTER C WITH HOOK
	0x0188, 'C', // LATIN CAPITAL LETTER C WITH HOOK
	// 0x018C, 0x018B, // LATIN CAPITAL LETTER D WITH TOPBAR
	0x018C, 'D', // LATIN CAPITAL LETTER D WITH TOPBAR
	// 0x0192, 0x0191, // LATIN CAPITAL LETTER F WITH HOOK
	0x0192, 'F', // LATIN CAPITAL LETTER F WITH HOOK
	0x0195, 0x01F6, // LATIN CAPITAL LETTER HWAIR
	// 0x0199, 0x0198, // LATIN CAPITAL LETTER K WITH HOOK
	0x0199, 'K', // LATIN CAPITAL LETTER K WITH HOOK
	// 0x019E, 0x0220, // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
	0x019E, 'N', // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
	// 0x01A1, 0x01A0, // LATIN CAPITAL LETTER O WITH HORN
	0x01A1, 'O', // LATIN CAPITAL LETTER O WITH HORN
	0x01A3, 0x01A2, // LATIN CAPITAL LETTER OI
	// 0x01A5, 0x01A4, // LATIN CAPITAL LETTER P WITH HOOK
	0x01A5, 'P', // LATIN CAPITAL LETTER P WITH HOOK
	0x01A8, 0x01A7, // LATIN CAPITAL LETTER TONE TWO
	// 0x01AD, 0x01AC, // LATIN CAPITAL LETTER T WITH HOOK
	0x01AD, 'T', // LATIN CAPITAL LETTER T WITH HOOK
	// 0x01B0, 0x01AF, // LATIN CAPITAL LETTER U WITH HORN
	0x01B0, 'U', // LATIN CAPITAL LETTER U WITH HORN
	// 0x01B4, 0x01B3, // LATIN CAPITAL LETTER Y WITH HOOK
	0x01B4, 'Y', // LATIN CAPITAL LETTER Y WITH HOOK
	// 0x01B6, 0x01B5, // LATIN CAPITAL LETTER Z WITH STROKE
	0x01B6, 'Z', // LATIN CAPITAL LETTER Z WITH STROKE
	0x01B9, 0x01B8, // LATIN CAPITAL LETTER EZH REVERSED
	0x01BD, 0x01BC, // LATIN CAPITAL LETTER TONE FIVE
	0x01BF, 0x01F7, // LATIN CAPITAL LETTER WYNN
	0x01C6, 0x01C4, // LATIN CAPITAL LETTER DZ WITH CARON
	0x01C9, 0x01C7, // LATIN CAPITAL LETTER LJ
	0x01CC, 0x01CA, // LATIN CAPITAL LETTER NJ
	// 0x01CE, 0x01CD, // LATIN CAPITAL LETTER A WITH CARON
	0x01CE, 'A', // LATIN CAPITAL LETTER A WITH CARON
	// 0x01D0, 0x01CF, // LATIN CAPITAL LETTER I WITH CARON
	0x01D0, 'I', // LATIN CAPITAL LETTER I WITH CARON
	// 0x01D2, 0x01D1, // LATIN CAPITAL LETTER O WITH CARON
	0x01D2, 'O', // LATIN CAPITAL LETTER O WITH CARON
	// 0x01D4, 0x01D3, // LATIN CAPITAL LETTER U WITH CARON
	0x01D4, 'U', // LATIN CAPITAL LETTER U WITH CARON
	// 0x01D6, 0x01D5, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	0x01D6, 'U', // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	// 0x01D8, 0x01D7, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	0x01D8, 'U', // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	// 0x01DA, 0x01D9, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	0x01DA, 'U', // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	// 0x01DC, 0x01DB, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	0x01DC, 'U', // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	0x01DD, 0x018E, // LATIN CAPITAL LETTER REVERSED E
	// 0x01DF, 0x01DE, // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
	0x01DF, 'A', // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
	// 0x01E1, 0x01E0, // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
	0x01E1, 'A', // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
	0x01E3, 0x01E2, // LATIN CAPITAL LETTER AE WITH MACRON
	// 0x01E5, 0x01E4, // LATIN CAPITAL LETTER G WITH STROKE
	0x01E5, 'G', // LATIN CAPITAL LETTER G WITH STROKE
	// 0x01E7, 0x01E6, // LATIN CAPITAL LETTER G WITH CARON
	0x01E7, 'G', // LATIN CAPITAL LETTER G WITH CARON
	// 0x01E9, 0x01E8, // LATIN CAPITAL LETTER K WITH CARON
	0x01E9, 'K', // LATIN CAPITAL LETTER K WITH CARON
	// 0x01EB, 0x01EA, // LATIN CAPITAL LETTER O WITH OGONEK
	0x01EB, 'O', // LATIN CAPITAL LETTER O WITH OGONEK
	// 0x01ED, 0x01EC, // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
	0x01ED, 'O', // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
	0x01EF, 0x01EE, // LATIN CAPITAL LETTER EZH WITH CARON
	0x01F3, 0x01F1, // LATIN CAPITAL LETTER DZ
	// 0x01F5, 0x01F4, // LATIN CAPITAL LETTER G WITH ACUTE
	0x01F5, 'G', // LATIN CAPITAL LETTER G WITH ACUTE
	// 0x01F9, 0x01F8, // LATIN CAPITAL LETTER N WITH GRAVE
	0x01F9, 'N', // LATIN CAPITAL LETTER N WITH GRAVE
	// 0x01FB, 0x01FA, // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
	0x01FB, 'A', // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
	0x01FD, 0x01FC, // LATIN CAPITAL LETTER AE WITH ACUTE
	// 0x01FF, 0x01FE, // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
	0x01FF, 'O', // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
	// 0x0201, 0x0200, // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
	0x0201, 'A', // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
	// 0x0203, 0x0202, // LATIN CAPITAL LETTER A WITH INVERTED BREVE
	0x0203, 'A', // LATIN CAPITAL LETTER A WITH INVERTED BREVE
	// 0x0205, 0x0204, // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
	0x0205, 'E', // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
	// 0x0207, 0x0206, // LATIN CAPITAL LETTER E WITH INVERTED BREVE
	0x0207, 'E', // LATIN CAPITAL LETTER E WITH INVERTED BREVE
	// 0x0209, 0x0208, // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
	0x0209, 'I', // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
	// 0x020B, 0x020A, // LATIN CAPITAL LETTER I WITH INVERTED BREVE
	0x020B, 'I', // LATIN CAPITAL LETTER I WITH INVERTED BREVE
	// 0x020D, 0x020C, // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
	0x020D, 'O', // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
	// 0x020F, 0x020E, // LATIN CAPITAL LETTER O WITH INVERTED BREVE
	0x020F, 'O', // LATIN CAPITAL LETTER O WITH INVERTED BREVE
	// 0x0211, 0x0210, // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
	0x0211, 'R', // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
	// 0x0213, 0x0212, // LATIN CAPITAL LETTER R WITH INVERTED BREVE
	0x0213, 'R', // LATIN CAPITAL LETTER R WITH INVERTED BREVE
	// 0x0215, 0x0214, // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
	0x0215, 'U', // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
	// 0x0217, 0x0216, // LATIN CAPITAL LETTER U WITH INVERTED BREVE
	0x0217, 'U', // LATIN CAPITAL LETTER U WITH INVERTED BREVE
	// 0x0219, 0x0218, // LATIN CAPITAL LETTER S WITH COMMA BELOW
	0x0219, 'S', // LATIN CAPITAL LETTER S WITH COMMA BELOW
	// 0x021B, 0x021A, // LATIN CAPITAL LETTER T WITH COMMA BELOW
	0x021B, 'T', // LATIN CAPITAL LETTER T WITH COMMA BELOW
	0x021D, 0x021C, // LATIN CAPITAL LETTER YOGH
	// 0x021F, 0x021E, // LATIN CAPITAL LETTER H WITH CARON
	0x021F, 'H', // LATIN CAPITAL LETTER H WITH CARON
	0x0223, 0x0222, // LATIN CAPITAL LETTER OU
	// 0x0225, 0x0224, // LATIN CAPITAL LETTER Z WITH HOOK
	0x0225, 'Z', // LATIN CAPITAL LETTER Z WITH HOOK
	// 0x0227, 0x0226, // LATIN CAPITAL LETTER A WITH DOT ABOVE
	0x0227, 'A', // LATIN CAPITAL LETTER A WITH DOT ABOVE
	// 0x0229, 0x0228, // LATIN CAPITAL LETTER E WITH CEDILLA
	0x0229, 'E', // LATIN CAPITAL LETTER E WITH CEDILLA
	// 0x022B, 0x022A, // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
	0x022B, 'O', // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
	// 0x022D, 0x022C, // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
	0x022D, 'O', // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
	// 0x022F, 0x022E, // LATIN CAPITAL LETTER O WITH DOT ABOVE
	0x022F, 'O', // LATIN CAPITAL LETTER O WITH DOT ABOVE
	// 0x0231, 0x0230, // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
	0x0231, 'O', // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
	// 0x0233, 0x0232, // LATIN CAPITAL LETTER Y WITH MACRON
	0x0233, 'Y', // LATIN CAPITAL LETTER Y WITH MACRON
	// 0x0253, 0x0181, // LATIN CAPITAL LETTER B WITH HOOK
	0x0253, 'B', // LATIN CAPITAL LETTER B WITH HOOK
	0x0254, 0x0186, // LATIN CAPITAL LETTER OPEN O
	0x0256, 0x0189, // LATIN CAPITAL LETTER AFRICAN D
	// 0x0257, 0x018A, // LATIN CAPITAL LETTER D WITH HOOK
	0x0257, 'D', // LATIN CAPITAL LETTER D WITH HOOK
	0x0259, 0x018F, // LATIN CAPITAL LETTER SCHWA
	0x025B, 0x0190, // LATIN CAPITAL LETTER OPEN E
	// 0x0260, 0x0193, // LATIN CAPITAL LETTER G WITH HOOK
	0x0260, 'G', // LATIN CAPITAL LETTER G WITH HOOK
	0x0263, 0x0194, // LATIN CAPITAL LETTER GAMMA
	// 0x0268, 0x0197, // LATIN CAPITAL LETTER I WITH STROKE
	0x0268, 'I', // LATIN CAPITAL LETTER I WITH STROKE
	0x0269, 0x0196, // LATIN CAPITAL LETTER IOTA
	0x026F, 0x019C, // LATIN CAPITAL LETTER TURNED M
	// 0x0272, 0x019D, // LATIN CAPITAL LETTER N WITH LEFT HOOK
	0x0272, 'N', // LATIN CAPITAL LETTER N WITH LEFT HOOK
	// 0x0275, 0x019F, // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
	0x0275, 'O', // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
	0x0280, 0x01A6, // LATIN LETTER YR
	0x0283, 0x01A9, // LATIN CAPITAL LETTER ESH
	// 0x0288, 0x01AE, // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
	0x0288, 'T', // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
	0x028A, 0x01B1, // LATIN CAPITAL LETTER UPSILON
	// 0x028B, 0x01B2, // LATIN CAPITAL LETTER V WITH HOOK
	0x028B, 'V', // LATIN CAPITAL LETTER V WITH HOOK
	0x0292, 0x01B7, // LATIN CAPITAL LETTER EZH
	0x03AC, 0x0386, // GREEK CAPITAL LETTER ALPHA WITH TONOS
	0x03AD, 0x0388, // GREEK CAPITAL LETTER EPSILON WITH TONOS
	0x03AE, 0x0389, // GREEK CAPITAL LETTER ETA WITH TONOS
	0x03AF, 0x038A, // GREEK CAPITAL LETTER IOTA WITH TONOS
	0x03B1, 0x0391, // GREEK CAPITAL LETTER ALPHA
	0x03B2, 0x0392, // GREEK CAPITAL LETTER BETA
	0x03B3, 0x0393, // GREEK CAPITAL LETTER GAMMA
	0x03B4, 0x0394, // GREEK CAPITAL LETTER DELTA
	0x03B5, 0x0395, // GREEK CAPITAL LETTER EPSILON
	0x03B6, 0x0396, // GREEK CAPITAL LETTER ZETA
	0x03B7, 0x0397, // GREEK CAPITAL LETTER ETA
	0x03B8, 0x0398, // GREEK CAPITAL LETTER THETA
	0x03B9, 0x0345, // COMBINING GREEK YPOGEGRAMMENI
	0x03BA, 0x039A, // GREEK CAPITAL LETTER KAPPA
	0x03BB, 0x039B, // GREEK CAPITAL LETTER LAMDA
	0x03BC, 0x039C, // GREEK CAPITAL LETTER MU
	0x03BD, 0x039D, // GREEK CAPITAL LETTER NU
	0x03BE, 0x039E, // GREEK CAPITAL LETTER XI
	0x03BF, 0x039F, // GREEK CAPITAL LETTER OMICRON
	0x03C0, 0x03A0, // GREEK CAPITAL LETTER PI
	0x03C1, 0x03A1, // GREEK CAPITAL LETTER RHO
	0x03C3, 0x03A3, // GREEK CAPITAL LETTER SIGMA
	0x03C4, 0x03A4, // GREEK CAPITAL LETTER TAU
	0x03C5, 0x03A5, // GREEK CAPITAL LETTER UPSILON
	0x03C6, 0x03A6, // GREEK CAPITAL LETTER PHI
	0x03C7, 0x03A7, // GREEK CAPITAL LETTER CHI
	0x03C8, 0x03A8, // GREEK CAPITAL LETTER PSI
	0x03C9, 0x03A9, // GREEK CAPITAL LETTER OMEGA
	0x03CA, 0x03AA, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
	0x03CB, 0x03AB, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
	0x03CC, 0x038C, // GREEK CAPITAL LETTER OMICRON WITH TONOS
	0x03CD, 0x038E, // GREEK CAPITAL LETTER UPSILON WITH TONOS
	0x03CE, 0x038F, // GREEK CAPITAL LETTER OMEGA WITH TONOS
	0x03D9, 0x03D8, // GREEK LETTER ARCHAIC KOPPA
	0x03DB, 0x03DA, // GREEK LETTER STIGMA
	0x03DD, 0x03DC, // GREEK LETTER DIGAMMA
	0x03DF, 0x03DE, // GREEK LETTER KOPPA
	0x03E1, 0x03E0, // GREEK LETTER SAMPI
	0x03E3, 0x03E2, // COPTIC CAPITAL LETTER SHEI
	0x03E5, 0x03E4, // COPTIC CAPITAL LETTER FEI
	0x03E7, 0x03E6, // COPTIC CAPITAL LETTER KHEI
	0x03E9, 0x03E8, // COPTIC CAPITAL LETTER HORI
	0x03EB, 0x03EA, // COPTIC CAPITAL LETTER GANGIA
	0x03ED, 0x03EC, // COPTIC CAPITAL LETTER SHIMA
	0x03EF, 0x03EE, // COPTIC CAPITAL LETTER DEI
	0x03F2, 0x03F9, // GREEK CAPITAL LUNATE SIGMA SYMBOL
	0x03F8, 0x03F7, // GREEK CAPITAL LETTER SHO
	0x03FB, 0x03FA, // GREEK CAPITAL LETTER SAN
	0x0430, 0x0410, // CYRILLIC CAPITAL LETTER A
	0x0431, 0x0411, // CYRILLIC CAPITAL LETTER BE
	0x0432, 0x0412, // CYRILLIC CAPITAL LETTER VE
	0x0433, 0x0413, // CYRILLIC CAPITAL LETTER GHE
	0x0434, 0x0414, // CYRILLIC CAPITAL LETTER DE
	0x0435, 0x0415, // CYRILLIC CAPITAL LETTER IE
	0x0436, 0x0416, // CYRILLIC CAPITAL LETTER ZHE
	0x0437, 0x0417, // CYRILLIC CAPITAL LETTER ZE
	0x0438, 0x0418, // CYRILLIC CAPITAL LETTER I
	0x0439, 0x0419, // CYRILLIC CAPITAL LETTER SHORT I
	0x043A, 0x041A, // CYRILLIC CAPITAL LETTER KA
	0x043B, 0x041B, // CYRILLIC CAPITAL LETTER EL
	0x043C, 0x041C, // CYRILLIC CAPITAL LETTER EM
	0x043D, 0x041D, // CYRILLIC CAPITAL LETTER EN
	0x043E, 0x041E, // CYRILLIC CAPITAL LETTER O
	0x043F, 0x041F, // CYRILLIC CAPITAL LETTER PE
	0x0440, 0x0420, // CYRILLIC CAPITAL LETTER ER
	0x0441, 0x0421, // CYRILLIC CAPITAL LETTER ES
	0x0442, 0x0422, // CYRILLIC CAPITAL LETTER TE
	0x0443, 0x0423, // CYRILLIC CAPITAL LETTER U
	0x0444, 0x0424, // CYRILLIC CAPITAL LETTER EF
	0x0445, 0x0425, // CYRILLIC CAPITAL LETTER HA
	0x0446, 0x0426, // CYRILLIC CAPITAL LETTER TSE
	0x0447, 0x0427, // CYRILLIC CAPITAL LETTER CHE
	0x0448, 0x0428, // CYRILLIC CAPITAL LETTER SHA
	0x0449, 0x0429, // CYRILLIC CAPITAL LETTER SHCHA
	0x044A, 0x042A, // CYRILLIC CAPITAL LETTER HARD SIGN
	0x044B, 0x042B, // CYRILLIC CAPITAL LETTER YERU
	0x044C, 0x042C, // CYRILLIC CAPITAL LETTER SOFT SIGN
	0x044D, 0x042D, // CYRILLIC CAPITAL LETTER E
	0x044E, 0x042E, // CYRILLIC CAPITAL LETTER YU
	0x044F, 0x042F, // CYRILLIC CAPITAL LETTER YA
	0x0450, 0x0400, // CYRILLIC CAPITAL LETTER IE WITH GRAVE
	0x0451, 0x0401, // CYRILLIC CAPITAL LETTER IO
	0x0452, 0x0402, // CYRILLIC CAPITAL LETTER DJE
	0x0453, 0x0403, // CYRILLIC CAPITAL LETTER GJE
	0x0454, 0x0404, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
	0x0455, 0x0405, // CYRILLIC CAPITAL LETTER DZE
	0x0456, 0x0406, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
	0x0457, 0x0407, // CYRILLIC CAPITAL LETTER YI
	0x0458, 0x0408, // CYRILLIC CAPITAL LETTER JE
	0x0459, 0x0409, // CYRILLIC CAPITAL LETTER LJE
	0x045A, 0x040A, // CYRILLIC CAPITAL LETTER NJE
	0x045B, 0x040B, // CYRILLIC CAPITAL LETTER TSHE
	0x045C, 0x040C, // CYRILLIC CAPITAL LETTER KJE
	0x045D, 0x040D, // CYRILLIC CAPITAL LETTER I WITH GRAVE
	0x045E, 0x040E, // CYRILLIC CAPITAL LETTER SHORT U
	0x045F, 0x040F, // CYRILLIC CAPITAL LETTER DZHE
	0x0461, 0x0460, // CYRILLIC CAPITAL LETTER OMEGA
	0x0463, 0x0462, // CYRILLIC CAPITAL LETTER YAT
	0x0465, 0x0464, // CYRILLIC CAPITAL LETTER IOTIFIED E
	0x0467, 0x0466, // CYRILLIC CAPITAL LETTER LITTLE YUS
	0x0469, 0x0468, // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
	0x046B, 0x046A, // CYRILLIC CAPITAL LETTER BIG YUS
	0x046D, 0x046C, // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
	0x046F, 0x046E, // CYRILLIC CAPITAL LETTER KSI
	0x0471, 0x0470, // CYRILLIC CAPITAL LETTER PSI
	0x0473, 0x0472, // CYRILLIC CAPITAL LETTER FITA
	0x0475, 0x0474, // CYRILLIC CAPITAL LETTER IZHITSA
	0x0477, 0x0476, // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
	0x0479, 0x0478, // CYRILLIC CAPITAL LETTER UK
	0x047B, 0x047A, // CYRILLIC CAPITAL LETTER ROUND OMEGA
	0x047D, 0x047C, // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
	0x047F, 0x047E, // CYRILLIC CAPITAL LETTER OT
	0x0481, 0x0480, // CYRILLIC CAPITAL LETTER KOPPA
	0x048B, 0x048A, // CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
	0x048D, 0x048C, // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
	0x048F, 0x048E, // CYRILLIC CAPITAL LETTER ER WITH TICK
	0x0491, 0x0490, // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
	0x0493, 0x0492, // CYRILLIC CAPITAL LETTER GHE WITH STROKE
	0x0495, 0x0494, // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
	0x0497, 0x0496, // CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
	0x0499, 0x0498, // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
	0x049B, 0x049A, // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
	0x049D, 0x049C, // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
	0x049F, 0x049E, // CYRILLIC CAPITAL LETTER KA WITH STROKE
	0x04A1, 0x04A0, // CYRILLIC CAPITAL LETTER BASHKIR KA
	0x04A3, 0x04A2, // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
	0x04A5, 0x04A4, // CYRILLIC CAPITAL LIGATURE EN GHE
	0x04A7, 0x04A6, // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
	0x04A9, 0x04A8, // CYRILLIC CAPITAL LETTER ABKHASIAN HA
	0x04AB, 0x04AA, // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
	0x04AD, 0x04AC, // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
	0x04AF, 0x04AE, // CYRILLIC CAPITAL LETTER STRAIGHT U
	0x04B1, 0x04B0, // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
	0x04B3, 0x04B2, // CYRILLIC CAPITAL LETTER HA WITH DESCENDER
	0x04B5, 0x04B4, // CYRILLIC CAPITAL LIGATURE TE TSE
	0x04B7, 0x04B6, // CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
	0x04B9, 0x04B8, // CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
	0x04BB, 0x04BA, // CYRILLIC CAPITAL LETTER SHHA
	0x04BD, 0x04BC, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
	0x04BF, 0x04BE, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
	0x04C2, 0x04C1, // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
	0x04C4, 0x04C3, // CYRILLIC CAPITAL LETTER KA WITH HOOK
	0x04C6, 0x04C5, // CYRILLIC CAPITAL LETTER EL WITH TAIL
	0x04C8, 0x04C7, // CYRILLIC CAPITAL LETTER EN WITH HOOK
	0x04CA, 0x04C9, // CYRILLIC CAPITAL LETTER EN WITH TAIL
	0x04CC, 0x04CB, // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
	0x04CE, 0x04CD, // CYRILLIC CAPITAL LETTER EM WITH TAIL
	0x04D1, 0x04D0, // CYRILLIC CAPITAL LETTER A WITH BREVE
	0x04D3, 0x04D2, // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
	0x04D5, 0x04D4, // CYRILLIC CAPITAL LIGATURE A IE
	0x04D7, 0x04D6, // CYRILLIC CAPITAL LETTER IE WITH BREVE
	0x04D9, 0x04D8, // CYRILLIC CAPITAL LETTER SCHWA
	0x04DB, 0x04DA, // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
	0x04DD, 0x04DC, // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
	0x04DF, 0x04DE, // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
	0x04E1, 0x04E0, // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
	0x04E3, 0x04E2, // CYRILLIC CAPITAL LETTER I WITH MACRON
	0x04E5, 0x04E4, // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
	0x04E7, 0x04E6, // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
	0x04E9, 0x04E8, // CYRILLIC CAPITAL LETTER BARRED O
	0x04EB, 0x04EA, // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
	0x04ED, 0x04EC, // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
	0x04EF, 0x04EE, // CYRILLIC CAPITAL LETTER U WITH MACRON
	0x04F1, 0x04F0, // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
	0x04F3, 0x04F2, // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
	0x04F5, 0x04F4, // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
	0x04F9, 0x04F8, // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
	0x0501, 0x0500, // CYRILLIC CAPITAL LETTER KOMI DE
	0x0503, 0x0502, // CYRILLIC CAPITAL LETTER KOMI DJE
	0x0505, 0x0504, // CYRILLIC CAPITAL LETTER KOMI ZJE
	0x0507, 0x0506, // CYRILLIC CAPITAL LETTER KOMI DZJE
	0x0509, 0x0508, // CYRILLIC CAPITAL LETTER KOMI LJE
	0x050B, 0x050A, // CYRILLIC CAPITAL LETTER KOMI NJE
	0x050D, 0x050C, // CYRILLIC CAPITAL LETTER KOMI SJE
	0x050F, 0x050E, // CYRILLIC CAPITAL LETTER KOMI TJE
	0x0561, 0x0531, // ARMENIAN CAPITAL LETTER AYB
	0x0562, 0x0532, // ARMENIAN CAPITAL LETTER BEN
	0x0563, 0x0533, // ARMENIAN CAPITAL LETTER GIM
	0x0564, 0x0534, // ARMENIAN CAPITAL LETTER DA
	0x0565, 0x0535, // ARMENIAN CAPITAL LETTER ECH
	0x0566, 0x0536, // ARMENIAN CAPITAL LETTER ZA
	0x0567, 0x0537, // ARMENIAN CAPITAL LETTER EH
	0x0568, 0x0538, // ARMENIAN CAPITAL LETTER ET
	0x0569, 0x0539, // ARMENIAN CAPITAL LETTER TO
	0x056A, 0x053A, // ARMENIAN CAPITAL LETTER ZHE
	0x056B, 0x053B, // ARMENIAN CAPITAL LETTER INI
	0x056C, 0x053C, // ARMENIAN CAPITAL LETTER LIWN
	0x056D, 0x053D, // ARMENIAN CAPITAL LETTER XEH
	0x056E, 0x053E, // ARMENIAN CAPITAL LETTER CA
	0x056F, 0x053F, // ARMENIAN CAPITAL LETTER KEN
	0x0570, 0x0540, // ARMENIAN CAPITAL LETTER HO
	0x0571, 0x0541, // ARMENIAN CAPITAL LETTER JA
	0x0572, 0x0542, // ARMENIAN CAPITAL LETTER GHAD
	0x0573, 0x0543, // ARMENIAN CAPITAL LETTER CHEH
	0x0574, 0x0544, // ARMENIAN CAPITAL LETTER MEN
	0x0575, 0x0545, // ARMENIAN CAPITAL LETTER YI
	0x0576, 0x0546, // ARMENIAN CAPITAL LETTER NOW
	0x0577, 0x0547, // ARMENIAN CAPITAL LETTER SHA
	0x0578, 0x0548, // ARMENIAN CAPITAL LETTER VO
	0x0579, 0x0549, // ARMENIAN CAPITAL LETTER CHA
	0x057A, 0x054A, // ARMENIAN CAPITAL LETTER PEH
	0x057B, 0x054B, // ARMENIAN CAPITAL LETTER JHEH
	0x057C, 0x054C, // ARMENIAN CAPITAL LETTER RA
	0x057D, 0x054D, // ARMENIAN CAPITAL LETTER SEH
	0x057E, 0x054E, // ARMENIAN CAPITAL LETTER VEW
	0x057F, 0x054F, // ARMENIAN CAPITAL LETTER TIWN
	0x0580, 0x0550, // ARMENIAN CAPITAL LETTER REH
	0x0581, 0x0551, // ARMENIAN CAPITAL LETTER CO
	0x0582, 0x0552, // ARMENIAN CAPITAL LETTER YIWN
	0x0583, 0x0553, // ARMENIAN CAPITAL LETTER PIWR
	0x0584, 0x0554, // ARMENIAN CAPITAL LETTER KEH
	0x0585, 0x0555, // ARMENIAN CAPITAL LETTER OH
	0x0586, 0x0556, // ARMENIAN CAPITAL LETTER FEH
	// 0x1E01, 0x1E00, // LATIN CAPITAL LETTER A WITH RING BELOW
	0x1E01, 'A', // LATIN CAPITAL LETTER A WITH RING BELOW
	// 0x1E03, 0x1E02, // LATIN CAPITAL LETTER B WITH DOT ABOVE
	0x1E03, 'B', // LATIN CAPITAL LETTER B WITH DOT ABOVE
	// 0x1E05, 0x1E04, // LATIN CAPITAL LETTER B WITH DOT BELOW
	0x1E05, 'B', // LATIN CAPITAL LETTER B WITH DOT BELOW
	// 0x1E07, 0x1E06, // LATIN CAPITAL LETTER B WITH LINE BELOW
	0x1E07, 'B', // LATIN CAPITAL LETTER B WITH LINE BELOW
	// 0x1E09, 0x1E08, // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
	0x1E09, 'C', // LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
	// 0x1E0B, 0x1E0A, // LATIN CAPITAL LETTER D WITH DOT ABOVE
	0x1E0B, 'D', // LATIN CAPITAL LETTER D WITH DOT ABOVE
	// 0x1E0D, 0x1E0C, // LATIN CAPITAL LETTER D WITH DOT BELOW
	0x1E0D, 'D', // LATIN CAPITAL LETTER D WITH DOT BELOW
	// 0x1E0F, 0x1E0E, // LATIN CAPITAL LETTER D WITH LINE BELOW
	0x1E0F, 'D', // LATIN CAPITAL LETTER D WITH LINE BELOW
	// 0x1E11, 0x1E10, // LATIN CAPITAL LETTER D WITH CEDILLA
	0x1E11, 'D', // LATIN CAPITAL LETTER D WITH CEDILLA
	// 0x1E13, 0x1E12, // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
	0x1E13, 'D', // LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
	// 0x1E15, 0x1E14, // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
	0x1E15, 'E', // LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
	// 0x1E17, 0x1E16, // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
	0x1E17, 'E', // LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
	// 0x1E19, 0x1E18, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
	0x1E19, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
	// 0x1E1B, 0x1E1A, // LATIN CAPITAL LETTER E WITH TILDE BELOW
	0x1E1B, 'E', // LATIN CAPITAL LETTER E WITH TILDE BELOW
	// 0x1E1D, 0x1E1C, // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
	0x1E1D, 'E', // LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
	// 0x1E1F, 0x1E1E, // LATIN CAPITAL LETTER F WITH DOT ABOVE
	0x1E1F, 'F', // LATIN CAPITAL LETTER F WITH DOT ABOVE
	// 0x1E21, 0x1E20, // LATIN CAPITAL LETTER G WITH MACRON
	0x1E21, 'G', // LATIN CAPITAL LETTER G WITH MACRON
	// 0x1E23, 0x1E22, // LATIN CAPITAL LETTER H WITH DOT ABOVE
	0x1E23, 'H', // LATIN CAPITAL LETTER H WITH DOT ABOVE
	// 0x1E25, 0x1E24, // LATIN CAPITAL LETTER H WITH DOT BELOW
	0x1E25, 'H', // LATIN CAPITAL LETTER H WITH DOT BELOW
	// 0x1E27, 0x1E26, // LATIN CAPITAL LETTER H WITH DIAERESIS
	0x1E27, 'H', // LATIN CAPITAL LETTER H WITH DIAERESIS
	// 0x1E29, 0x1E28, // LATIN CAPITAL LETTER H WITH CEDILLA
	0x1E29, 'H', // LATIN CAPITAL LETTER H WITH CEDILLA
	// 0x1E2B, 0x1E2A, // LATIN CAPITAL LETTER H WITH BREVE BELOW
	0x1E2B, 'H', // LATIN CAPITAL LETTER H WITH BREVE BELOW
	// 0x1E2D, 0x1E2C, // LATIN CAPITAL LETTER I WITH TILDE BELOW
	0x1E2D, 'I', // LATIN CAPITAL LETTER I WITH TILDE BELOW
	// 0x1E2F, 0x1E2E, // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
	0x1E2F, 'I', // LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
	// 0x1E31, 0x1E30, // LATIN CAPITAL LETTER K WITH ACUTE
	0x1E31, 'K', // LATIN CAPITAL LETTER K WITH ACUTE
	// 0x1E33, 0x1E32, // LATIN CAPITAL LETTER K WITH DOT BELOW
	0x1E33, 'K', // LATIN CAPITAL LETTER K WITH DOT BELOW
	// 0x1E35, 0x1E34, // LATIN CAPITAL LETTER K WITH LINE BELOW
	0x1E35, 'K', // LATIN CAPITAL LETTER K WITH LINE BELOW
	// 0x1E37, 0x1E36, // LATIN CAPITAL LETTER L WITH DOT BELOW
	0x1E37, 'L', // LATIN CAPITAL LETTER L WITH DOT BELOW
	// 0x1E39, 0x1E38, // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
	0x1E39, 'L', // LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
	// 0x1E3B, 0x1E3A, // LATIN CAPITAL LETTER L WITH LINE BELOW
	0x1E3B, 'L', // LATIN CAPITAL LETTER L WITH LINE BELOW
	// 0x1E3D, 0x1E3C, // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
	0x1E3D, 'L', // LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
	// 0x1E3F, 0x1E3E, // LATIN CAPITAL LETTER M WITH ACUTE
	0x1E3F, 'M', // LATIN CAPITAL LETTER M WITH ACUTE
	// 0x1E41, 0x1E40, // LATIN CAPITAL LETTER M WITH DOT ABOVE
	0x1E41, 'M', // LATIN CAPITAL LETTER M WITH DOT ABOVE
	// 0x1E43, 0x1E42, // LATIN CAPITAL LETTER M WITH DOT BELOW
	0x1E43, 'M', // LATIN CAPITAL LETTER M WITH DOT BELOW
	// 0x1E45, 0x1E44, // LATIN CAPITAL LETTER N WITH DOT ABOVE
	0x1E45, 'N', // LATIN CAPITAL LETTER N WITH DOT ABOVE
	// 0x1E47, 0x1E46, // LATIN CAPITAL LETTER N WITH DOT BELOW
	0x1E47, 'N', // LATIN CAPITAL LETTER N WITH DOT BELOW
	// 0x1E49, 0x1E48, // LATIN CAPITAL LETTER N WITH LINE BELOW
	0x1E49, 'N', // LATIN CAPITAL LETTER N WITH LINE BELOW
	// 0x1E4B, 0x1E4A, // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
	0x1E4B, 'N', // LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
	// 0x1E4D, 0x1E4C, // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
	0x1E4D, 'O', // LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
	// 0x1E4F, 0x1E4E, // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
	0x1E4F, 'O', // LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
	// 0x1E51, 0x1E50, // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
	0x1E51, 'O', // LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
	// 0x1E53, 0x1E52, // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
	0x1E53, 'O', // LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
	// 0x1E55, 0x1E54, // LATIN CAPITAL LETTER P WITH ACUTE
	0x1E55, 'P', // LATIN CAPITAL LETTER P WITH ACUTE
	// 0x1E57, 0x1E56, // LATIN CAPITAL LETTER P WITH DOT ABOVE
	0x1E57, 'P', // LATIN CAPITAL LETTER P WITH DOT ABOVE
	// 0x1E59, 0x1E58, // LATIN CAPITAL LETTER R WITH DOT ABOVE
	0x1E59, 'R', // LATIN CAPITAL LETTER R WITH DOT ABOVE
	// 0x1E5B, 0x1E5A, // LATIN CAPITAL LETTER R WITH DOT BELOW
	0x1E5B, 'R', // LATIN CAPITAL LETTER R WITH DOT BELOW
	// 0x1E5D, 0x1E5C, // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
	0x1E5D, 'R', // LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
	// 0x1E5F, 0x1E5E, // LATIN CAPITAL LETTER R WITH LINE BELOW
	0x1E5F, 'R', // LATIN CAPITAL LETTER R WITH LINE BELOW
	// 0x1E61, 0x1E60, // LATIN CAPITAL LETTER S WITH DOT ABOVE
	0x1E61, 'S', // LATIN CAPITAL LETTER S WITH DOT ABOVE
	// 0x1E63, 0x1E62, // LATIN CAPITAL LETTER S WITH DOT BELOW
	0x1E63, 'S', // LATIN CAPITAL LETTER S WITH DOT BELOW
	// 0x1E65, 0x1E64, // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
	0x1E65, 'S', // LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
	// 0x1E67, 0x1E66, // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
	0x1E67, 'S', // LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
	// 0x1E69, 0x1E68, // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
	0x1E69, 'S', // LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
	// 0x1E6B, 0x1E6A, // LATIN CAPITAL LETTER T WITH DOT ABOVE
	0x1E6B, 'T', // LATIN CAPITAL LETTER T WITH DOT ABOVE
	// 0x1E6D, 0x1E6C, // LATIN CAPITAL LETTER T WITH DOT BELOW
	0x1E6D, 'T', // LATIN CAPITAL LETTER T WITH DOT BELOW
	// 0x1E6F, 0x1E6E, // LATIN CAPITAL LETTER T WITH LINE BELOW
	0x1E6F, 'T', // LATIN CAPITAL LETTER T WITH LINE BELOW
	// 0x1E71, 0x1E70, // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
	0x1E71, 'T', // LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
	// 0x1E73, 0x1E72, // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
	0x1E73, 'U', // LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
	// 0x1E75, 0x1E74, // LATIN CAPITAL LETTER U WITH TILDE BELOW
	0x1E75, 'U', // LATIN CAPITAL LETTER U WITH TILDE BELOW
	// 0x1E77, 0x1E76, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
	0x1E77, 'U', // LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
	// 0x1E79, 0x1E78, // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
	0x1E79, 'U', // LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
	// 0x1E7B, 0x1E7A, // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
	0x1E7B, 'U', // LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
	// 0x1E7D, 0x1E7C, // LATIN CAPITAL LETTER V WITH TILDE
	0x1E7D, 'V', // LATIN CAPITAL LETTER V WITH TILDE
	// 0x1E7F, 0x1E7E, // LATIN CAPITAL LETTER V WITH DOT BELOW
	0x1E7F, 'V', // LATIN CAPITAL LETTER V WITH DOT BELOW
	// 0x1E81, 0x1E80, // LATIN CAPITAL LETTER W WITH GRAVE
	0x1E81, 'W', // LATIN CAPITAL LETTER W WITH GRAVE
	// 0x1E83, 0x1E82, // LATIN CAPITAL LETTER W WITH ACUTE
	0x1E83, 'W', // LATIN CAPITAL LETTER W WITH ACUTE
	// 0x1E85, 0x1E84, // LATIN CAPITAL LETTER W WITH DIAERESIS
	0x1E85, 'W', // LATIN CAPITAL LETTER W WITH DIAERESIS
	// 0x1E87, 0x1E86, // LATIN CAPITAL LETTER W WITH DOT ABOVE
	0x1E87, 'W', // LATIN CAPITAL LETTER W WITH DOT ABOVE
	// 0x1E89, 0x1E88, // LATIN CAPITAL LETTER W WITH DOT BELOW
	0x1E89, 'W', // LATIN CAPITAL LETTER W WITH DOT BELOW
	// 0x1E8B, 0x1E8A, // LATIN CAPITAL LETTER X WITH DOT ABOVE
	0x1E8B, 'X', // LATIN CAPITAL LETTER X WITH DOT ABOVE
	// 0x1E8D, 0x1E8C, // LATIN CAPITAL LETTER X WITH DIAERESIS
	0x1E8D, 'X', // LATIN CAPITAL LETTER X WITH DIAERESIS
	// 0x1E8F, 0x1E8E, // LATIN CAPITAL LETTER Y WITH DOT ABOVE
	0x1E8F, 'Y', // LATIN CAPITAL LETTER Y WITH DOT ABOVE
	// 0x1E91, 0x1E90, // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
	0x1E91, 'Z', // LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
	// 0x1E93, 0x1E92, // LATIN CAPITAL LETTER Z WITH DOT BELOW
	0x1E93, 'Z', // LATIN CAPITAL LETTER Z WITH DOT BELOW
	// 0x1E95, 0x1E94, // LATIN CAPITAL LETTER Z WITH LINE BELOW
	0x1E95, 'Z', // LATIN CAPITAL LETTER Z WITH LINE BELOW
	// 0x1EA1, 0x1EA0, // LATIN CAPITAL LETTER A WITH DOT BELOW
	0x1EA1, 'A', // LATIN CAPITAL LETTER A WITH DOT BELOW
	// 0x1EA3, 0x1EA2, // LATIN CAPITAL LETTER A WITH HOOK ABOVE
	0x1EA3, 'A', // LATIN CAPITAL LETTER A WITH HOOK ABOVE
	// 0x1EA5, 0x1EA4, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
	0x1EA5, 'A', // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
	// 0x1EA7, 0x1EA6, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
	0x1EA7, 'A', // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
	// 0x1EA9, 0x1EA8, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
	0x1EA9, 'A', // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
	// 0x1EAB, 0x1EAA, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
	0x1EAB, 'A', // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
	// 0x1EAD, 0x1EAC, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
	0x1EAD, 'A', // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
	// 0x1EAF, 0x1EAE, // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
	0x1EAF, 'A', // LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
	// 0x1EB1, 0x1EB0, // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
	0x1EB1, 'A', // LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
	// 0x1EB3, 0x1EB2, // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
	0x1EB3, 'A', // LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
	// 0x1EB5, 0x1EB4, // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
	0x1EB5, 'A', // LATIN CAPITAL LETTER A WITH BREVE AND TILDE
	// 0x1EB7, 0x1EB6, // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
	0x1EB7, 'A', // LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
	// 0x1EB9, 0x1EB8, // LATIN CAPITAL LETTER E WITH DOT BELOW
	0x1EB9, 'E', // LATIN CAPITAL LETTER E WITH DOT BELOW
	// 0x1EBB, 0x1EBA, // LATIN CAPITAL LETTER E WITH HOOK ABOVE
	0x1EBB, 'E', // LATIN CAPITAL LETTER E WITH HOOK ABOVE
	// 0x1EBD, 0x1EBC, // LATIN CAPITAL LETTER E WITH TILDE
	0x1EBD, 'E', // LATIN CAPITAL LETTER E WITH TILDE
	// 0x1EBF, 0x1EBE, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
	0x1EBF, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
	// 0x1EC1, 0x1EC0, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
	0x1EC1, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
	// 0x1EC3, 0x1EC2, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
	0x1EC3, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
	// 0x1EC5, 0x1EC4, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
	0x1EC5, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
	// 0x1EC7, 0x1EC6, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
	0x1EC7, 'E', // LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
	// 0x1EC9, 0x1EC8, // LATIN CAPITAL LETTER I WITH HOOK ABOVE
	0x1EC9, 'I', // LATIN CAPITAL LETTER I WITH HOOK ABOVE
	// 0x1ECB, 0x1ECA, // LATIN CAPITAL LETTER I WITH DOT BELOW
	0x1ECB, 'I', // LATIN CAPITAL LETTER I WITH DOT BELOW
	// 0x1ECD, 0x1ECC, // LATIN CAPITAL LETTER O WITH DOT BELOW
	0x1ECD, 'O', // LATIN CAPITAL LETTER O WITH DOT BELOW
	// 0x1ECF, 0x1ECE, // LATIN CAPITAL LETTER O WITH HOOK ABOVE
	0x1ECF, 'O', // LATIN CAPITAL LETTER O WITH HOOK ABOVE
	// 0x1ED1, 0x1ED0, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
	0x1ED1, 'O', // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
	// 0x1ED3, 0x1ED2, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
	0x1ED3, 'O', // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
	// 0x1ED5, 0x1ED4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
	0x1ED5, 'O', // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
	// 0x1ED7, 0x1ED6, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
	0x1ED7, 'O', // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
	// 0x1ED9, 0x1ED8, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
	0x1ED9, 'O', // LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
	// 0x1EDB, 0x1EDA, // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
	0x1EDB, 'O', // LATIN CAPITAL LETTER O WITH HORN AND ACUTE
	// 0x1EDD, 0x1EDC, // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
	0x1EDD, 'O', // LATIN CAPITAL LETTER O WITH HORN AND GRAVE
	// 0x1EDF, 0x1EDE, // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
	0x1EDF, 'O', // LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
	// 0x1EE1, 0x1EE0, // LATIN CAPITAL LETTER O WITH HORN AND TILDE
	0x1EE1, 'O', // LATIN CAPITAL LETTER O WITH HORN AND TILDE
	// 0x1EE3, 0x1EE2, // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
	0x1EE3, 'O', // LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
	// 0x1EE5, 0x1EE4, // LATIN CAPITAL LETTER U WITH DOT BELOW
	0x1EE5, 'U', // LATIN CAPITAL LETTER U WITH DOT BELOW
	// 0x1EE7, 0x1EE6, // LATIN CAPITAL LETTER U WITH HOOK ABOVE
	0x1EE7, 'U', // LATIN CAPITAL LETTER U WITH HOOK ABOVE
	// 0x1EE9, 0x1EE8, // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
	0x1EE9, 'U', // LATIN CAPITAL LETTER U WITH HORN AND ACUTE
	// 0x1EEB, 0x1EEA, // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
	0x1EEB, 'U', // LATIN CAPITAL LETTER U WITH HORN AND GRAVE
	// 0x1EED, 0x1EEC, // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
	0x1EED, 'U', // LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
	// 0x1EEF, 0x1EEE, // LATIN CAPITAL LETTER U WITH HORN AND TILDE
	0x1EEF, 'U', // LATIN CAPITAL LETTER U WITH HORN AND TILDE
	// 0x1EF1, 0x1EF0, // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
	0x1EF1, 'U', // LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
	// 0x1EF3, 0x1EF2, // LATIN CAPITAL LETTER Y WITH GRAVE
	0x1EF3, 'Y', // LATIN CAPITAL LETTER Y WITH GRAVE
	// 0x1EF5, 0x1EF4, // LATIN CAPITAL LETTER Y WITH DOT BELOW
	0x1EF5, 'Y', // LATIN CAPITAL LETTER Y WITH DOT BELOW
	// 0x1EF7, 0x1EF6, // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
	0x1EF7, 'Y', // LATIN CAPITAL LETTER Y WITH HOOK ABOVE
	// 0x1EF9, 0x1EF8, // LATIN CAPITAL LETTER Y WITH TILDE
	0x1EF9, 'Y', // LATIN CAPITAL LETTER Y WITH TILDE
	0x1F00, 0x1F08, // GREEK CAPITAL LETTER ALPHA WITH PSILI
	0x1F01, 0x1F09, // GREEK CAPITAL LETTER ALPHA WITH DASIA
	0x1F02, 0x1F0A, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
	0x1F03, 0x1F0B, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
	0x1F04, 0x1F0C, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
	0x1F05, 0x1F0D, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
	0x1F06, 0x1F0E, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
	0x1F07, 0x1F0F, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
	0x1F10, 0x1F18, // GREEK CAPITAL LETTER EPSILON WITH PSILI
	0x1F11, 0x1F19, // GREEK CAPITAL LETTER EPSILON WITH DASIA
	0x1F12, 0x1F1A, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
	0x1F13, 0x1F1B, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
	0x1F14, 0x1F1C, // GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
	0x1F15, 0x1F1D, // GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
	0x1F20, 0x1F28, // GREEK CAPITAL LETTER ETA WITH PSILI
	0x1F21, 0x1F29, // GREEK CAPITAL LETTER ETA WITH DASIA
	0x1F22, 0x1F2A, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
	0x1F23, 0x1F2B, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
	0x1F24, 0x1F2C, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
	0x1F25, 0x1F2D, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
	0x1F26, 0x1F2E, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
	0x1F27, 0x1F2F, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
	0x1F30, 0x1F38, // GREEK CAPITAL LETTER IOTA WITH PSILI
	0x1F31, 0x1F39, // GREEK CAPITAL LETTER IOTA WITH DASIA
	0x1F32, 0x1F3A, // GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
	0x1F33, 0x1F3B, // GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
	0x1F34, 0x1F3C, // GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
	0x1F35, 0x1F3D, // GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
	0x1F36, 0x1F3E, // GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
	0x1F37, 0x1F3F, // GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
	0x1F40, 0x1F48, // GREEK CAPITAL LETTER OMICRON WITH PSILI
	0x1F41, 0x1F49, // GREEK CAPITAL LETTER OMICRON WITH DASIA
	0x1F42, 0x1F4A, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
	0x1F43, 0x1F4B, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
	0x1F44, 0x1F4C, // GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
	0x1F45, 0x1F4D, // GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
	0x1F51, 0x1F59, // GREEK CAPITAL LETTER UPSILON WITH DASIA
	0x1F53, 0x1F5B, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
	0x1F55, 0x1F5D, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
	0x1F57, 0x1F5F, // GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
	0x1F60, 0x1F68, // GREEK CAPITAL LETTER OMEGA WITH PSILI
	0x1F61, 0x1F69, // GREEK CAPITAL LETTER OMEGA WITH DASIA
	0x1F62, 0x1F6A, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
	0x1F63, 0x1F6B, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
	0x1F64, 0x1F6C, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
	0x1F65, 0x1F6D, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
	0x1F66, 0x1F6E, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
	0x1F67, 0x1F6F, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
	0x1F70, 0x1FBA, // GREEK CAPITAL LETTER ALPHA WITH VARIA
	0x1F71, 0x1FBB, // GREEK CAPITAL LETTER ALPHA WITH OXIA
	0x1F72, 0x1FC8, // GREEK CAPITAL LETTER EPSILON WITH VARIA
	0x1F73, 0x1FC9, // GREEK CAPITAL LETTER EPSILON WITH OXIA
	0x1F74, 0x1FCA, // GREEK CAPITAL LETTER ETA WITH VARIA
	0x1F75, 0x1FCB, // GREEK CAPITAL LETTER ETA WITH OXIA
	0x1F76, 0x1FDA, // GREEK CAPITAL LETTER IOTA WITH VARIA
	0x1F77, 0x1FDB, // GREEK CAPITAL LETTER IOTA WITH OXIA
	0x1F78, 0x1FF8, // GREEK CAPITAL LETTER OMICRON WITH VARIA
	0x1F79, 0x1FF9, // GREEK CAPITAL LETTER OMICRON WITH OXIA
	0x1F7A, 0x1FEA, // GREEK CAPITAL LETTER UPSILON WITH VARIA
	0x1F7B, 0x1FEB, // GREEK CAPITAL LETTER UPSILON WITH OXIA
	0x1F7C, 0x1FFA, // GREEK CAPITAL LETTER OMEGA WITH VARIA
	0x1F7D, 0x1FFB, // GREEK CAPITAL LETTER OMEGA WITH OXIA
	0x1F80, 0x1F88, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
	0x1F81, 0x1F89, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
	0x1F82, 0x1F8A, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
	0x1F83, 0x1F8B, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
	0x1F84, 0x1F8C, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
	0x1F85, 0x1F8D, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
	0x1F86, 0x1F8E, // GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
	0x1F87, 0x1F8F, // GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	0x1F90, 0x1F98, // GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
	0x1F91, 0x1F99, // GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
	0x1F92, 0x1F9A, // GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
	0x1F93, 0x1F9B, // GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
	0x1F94, 0x1F9C, // GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
	0x1F95, 0x1F9D, // GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
	0x1F96, 0x1F9E, // GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
	0x1F97, 0x1F9F, // GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	0x1FA0, 0x1FA8, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
	0x1FA1, 0x1FA9, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
	0x1FA2, 0x1FAA, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
	0x1FA3, 0x1FAB, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
	0x1FA4, 0x1FAC, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
	0x1FA5, 0x1FAD, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
	0x1FA6, 0x1FAE, // GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
	0x1FA7, 0x1FAF, // GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	0x1FB0, 0x1FB8, // GREEK CAPITAL LETTER ALPHA WITH VRACHY
	0x1FB1, 0x1FB9, // GREEK CAPITAL LETTER ALPHA WITH MACRON
	0x1FB3, 0x1FBC, // GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
	0x1FC3, 0x1FCC, // GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
	0x1FD0, 0x1FD8, // GREEK CAPITAL LETTER IOTA WITH VRACHY
	0x1FD1, 0x1FD9, // GREEK CAPITAL LETTER IOTA WITH MACRON
	0x1FE0, 0x1FE8, // GREEK CAPITAL LETTER UPSILON WITH VRACHY
	0x1FE1, 0x1FE9, // GREEK CAPITAL LETTER UPSILON WITH MACRON
	0x1FE5, 0x1FEC, // GREEK CAPITAL LETTER RHO WITH DASIA
	0x1FF3, 0x1FFC, // GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
	0x2170, 0x2160, // ROMAN NUMERAL ONE
	0x2171, 0x2161, // ROMAN NUMERAL TWO
	0x2172, 0x2162, // ROMAN NUMERAL THREE
	0x2173, 0x2163, // ROMAN NUMERAL FOUR
	0x2174, 0x2164, // ROMAN NUMERAL FIVE
	0x2175, 0x2165, // ROMAN NUMERAL SIX
	0x2176, 0x2166, // ROMAN NUMERAL SEVEN
	0x2177, 0x2167, // ROMAN NUMERAL EIGHT
	0x2178, 0x2168, // ROMAN NUMERAL NINE
	0x2179, 0x2169, // ROMAN NUMERAL TEN
	0x217A, 0x216A, // ROMAN NUMERAL ELEVEN
	0x217B, 0x216B, // ROMAN NUMERAL TWELVE
	0x217C, 0x216C, // ROMAN NUMERAL FIFTY
	0x217D, 0x216D, // ROMAN NUMERAL ONE HUNDRED
	0x217E, 0x216E, // ROMAN NUMERAL FIVE HUNDRED
	0x217F, 0x216F, // ROMAN NUMERAL ONE THOUSAND
	// 0x24D0, 0x24B6, // CIRCLED LATIN CAPITAL LETTER A
	0x24D0, 'A', // CIRCLED LATIN CAPITAL LETTER A
	// 0x24D1, 0x24B7, // CIRCLED LATIN CAPITAL LETTER B
	0x24D1, 'B', // CIRCLED LATIN CAPITAL LETTER B
	// 0x24D2, 0x24B8, // CIRCLED LATIN CAPITAL LETTER C
	0x24D2, 'C', // CIRCLED LATIN CAPITAL LETTER C
	// 0x24D3, 0x24B9, // CIRCLED LATIN CAPITAL LETTER D
	0x24D3, 'D', // CIRCLED LATIN CAPITAL LETTER D
	// 0x24D4, 0x24BA, // CIRCLED LATIN CAPITAL LETTER E
	0x24D4, 'E', // CIRCLED LATIN CAPITAL LETTER E
	// 0x24D5, 0x24BB, // CIRCLED LATIN CAPITAL LETTER F
	0x24D5, 'F', // CIRCLED LATIN CAPITAL LETTER F
	// 0x24D6, 0x24BC, // CIRCLED LATIN CAPITAL LETTER G
	0x24D6, 'G', // CIRCLED LATIN CAPITAL LETTER G
	// 0x24D7, 0x24BD, // CIRCLED LATIN CAPITAL LETTER H
	0x24D7, 'H', // CIRCLED LATIN CAPITAL LETTER H
	// 0x24D8, 0x24BE, // CIRCLED LATIN CAPITAL LETTER I
	0x24D8, 'I', // CIRCLED LATIN CAPITAL LETTER I
	// 0x24D9, 0x24BF, // CIRCLED LATIN CAPITAL LETTER J
	0x24D9, 'J', // CIRCLED LATIN CAPITAL LETTER J
	// 0x24DA, 0x24C0, // CIRCLED LATIN CAPITAL LETTER K
	0x24DA, 'K', // CIRCLED LATIN CAPITAL LETTER K
	// 0x24DB, 0x24C1, // CIRCLED LATIN CAPITAL LETTER L
	0x24DB, 'L', // CIRCLED LATIN CAPITAL LETTER L
	// 0x24DC, 0x24C2, // CIRCLED LATIN CAPITAL LETTER M
	0x24DC, 'M', // CIRCLED LATIN CAPITAL LETTER M
	// 0x24DD, 0x24C3, // CIRCLED LATIN CAPITAL LETTER N
	0x24DD, 'N', // CIRCLED LATIN CAPITAL LETTER N
	// 0x24DE, 0x24C4, // CIRCLED LATIN CAPITAL LETTER O
	0x24DE, 'O', // CIRCLED LATIN CAPITAL LETTER O
	// 0x24DF, 0x24C5, // CIRCLED LATIN CAPITAL LETTER P
	0x24DF, 'P', // CIRCLED LATIN CAPITAL LETTER P
	// 0x24E0, 0x24C6, // CIRCLED LATIN CAPITAL LETTER Q
	0x24E0, 'Q', // CIRCLED LATIN CAPITAL LETTER Q
	// 0x24E1, 0x24C7, // CIRCLED LATIN CAPITAL LETTER R
	0x24E1, 'R', // CIRCLED LATIN CAPITAL LETTER R
	// 0x24E2, 0x24C8, // CIRCLED LATIN CAPITAL LETTER S
	0x24E2, 'S', // CIRCLED LATIN CAPITAL LETTER S
	// 0x24E3, 0x24C9, // CIRCLED LATIN CAPITAL LETTER T
	0x24E3, 'T', // CIRCLED LATIN CAPITAL LETTER T
	// 0x24E4, 0x24CA, // CIRCLED LATIN CAPITAL LETTER U
	0x24E4, 'U', // CIRCLED LATIN CAPITAL LETTER U
	// 0x24E5, 0x24CB, // CIRCLED LATIN CAPITAL LETTER V
	0x24E5, 'V', // CIRCLED LATIN CAPITAL LETTER V
	// 0x24E6, 0x24CC, // CIRCLED LATIN CAPITAL LETTER W
	0x24E6, 'W', // CIRCLED LATIN CAPITAL LETTER W
	// 0x24E7, 0x24CD, // CIRCLED LATIN CAPITAL LETTER X
	0x24E7, 'X', // CIRCLED LATIN CAPITAL LETTER X
	// 0x24E8, 0x24CE, // CIRCLED LATIN CAPITAL LETTER Y
	0x24E8, 'Y', // CIRCLED LATIN CAPITAL LETTER Y
	// 0x24E9, 0x24CF, // CIRCLED LATIN CAPITAL LETTER Z
	0x24E9, 'Z', // CIRCLED LATIN CAPITAL LETTER Z
	// 0xFF41, 0xFF21, // FULLWIDTH LATIN CAPITAL LETTER A
	0xFF41, 'A', // FULLWIDTH LATIN CAPITAL LETTER A
	// 0xFF42, 0xFF22, // FULLWIDTH LATIN CAPITAL LETTER B
	0xFF42, 'B', // FULLWIDTH LATIN CAPITAL LETTER B
	// 0xFF43, 0xFF23, // FULLWIDTH LATIN CAPITAL LETTER C
	0xFF43, 'C', // FULLWIDTH LATIN CAPITAL LETTER C
	// 0xFF44, 0xFF24, // FULLWIDTH LATIN CAPITAL LETTER D
	0xFF44, 'D', // FULLWIDTH LATIN CAPITAL LETTER D
	// 0xFF45, 0xFF25, // FULLWIDTH LATIN CAPITAL LETTER E
	0xFF45, 'E', // FULLWIDTH LATIN CAPITAL LETTER E
	// 0xFF46, 0xFF26, // FULLWIDTH LATIN CAPITAL LETTER F
	0xFF46, 'F', // FULLWIDTH LATIN CAPITAL LETTER F
	// 0xFF47, 0xFF27, // FULLWIDTH LATIN CAPITAL LETTER G
	0xFF47, 'G', // FULLWIDTH LATIN CAPITAL LETTER G
	// 0xFF48, 0xFF28, // FULLWIDTH LATIN CAPITAL LETTER H
	0xFF48, 'H', // FULLWIDTH LATIN CAPITAL LETTER H
	// 0xFF49, 0xFF29, // FULLWIDTH LATIN CAPITAL LETTER I
	0xFF49, 'I', // FULLWIDTH LATIN CAPITAL LETTER I
	// 0xFF4A, 0xFF2A, // FULLWIDTH LATIN CAPITAL LETTER J
	0xFF4A, 'J', // FULLWIDTH LATIN CAPITAL LETTER J
	// 0xFF4B, 0xFF2B, // FULLWIDTH LATIN CAPITAL LETTER K
	0xFF4B, 'K', // FULLWIDTH LATIN CAPITAL LETTER K
	// 0xFF4C, 0xFF2C, // FULLWIDTH LATIN CAPITAL LETTER L
	0xFF4C, 'L', // FULLWIDTH LATIN CAPITAL LETTER L
	// 0xFF4D, 0xFF2D, // FULLWIDTH LATIN CAPITAL LETTER M
	0xFF4D, 'M', // FULLWIDTH LATIN CAPITAL LETTER M
	// 0xFF4E, 0xFF2E, // FULLWIDTH LATIN CAPITAL LETTER N
	0xFF4E, 'N', // FULLWIDTH LATIN CAPITAL LETTER N
	// 0xFF4F, 0xFF2F, // FULLWIDTH LATIN CAPITAL LETTER O
	0xFF4F, 'O', // FULLWIDTH LATIN CAPITAL LETTER O
	// 0xFF50, 0xFF30, // FULLWIDTH LATIN CAPITAL LETTER P
	0xFF50, 'P', // FULLWIDTH LATIN CAPITAL LETTER P
	// 0xFF51, 0xFF31, // FULLWIDTH LATIN CAPITAL LETTER Q
	0xFF51, 'Q', // FULLWIDTH LATIN CAPITAL LETTER Q
	// 0xFF52, 0xFF32, // FULLWIDTH LATIN CAPITAL LETTER R
	0xFF52, 'R', // FULLWIDTH LATIN CAPITAL LETTER R
	// 0xFF53, 0xFF33, // FULLWIDTH LATIN CAPITAL LETTER S
	0xFF53, 'S', // FULLWIDTH LATIN CAPITAL LETTER S
	// 0xFF54, 0xFF34, // FULLWIDTH LATIN CAPITAL LETTER T
	0xFF54, 'T', // FULLWIDTH LATIN CAPITAL LETTER T
	// 0xFF55, 0xFF35, // FULLWIDTH LATIN CAPITAL LETTER U
	0xFF55, 'U', // FULLWIDTH LATIN CAPITAL LETTER U
	// 0xFF56, 0xFF36, // FULLWIDTH LATIN CAPITAL LETTER V
	0xFF56, 'V', // FULLWIDTH LATIN CAPITAL LETTER V
	// 0xFF57, 0xFF37, // FULLWIDTH LATIN CAPITAL LETTER W
	0xFF57, 'W', // FULLWIDTH LATIN CAPITAL LETTER W
	// 0xFF58, 0xFF38, // FULLWIDTH LATIN CAPITAL LETTER X
	0xFF58, 'X', // FULLWIDTH LATIN CAPITAL LETTER X
	// 0xFF59, 0xFF39, // FULLWIDTH LATIN CAPITAL LETTER Y
	0xFF59, 'Y', // FULLWIDTH LATIN CAPITAL LETTER Y
	// 0xFF5A, 0xFF3A, // FULLWIDTH LATIN CAPITAL LETTER Z
	0xFF5A, 'Z', // FULLWIDTH LATIN CAPITAL LETTER Z
};

// ***************************************************************************

int toLowerUpperCompare(const void *arg1, const void *arg2)
{
	ucchar uc1 = *(ucchar *)arg1;
	ucchar uc2 = *(ucchar *)arg2;
	return (uc1<uc2)?-1:(uc1 > uc2)?1:0;
}

// ***************************************************************************

/* This macro uses bsearch, it can be slow. If it is, a template (inline) version of bsearch working with pointers should be written */
#define toLowerUpperSearch(value, table) ((ucchar *)bsearch( value, table, sizeof(table)/(2*sizeof(ucchar)), 2*sizeof(ucchar), toLowerUpperCompare))

// ***************************************************************************

ucstring	toLower (const ucstring &str)
{
	uint i;
	ucstring temp = str;
	const uint size = temp.size();
	for (i=0; i<size; i++)
	{
		// Search the key in the table
		ucchar *result = toLowerUpperSearch (&(temp[i]), UnicodeUpperToLower);
		if (result)
			temp[i] = result[1];
	}
	return temp;
}

// ***************************************************************************

void		toLower (ucchar *str)
{
	while (*str)
	{
		// Search the key in the table
		ucchar *result = toLowerUpperSearch (str, UnicodeUpperToLower);
		if (result)
			*str = result[1];
		str++;
	}
}

// ***************************************************************************

ucchar		toLower (ucchar c)
{
	// Search the key in the table
	ucchar *result = toLowerUpperSearch (&c, UnicodeUpperToLower);
	if (result)
		return result[1];
	return c;
}

// ***************************************************************************

ucstring	toUpper (const ucstring &str)
{
	uint i;
	ucstring temp = str;
	const uint size = temp.size();
	for (i=0; i<size; i++)
	{
		// Search the key in the table
		ucchar *result = toLowerUpperSearch (&(temp[i]), UnicodeLowerToUpper);
		if (result)
			temp[i] = result[1];
	}
	return temp;
}

// ***************************************************************************

void		toUpper (ucchar *str)
{
	while (*str)
	{
		// Search the key in the table
		ucchar *result = toLowerUpperSearch (str, UnicodeLowerToUpper);
		if (result)
			*str = result[1];
		str++;
	}
}

// ***************************************************************************

ucchar		toUpper (ucchar c)
{
	// Search the key in the table
	ucchar *result = toLowerUpperSearch (&c, UnicodeLowerToUpper);
	if (result)
		return result[1];
	return c;
}

// ***************************************************************************

} // NLMISC
