/*
 * Copyright (c) 2005 Sun Microsystems, Inc.  All rights reserved.  U.S.
 * Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and
 * applicable provisions of the FAR and its supplements.  Use is subject
 * to license terms.
 *
 * This distribution may include materials developed by third parties.
 * Sun, Sun Microsystems, the Sun logo, Java and J2EE are trademarks
 * or registered trademarks of Sun Microsystems, Inc. in the U.S. and
 * other countries.
 *
 * Copyright (c) 2005 Sun Microsystems, Inc. Tous droits reserves.
 *
 * Droits du gouvernement americain, utilisateurs gouvernementaux - logiciel
 * commercial. Les utilisateurs gouvernementaux sont soumis au contrat de
 * licence standard de Sun Microsystems, Inc., ainsi qu'aux dispositions
 * en vigueur de la FAR (Federal Acquisition Regulations) et des
 * supplements a celles-ci.  Distribue par des licences qui en
 * restreignent l'utilisation.
 *
 * Cette distribution peut comprendre des composants developpes par des
 * tierces parties. Sun, Sun Microsystems, le logo Sun, Java et J2EE
 * sont des marques de fabrique ou des marques deposees de Sun
 * Microsystems, Inc. aux Etats-Unis et dans d'autres pays.
 */

package dataregistry;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;


/**
 * This is the local-home interface for Orders enterprise bean.
 */
public interface OrderLocalHome extends EJBLocalHome {

    OrderLocal findByPrimaryKey(Integer key)  throws FinderException;

    public OrderLocal create(Integer orderId, String status, Timestamp lastUpdate, BigDecimal discount, String shipmentInfo) throws CreateException;

    Collection findByOrderId(Integer orderId) throws FinderException;

    Collection findByStatus(String status) throws FinderException;

    Collection findByDiscount(BigDecimal discount) throws FinderException;

    Collection findByShipmentInfo(String shipmentInfo) throws FinderException;

    OrderLocal create(Integer orderId, String status, BigDecimal discount, String shipmentInfo) throws CreateException;

    void adjustDiscount(int adjustment);
    
    
}
