(function(tree) {

tree.URL = function URL(val, paths) {
    if (val.data) {
        this.attrs = val;
    } else {
        // Add the base path if the URL is relative and we are in the browser
        if (!/^(?:https?:\/|file:\/)?\//.test(val.value) && paths.length > 0 && typeof(process) === 'undefined') {
            val.value = paths[0] + (val.value.charAt(0) === '/' ? val.value.slice(1) : val.value);
        }
        this.value = val;
        this.paths = paths;
        this.is = 'uri';
    }
};
tree.URL.prototype = {
    toString: function() {
        return this.value.toString();
    },
    eval: function(ctx) {
        return this.attrs ? this : new tree.URL(this.value.eval(ctx), this.paths);
        // URL case no longer supported.
        // @TODO: throw an error?
    }
};

})(require('../tree'));
