// file kernel/n/x86-64/numerix.S: assembly code for mode = SLONG
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                 Fonctions assembleur pour le mode SLONG               |
 |                                                                       |
 +-----------------------------------------------------------------------*/


/* fichier de configuration spcifique  la machine cible */
#include "../../config.h"

/* nom des symboles exports */
#ifdef __USER_LABEL_PREFIX__
#define SUBR(nom)  CATENATE2(__USER_LABEL_PREFIX__,nom)
#define CATENATE2(x,y) CATENATE(x,y)
#define CATENATE(x,y)  x##y
#else
#define SUBR(nom) nom
#endif

/* alignement */
#define ALIGN(x) .align x

/* entre et retour de fonction */
#if __ELF__
#define  ENTER(nom)                \
        ALIGN(32)                 ;\
        .globl SUBR(nom)          ;\
        .type  SUBR(nom),@function;\
SUBR(nom):                        ;\
        pushq  %rbp               ;\
        movq   %rsp,%rbp          ;\
        pushq  %rbx               ;\
        pushq  %r12               ;\
        pushq  %r13               ;\
        pushq  %r14               ;\
        pushq  %r15
#else
#define  ENTER(nom)                \
        ALIGN(32)                 ;\
        .globl SUBR(nom)          ;\
SUBR(nom):                        ;\
        pushq  %rbp               ;\
        movq   %rsp,%rbp          ;\
        pushq  %rbx               ;\
        pushq  %r12               ;\
        pushq  %r13               ;\
        pushq  %r14               ;\
        pushq  %r15
#endif

#define  RETURN_WITH_BP            \
        movq   -40(%rbp),%r15     ;\
        movq   -32(%rbp),%r14     ;\
        movq   -24(%rbp),%r13     ;\
        movq   -16(%rbp),%r12     ;\
        movq    -8(%rbp),%rbx     ;\
        movq   %rbp,%rsp          ;\
        popq   %rbp               ;\
        ret

#define  RETURN_WITH_SP            \
        popq   %r15               ;\
        popq   %r14               ;\
        popq   %r13               ;\
        popq   %r12               ;\
        popq   %rbx               ;\
        popq   %rbp               ;\
        ret

/* idem sans sauvegarde des registres */
#if __ELF__
#define  QUICKENTER(nom)           \
        ALIGN(32)                 ;\
        .globl SUBR(nom)          ;\
        .type SUBR(nom),@function ;\
SUBR(nom):
#else
#define  QUICKENTER(nom)           \
        ALIGN(32)                 ;\
        .globl SUBR(nom)          ;\
SUBR(nom):
#endif
		
/* accs aux paramtres d appel */
#define arg1   %rdi
#define arg2   %rsi
#define arg3   %rdx
#define arg4   %rcx
#define arg5   %r8
#define arg6   %r9
#define arg7   16(%rbp)
#define arg8   24(%rbp)

/* variables locales */
#define tmp1  -48(%rbp)
#define tmp2  -56(%rbp)
#define tmp3  -64(%rbp)
#define tmp4  -72(%rbp)
#define tmp5  -80(%rbp)
#define tmp6  -88(%rbp)
#define tmp7  -96(%rbp)
#define tmp8 -104(%rbp)

/* sauvegarde les registres sur la pile */
#define PUSHALL \
  pushq %rax        ; \
  pushq %rbx        ; \
  pushq %rcx        ; \
  pushq %rdx        ; \
  pushq %rsi        ; \
  pushq %rdi        ; \
  pushq %rbp        ; \
  pushq %r8         ; \
  pushq %r9         ; \
  pushq %r10        ; \
  pushq %r11        ; \
  pushq %r12        ; \
  pushq %r13        ; \
  pushq %r14        ; \
  pushq %r15        ; \
  pushf

#define POPALL \
  popf              ; \
  popq  %r15        ; \
  popq  %r14        ; \
  popq  %r13        ; \
  popq  %r12        ; \
  popq  %r11        ; \
  popq  %r10        ; \
  popq  %r9         ; \
  popq  %r8         ; \
  popq  %rbp        ; \
  popq  %rdi        ; \
  popq  %rsi        ; \
  popq  %rdx        ; \
  popq  %rcx        ; \
  popq  %rbx        ; \
  popq  %rax

/* affiche un message sur stdout */
#define TRACE(msg)    \
  PUSHALL           ; \
  call 9f           ; \
  .string msg       ; \
9:                  ; \
  popq  %rsi        ; \
  movq  $1, %rdi    ; \
  xorq  %rax, %rax  ; \
  call  dprintf     ; \
  POPALL

/*
   allocation de mmoire temporaire
   entre : eax = nombre d octets  allouer
   sortie : esp <- esp - eax, eax <- ind.
*/
#if defined(__CYGWIN__) || defined(__MSVCRT__)
#define ALLOCA call __alloca
#else
#define ALLOCA subq %rax, %rsp
#endif
	
                               /* +--------+
                                  |  Code  |
                                  +--------+ */

/* dboguage */ 
/* #include "dumpreg.S" */

/* addition/soustraction */
#include "add.S"

/* multiplication/carr */
#include "mul_n2.S"
#include "karatsuba.S"
#include "toom.S"

/* oprations modulo BASE^n +/- 1 */
#include "mmod.S"
#include "smod.S"

/* division/racine carre */
#include "div_n2.S"
#include "sqrt_n2.S"
#include "burnikel.S"

/* exponentiation modulaire */
#include "montgomery.S"
        
/* pgcd */
#include "gcd_n2.S"

/* divers */
#include "cmp.S"
#include "shift.S"

