// file kernel/n/x86/dumpreg.S: debugging facilities
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                    Affichage des registres x86                        |
 |                                                                       |
 +-----------------------------------------------------------------------*/

                         # +-------------------------+
                         # |  Affiche les registres  |
                         # +-------------------------+


# format : Flags edi esi ebp esp ebx edx ecx eax
# Flags  : [0  0  0  0]  [0  0  0  0]  [0  0  0  0]  [0  0  vm rf]
#          [0  nt id pl] [of df if tf] [sf zf 0  af] [0  pf 1  cf]
        
        ALIGN_32
.Lsn_dump_reg:
        
        pusha                   # sauve tous les registres
        pushf                   # et les flags
        call   1f
        .string "\nflags    edi      esi      ebp      esp      ebx      edx      ecx      eax\n%08X %08X %08X %08X %08X %08X %08X %08X %08X\n"
1:
        PRINTF
        leal   4(%esp), %esp
        popf
        popa
        ret


                             # +-----------------+
                             # |  Registres MMX  |
                             # +-----------------+


#ifdef use_sse2
        ALIGN_32
.Lsn_dump_mmx:

        pusha
        pushf
        movl   %esp,    %ebp
        movl   %ebp,    %eax
        andl   $-8,     %eax
        movl   %eax,    %esp

        leal -8(%esp), %esp; movq %mm7, (%esp)
        leal -8(%esp), %esp; movq %mm6, (%esp)
        leal -8(%esp), %esp; movq %mm5, (%esp)
        leal -8(%esp), %esp; movq %mm4, (%esp)
        leal -8(%esp), %esp; movq %mm3, (%esp)
        leal -8(%esp), %esp; movq %mm2, (%esp)
        leal -8(%esp), %esp; movq %mm1, (%esp)
        leal -8(%esp), %esp; movq %mm0, (%esp)

        call  1f
        .string "\nmm0: %016llX\nmm1: %016llX\nmm2: %016llX\nmm3: %016llX\nmm4: %016llX\nmm5: %016llX\nmm6: %016llX\nmm7: %016llX\n"
1:
        PRINTF
        movl   %ebp,    %esp
        popf
        popa
        ret

                             # +-----------------+
                             # |  Registres XMM  |
                             # +-----------------+


        ALIGN_32
.Lsn_dump_xmm:

        pusha
        pushf
        movl   %esp,    %ebp
        movl   %ebp,    %eax
        andl   $-16,    %eax
        movl   %eax,    %esp

        pshufd $0x4e, %xmm7, %xmm7
        pshufd $0x4e, %xmm6, %xmm6
        pshufd $0x4e, %xmm5, %xmm5
        pshufd $0x4e, %xmm4, %xmm4
        pshufd $0x4e, %xmm3, %xmm3
        pshufd $0x4e, %xmm2, %xmm2
        pshufd $0x4e, %xmm1, %xmm1
        pshufd $0x4e, %xmm0, %xmm0
        
        leal -16(%esp), %esp; movdqa %xmm7, (%esp)
        leal -16(%esp), %esp; movdqa %xmm6, (%esp)
        leal -16(%esp), %esp; movdqa %xmm5, (%esp)
        leal -16(%esp), %esp; movdqa %xmm4, (%esp)
        leal -16(%esp), %esp; movdqa %xmm3, (%esp)
        leal -16(%esp), %esp; movdqa %xmm2, (%esp)
        leal -16(%esp), %esp; movdqa %xmm1, (%esp)
        leal -16(%esp), %esp; movdqa %xmm0, (%esp)

        pshufd $0x4e, %xmm7, %xmm7
        pshufd $0x4e, %xmm6, %xmm6
        pshufd $0x4e, %xmm5, %xmm5
        pshufd $0x4e, %xmm4, %xmm4
        pshufd $0x4e, %xmm3, %xmm3
        pshufd $0x4e, %xmm2, %xmm2
        pshufd $0x4e, %xmm1, %xmm1
        pshufd $0x4e, %xmm0, %xmm0
        
        call   1f
        .string "\nxmm0: %016llX%016llX\nxmm1: %016llX%016llX\nxmm2: %016llX%016llX\nxmm3: %016llX%016llX\nxmm4: %016llX%016llX\nxmm5: %016llX%016llX\nxmm6: %016llX%016llX\nxmm7: %016llX%016llX\n"
1:
        PRINTF
        movl   %ebp,    %esp
        popf
        popa
        ret

#endif /* use_sse2 */
