      logical function tce_ccsdt_driver(title,ref,corr,thresh,maxiter,
     &        d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &        d_t3,k_t3_offset,size_t3,d_f1,k_f1_offset,
     &        d_v2,k_v2_offset,diis_t3)
c
c $Id: tce_ccsdt_driver.F,v 1.4 2008-02-16 02:42:53 jhammond Exp $
c 
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by 
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
c#include "tce.fh"
c#include "tce_main.fh"
c#include "tce_prop.fh"
c#include "tce_ints.fh"
c#include "tce_amps.fh"
c#include "tce_diis.fh"
c
c     CI, CC, & MBPT
c
      integer iter,maxiter
      logical nodezero         ! True if node 0
      logical recompf          ! True if recompute Fock
      double precision cpu     ! CPU sec counter
      double precision wall    ! WALL sec counter
      integer irrep
      integer irrep_g
      integer d_e              ! SF handle for e file
      integer l_e_offset       ! Offset for e file
      integer k_e_offset       ! Offset for e file
      integer size_e           ! File size in doubles
      integer d_f1             ! SF handle for MO 1e integrals
      integer k_f1_offset      ! Offset for 1e integral file
      integer size_1e          ! File size in doubles
      integer d_v2             ! SF handle for MO 2e integrals
      integer k_v2_offset      ! Offset for 2e integral file
      integer size_2e          ! File size in doubles
      integer d_t1             ! SF handle for t1 amplitudes
      integer k_t1_offset      ! Offset for t1 file
      integer size_t1          ! File size in doubles
      integer d_t2             ! SF handle for t2 amplitudes
      integer k_t2_offset      ! Offset for t2 file
      integer size_t2          ! File size in doubles
      integer d_t3             ! SF handle for t2 amplitudes
      integer k_t3_offset      ! Offset for t2 file
      integer size_t3          ! File size in doubles
      logical diis_t3
      integer d_r1             ! SF handle for r1 amplitudes
      integer d_r2             ! SF handle for r2 amplitudes
      integer d_r3             ! SF handle for t2 amplitudes
      double precision ref     ! Ground state energy
      double precision corr    ! Correlation energy
      double precision r1,r2,r3
      double precision residual! Largest residual
      double precision thresh
      integer dummy            ! Dummy argument for DIIS
      character*255 filename
      character*20 title
      character*4 irrepname
      nodezero=(ga_nodeid().eq.0)
      call tce_e_offset(l_e_offset,k_e_offset,size_e)
#if defined(DEBUG_PRINT)
        if(nodezero) write(LuOut,*) 'l_e_offset = ',l_e_offset
#endif
c -------------
c CCSD    right
c -------------
      call tce_diis_init()
      do iter=1,maxiter
          cpu=-util_cpusec()
          wall=-util_wallsec()
          if (nodezero.and.(iter.eq.1)) write(LuOut,9050) title
          call tce_filename('e',filename)
          call createfile(filename,d_e,size_e)
c          print*,'ccsdt_e'
          call ccsdt_e(d_f1,d_e,d_t1,d_t2,d_v2,
     1                 k_f1_offset,k_e_offset,
     2                 k_t1_offset,k_t2_offset,k_v2_offset)
          call reconcilefile(d_e,size_e)
          call tce_filename('r1',filename)
          call createfile(filename,d_r1,size_t1)
c          print*,'ccsdt_t1'
          call ccsdt_t1(d_f1,d_r1,d_t1,d_t2,d_t3,d_v2,
     1                  k_f1_offset,k_t1_offset,k_t1_offset,
     2                  k_t2_offset,k_t3_offset,k_v2_offset)
          call reconcilefile(d_r1,size_t1)
          call tce_filename('r2',filename)
          call createfile(filename,d_r2,size_t2)
c          print*,'ccsdt_t2'
          call ccsdt_t2(d_f1,d_r2,d_t1,d_t2,d_t3,d_v2,
     1                  k_f1_offset,k_t2_offset,k_t1_offset,
     2                  k_t2_offset,k_t3_offset,k_v2_offset)
          call reconcilefile(d_r2,size_t2)
          call tce_filename('r3',filename)
          call createfile(filename,d_r3,size_t3)
c          print*,'ccsdt_t3'
          call ccsdt_t3(d_f1,d_r3,d_t1,d_t2,d_t3,d_v2,
     1                  k_f1_offset,k_t3_offset,k_t1_offset,
     2                  k_t2_offset,k_t3_offset,k_v2_offset)
          call reconcilefile(d_r3,size_t3)
          call tce_residual_t1(d_r1,k_t1_offset,r1)
          call tce_residual_t2(d_r2,k_t2_offset,r2)
          call tce_residual_t3(d_r3,k_t3_offset,r3)
          residual = max(r1,r2,r3)
          call get_block(d_e,corr,1,0)
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
          if (nodezero) write(LuOut,9100) iter,residual,corr,cpu,wall
          if (residual .lt. thresh) then
            if (nodezero) then
              write(LuOut,9060)
              write(LuOut,9070) "CCSDT",corr
              write(LuOut,9080) "CCSDT",ref + corr
            endif
            call deletefile(d_r3)
            call deletefile(d_r2)
            call deletefile(d_r1)
            call deletefile(d_e)
            call tce_diis_tidy()
            if (.not.ma_pop_stack(l_e_offset))
     1        call errquit("tce_ccsdt_driver: MA problem",
     2                     l_e_offset,MA_ERR)
            tce_ccsdt_driver=.true.
            return
          endif
          call tce_diis(.false.,iter,.true.,.true.,diis_t3,.false.,
     1                  d_r1,d_t1,k_t1_offset,size_t1,
     2                  d_r2,d_t2,k_t2_offset,size_t2,
     3                  d_r3,d_t3,k_t3_offset,size_t3,
     4                  dummy,dummy,dummy,dummy)
          call deletefile(d_r3)
          call deletefile(d_r2)
          call deletefile(d_r1)
          call deletefile(d_e)
          if (nodezero) call util_flush(LuOut)
      enddo
      call tce_diis_tidy()
      if (.not.ma_pop_stack(l_e_offset))
     1     call errquit("tce_ccsdt_driver: MA problem",
     2                  l_e_offset,MA_ERR)
      tce_ccsdt_driver=.false.
      return  
c
c     ======
c     Format
c     ======
c
 9000 format(1x,A,' file size   = ',i16)
 9010 format(1x,A,' file name   = ',A)
 9090 format(1x,A,' file handle = ',i10)
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
 9480 format(1x,'Cpu & wall time / sec for ',A,2f15.1)
 9050 format(/,1x,A,' iterations',/,
     1  1x,'--------------------------------------------------------',/
     2  1x,'Iter          Residuum       Correlation     Cpu    Wall',/
     3  1x,'--------------------------------------------------------')
 9060 format(
     1  1x,'--------------------------------------------------------',/
     2  1x,'Iterations converged')
 9070 format(1x,A,' correlation energy / hartree = ',f25.15)
 9080 format(1x,A,' total energy / hartree       = ',f25.15)
 9100 format(1x,i4,2f18.13,2f8.1)
 9120 format(1x,A)
 9250 format(1x,'Ground-state symmetry is ',A4)
 9210 format(/,1x,'Iteration ',i3,' using ',i4,' trial vectors')
 9230 format(1x,f17.13,f18.13,f11.5,2f8.1)
 9240 format(1x,
     1'--------------------------------------------------------------'
     2,/,1x,'Iterations converged')
 9310 format(1x,A,' ground state energy / hartree  =',f25.15)
 9420 format(1x,i4,f18.13,2f8.1)
 9440 format(1x,A3,' axis ( ',A4,'symmetry)')
      end
