// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_ListEditor_HeaderFile
#define _IFSelect_ListEditor_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_ListEditor_HeaderFile
#include <Handle_IFSelect_ListEditor.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Interface_TypedValue_HeaderFile
#include <Handle_Interface_TypedValue.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
class Interface_TypedValue;
class TColStd_HSequenceOfHAsciiString;
class TColStd_HSequenceOfInteger;
class Interface_InterfaceModel;
class TCollection_HAsciiString;


//! A ListEditor is an auxiliary operator for Editor/EditForm <br>
//!           I.E. it works on parameter values expressed as strings <br>
//! <br>
//!           For a parameter which is a list, it may not be edited in once <br>
//!           by just setting a new value (as a string) <br>
//! <br>
//!           Firstly, a list can be long (and tedious to be accessed flat) <br>
//!           then requires a better way of accessing <br>
//! <br>
//!           Moreover, not only its VALUES may be changed (SetValue), but <br>
//!           also its LENGTH : items may be added or removed ... <br>
//! <br>
//!           Hence, the way of editing a parameter as a list is : <br>
//!           - edit it separately, with the help of a ListEditor <br>
//!           - it remains possible to prepare a new list of values apart <br>
//!           - then give the new list in once to the EditForm <br>
//! <br>
//!           An EditList is produced by the Editor, with a basic definition <br>
//!           This definition (brought by this class) can be redefined <br>
//!           Hence the Editor may produce a specific ListEditor as needed <br>
class IFSelect_ListEditor : public MMgt_TShared {

public:

  //! Creates a ListEditor with absolutely no constraint <br>
  Standard_EXPORT   IFSelect_ListEditor();
  //! Creates a ListEditor, for which items of the list to edit are <br>
//!           defined by <def>, and <max> describes max length : <br>
//!           0 (D) means no limit <br>
//!           value > 0 means : no more the <max> items are allowed <br>
  Standard_EXPORT   IFSelect_ListEditor(const Handle(Interface_TypedValue)& def,const Standard_Integer max = 0);
  //! Loads a Model. It is used to check items of type Entity(Ident) <br>
  Standard_EXPORT     void LoadModel(const Handle(Interface_InterfaceModel)& model) ;
  //! Loads the original values for the list <br>
//!           Remark : If its length is mor then MaxLength, editions remain <br>
//!           allowed, except Add <br>
  Standard_EXPORT     void LoadValues(const Handle(TColStd_HSequenceOfHAsciiString)& vals) ;
  //! Declares this ListEditor to have been touched (whatever action) <br>
  Standard_EXPORT     void SetTouched() ;
  //! Clears all editions already recorded <br>
  Standard_EXPORT     void ClearEdit() ;
  //! Loads a new list to replace the older one, in once ! <br>
//!           By default (can be redefined) checks the length of the list <br>
//!           and the value of each item according to the def <br>
//!           Items are all recorded as Modified <br>
//! <br>
//!           If no def has been given at creation time, no check is done <br>
//!           Returns True when done, False if checks have failed ... a <br>
//!           specialisation may also lock it by returning always False ... <br>
  Standard_EXPORT   virtual  Standard_Boolean LoadEdited(const Handle(TColStd_HSequenceOfHAsciiString)& list) ;
  //! Sets a new value for the item <num> (in edited list) <br>
//!           <val> may be a Null Handle, then the value will be cleared but <br>
//!           not removed <br>
//!           Returns True when done. False if <num> is out of range or if <br>
//!           <val> does not satisfy the definition <br>
  Standard_EXPORT   virtual  Standard_Boolean SetValue(const Standard_Integer num,const Handle(TCollection_HAsciiString)& val) ;
  //! Adds a new item. By default appends (at the end of the list) <br>
//!           Can insert before a given rank <num>, if positive <br>
//!           Returns True when done. False if MaxLength may be overpassed <br>
//!           or if <val> does not satisfy the definition <br>
  Standard_EXPORT   virtual  Standard_Boolean AddValue(const Handle(TCollection_HAsciiString)& val,const Standard_Integer atnum = 0) ;
  //! Removes items from the list <br>
//!           By default removes one item. Else, count given by <howmany> <br>
//!           Remove from rank <num> included. By default, from the end <br>
//!           Returns True when done, False (and does not work) if case of <br>
//!           out of range of if <howmany> is greater than current length <br>
  Standard_EXPORT   virtual  Standard_Boolean Remove(const Standard_Integer num = 0,const Standard_Integer howmany = 1) ;
  //! Returns the value from which the edition started <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfHAsciiString OriginalValues() const;
  //! Returns the result of the edition <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfHAsciiString EditedValues() const;
  //! Returns count of values, edited (D) or original <br>
  Standard_EXPORT     Standard_Integer NbValues(const Standard_Boolean edited = Standard_True) const;
  //! Returns a value given its rank. Edited (D) or Original <br>
//!           A Null String means the value is cleared but not removed <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString Value(const Standard_Integer num,const Standard_Boolean edited = Standard_True) const;
  //! Tells if a value (in edited list) has been changed, i.e. <br>
//!           either modified-value, or added <br>
  Standard_EXPORT     Standard_Boolean IsChanged(const Standard_Integer num) const;
  //! Tells if a value (in edited list) has been modified-value <br>
//!           (not added) <br>
  Standard_EXPORT     Standard_Boolean IsModified(const Standard_Integer num) const;
  //! Tells if a value (in edited list) has been added (new one) <br>
  Standard_EXPORT     Standard_Boolean IsAdded(const Standard_Integer num) const;
  //! Tells if at least one edition (SetValue-AddValue-Remove) has <br>
//!           been recorded <br>
  Standard_EXPORT     Standard_Boolean IsTouched() const;




  DEFINE_STANDARD_RTTI(IFSelect_ListEditor)

protected:




private: 


Standard_Integer themax;
Handle_Interface_TypedValue thedef;
Standard_Integer thetouc;
Handle_TColStd_HSequenceOfHAsciiString theorig;
Handle_TColStd_HSequenceOfHAsciiString theedit;
Handle_TColStd_HSequenceOfInteger thestat;
Handle_Interface_InterfaceModel themodl;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
