// Copyright 2007 Deutsches Forschungszentrum fuer Kuenstliche Intelligenz
// or its licensors, as applicable.
//
// You may not use this file except under the terms of the accompanying license.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you
// may not use this file except in compliance with the License. You may
// obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Project: ocr-bpnet
// File: feature-extractor-main.h
// Purpose: feature extractor main test class
// Responsible: kapry
// Reviewer: rangoni
// Primary Repository:
// Web Sites: www.iupr.org, www.dfki.de

#include "feature-extractor.h"
#include "imgio.h"
#include "imglib.h"
#include "ocrcomponents.h"
#include "ocr-segmentations.h"
#include "ocr-utils.h"
#include "additions.h"

using namespace ocropus;
using namespace iulib;
using namespace colib;


int main(int argc,char **argv){
    //
    // usage    in_image    out_seg_file    type_feature    out_prefix_feature_images   on_seg
    //          1           2               3               4                           5
    //  
    //  ex      ~/char.png  outseg.png      GRAD            ~/feature                   0
    //
    try {
        if (argc != 5) {
            printf("usage: feature-extractor-main [in_image] [out_seg_file] [type_feature] [out_prefix_feature_images] [on_seg]\n");
            throw "the binary takes 5 arguments";
        }
        bool fullimage = (argv[5][0] == '0');
        int all = 0;
        FeatureExtractor::FeatureType featuretype;
        featuretype = FeatureExtractor::GRAD;
        if(!strcasecmp(argv[3],"IMAGE")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::IMAGE;
        }
        else if(!strcasecmp(argv[3],"GRAD")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::GRAD;
        }
        else if(!strcasecmp(argv[3],"BAYS")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::BAYS;
        }
        else if(!strcasecmp(argv[3],"SKEL")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::SKEL;
        }
        else if(!strcasecmp(argv[3],"SKEL2")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::SKEL2;
        }
        else if(!strcasecmp(argv[3],"SKELPTS")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::SKELPTS;
        }
        else if(!strcasecmp(argv[3],"INCL")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::INCL;
        }
        else if(!strcasecmp(argv[3],"POS")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::POS;
        }
        else if(!strcasecmp(argv[3],"RELSIZE")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::RELSIZE;
        }
        else if(!strcasecmp(argv[3],"HISTO")) {
            printf("calculate %s\n",argv[3]);
            featuretype = FeatureExtractor::HISTO;
        }
        else if(!strcasecmp(argv[3],"ALL")) {
            printf("calculate %s\n",argv[3]);
            all = 1;
        } else {
            throw "feature type not implemented yet.";
        }

        autodel<ISegmentLine> segmenter(make_SegmentLineByCCS());
        
        bytearray image;
        read_image_gray(image,argv[1]);
        optional_check_background_is_lighter(image);
        bytearray lineimage; // for debugging
        copy(lineimage,image); // for debugging
        autodel<FeatureExtractor> extractor(make_FeatureExtractor(50,50));
        extractor->setRemoveIsolatedPixels(false);
        extractor->setImage(lineimage);
        extractor->setLineInfo(0,50); //19-75

        if (fullimage) {
            char aux[1024];
            floatarray feature;
            bytearray img;
            sprintf(aux,"%s_%.2d.png", argv[4],1);
            if (all==1) {
                extractor->appendFeatures(feature,image,FeatureExtractor::BAYS);
                extractor->appendFeatures(feature,image,FeatureExtractor::GRAD);
                extractor->appendFeatures(feature,image,FeatureExtractor::INCL);
                extractor->appendFeatures(feature,image,FeatureExtractor::IMAGE);
                extractor->appendFeatures(feature,image,FeatureExtractor::SKEL);
                extractor->appendFeatures(feature,image,FeatureExtractor::SKELPTS);
                extractor->appendFeatures(feature,image,FeatureExtractor::RELSIZE);
                extractor->appendFeatures(feature,image,FeatureExtractor::SKEL2);
                extractor->appendFeatures(feature,image,FeatureExtractor::HISTO);
            } else if (all==0) {
                extractor->getFeatures(feature,image,featuretype);
            }
            extractor->feat2image(img,feature);
            additions::save_char(img,aux);
        } else {
            intarray segmentation;
            segmenter->charseg(segmentation,image);
            write_png_packed(stdio(argv[2],"wb"),segmentation);

            make_line_segmentation_black(segmentation);
            narray<rectangle> bboxes;
            bounding_boxes(bboxes,segmentation);

            floatarray feature;
            bytearray img;
            bytearray subimage;
            printf("bb:%d\n",bboxes.length());
            for(int i=1;i<bboxes.length();i++) {
                feature.clear();
                if(all==1) {
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::BAYS);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::GRAD);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::INCL);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::IMAGE);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::SKEL);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::SKELPTS);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::RELSIZE);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::SKEL2);
                    extractor->appendFeatures(feature,bboxes(i),FeatureExtractor::HISTO);
                } else if (all == 0) {
                    extractor->getFeatures(feature,bboxes(i),featuretype);
                }

                crop(subimage,lineimage,bboxes(i));

                if(all==1) {
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::BAYS);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::GRAD);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::INCL);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::IMAGE);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::SKEL);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::SKELPTS);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::RELSIZE);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::SKEL2);
                    extractor->appendFeatures(feature,subimage,FeatureExtractor::HISTO);
                } else if(all==0) {
                    extractor->getFeatures(feature,subimage,featuretype);
                }
                extractor->feat2image(img,feature);
                char aux[1024];
                sprintf(aux,"%s_%.2d.png",argv[4],i);
                additions::save_char(img,aux);
            }
        }
    }
    catch(const char *oops) {
        fprintf(stderr,"oops: %s\n",oops);
    }

    return 0;
}
