#include "filter_range.h"

bool str2range(const STD_string& str, Range& range, int srcsize) {
  Log<Filter> odinlog("","str2range");
  if(str=="") return false;
  int increment=1;
  svector tokscol=tokens(str,':');
  int colsize=tokscol.size();
  if(colsize<1 || colsize>2) return false;
  if(colsize==2) increment=atoi(tokscol[1].c_str());
  svector toks=tokens(tokscol[0],'-');
  bool result=false;
  if(toks.size()==2) {range=Range(atoi(toks[0].c_str()),atoi(toks[1].c_str()),increment); result=true;}
  if(toks.size()==1) {range=Range(atoi(toks[0].c_str()),atoi(toks[0].c_str()),increment); result=true;}

  if(result) {
    if(range.first()>range.last()) result=false;
    if(range.first()<0 || range.first()>=srcsize) result=false;
    if(range.last()<0  || range.last()>=srcsize)  result=false;
    if(!result) ODINLOG(odinlog,errorLog) << "Values " << range << " out of allowable range (0," << (srcsize-1) << ")" << STD_endl;
  }
  return result;
}
