// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Adaptor3d_IsoCurve_HeaderFile
#define _Adaptor3d_IsoCurve_HeaderFile

#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _GeomAbs_IsoType_HeaderFile
#include <GeomAbs_IsoType.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Adaptor3d_Curve_HeaderFile
#include <Adaptor3d_Curve.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
#ifndef _Handle_Geom_BezierCurve_HeaderFile
#include <Handle_Geom_BezierCurve.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
class Adaptor3d_HSurface;
class Standard_NoSuchObject;
class Standard_OutOfRange;
class Standard_DomainError;
class TColStd_Array1OfReal;
class Adaptor3d_HCurve;
class gp_Pnt;
class gp_Vec;
class gp_Lin;
class gp_Circ;
class gp_Elips;
class gp_Hypr;
class gp_Parab;
class Geom_BezierCurve;
class Geom_BSplineCurve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Defines an isoparametric curve on  a surface.  The <br>
//!          type  of isoparametric curve  (U  or V) is defined <br>
//!          with the   enumeration  IsoType from   GeomAbs  if <br>
//!          NoneIso is given an error is raised. <br>
class Adaptor3d_IsoCurve  : public Adaptor3d_Curve {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! The iso is set to NoneIso. <br>
Standard_EXPORT Adaptor3d_IsoCurve();

//! The surface is loaded. The iso is set to NoneIso. <br>
Standard_EXPORT Adaptor3d_IsoCurve(const Handle(Adaptor3d_HSurface)& S);

//! Creates  an  IsoCurve curve.   Iso  defines the <br>
//!          type (isoU or  isoU) Param defines the value of <br>
//!          the iso. The bounds  of  the iso are the bounds <br>
//!          of the surface. <br>
Standard_EXPORT Adaptor3d_IsoCurve(const Handle(Adaptor3d_HSurface)& S,const GeomAbs_IsoType Iso,const Standard_Real Param);

//! Create an IsoCurve curve.  Iso defines the type <br>
//!          (isoU or isov).  Param defines the value of the <br>
//!          iso. WFirst,WLast define the bounds of the iso. <br>
Standard_EXPORT Adaptor3d_IsoCurve(const Handle(Adaptor3d_HSurface)& S,const GeomAbs_IsoType Iso,const Standard_Real Param,const Standard_Real WFirst,const Standard_Real WLast);

//! Changes  the surface.  The  iso  is  reset  to <br>
//!          NoneIso. <br>
Standard_EXPORT   void Load(const Handle(Adaptor3d_HSurface)& S) ;

//! Changes the iso on the current surface. <br>
Standard_EXPORT   void Load(const GeomAbs_IsoType Iso,const Standard_Real Param) ;

//! Changes the iso on the current surface. <br>
Standard_EXPORT   void Load(const GeomAbs_IsoType Iso,const Standard_Real Param,const Standard_Real WFirst,const Standard_Real WLast) ;

 const Handle_Adaptor3d_HSurface& Surface() const;

  GeomAbs_IsoType Iso() const;

  Standard_Real Parameter() const;

  Standard_Real FirstParameter() const;

  Standard_Real LastParameter() const;


Standard_EXPORT   GeomAbs_Shape Continuity() const;

//! Returns  the number  of  intervals for  continuity <br>
//!          <S>. May be one if Continuity(me) >= <S> <br>
Standard_EXPORT   Standard_Integer NbIntervals(const GeomAbs_Shape S) ;

//! Stores in <T> the  parameters bounding the intervals <br>
//!          of continuity <S>. <br>
//! <br>
//!          The array must provide  enough room to  accomodate <br>
//!          for the parameters. i.e. T.Length() > NbIntervals() <br>
Standard_EXPORT   void Intervals(TColStd_Array1OfReal& T,const GeomAbs_Shape S) ;

//! Returns    a  curve equivalent   of  <me>  between <br>
//!          parameters <First>  and <Last>. <Tol>  is used  to <br>
//!          test for 3d points confusion. <br>//! If <First> >= <Last> <br>
Standard_EXPORT   Handle_Adaptor3d_HCurve Trim(const Standard_Real First,const Standard_Real Last,const Standard_Real Tol) const;


Standard_EXPORT   Standard_Boolean IsClosed() const;


Standard_EXPORT   Standard_Boolean IsPeriodic() const;


Standard_EXPORT   Standard_Real Period() const;

//! Computes the point of parameter U on the curve. <br>
Standard_EXPORT   gp_Pnt Value(const Standard_Real U) const;

//! Computes the point of parameter U on the curve. <br>
Standard_EXPORT   void D0(const Standard_Real U,gp_Pnt& P) const;

//! Computes the point of parameter U on the curve with its <br>
//!  first derivative. <br>//! Raised if the continuity of the current interval <br>
//!  is not C1. <br>
Standard_EXPORT   void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V) const;


//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. <br>//! Raised if the continuity of the current interval <br>
//!  is not C2. <br>
Standard_EXPORT   void D2(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const;


//!  Returns the point P of parameter U, the first, the second <br>
//!  and the third derivative. <br>//! Raised if the continuity of the current interval <br>
//!  is not C3. <br>
Standard_EXPORT   void D3(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) const;


//!  The returned vector gives the value of the derivative for the <br>
//!  order of derivation N. <br>//! Raised if the continuity of the current interval <br>
//!  is not CN. <br>//! Raised if N < 1. <br>
Standard_EXPORT   gp_Vec DN(const Standard_Real U,const Standard_Integer N) const;

//!  Returns the parametric  resolution corresponding <br>
//!         to the real space resolution <R3d>. <br>
Standard_EXPORT   Standard_Real Resolution(const Standard_Real R3d) const;

//! Returns  the  type of the   curve  in the  current <br>
//!          interval :   Line,   Circle,   Ellipse, Hyperbola, <br>
//!          Parabola, BezierCurve, BSplineCurve, OtherCurve. <br>
Standard_EXPORT   GeomAbs_CurveType GetType() const;


Standard_EXPORT   gp_Lin Line() const;


Standard_EXPORT   gp_Circ Circle() const;


Standard_EXPORT   gp_Elips Ellipse() const;


Standard_EXPORT   gp_Hypr Hyperbola() const;


Standard_EXPORT   gp_Parab Parabola() const;


Standard_EXPORT   Standard_Integer Degree() const;


Standard_EXPORT   Standard_Boolean IsRational() const;


Standard_EXPORT   Standard_Integer NbPoles() const;


Standard_EXPORT   Standard_Integer NbKnots() const;


Standard_EXPORT   Handle_Geom_BezierCurve Bezier() const;


Standard_EXPORT   Handle_Geom_BSplineCurve BSpline() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Adaptor3d_HSurface mySurface;
GeomAbs_IsoType myIso;
Standard_Real myFirst;
Standard_Real myLast;
Standard_Real myParameter;


};


#include <Adaptor3d_IsoCurve.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
