// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffset_Inter3d_HeaderFile
#define _BRepOffset_Inter3d_HeaderFile

#ifndef _Handle_BRepAlgo_AsDes_HeaderFile
#include <Handle_BRepAlgo_AsDes.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BRepAlgo_AsDes;
class TopTools_ListOfShape;
class BRepAlgo_Image;
class TopoDS_Face;
class TopoDS_Shape;
class BRepOffset_Analyse;
class BRepOffset_DataMapOfShapeOffset;
class TopTools_DataMapOfShapeShape;
class TopTools_MapOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Computes the intersection face face in a set of faces <br>
//!          Store the result in a SD as AsDes. <br>
class BRepOffset_Inter3d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepOffset_Inter3d(const Handle(BRepAlgo_AsDes)& AsDes,const TopAbs_State Side,const Standard_Real Tol);


Standard_EXPORT   void CompletInt(const TopTools_ListOfShape& SetOfFaces,const BRepAlgo_Image& InitOffsetFace) ;


Standard_EXPORT   void FaceInter(const TopoDS_Face& F1,const TopoDS_Face& F2,const BRepAlgo_Image& InitOffsetFace) ;


Standard_EXPORT   void ConnexIntByArc(const TopTools_ListOfShape& SetOfFaces,const TopoDS_Shape& ShapeInit,const BRepOffset_Analyse& Analyse,const BRepAlgo_Image& InitOffsetFace) ;


Standard_EXPORT   void ConnexIntByInt(const TopoDS_Shape& SI,const BRepOffset_DataMapOfShapeOffset& MapSF,const BRepOffset_Analyse& A,TopTools_DataMapOfShapeShape& MES,TopTools_DataMapOfShapeShape& Build,TopTools_ListOfShape& Failed) ;


Standard_EXPORT   void ContextIntByInt(const TopTools_MapOfShape& ContextFaces,const Standard_Boolean ExtentContext,const BRepOffset_DataMapOfShapeOffset& MapSF,const BRepOffset_Analyse& A,TopTools_DataMapOfShapeShape& MES,TopTools_DataMapOfShapeShape& Build,TopTools_ListOfShape& Failed) ;


Standard_EXPORT   void ContextIntByArc(const TopTools_MapOfShape& ContextFaces,const Standard_Boolean ExtentContext,const BRepOffset_Analyse& Analyse,const BRepAlgo_Image& InitOffsetFace,BRepAlgo_Image& InitOffsetEdge) ;


Standard_EXPORT   void AddCommonEdges(const TopTools_ListOfShape& SetOfFaces) ;


Standard_EXPORT   void SetDone(const TopoDS_Face& F1,const TopoDS_Face& F2) ;


Standard_EXPORT   Standard_Boolean IsDone(const TopoDS_Face& F1,const TopoDS_Face& F2) const;


Standard_EXPORT   TopTools_MapOfShape& TouchedFaces() ;


Standard_EXPORT   Handle_BRepAlgo_AsDes AsDes() const;


Standard_EXPORT   TopTools_MapOfShape& NewEdges() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Store(const TopoDS_Face& F1,const TopoDS_Face& F2,const TopTools_ListOfShape& LInt1,const TopTools_ListOfShape& LInt2) ;


 // Fields PRIVATE
 //
Handle_BRepAlgo_AsDes myAsDes;
TopTools_MapOfShape myTouched;
TopTools_DataMapOfShapeListOfShape myDone;
TopTools_MapOfShape myNewEdges;
TopAbs_State mySide;
Standard_Real myTol;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
