// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrim_Wedge_HeaderFile
#define _BRepPrim_Wedge_HeaderFile

#ifndef _BRepPrim_GWedge_HeaderFile
#include <BRepPrim_GWedge.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class gp_Ax2;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides constructors without Builders. <br>
class BRepPrim_Wedge  : public BRepPrim_GWedge {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a  Wedge  algorithm.   <Axes> is  the axis <br>
//!          system for the primitive. <br>
//! <br>
//!          XMin, YMin, ZMin are set to 0 <br>
//!          XMax, YMax, ZMax are set to dx, dy, dz <br>
//!          Z2Min = ZMin <br>
//!          Z2Max = ZMax <br>
//!          X2Min = XMin <br>
//!          X2Max = XMax <br>
//!          The result is a box <br>
//!          dx,dy,dz should be positive <br>
Standard_EXPORT BRepPrim_Wedge(const gp_Ax2& Axes,const Standard_Real dx,const Standard_Real dy,const Standard_Real dz);

//! Creates  a Wedge  primitive. <Axes> is   the  axis <br>
//!          system for the primitive. <br>
//! <br>
//!          XMin, YMin, ZMin are set to 0 <br>
//!          XMax, YMax, ZMax are set to dx, dy, dz <br>
//!          Z2Min = ZMin <br>
//!          Z2Max = ZMax <br>
//!          X2Min = ltx <br>
//!          X2Max = ltx <br>
//!          The result is a STEP right angular wedge <br>
//!          dx,dy,dz should be positive <br>
//!          ltx should not be negative <br>
Standard_EXPORT BRepPrim_Wedge(const gp_Ax2& Axes,const Standard_Real dx,const Standard_Real dy,const Standard_Real dz,const Standard_Real ltx);

//! Create  a Wedge primitive.   <Axes>  is  the  axis <br>
//!          system for the primitive. <br>
//! <br>
//!          all the fields are set to the corresponding value <br>
//!          XYZMax - XYZMin should be positive <br>
//!          ZX2Max - ZX2Min should not be negative <br>
Standard_EXPORT BRepPrim_Wedge(const gp_Ax2& Axes,const Standard_Real xmin,const Standard_Real ymin,const Standard_Real zmin,const Standard_Real z2min,const Standard_Real x2min,const Standard_Real xmax,const Standard_Real ymax,const Standard_Real zmax,const Standard_Real z2max,const Standard_Real x2max);





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
