// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRBRep_PolyAlgo_HeaderFile
#define _HLRBRep_PolyAlgo_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_HLRBRep_PolyAlgo_HeaderFile
#include <Handle_HLRBRep_PolyAlgo.hxx>
#endif

#ifndef _HLRAlgo_Projector_HeaderFile
#include <HLRAlgo_Projector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopTools_SequenceOfShape_HeaderFile
#include <TopTools_SequenceOfShape.hxx>
#endif
#ifndef _TopTools_IndexedMapOfShape_HeaderFile
#include <TopTools_IndexedMapOfShape.hxx>
#endif
#ifndef _Handle_HLRAlgo_PolyAlgo_HeaderFile
#include <Handle_HLRAlgo_PolyAlgo.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _BRepAdaptor_Surface_HeaderFile
#include <BRepAdaptor_Surface.hxx>
#endif
#ifndef _BRepAdaptor_Curve_HeaderFile
#include <BRepAdaptor_Curve.hxx>
#endif
#ifndef _BRepAdaptor_Curve2d_HeaderFile
#include <BRepAdaptor_Curve2d.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Handle_HLRAlgo_PolyInternalData_HeaderFile
#include <Handle_HLRAlgo_PolyInternalData.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class HLRAlgo_PolyAlgo;
class Geom_Surface;
class Standard_OutOfRange;
class TopoDS_Shape;
class HLRAlgo_Projector;
class TColStd_Array1OfTransient;
class TColStd_Array1OfInteger;
class TopTools_MapOfShape;
class TopoDS_Edge;
class HLRAlgo_ListOfBPoint;
class TopTools_ListOfShape;
class HLRAlgo_PolyInternalData;
class HLRAlgo_EdgeStatus;


//!  A framework to compute the shape as seen in <br>
//! a projection plane. This is done by calculating <br>
//! the visible and the hidden parts of the shape. <br>
//! HLRBRep_PolyAlgo works with three types of entity: <br>
//! -   shapes to be visualized (these shapes must <br>
//!   have already been triangulated.) <br>
//! -   edges in these shapes (these edges are <br>
//!   defined as polygonal lines on the <br>
//!   triangulation of the shape, and are the basic <br>
//!   entities which will be visualized or hidden), and <br>
//! -   triangles in these shapes which hide the edges. <br>
//!   HLRBRep_PolyAlgo is based on the principle <br>
//! of comparing each edge of the shape to be <br>
//! visualized with each of the triangles produced <br>
//! by the triangulation of the shape, and <br>
//! calculating the visible and the hidden parts of each edge. <br>
//! For a given projection, HLRBRep_PolyAlgo <br>
//! calculates a set of lines characteristic of the <br>
//! object being represented. It is also used in <br>
//! conjunction with the HLRBRep_PolyHLRToShape extraction <br>
//! utilities, which reconstruct a new, simplified <br>
//! shape from a selection of calculation results. <br>
//! This new shape is made up of edges, which <br>
//! represent the shape visualized in the projection. <br>
//! HLRBRep_PolyAlgo works with a polyhedral <br>
//! simplification of the shape whereas <br>
//! HLRBRep_Algo takes the shape itself into <br>
//! account. When you use HLRBRep_Algo, you <br>
//! obtain an exact result, whereas, when you use <br>
//! HLRBRep_PolyAlgo, you reduce computation <br>
//! time but obtain polygonal segments. <br>
//! An HLRBRep_PolyAlgo object provides a framework for: <br>
//! -   defining the point of view <br>
//! -   identifying the shape or shapes to be visualized <br>
//! -   calculating the outlines <br>
//! -   calculating the visible and hidden lines of the shape. <br>
//!   Warning <br>
//! -   Superimposed lines are not eliminated by this algorithm. <br>
//! -   There must be no unfinished objects inside the shape you wish to visualize. <br>
//! -   Points are not treated. <br>
//! -   Note that this is not the sort of algorithm <br>
//!   used in generating shading, which calculates <br>
//!   the visible and hidden parts of each face in a <br>
//!   shape to be visualized by comparing each <br>
//!   face in the shape with every other face in the same shape. <br>
class HLRBRep_PolyAlgo : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Constructs an empty framework for the <br>
//! calculation of the visible and hidden lines of a shape in a projection. <br>
//! Use the functions: <br>
//! -   Projector to define the point of view <br>
//! -   Load to select the shape or shapes to be  visualized <br>
//! -   Update to compute the visible and hidden lines of the shape. <br>
//!   Warning <br>
//! The shape or shapes to be visualized must have already been triangulated. <br>
Standard_EXPORT HLRBRep_PolyAlgo();


Standard_EXPORT HLRBRep_PolyAlgo(const Handle(HLRBRep_PolyAlgo)& A);


Standard_EXPORT HLRBRep_PolyAlgo(const TopoDS_Shape& S);

  Standard_Integer NbShapes() const;


Standard_EXPORT   TopoDS_Shape& Shape(const Standard_Integer I) ;

//! remove the Shape of Index <I>. <br>
Standard_EXPORT   void Remove(const Standard_Integer I) ;

//! return the index of the Shape <S> and  return 0 if <br>
//!          the Shape <S> is not found. <br>
Standard_EXPORT   Standard_Integer Index(const TopoDS_Shape& S) const;
//! Loads the shape S into this framework. <br>
//! Warning S must have already been triangulated. <br>
  void Load(const TopoDS_Shape& S) ;


Standard_EXPORT   Handle_HLRAlgo_PolyAlgo Algo() const;
//! Sets the parameters of the view for this framework. <br>
//! These parameters are defined by an HLRAlgo_Projector object, <br>
//! which is returned by the Projector function on a Prs3d_Projector object. <br>
 const HLRAlgo_Projector& Projector() const;

  void Projector(const HLRAlgo_Projector& P) ;

  Standard_Real Angle() const;

  void Angle(const Standard_Real Ang) ;

  Standard_Real TolAngular() const;

  void TolAngular(const Standard_Real Tol) ;

  Standard_Real TolCoef() const;

  void TolCoef(const Standard_Real Tol) ;

//! Launches calculation of outlines of the shape <br>
//! visualized by this framework. Used after setting the point of view and <br>
//! defining the shape or shapes to be visualized. <br>
Standard_EXPORT   void Update() ;

  void InitHide() ;

  Standard_Boolean MoreHide() const;

  void NextHide() ;


Standard_EXPORT   void Hide(Standard_Address& Coordinates,HLRAlgo_EdgeStatus& status,TopoDS_Shape& S,Standard_Boolean& reg1,Standard_Boolean& regn,Standard_Boolean& outl,Standard_Boolean& intl) ;

  void InitShow() ;

  Standard_Boolean MoreShow() const;

  void NextShow() ;


Standard_EXPORT   void Show(Standard_Address& Coordinates,TopoDS_Shape& S,Standard_Boolean& reg1,Standard_Boolean& regn,Standard_Boolean& outl,Standard_Boolean& intl) ;

//! Make a shape  with  the internal outlines in  each <br>
//!          face. <br>
Standard_EXPORT   TopoDS_Shape OutLinedShape(const TopoDS_Shape& S) const;

  Standard_Boolean Debug() const;

  void Debug(const Standard_Boolean B) ;
//Standard_EXPORT ~HLRBRep_PolyAlgo();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   TopoDS_Shape MakeShape() const;


Standard_EXPORT   Standard_Integer InitShape(const TopoDS_Shape& Shape,Standard_Boolean& IsoledF,Standard_Boolean& IsoledE) ;


Standard_EXPORT   void StoreShell(const TopoDS_Shape& Shape,Standard_Integer& iShell,TColStd_Array1OfTransient& Shell,const Standard_Boolean IsoledF,const Standard_Boolean IsoledE,TColStd_Array1OfInteger& ES,TColStd_Array1OfTransient& PD,TColStd_Array1OfTransient& PID,TopTools_MapOfShape& ShapeMap1,TopTools_MapOfShape& ShapeMap2) ;


Standard_EXPORT   Standard_Boolean Normal(const Standard_Integer iNode,const Standard_Address Nod1Indices,const Standard_Address Nod1RValues,Standard_Address& TData,Standard_Address& PISeg,Standard_Address& PINod,const Standard_Boolean orient) const;


Standard_EXPORT   Standard_Boolean AverageNormal(const Standard_Integer iNode,const Standard_Address Nod1Indices,Standard_Address& TData,Standard_Address& PISeg,Standard_Address& PINod,Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;


Standard_EXPORT   void AddNormalOnTriangle(const Standard_Integer iTri,const Standard_Integer iNode,Standard_Integer& jNode,Standard_Address& TData,Standard_Address& PINod,Standard_Real& X,Standard_Real& Y,Standard_Real& Z,Standard_Boolean& OK) const;


Standard_EXPORT   void InitBiPointsWithConnexity(const Standard_Integer e,TopoDS_Edge& E,HLRAlgo_ListOfBPoint& List,TColStd_Array1OfTransient& PID,TopTools_ListOfShape& LS,const Standard_Boolean connex) ;


Standard_EXPORT   void Interpolation(HLRAlgo_ListOfBPoint& List,Standard_Real& X1,Standard_Real& Y1,Standard_Real& Z1,Standard_Real& X2,Standard_Real& Y2,Standard_Real& Z2,Standard_Real& XTI1,Standard_Real& YTI1,Standard_Real& ZTI1,Standard_Real& XTI2,Standard_Real& YTI2,Standard_Real& ZTI2,const Standard_Integer e,Standard_Real& U1,Standard_Real& U2,Standard_Address& Nod11Indices,Standard_Address& Nod11RValues,Standard_Address& Nod12Indices,Standard_Address& Nod12RValues,const Standard_Integer i1p1,const Standard_Integer i1p2,const Standard_Integer i1,const Handle(HLRAlgo_PolyInternalData)& pid1,Standard_Address& TData1,Standard_Address& PISeg1,Standard_Address& PINod1) const;


Standard_EXPORT   void Interpolation(HLRAlgo_ListOfBPoint& List,Standard_Real& X1,Standard_Real& Y1,Standard_Real& Z1,Standard_Real& X2,Standard_Real& Y2,Standard_Real& Z2,Standard_Real& XTI1,Standard_Real& YTI1,Standard_Real& ZTI1,Standard_Real& XTI2,Standard_Real& YTI2,Standard_Real& ZTI2,const Standard_Integer e,Standard_Real& U1,Standard_Real& U2,const GeomAbs_Shape rg,Standard_Address& Nod11Indices,Standard_Address& Nod11RValues,Standard_Address& Nod12Indices,Standard_Address& Nod12RValues,const Standard_Integer i1p1,const Standard_Integer i1p2,const Standard_Integer i1,const Handle(HLRAlgo_PolyInternalData)& pid1,Standard_Address& TData1,Standard_Address& PISeg1,Standard_Address& PINod1,Standard_Address& Nod21Indices,Standard_Address& Nod21RValues,Standard_Address& Nod22Indices,Standard_Address& Nod22RValues,const Standard_Integer i2p1,const Standard_Integer i2p2,const Standard_Integer i2,const Handle(HLRAlgo_PolyInternalData)& pid2,Standard_Address& TData2,Standard_Address& PISeg2,Standard_Address& PINod2) const;


Standard_EXPORT   Standard_Boolean Interpolation(const Standard_Real U1,const Standard_Real U2,const Standard_Address Nod1RValues,const Standard_Address Nod2RValues,Standard_Real& X3,Standard_Real& Y3,Standard_Real& Z3,Standard_Real& XT3,Standard_Real& YT3,Standard_Real& ZT3,Standard_Real& coef3,Standard_Real& U3,Standard_Boolean& mP3P1) const;


Standard_EXPORT   void MoveOrInsertPoint(HLRAlgo_ListOfBPoint& List,Standard_Real& X1,Standard_Real& Y1,Standard_Real& Z1,Standard_Real& X2,Standard_Real& Y2,Standard_Real& Z2,Standard_Real& XTI1,Standard_Real& YTI1,Standard_Real& ZTI1,Standard_Real& XTI2,Standard_Real& YTI2,Standard_Real& ZTI2,const Standard_Integer e,Standard_Real& U1,Standard_Real& U2,Standard_Address& Nod11Indices,Standard_Address& Nod11RValues,Standard_Address& Nod12Indices,Standard_Address& Nod12RValues,const Standard_Integer i1p1,const Standard_Integer i1p2,const Standard_Integer i1,const Handle(HLRAlgo_PolyInternalData)& pid1,Standard_Address& TData1,Standard_Address& PISeg1,Standard_Address& PINod1,const Standard_Real X3,const Standard_Real Y3,const Standard_Real Z3,const Standard_Real XT3,const Standard_Real YT3,const Standard_Real ZT3,const Standard_Real coef3,const Standard_Real U3,const Standard_Boolean insP3,const Standard_Boolean mP3P1,const Standard_Boolean flag) const;


Standard_EXPORT   void MoveOrInsertPoint(HLRAlgo_ListOfBPoint& List,Standard_Real& X1,Standard_Real& Y1,Standard_Real& Z1,Standard_Real& X2,Standard_Real& Y2,Standard_Real& Z2,Standard_Real& XTI1,Standard_Real& YTI1,Standard_Real& ZTI1,Standard_Real& XTI2,Standard_Real& YTI2,Standard_Real& ZTI2,const Standard_Integer e,Standard_Real& U1,Standard_Real& U2,Standard_Address& Nod11Indices,Standard_Address& Nod11RValues,Standard_Address& Nod12Indices,Standard_Address& Nod12RValues,const Standard_Integer i1p1,const Standard_Integer i1p2,const Standard_Integer i1,const Handle(HLRAlgo_PolyInternalData)& pid1,Standard_Address& TData1,Standard_Address& PISeg1,Standard_Address& PINod1,Standard_Address& Nod21Indices,Standard_Address& Nod21RValues,Standard_Address& Nod22Indices,Standard_Address& Nod22RValues,const Standard_Integer i2p1,const Standard_Integer i2p2,const Standard_Integer i2,const Handle(HLRAlgo_PolyInternalData)& pid2,Standard_Address& TData2,Standard_Address& PISeg2,Standard_Address& PINod2,const Standard_Real X3,const Standard_Real Y3,const Standard_Real Z3,const Standard_Real XT3,const Standard_Real YT3,const Standard_Real ZT3,const Standard_Real coef3,const Standard_Real U3,const Standard_Boolean insP3,const Standard_Boolean mP3P1,const Standard_Boolean flag) const;


Standard_EXPORT   void MoveOrInsertPoint(HLRAlgo_ListOfBPoint& List,Standard_Real& X1,Standard_Real& Y1,Standard_Real& Z1,Standard_Real& X2,Standard_Real& Y2,Standard_Real& Z2,Standard_Real& XTI1,Standard_Real& YTI1,Standard_Real& ZTI1,Standard_Real& XTI2,Standard_Real& YTI2,Standard_Real& ZTI2,const Standard_Integer e,Standard_Real& U1,Standard_Real& U2,Standard_Address& Nod11Indices,Standard_Address& Nod11RValues,Standard_Address& Nod12Indices,Standard_Address& Nod12RValues,const Standard_Integer i1p1,const Standard_Integer i1p2,const Standard_Integer i1,const Handle(HLRAlgo_PolyInternalData)& pid1,Standard_Address& TData1,Standard_Address& PISeg1,Standard_Address& PINod1,Standard_Address& Nod21Indices,Standard_Address& Nod21RValues,Standard_Address& Nod22Indices,Standard_Address& Nod22RValues,const Standard_Integer i2p1,const Standard_Integer i2p2,const Standard_Integer i2,const Handle(HLRAlgo_PolyInternalData)& pid2,Standard_Address& TData2,Standard_Address& PISeg2,Standard_Address& PINod2,const Standard_Real X3,const Standard_Real Y3,const Standard_Real Z3,const Standard_Real XT3,const Standard_Real YT3,const Standard_Real ZT3,const Standard_Real coef3,const Standard_Real U3,const Standard_Boolean insP3,const Standard_Boolean mP3P1,const Standard_Real X4,const Standard_Real Y4,const Standard_Real Z4,const Standard_Real XT4,const Standard_Real YT4,const Standard_Real ZT4,const Standard_Real coef4,const Standard_Real U4,const Standard_Boolean insP4,const Standard_Boolean mP4P1,const Standard_Boolean flag) const;


Standard_EXPORT   void InsertOnOutLine(TColStd_Array1OfTransient& PID) ;


Standard_EXPORT   void CheckFrBackTriangles(HLRAlgo_ListOfBPoint& List,TColStd_Array1OfTransient& PID) ;


Standard_EXPORT   void FindEdgeOnTriangle(const Standard_Address Tri1Indices,const Standard_Integer ip1,const Standard_Integer ip2,Standard_Integer& jtrouv,Standard_Boolean& isDirect) const;


Standard_EXPORT   void ChangeNode(const Standard_Integer ip1,const Standard_Integer ip2,const Standard_Address Nod1Indices,const Standard_Address Nod1RValues,const Standard_Address Nod2Indices,const Standard_Address Nod2RValues,const Standard_Real coef1,const Standard_Real X3,const Standard_Real Y3,const Standard_Real Z3,const Standard_Boolean first,Standard_Address& TData,Standard_Address& PISeg,Standard_Address& PINod) const;


Standard_EXPORT   void UpdateAroundNode(const Standard_Integer iNode,const Standard_Address Nod1Indices,const Standard_Address TData,const Standard_Address PISeg,const Standard_Address PINod) const;


Standard_EXPORT   void OrientTriangle(const Standard_Integer iTri,const Standard_Address Tri1Indices,const Standard_Address Nod1Indices,const Standard_Address Nod1RValues,const Standard_Address Nod2Indices,const Standard_Address Nod2RValues,const Standard_Address Nod3Indices,const Standard_Address Nod3RValues) const;


Standard_EXPORT   Standard_Boolean Triangles(const Standard_Integer ip1,const Standard_Integer ip2,const Standard_Address Nod1Indices,Standard_Address& PISeg,Standard_Integer& iTri1,Standard_Integer& iTri2) const;


Standard_EXPORT   Standard_Boolean NewNode(const Standard_Address Nod1RValues,const Standard_Address Nod2RValues,Standard_Real& coef1,Standard_Boolean& moveP1) const;


Standard_EXPORT   void UVNode(const Standard_Address Nod1RValues,const Standard_Address Nod2RValues,const Standard_Real coef1,Standard_Real& U3,Standard_Real& V3) const;


Standard_EXPORT   void CheckDegeneratedSegment(const Standard_Address Nod1Indices,const Standard_Address Nod1RValues,const Standard_Address Nod2Indices,const Standard_Address Nod2RValues) const;


Standard_EXPORT   void UpdateOutLines(HLRAlgo_ListOfBPoint& List,TColStd_Array1OfTransient& PID) ;


Standard_EXPORT   void UpdateEdgesBiPoints(HLRAlgo_ListOfBPoint& List,const TColStd_Array1OfTransient& PID,const Standard_Boolean closed) ;


Standard_EXPORT   void UpdatePolyData(TColStd_Array1OfTransient& PD,TColStd_Array1OfTransient& PID,const Standard_Boolean closed) ;


Standard_EXPORT   void TMultiply(Standard_Real& X,Standard_Real& Y,Standard_Real& Z,const Standard_Boolean VecPartOnly = Standard_False) const;


Standard_EXPORT   void TTMultiply(Standard_Real& X,Standard_Real& Y,Standard_Real& Z,const Standard_Boolean VecPartOnly = Standard_False) const;


Standard_EXPORT   void TIMultiply(Standard_Real& X,Standard_Real& Y,Standard_Real& Z,const Standard_Boolean VecPartOnly = Standard_False) const;


 // Fields PRIVATE
 //
HLRAlgo_Projector myProj;
Standard_Real TMat[3][3];
Standard_Real TLoc[3];
Standard_Real TTMa[3][3];
Standard_Real TTLo[3];
Standard_Real TIMa[3][3];
Standard_Real TILo[3];
TopTools_SequenceOfShape myShapes;
TopTools_IndexedMapOfShape myEMap;
TopTools_IndexedMapOfShape myFMap;
Handle_HLRAlgo_PolyAlgo myAlgo;
Standard_Integer myHide;
Standard_Boolean myDebug;
Standard_Real myAngle;
Standard_Real myTolSta;
Standard_Real myTolEnd;
Standard_Real myTolAngular;
Handle_Geom_Surface myGSurf;
BRepAdaptor_Surface myBSurf;
BRepAdaptor_Curve myBCurv;
BRepAdaptor_Curve2d myPC;


};


#include <HLRBRep_PolyAlgo.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
