// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRBRep_VertexList_HeaderFile
#define _HLRBRep_VertexList_HeaderFile

#ifndef _HLRAlgo_ListIteratorOfInterferenceList_HeaderFile
#include <HLRAlgo_ListIteratorOfInterferenceList.hxx>
#endif
#ifndef _HLRBRep_EdgeInterferenceTool_HeaderFile
#include <HLRBRep_EdgeInterferenceTool.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class HLRBRep_EdgeInterferenceTool;
class HLRAlgo_ListIteratorOfInterferenceList;
class HLRAlgo_Intersection;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class HLRBRep_VertexList  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT HLRBRep_VertexList(const HLRBRep_EdgeInterferenceTool& T,const HLRAlgo_ListIteratorOfInterferenceList& I);

//! Returns True when the curve is periodic. <br>
Standard_EXPORT   Standard_Boolean IsPeriodic() const;

//! Returns True when there are more vertices. <br>
Standard_EXPORT   Standard_Boolean More() const;

//! Proceeds to the next vertex. <br>
Standard_EXPORT   void Next() ;

//! Returns the current vertex <br>
//! <br>
Standard_EXPORT  const HLRAlgo_Intersection& Current() const;

//! Returns True  if the current  vertex  is is on the <br>
//!          boundary of the edge. <br>
Standard_EXPORT   Standard_Boolean IsBoundary() const;

//! Returns  True   if   the current    vertex  is  an <br>
//!          interference. <br>
Standard_EXPORT   Standard_Boolean IsInterference() const;

//! Returns the  orientation of the  current vertex if <br>
//!          it is on the boundary of the edge. <br>
Standard_EXPORT   TopAbs_Orientation Orientation() const;

//! Returns  the transition  of the  current vertex if <br>
//!          it is an interference. <br>
Standard_EXPORT   TopAbs_Orientation Transition() const;

//! Returns  the  transition  of  the  current  vertex <br>
//!          relative to the boundary if it is an interference. <br>
Standard_EXPORT   TopAbs_Orientation BoundaryTransition() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
HLRAlgo_ListIteratorOfInterferenceList myIterator;
HLRBRep_EdgeInterferenceTool myTool;
Standard_Boolean fromEdge;
Standard_Boolean fromInterf;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
