// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_Act_HeaderFile
#define _IFSelect_Act_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_Act_HeaderFile
#include <Handle_IFSelect_Act.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _IFSelect_ActFunc_HeaderFile
#include <IFSelect_ActFunc.hxx>
#endif
#ifndef _IFSelect_Activator_HeaderFile
#include <IFSelect_Activator.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _IFSelect_ReturnStatus_HeaderFile
#include <IFSelect_ReturnStatus.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IFSelect_SessionPilot_HeaderFile
#include <Handle_IFSelect_SessionPilot.hxx>
#endif
class Standard_DomainError;
class IFSelect_SessionPilot;


//! Act gives a simple way to define and add functions to be ran <br>
//!           from a SessionPilot, as follows : <br>
//! <br>
//!           Define a function as <br>
//!             static IFSelect_RetStatus myfunc <br>
//!               (const Standard_CString name, <br>
//!                const Handle(IFSelect_SessionPilot)& pilot) <br>
//!             { ... } <br>
//!           When ran, it receives the exact name (string) of the called <br>
//!           function, and the SessionPilot which brings other infos <br>
//! <br>
//!           Add it by <br>
//!             IFSelect_Act::AddFunc (name,help,myfunc); <br>
//!               for a normal function, or <br>
//!             IFSelect_Act::AddFSet (name,help,myfunc); <br>
//!               for a function which is intended to create a control item <br>
//!           name and help are given as CString <br>
//! <br>
//!           Then, it is available for run <br>
class IFSelect_Act : public IFSelect_Activator {

public:
 // Methods PUBLIC
 // 

//! Creates an Act with a name, help and a function <br>
//!           mode (Add or AddSet) is given when recording <br>
Standard_EXPORT IFSelect_Act(const Standard_CString name,const Standard_CString help,const IFSelect_ActFunc func);

//! Execution of Command Line. remark that <number> is senseless <br>
//!           because each Act brings one and only one function <br>
Standard_EXPORT   IFSelect_ReturnStatus Do(const Standard_Integer number,const Handle(IFSelect_SessionPilot)& pilot) ;

//! Short Help for commands : returns the help given to create <br>
Standard_EXPORT   Standard_CString Help(const Standard_Integer number) const;

//! Changes the default group name for the following Acts <br>
//!           group empty means to come back to default from Activator <br>
//!           Also a file name can be precised (to query by getsource) <br>
Standard_EXPORT static  void SetGroup(const Standard_CString group,const Standard_CString file = "") ;

//! Adds a function with its name and help : creates an Act then <br>
//!           records it as normal function <br>
Standard_EXPORT static  void AddFunc(const Standard_CString name,const Standard_CString help,const IFSelect_ActFunc func) ;

//! Adds a function with its name and help : creates an Act then <br>
//!           records it as function for XSET (i.e. to create control item) <br>
Standard_EXPORT static  void AddFSet(const Standard_CString name,const Standard_CString help,const IFSelect_ActFunc func) ;
//Standard_EXPORT ~IFSelect_Act();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString thename;
TCollection_AsciiString thehelp;
IFSelect_ActFunc thefunc;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
