// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntRes2d_IntersectionSegment_HeaderFile
#define _IntRes2d_IntersectionSegment_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntRes2d_IntersectionPoint_HeaderFile
#include <IntRes2d_IntersectionPoint.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_DomainError;
class IntRes2d_IntersectionPoint;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& IntRes2d_IntersectionSegment_Type_();

//! Definition of an intersection curve between <br>
//!          two 2D curves. <br>
class IntRes2d_IntersectionSegment  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT IntRes2d_IntersectionSegment();

IntRes2d_IntersectionSegment(const IntRes2d_IntersectionPoint& P1,const IntRes2d_IntersectionPoint& P2,const Standard_Boolean Oppos,const Standard_Boolean ReverseFlag);

IntRes2d_IntersectionSegment(const IntRes2d_IntersectionPoint& P,const Standard_Boolean First,const Standard_Boolean Oppos,const Standard_Boolean ReverseFlag);
//! Creates an infinite segment of intersection. <br>
IntRes2d_IntersectionSegment(const Standard_Boolean Oppos);
//! Returns TRUE if the intersection segment has got <br>
//!          the same orientation on both curves. <br>
  Standard_Boolean IsOpposite() const;
//! Returns True if the segment is  limited by a first <br>
//!          point.   This  point defines  the lowest parameter <br>
//!          admitted on the first  curve for the  segment.  If <br>
//!          IsOpposite  returns  False, it  defines the lowest <br>
//!          parameter on the  second curve, otherwise,  it  is <br>
//!          the highest parameter on the second curve. <br>
  Standard_Boolean HasFirstPoint() const;
//! Returns the  first point   of the segment    as an <br>
//!          IntersectionPoint (with    a    transition).   The <br>
//!          exception  DomainError  is raised if HasFirstPoint <br>
//!          returns False. <br>
 const IntRes2d_IntersectionPoint& FirstPoint() const;
//! Returns True if the segment  is  limited by a last <br>
//!          point.  This point  defines  the highest parameter <br>
//!          admitted on the  first curve for  the segment.  If <br>
//!          IsOpposite returns  False, it  defines the highest <br>
//!          parameter on  the  second curve, otherwise, it  is <br>
//!          the lowest parameter on the second curve. <br>
  Standard_Boolean HasLastPoint() const;
//! Returns   the  last point  of the    segment as an <br>
//!          IntersectionPoint   (with  a    transition).   The <br>
//!          exception        DomainError     is   raised    if <br>
//!          HasLastExtremity returns False. <br>
 const IntRes2d_IntersectionPoint& LastPoint() const;
    Standard_Boolean _CSFDB_GetIntRes2d_IntersectionSegmentoppos() const { return oppos; }
    void _CSFDB_SetIntRes2d_IntersectionSegmentoppos(const Standard_Boolean p) { oppos = p; }
    Standard_Boolean _CSFDB_GetIntRes2d_IntersectionSegmentfirst() const { return first; }
    void _CSFDB_SetIntRes2d_IntersectionSegmentfirst(const Standard_Boolean p) { first = p; }
    Standard_Boolean _CSFDB_GetIntRes2d_IntersectionSegmentlast() const { return last; }
    void _CSFDB_SetIntRes2d_IntersectionSegmentlast(const Standard_Boolean p) { last = p; }
    const IntRes2d_IntersectionPoint& _CSFDB_GetIntRes2d_IntersectionSegmentptfirst() const { return ptfirst; }
    const IntRes2d_IntersectionPoint& _CSFDB_GetIntRes2d_IntersectionSegmentptlast() const { return ptlast; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& IntRes2d_IntersectionSegment_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean oppos;
Standard_Boolean first;
Standard_Boolean last;
IntRes2d_IntersectionPoint ptfirst;
IntRes2d_IntersectionPoint ptlast;


};


#include <IntRes2d_IntersectionSegment.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
