// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Standard_HeaderFile
#define _Standard_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Size_HeaderFile
#include <Standard_Size.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ErrorHandlerCallback;
class Standard_ErrorHandler;
class Standard_AncestorIterator;
class Standard_Storable;
class Standard_Persistent;
class Standard_GUID;
class Standard_Transient;
class Standard_Type;
class Standard_Failure;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class Standard  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Allocates memory blocks <br>
//!           aSize - bytes to  allocate <br>
Standard_EXPORT static  Standard_Address Allocate(const Standard_Size aSize) ;

//!  Deallocates memory blocks <br>
//!           aStorage - previously allocated memory block to be freed <br>
Standard_EXPORT static  void Free(Standard_Address& aStorage) ;

//!  Reallocates memory blocks <br>
//!           aStorage - previously allocated memory block <br>
//!           aNewSize - new size in bytes <br>
Standard_EXPORT static  Standard_Address Reallocate(Standard_Address& aStorage,const Standard_Size aNewSize) ;

//!  Deallocates the storage retained on the free list <br>
//!           and clears the list. <br>
//!           Returns non-zero if some memory has been actually freed. <br>
Standard_EXPORT static  Standard_Integer Purge() ;

//! Returns boolean flag indicating whether OCCT is <br>
//!          operating in reentrant mode. This flag affects OCCT <br>
//!          memory manager, exception and signal handling, <br>
//!          operations with handles etc., making them thread-safe. <br>
Standard_EXPORT static  Standard_Boolean IsReentrant() ;

//! Sets boolean flag indicating whether OCCT is <br>
//!          operating in reentrant mode. <br>
//!          See method IsReentrant() for more information. <br>
//!          Note: This method may be called only when no any other <br>
//!                thread using OCCT exists <br>
Standard_EXPORT static  void SetReentrant(const Standard_Boolean isReentrant) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Standard_ErrorHandlerCallback;
friend class Standard_ErrorHandler;
friend class Standard_AncestorIterator;
friend class Standard_Storable;
friend class Standard_Persistent;
friend class Standard_GUID;
friend class Standard_Transient;
friend class Standard_Type;
friend class Standard_Failure;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
