// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Standard_Storable_HeaderFile
#define _Standard_Storable_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& Standard_Storable_Type_();

//! This class Storable is an abstract class that allows built-in <br>
//!          primitive types to be extended. They are not themselves <br>
//!          persistent, but are known by the database, therefore can be used <br>
//!         to define the internal representation of persistent objects. <br>
//!         Otherwise, all the fields of subclasses of Object MUST inherit <br>
//!         from Storable. <br>
//! <br>
//!         This class provides also a framework for copying, comparing and <br>
//!         printing. <br>
class Standard_Storable  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~Standard_Storable(){Delete();}

//! Returns a hashed value denoting <me>. This value is in <br>
//!         the range 1..<Upper>. <br>
Standard_EXPORT virtual  Standard_Integer HashCode(const Standard_Integer Upper) const;

//! Returns true if the direct contents of <me> and <br>
//!         <Other> are memberwise equal. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Standard_Storable& Other) const;
  Standard_Boolean operator ==(const Standard_Storable& Other) const
{
  return IsEqual(Other);
}


//! Returns true if the Deep contents of <me> and <br>
//!         <Other> are memberwise equal. <br>
Standard_EXPORT   Standard_Boolean IsSimilar(const Standard_Storable& Other) const;

//! Prints the contents at the first level of <me> on <br>
//!         the stream <s>. The Root version of ShallowDump prints <br>
//!         the name of the class <me> is instance of, followed by <br>
//!         its memory address. <br>
Standard_EXPORT virtual  void ShallowDump(Standard_OStream& S) const;




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& Standard_Storable_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//
inline Standard_Integer HashCode(const Standard_Storable& me,const Standard_Integer Upper) {
 return me.HashCode(Upper);
}

inline Standard_Boolean IsSimilar(const Standard_Storable& me,const Standard_Storable& Other) {
 return me.IsSimilar(Other);
}

inline void ShallowDump(const Standard_Storable& me,Standard_OStream& S) {
 me.ShallowDump(S);
}



#endif
