// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TCollection_AsciiString_HeaderFile
#define _TCollection_AsciiString_HeaderFile

#ifndef _Standard_PCharacter_HeaderFile
#include <Standard_PCharacter.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_IStream_HeaderFile
#include <Standard_IStream.hxx>
#endif
class Standard_NullObject;
class Standard_OutOfRange;
class Standard_NumericError;
class Standard_NegativeValue;
class TCollection_HAsciiString;
class TCollection_ExtendedString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A variable-length sequence of ASCII characters <br>
//! (normal 8-bit character type). It provides editing <br>
//! operations with built-in memory management to <br>
//! make AsciiString objects easier to use than <br>
//! ordinary character arrays. <br>
//! AsciiString objects follow value semantics; in <br>
//! other words, they are the actual strings, not <br>
//! handles to strings, and are copied through <br>
//! assignment. You may use HAsciiString objects <br>
//! to get handles to strings. <br>
class TCollection_AsciiString  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes a AsciiString to an empty AsciiString. <br>
Standard_EXPORT TCollection_AsciiString();

//! Initializes a AsciiString with a CString. <br>
Standard_EXPORT TCollection_AsciiString(const Standard_CString message);

//! Initializes a AsciiString with a CString. <br>
Standard_EXPORT TCollection_AsciiString(const Standard_CString message,const Standard_Integer aLen);

//! Initializes a AsciiString with a single character. <br>
Standard_EXPORT TCollection_AsciiString(const Standard_Character aChar);

//! Initializes an AsciiString with <length> space allocated. <br>
//! and filled with <filler>. This is usefull for buffers. <br>
Standard_EXPORT TCollection_AsciiString(const Standard_Integer length,const Standard_Character filler);

//! Initializes an AsciiString with an integer value <br>
Standard_EXPORT TCollection_AsciiString(const Standard_Integer value);

//! Initializes an AsciiString with a real value <br>
Standard_EXPORT TCollection_AsciiString(const Standard_Real value);

//! Initializes a AsciiString with another AsciiString. <br>
Standard_EXPORT TCollection_AsciiString(const TCollection_AsciiString& astring);

//! Initializes a AsciiString with copy of another AsciiString <br>
//!          concatenated with the message character. <br>
Standard_EXPORT TCollection_AsciiString(const TCollection_AsciiString& astring,const Standard_Character message);

//! Initializes a AsciiString with copy of another AsciiString <br>
//!          concatenated with the message string. <br>
Standard_EXPORT TCollection_AsciiString(const TCollection_AsciiString& astring,const Standard_CString message);

//! Initializes a AsciiString with copy of another AsciiString <br>
//!          concatenated with the message string. <br>
Standard_EXPORT TCollection_AsciiString(const TCollection_AsciiString& astring,const TCollection_AsciiString& message);

//! Creation by converting an extended string to an ascii string. <br>
//!          If replaceNonAscii is non-null charecter, it will be used <br>
//!          in place of any non-ascii character found in the source string. <br>
//!          Otherwise, raises OutOfRange exception if at least one character <br>
//!          in the source string is not in the "Ascii range". <br>
Standard_EXPORT TCollection_AsciiString(const TCollection_ExtendedString& astring,const Standard_Character replaceNonAscii = 0);

//! Appends <other>  to me. This is an unary operator. <br>
Standard_EXPORT   void AssignCat(const Standard_Character other) ;
  void operator +=(const Standard_Character other) 
{
  AssignCat(other);
}


//! Appends <other>  to me. This is an unary operator. <br>
Standard_EXPORT   void AssignCat(const Standard_Integer other) ;
  void operator +=(const Standard_Integer other) 
{
  AssignCat(other);
}


//! Appends <other>  to me. This is an unary operator. <br>
Standard_EXPORT   void AssignCat(const Standard_Real other) ;
  void operator +=(const Standard_Real other) 
{
  AssignCat(other);
}


//! Appends <other>  to me. This is an unary operator. <br>
//! ex: aString += "Dummy" <br>
//! To catenate more than one CString, you must put a <br>
//! AsciiString before. <br>
//!  Example: aString += "Hello " + "Dolly"  IS NOT VALID ! <br>
//! But astring += anotherString + "Hello " + "Dolly" is valid. <br>
Standard_EXPORT   void AssignCat(const Standard_CString other) ;
  void operator +=(const Standard_CString other) 
{
  AssignCat(other);
}


//! Appends <other> to me. This is an unary operator. <br>
//!  Example: aString += anotherString <br>
Standard_EXPORT   void AssignCat(const TCollection_AsciiString& other) ;
  void operator +=(const TCollection_AsciiString& other) 
{
  AssignCat(other);
}


//! Converts the first character into its corresponding <br>
//! upper-case character and the other characters into lowercase <br>
//!  Example: before <br>
//!   me = "hellO " <br>
//! after <br>
//!   me = "Hello " <br>
Standard_EXPORT   void Capitalize() ;
//! Appends <other>  to me. <br>
//! Syntax: <br>
//! aString = aString + "Dummy" <br>
//!  Example: aString contains "I say " <br>
//! aString = aString + "Hello " + "Dolly" <br>
//! gives "I say Hello Dolly" <br>
//! To catenate more than one CString, you must put a String before. <br>
//! So the following example is WRONG ! <br>
//!      aString = "Hello " + "Dolly"  THIS IS NOT ALLOWED <br>
//! This rule is applicable to AssignCat (operator +=) too. <br>
  TCollection_AsciiString Cat(const Standard_Character other) const;
  TCollection_AsciiString operator +(const Standard_Character other) const
{
  return Cat(other);
}

//! Appends <other>  to me. <br>
//! Syntax: <br>
//! aString = aString + 15; <br>
//!  Example: aString contains "I say " <br>
//! gives "I say 15" <br>
//! To catenate more than one CString, you must put a String before. <br>
//! So the following example is WRONG ! <br>
//!      aString = "Hello " + "Dolly"  THIS IS NOT ALLOWED <br>
//! This rule is applicable to AssignCat (operator +=) too. <br>
  TCollection_AsciiString Cat(const Standard_Integer other) const;
  TCollection_AsciiString operator +(const Standard_Integer other) const
{
  return Cat(other);
}

//! Appends <other>  to me. <br>
//! Syntax: <br>
//! aString = aString + 15.15; <br>
//!  Example: aString contains "I say " <br>
//! gives "I say 15.15" <br>
//! To catenate more than one CString, you must put a String before. <br>
//! So the following example is WRONG ! <br>
//!      aString = "Hello " + "Dolly"  THIS IS NOT ALLOWED <br>
//! This rule is applicable to AssignCat (operator +=) too. <br>
  TCollection_AsciiString Cat(const Standard_Real other) const;
  TCollection_AsciiString operator +(const Standard_Real other) const
{
  return Cat(other);
}

//! Appends <other>  to me. <br>
//! Syntax: <br>
//! aString = aString + "Dummy" <br>
//!  Example: aString contains "I say " <br>
//! aString = aString + "Hello " + "Dolly" <br>
//! gives "I say Hello Dolly" <br>
//! To catenate more than one CString, you must put a String before. <br>
//! So the following example is WRONG ! <br>
//!      aString = "Hello " + "Dolly"  THIS IS NOT ALLOWED <br>
//! This rule is applicable to AssignCat (operator +=) too. <br>
  TCollection_AsciiString Cat(const Standard_CString other) const;
  TCollection_AsciiString operator +(const Standard_CString other) const
{
  return Cat(other);
}

//! Appends <other> to me. <br>
//!  Example: aString = aString + anotherString <br>
  TCollection_AsciiString Cat(const TCollection_AsciiString& other) const;
  TCollection_AsciiString operator +(const TCollection_AsciiString& other) const
{
  return Cat(other);
}


//! Modifies this ASCII string so that its length <br>
//! becomes equal to Width and the new characters <br>
//! are equal to Filler. New characters are added <br>
//! both at the beginning and at the end of this string. <br>
//! If Width is less than the length of this ASCII string, nothing happens. <br>
//! Example <br>
//! TCollection_AsciiString <br>
//! myAlphabet("abcdef"); <br>
//! myAlphabet.Center(9,' '); <br>
//! assert ( myAlphabet == " <br>
//! abcdef " ); <br>
Standard_EXPORT   void Center(const Standard_Integer Width,const Standard_Character Filler) ;

//! Substitutes all the characters equal to aChar by NewChar <br>
//! in the AsciiString <me>. <br>
//! The substitution can be case sensitive. <br>
//! If you don't use default case sensitive, no matter wether aChar <br>
//! is uppercase or not. <br>
//!  Example: me = "Histake" -> ChangeAll('H','M',Standard_True) <br>
//! gives me = "Mistake" <br>
Standard_EXPORT   void ChangeAll(const Standard_Character aChar,const Standard_Character NewChar,const Standard_Boolean CaseSensitive = Standard_True) ;

//! Removes all characters contained in <me>. <br>
//! This produces an empty AsciiString. <br>
Standard_EXPORT   void Clear() ;

//! Copy <fromwhere> to <me>. <br>
//! Used as operator = <br>
//!  Example: aString = anotherCString; <br>
Standard_EXPORT   void Copy(const Standard_CString fromwhere) ;
  void operator =(const Standard_CString fromwhere) 
{
  Copy(fromwhere);
}


//! Copy <fromwhere> to <me>. <br>
//! Used as operator = <br>
//!  Example: aString = anotherString; <br>
Standard_EXPORT   void Copy(const TCollection_AsciiString& fromwhere) ;
  void operator =(const TCollection_AsciiString& fromwhere) 
{
  Copy(fromwhere);
}


//! Frees memory allocated by AsciiString. <br>
Standard_EXPORT   void Destroy() ;
~TCollection_AsciiString()
{
  Destroy();
}


//! Returns the index of the first character of <me> that is <br>
//! present in <Set>. <br>
//! The search begins to the index FromIndex and ends to the <br>
//! the index ToIndex. <br>
//! Returns zero if failure. <br>
//! Raises an exception if FromIndex or ToIndex is out of range. <br>
//!  Example: before <br>
//!   me = "aabAcAa", S = "Aa", FromIndex = 1, Toindex = 7 <br>
//! after <br>
//!   me = "aabAcAa" <br>
//! returns <br>
//!   1 <br>
Standard_EXPORT   Standard_Integer FirstLocationInSet(const TCollection_AsciiString& Set,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Returns the index of the first character of <me> <br>
//! that is not present in the set <Set>. <br>
//! The search begins to the index FromIndex and ends to the <br>
//! the index ToIndex in <me>. <br>
//! Returns zero if failure. <br>
//! Raises an exception if FromIndex or ToIndex is out of range. <br>
//!  Example: before <br>
//!   me = "aabAcAa", S = "Aa", FromIndex = 1, Toindex = 7 <br>
//! after <br>
//!   me = "aabAcAa" <br>
//! returns <br>
//!   3 <br>
Standard_EXPORT   Standard_Integer FirstLocationNotInSet(const TCollection_AsciiString& Set,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Inserts a Character at position <where>. <br>
//!  Example: <br>
//!    aString contains "hy not ?" <br>
//!    aString.Insert(1,'W'); gives "Why not ?" <br>
//!    aString contains "Wh" <br>
//!    aString.Insert(3,'y'); gives "Why" <br>
//!    aString contains "Way" <br>
//!    aString.Insert(2,'h'); gives "Why" <br>
Standard_EXPORT   void Insert(const Standard_Integer where,const Standard_Character what) ;

//! Inserts a CString at position <where>. <br>
//!  Example: <br>
//!    aString contains "O more" <br>
//!    aString.Insert(2,"nce");  gives "Once more" <br>
Standard_EXPORT   void Insert(const Standard_Integer where,const Standard_CString what) ;

//! Inserts a AsciiString at position <where>. <br>
Standard_EXPORT   void Insert(const Standard_Integer where,const TCollection_AsciiString& what) ;

//! Pushing a string after a specific index in the string <me>. <br>
//! Raises an exception if Index is out of bounds. <br>
//! -   less than 0 (InsertAfter), or less than 1 (InsertBefore), or <br>
//! -   greater than the number of characters in this ASCII string. <br>
//!  Example: <br>
//! before <br>
//!   me = "cde" , Index = 0 , other = "ab" <br>
//! after <br>
//!   me = "abcde" , other = "ab" <br>
Standard_EXPORT   void InsertAfter(const Standard_Integer Index,const TCollection_AsciiString& other) ;

//! Pushing a string before a specific index in the string <me>. <br>
//! Raises an exception if Index is out of bounds. <br>
//! -   less than 0 (InsertAfter), or less than 1 (InsertBefore), or <br>
//! -   greater than the number of characters in this ASCII string. <br>
//!  Example: <br>
//! before <br>
//!   me = "cde" , Index = 1 , other = "ab" <br>
//! after <br>
//!   me = "abcde" , other = "ab" <br>
Standard_EXPORT   void InsertBefore(const Standard_Integer Index,const TCollection_AsciiString& other) ;

//! Returns True if the string <me> contains zero character. <br>
Standard_EXPORT   Standard_Boolean IsEmpty() const;

//!  Returns true if the characters in this ASCII string <br>
//! are identical to the characters in ASCII string other. <br>
//! Note that this method is an alias of operator ==. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Standard_CString other) const;
  Standard_Boolean operator ==(const Standard_CString other) const
{
  return IsEqual(other);
}


//!  Returns true if the characters in this ASCII string <br>
//! are identical to the characters in ASCII string other. <br>
//! Note that this method is an alias of operator ==. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const TCollection_AsciiString& other) const;
  Standard_Boolean operator ==(const TCollection_AsciiString& other) const
{
  return IsEqual(other);
}


//!  Returns true if there are differences between the <br>
//! characters in this ASCII string and ASCII string other. <br>
//! Note that this method is an alias of operator != <br>
Standard_EXPORT   Standard_Boolean IsDifferent(const Standard_CString other) const;
  Standard_Boolean operator !=(const Standard_CString other) const
{
  return IsDifferent(other);
}


//!  Returns true if there are differences between the <br>
//! characters in this ASCII string and ASCII string other. <br>
//! Note that this method is an alias of operator != <br>
Standard_EXPORT   Standard_Boolean IsDifferent(const TCollection_AsciiString& other) const;
  Standard_Boolean operator !=(const TCollection_AsciiString& other) const
{
  return IsDifferent(other);
}


//! Returns TRUE if <me> is 'ASCII' less than <other>. <br>
Standard_EXPORT   Standard_Boolean IsLess(const Standard_CString other) const;
  Standard_Boolean operator <(const Standard_CString other) const
{
  return IsLess(other);
}


//! Returns TRUE if <me> is 'ASCII' less than <other>. <br>
Standard_EXPORT   Standard_Boolean IsLess(const TCollection_AsciiString& other) const;
  Standard_Boolean operator <(const TCollection_AsciiString& other) const
{
  return IsLess(other);
}


//! Returns TRUE if <me> is 'ASCII' greater than <other>. <br>
Standard_EXPORT   Standard_Boolean IsGreater(const Standard_CString other) const;
  Standard_Boolean operator >(const Standard_CString other) const
{
  return IsGreater(other);
}


//! Returns TRUE if <me> is 'ASCII' greater than <other>. <br>
Standard_EXPORT   Standard_Boolean IsGreater(const TCollection_AsciiString& other) const;
  Standard_Boolean operator >(const TCollection_AsciiString& other) const
{
  return IsGreater(other);
}


//! Converts a AsciiString containing a numeric expression to <br>
//! an Integer. <br>
//!  Example: "215" returns 215. <br>
Standard_EXPORT   Standard_Integer IntegerValue() const;

//! Returns True if the AsciiString contains an integer value. <br>
//! Note: an integer value is considered to be a real value as well. <br>
Standard_EXPORT   Standard_Boolean IsIntegerValue() const;

//! Returns True if the AsciiString contains a real value. <br>
//!  Note: an integer value is considered to be a real value as well. <br>
Standard_EXPORT   Standard_Boolean IsRealValue() const;

//! Returns True if the AsciiString contains only ASCII characters <br>
//! between ' ' and '~'. <br>
//! This means no control character and no extended ASCII code. <br>
Standard_EXPORT   Standard_Boolean IsAscii() const;

//! Removes all space characters in the begining of the string. <br>
Standard_EXPORT   void LeftAdjust() ;

//! left justify <br>
//! Length becomes equal to Width and the new characters are <br>
//! equal to Filler. <br>
//! If Width < Length nothing happens. <br>
//! Raises an exception if Width is less than zero. <br>
//!  Example: <br>
//! before <br>
//!   me = "abcdef" , Width = 9 , Filler = ' ' <br>
//! after <br>
//!   me = "abcdef   " <br>
Standard_EXPORT   void LeftJustify(const Standard_Integer Width,const Standard_Character Filler) ;
//! Returns number of characters in <me>. <br>
//! This is the same functionality as 'strlen' in C. <br>
//! Example <br>
//!  TCollection_AsciiString myAlphabet("abcdef"); <br>
//! assert ( myAlphabet.Length() == 6 ); <br>
//! -   1 is the position of the first character in this string. <br>
//! -   The length of this string gives the position of its last character. <br>
//! -   Positions less than or equal to zero, or <br>
//!   greater than the length of this string are <br>
//!   invalid in functions which identify a character <br>
//!   of this string by its position. <br>
  Standard_Integer Length() const;

//! Returns an index in the string <me> of the first occurence <br>
//! of the string S in the string <me> from the starting index <br>
//! FromIndex to the ending index ToIndex <br>
//! returns zero if failure <br>
//! Raises an exception if FromIndex or ToIndex is out of range. <br>
//!  Example: <br>
//! before <br>
//!   me = "aabAaAa", S = "Aa", FromIndex = 1, ToIndex = 7 <br>
//! after <br>
//!   me = "aabAaAa" <br>
//! returns <br>
//!   4 <br>
Standard_EXPORT   Standard_Integer Location(const TCollection_AsciiString& other,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Returns the index of the nth occurence of the character C <br>
//! in the string <me> from the starting index FromIndex to the <br>
//! ending index ToIndex. <br>
//! Returns zero if failure. <br>
//! Raises an exception if FromIndex or ToIndex is out of range. <br>
//!  Example: <br>
//! before <br>
//!   me = "aabAa", N = 3, C = 'a', FromIndex = 1, ToIndex = 5 <br>
//! after <br>
//!   me = "aabAa" <br>
//! returns <br>
//!   5 <br>
Standard_EXPORT   Standard_Integer Location(const Standard_Integer N,const Standard_Character C,const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;

//! Converts <me> to its lower-case equivalent. <br>
//! Example <br>
//! TCollection_AsciiString myString("Hello Dolly"); <br>
//! myString.UpperCase(); <br>
//! assert ( myString == "HELLO DOLLY" ); <br>
//! myString.LowerCase(); <br>
//! assert ( myString == "hello dolly" ); <br>
Standard_EXPORT   void LowerCase() ;

//! Inserts the string other at the beginning of this ASCII string. <br>
//! Example <br>
//! TCollection_AsciiString myAlphabet("cde"); <br>
//! TCollection_AsciiString myBegin("ab"); <br>
//! myAlphabet.Prepend(myBegin); <br>
//! assert ( myAlphabet == "abcde" ); <br>
Standard_EXPORT   void Prepend(const TCollection_AsciiString& other) ;

//! Displays <me> on a stream. <br>
Standard_EXPORT   void Print(Standard_OStream& astream) const;
friend Standard_EXPORT Standard_OStream& operator << (Standard_OStream& astream,const TCollection_AsciiString& astring);

//! Read <me> from a stream. <br>
Standard_EXPORT   void Read(Standard_IStream& astream) ;
friend Standard_EXPORT Standard_IStream& operator >> (Standard_IStream& astream, TCollection_AsciiString& astring);

//! Converts an AsciiString containing a numeric expression. <br>
//! to a Real. <br>
//!  Example: ex: "215" returns 215.0. <br>
//! ex: "3.14159267" returns 3.14159267. <br>
Standard_EXPORT   Standard_Real RealValue() const;

//! Remove all the occurences of the character C in the string. <br>
//!  Example: <br>
//! before <br>
//!   me = "HellLLo", C = 'L' , CaseSensitive = True <br>
//! after <br>
//!   me = "Hello" <br>
Standard_EXPORT   void RemoveAll(const Standard_Character C,const Standard_Boolean CaseSensitive) ;

//! Removes every <what> characters from <me>. <br>
Standard_EXPORT   void RemoveAll(const Standard_Character what) ;

//! Erases <ahowmany> characters from position <where>, <br>
//! <where> included. <br>
//!  Example: <br>
//!   aString contains "Hello" <br>
//!   aString.Remove(2,2) erases 2 characters from position 2 <br>
//! This gives "Hlo". <br>
Standard_EXPORT   void Remove(const Standard_Integer where,const Standard_Integer ahowmany = 1) ;

//! Removes all space characters at the end of the string. <br>
Standard_EXPORT   void RightAdjust() ;

//! Right justify. <br>
//! Length becomes equal to Width and the new characters are <br>
//! equal to Filler. <br>
//! if Width < Length nothing happens. <br>
//! Raises an exception if Width is less than zero. <br>
//!  Example: <br>
//! before <br>
//!   me = "abcdef" , Width = 9 , Filler = ' ' <br>
//! after <br>
//!   me = "   abcdef" <br>
Standard_EXPORT   void RightJustify(const Standard_Integer Width,const Standard_Character Filler) ;

//! Searches a CString in <me> from the beginning <br>
//! and returns position of first item <what> matching. <br>
//! it returns -1 if not found. <br>
//!  Example: <br>
//!  aString contains "Sample single test" <br>
//!  aString.Search("le") returns 5 <br>
Standard_EXPORT   Standard_Integer Search(const Standard_CString what) const;

//! Searches an AsciiString in <me> from the beginning <br>
//! and returns position of first item <what> matching. <br>
//! It returns -1 if not found. <br>
Standard_EXPORT   Standard_Integer Search(const TCollection_AsciiString& what) const;

//! Searches a CString in a AsciiString from the end <br>
//! and returns position of first item <what> matching. <br>
//! It returns -1 if not found. <br>
//!  Example: <br>
//!  aString contains "Sample single test" <br>
//!  aString.SearchFromEnd("le") returns 12 <br>
Standard_EXPORT   Standard_Integer SearchFromEnd(const Standard_CString what) const;

//! Searches a AsciiString in another AsciiString from the end <br>
//! and returns position of first item <what> matching. <br>
//! It returns -1 if not found. <br>
Standard_EXPORT   Standard_Integer SearchFromEnd(const TCollection_AsciiString& what) const;

//! Replaces one character in the AsciiString at position <where>. <br>
//! If <where> is less than zero or greater than the length of <me> <br>
//! an exception is raised. <br>
//!  Example: <br>
//! aString contains "Garbake" <br>
//! astring.Replace(6,'g')  gives <me> = "Garbage" <br>
Standard_EXPORT   void SetValue(const Standard_Integer where,const Standard_Character what) ;

//! Replaces a part of <me> by a CString. <br>
//! If <where> is less than zero or greater than the length of <me> <br>
//! an exception is raised. <br>
//!  Example: <br>
//!  aString contains "abcde" <br>
//!  aString.SetValue(4,"1234567") gives <me> = "abc1234567" <br>
Standard_EXPORT   void SetValue(const Standard_Integer where,const Standard_CString what) ;

//! Replaces a part of <me> by another AsciiString. <br>
Standard_EXPORT   void SetValue(const Standard_Integer where,const TCollection_AsciiString& what) ;

//! Splits a AsciiString into two sub-strings. <br>
//!  Example: <br>
//! aString contains "abcdefg" <br>
//! aString.Split(3) gives <me> = "abc" and returns "defg" <br>
Standard_EXPORT   TCollection_AsciiString Split(const Standard_Integer where) ;
//! Creation of a sub-string of the string <me>. <br>
//! The sub-string starts to the index Fromindex and ends <br>
//! to the index ToIndex. <br>
//! Raises an exception if ToIndex or FromIndex is out of bounds <br>
//!  Example: <br>
//! before <br>
//!   me = "abcdefg", ToIndex=3, FromIndex=6 <br>
//! after <br>
//!   me = "abcdefg" <br>
//! returns <br>
//!   "cdef" <br>
  TCollection_AsciiString SubString(const Standard_Integer FromIndex,const Standard_Integer ToIndex) const;
//! Returns pointer to AsciiString (char *). <br>
//! This is useful for some casual manipulations. <br>
//!  Warning: Because this "char *" is 'const', you can't modify its contents. <br>
  Standard_CString ToCString() const;

//! Extracts <whichone> token from <me>. <br>
//! By default, the <separators> is set to space and tabulation. <br>
//! By default, the token extracted is the first one (whichone = 1). <br>
//! <separators> contains all separators you need. <br>
//! If no token indexed by <whichone> is found, it returns empty AsciiString. <br>
//!  Example: <br>
//!    aString contains "This is a     message" <br>
//!    aString.Token()  returns "This" <br>
//!    aString.Token(" ",4) returns "message" <br>
//!    aString.Token(" ",2) returns "is" <br>
//!    aString.Token(" ",9) returns "" <br>
//! Other separators than space character and tabulation are allowed : <br>
//!    aString contains "1234; test:message   , value" <br>
//!    aString.Token("; :,",4) returns "value" <br>
//!    aString.Token("; :,",2) returns "test" <br>
Standard_EXPORT   TCollection_AsciiString Token(const Standard_CString separators = " \t",const Standard_Integer whichone = 1) const;

//! Truncates <me> to <ahowmany> characters. <br>
//!  Example:  me = "Hello Dolly" -> Trunc(3) -> me = "Hel" <br>
Standard_EXPORT   void Trunc(const Standard_Integer ahowmany) ;

//! Converts <me> to its upper-case equivalent. <br>
Standard_EXPORT   void UpperCase() ;

//! Length of the string ignoring all spaces (' ') and the <br>
//! control character at the end. <br>
Standard_EXPORT   Standard_Integer UsefullLength() const;

//! Returns character at position <where> in <me>. <br>
//! If <where> is less than zero or greater than the lenght of <me>, <br>
//! an exception is raised. <br>
//!  Example: <br>
//!    aString contains "Hello" <br>
//!    aString.Value(2) returns 'e' <br>
Standard_EXPORT   Standard_Character Value(const Standard_Integer where) const;
//! Hash function for AsciiString <br>
//!  (returns the same Integer value that the hash function for ExtendedString) <br>
static  Standard_Integer HashCode(const TCollection_AsciiString& astring,const Standard_Integer Upper) ;
//! Returns True  when the two  strings are the same. <br>
//!          (Just for HashCode for AsciiString) <br>
static  Standard_Boolean IsEqual(const TCollection_AsciiString& string1,const TCollection_AsciiString& string2) ;
//! Returns True  when the two  strings are the same. <br>
//!          (Just for HashCode for AsciiString) <br>
static  Standard_Boolean IsEqual(const TCollection_AsciiString& string1,const Standard_CString string2) ;
//! Hash function for AsciiString no case sensitive <br>
static  Standard_Integer HASHCODE(const TCollection_AsciiString& astring,const Standard_Integer Upper) ;

//! Returns True  when the two  strings are the same <br>
//!          (no case sensitive). <br>
//!          (Just for HashCode for AsciiString) <br>
Standard_EXPORT static  Standard_Boolean ISSIMILAR(const TCollection_AsciiString& string1,const TCollection_AsciiString& string2) ;


friend class TCollection_HAsciiString;



protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Split(const Standard_Integer where,TCollection_AsciiString& result) ;


Standard_EXPORT   void SubString(const Standard_Integer FromIndex,const Standard_Integer ToIndex,TCollection_AsciiString& result) const;


Standard_EXPORT   void Token(const Standard_CString separators,const Standard_Integer whichone,TCollection_AsciiString& result) const;


 // Fields PRIVATE
 //
Standard_PCharacter mystring;
Standard_Integer mylength;


};


#include <TCollection_AsciiString.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
