// TopologyTransformationsDoc.cpp : implementation of the CTopologyTransformationsDoc class
//

#include "stdafx.h"

#include "TopologyTransformationsDoc.h"

#include "TopologyTransformationsApp.h"
#include "ResultDialog.h"

#include "ISession_Direction.h"
#include "..\res\resource.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>


/////////////////////////////////////////////////////////////////////////////
// CTopologyTransformationsDoc

IMPLEMENT_DYNCREATE(CTopologyTransformationsDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyTransformationsDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CTopologyTransformationsDoc)
	ON_COMMAND(ID_MIRROR, OnMirror)
	ON_COMMAND(ID_MIRRORAXIS, OnMirroraxis)
	ON_COMMAND(ID_ROTATE, OnRotate)
	ON_COMMAND(ID_SCALE, OnScale)
	ON_COMMAND(ID_TRANSLATION, OnTranslation)
	ON_COMMAND(ID_DISPLACEMENT, OnDisplacement)
	ON_COMMAND(ID_DEFORM, OnDeform)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyTransformationsDoc construction/destruction

CTopologyTransformationsDoc::CTopologyTransformationsDoc()
{
	myAISContext->SetDisplayMode(AIS_Shaded,Standard_False);
}

CTopologyTransformationsDoc::~CTopologyTransformationsDoc()
{
}
 
void CTopologyTransformationsDoc::OnMirror() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	gp_Trsf theTransformation;
	gp_Pnt PntCenterOfTheTransformation(110,60,60);
	Handle(AIS_Point) aispnt = new AIS_Point(new Geom_CartesianPoint(PntCenterOfTheTransformation));
	myAISContext->Display(aispnt,Standard_False);
	theTransformation.SetMirror(PntCenterOfTheTransformation);
	BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);
	TopoDS_Shape S2 = myBRepTransformation.Shape();
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();
    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.); \n\
gp_Trsf theTransformation; \n\
gp_Pnt PntCenterOfTheTransformation(110,60,60); \n\
theTransformation.SetMirror(PntCenterOfTheTransformation);\n\
BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepTransformation.Shape();	\n");
	PocessTextInDialog("Transform a Shape with Mirror and One point.", Message);
	
}

void CTopologyTransformationsDoc::OnMirroraxis() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	gp_Trsf theTransformation;
	gp_Ax1 axe = gp_Ax1(gp_Pnt(110,60,60),gp_Dir(0.,1.,0.));
	Handle(Geom_Axis1Placement) Gax1 = new Geom_Axis1Placement(axe);
	Handle (AIS_Axis) ax1 = new AIS_Axis(Gax1);
	myAISContext->Display(ax1,Standard_False);
	theTransformation.SetMirror(axe);
	BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);
	TopoDS_Shape S2 = myBRepTransformation.Shape();
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.); \n\
gp_Trsf theTransformation; \n\
gp_Ax1 Axis = gp_Ax1(gp_Pnt(110,60,60),gp_Dir(0.,1.,0.)); \n\
theTransformation.SetMirror(Axis);\n\
BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepTransformation.Shape();	\n");

	PocessTextInDialog("Transform a Shape with Mirror and One axis.", Message);

}


void CTopologyTransformationsDoc::OnRotate() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	gp_Trsf theTransformation;
	gp_Ax1 axe = gp_Ax1(gp_Pnt(200,60,60),gp_Dir(0.,1.,0.));
	Handle(Geom_Axis1Placement) Gax1 = new Geom_Axis1Placement(axe);
	Handle (AIS_Axis) ax1 = new AIS_Axis(Gax1);
	myAISContext->Display(ax1,Standard_False);
	theTransformation.SetRotation(axe,30*PI/180);
	BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);
	TopoDS_Shape S2 = myBRepTransformation.Shape();
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.); \n\
gp_Trsf theTransformation; \n\
gp_Ax1 Axis = gp_Ax1(gp_Pnt(200,60,60),gp_Dir(0.,1.,0.)); \n\
theTransformation.SetRotation(Axis,30*PI/180); // Rotation of 30 degrees \n\
BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepTransformation.Shape();	\n");

	PocessTextInDialog("Transform a Shape with Rotation.", Message);
	
}

void CTopologyTransformationsDoc::OnScale() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	gp_Trsf theTransformation;
	gp_Pnt theCenterOfScale(200,60,60);
	Handle(AIS_Point) aispnt = new AIS_Point(new Geom_CartesianPoint(theCenterOfScale));

	myAISContext->Display(aispnt,Standard_False);
	theTransformation.SetScale(theCenterOfScale,0.5);
	BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);
	TopoDS_Shape S2 = myBRepTransformation.Shape();

	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.); \n\
gp_Trsf theTransformation; \n\
gp_Pnt theCenterOfScale(200,60,60); \n\
theTransformation.SetScale(theCenterOfScale,0.5); // Scale : value = 0.5 \n\
BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepTransformation.Shape();	\n");

	PocessTextInDialog("Scale a Shape with One point.", Message);
	

}



void CTopologyTransformationsDoc::OnTranslation() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(6.,10.,8.,2.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);
	myAISContext->Display(ais1,Standard_False);
	gp_Trsf theTransformation;
	gp_Vec theVectorOfTranslation(-6,-6,6);
 
	Handle (ISession_Direction) aDirection1 = new ISession_Direction(gp_Pnt(0,0,0),theVectorOfTranslation);
	myAISContext->Display(aDirection1,Standard_False);

	theTransformation.SetTranslation(theVectorOfTranslation);
	BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);
	TopoDS_Shape S2 = myBRepTransformation.Shape();

	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);

	Fit();

    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(6.,10.,8.,2.); \n\
gp_Trsf theTransformation; \n\
gp_Vec theVectorOfTranslation(6,6,6); \n\
theTransformation.SetTranslation(theVectorOfTranslation); \n\
BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepTransformation.Shape();	\n");

	PocessTextInDialog("Translate a Shape with One vector.", Message);
	
}

void CTopologyTransformationsDoc::OnDisplacement() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	gp_Trsf theTransformation;

	gp_Ax3 ax3_1(gp_Pnt(0,0,0),gp_Dir(0,0,1));
	gp_Ax3 ax3_2(gp_Pnt(60,60,60),gp_Dir(1,1,1));

	theTransformation.SetDisplacement(ax3_1,ax3_2);
	BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);
	TopoDS_Shape TransformedShape = myBRepTransformation.Shape();
	Handle(AIS_Shape) ais2 = new AIS_Shape(TransformedShape);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();
    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.); \n\
gp_Trsf theTransformation; \n\
gp_Ax3 ax3_1(gp_Pnt(0,0,0),gp_Dir(0,0,1)); \n\
gp_Ax3 ax3_2(gp_Pnt(60,60,60),gp_Dir(1,1,1)); \n\
theTransformation.SetDisplacement(ax3_1,ax3_2); \n\
BRepBuilderAPI_Transform myBRepTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepTransformation.Shape();	\n");

	PocessTextInDialog("Displace a Shape with Two coordinate systems.", Message);
	
	
}


void CTopologyTransformationsDoc::OnDeform() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); 
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);

	gp_GTrsf theTransformation;
	gp_Mat rot(1, 0, 0, 0, 0.5, 0, 0, 0, 1.5);
	theTransformation.SetVectorialPart(rot);
	theTransformation.SetTranslationPart(gp_XYZ(5,5,5));

	BRepBuilderAPI_GTransform myBRepTransformation(S,theTransformation);
	TopoDS_Shape S2 = myBRepTransformation.Shape();

	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_BLUE1,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();
    TCollection_AsciiString Message ("\
\n\
TopoDS_Shape S = BRepBuilderAPI_MakeWedge(60.,100.,80.,20.); \n\
gp_GTrsf theTransformation; \n\
gp_Mat rot(1, 0, 0, 0, 0.5, 0, 0, 0, 1.5); // scaling : 100% on X ; 50% on Y ; 150% on Z . \n\
theTransformation.SetVectorialPart(rot); \n\
theTransformation.SetTranslationPart(gp_XYZ(5,5,5)); \n\
BRepBuilderAPI_GTransform myBRepGTransformation(S,theTransformation);\n\
TopoDS_Shape TransformedShape = myBRepGTransformation.Shape();	\n");

	PocessTextInDialog("Deform a Shape with One matrix of deformation and One translation.", Message);
}
