// 2DImageDoc.cpp : implementation of the C2DImageDoc class
//

#include "stdafx.h"

#include "2DImageDoc.h"

#include "2DImageApp.h"
#include "Sample2D_Image.h"

/////////////////////////////////////////////////////////////////////////////
// C2DImageDoc

IMPLEMENT_DYNCREATE(C2DImageDoc, OCC_2dDoc)

BEGIN_MESSAGE_MAP(C2DImageDoc, OCC_2dDoc)
	//{{AFX_MSG_MAP(C2DImageDoc)
	ON_COMMAND(ID_BUTTON_Test_MultiImages, OnBUTTONTestMultiImages)
	ON_COMMAND(ID_BUTTON_Test_Image, OnBUTTONTestImage)
	ON_COMMAND(ID_BUTTON_Erase, OnBUTTONErase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DImageDoc construction/destruction

C2DImageDoc::C2DImageDoc()
{
}

C2DImageDoc::~C2DImageDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// C2DImageDoc diagnostics

#ifdef _DEBUG
void C2DImageDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void C2DImageDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C2DImageDoc commands

void C2DImageDoc::OnBUTTONErase() 
{
   myAISInteractiveContext2D->EraseAll();
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Erase;
  TCollection_AsciiString Message("\
call :    \n\
   myAISInteractiveContext2D->EraseAll();");

  // Update The Result Dialog
  UpdateResultDialog(ID_BUTTON_Erase,Message);
}





void C2DImageDoc::OnBUTTONTestMultiImages() 
{
  CFileDialog dlg(TRUE,
                  NULL,
                  NULL,
                  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
                  "image Files (*.bmp , *.gif , *.xwd)|*.bmp; *.gif; *.xwd; | all files (*.*)|*.*;||", 
                  NULL );

  CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
  initdir += "\\Data";

  dlg.m_ofn.lpstrInitialDir = initdir;
  

  if (dlg.DoModal() == IDOK) 
  {
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
    CString filename = dlg.GetPathName();
    Standard_CString aFileName = (Standard_CString)(LPCTSTR)filename;
    {  // 1
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(40,50) ;
    anImage->SetTypeOfPlacement(Aspect_CP_SouthEast) ;
	anImage->SetIsZoomable(Standard_True);

    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);  
    }
    {  // 2
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(50,50) ;
    anImage->SetTypeOfPlacement(Aspect_CP_SouthWest) ;
	anImage->SetIsZoomable(Standard_True);

    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);     
    }
    {  // 3
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(40,40) ;
    anImage->SetTypeOfPlacement(Aspect_CP_NorthEast) ;
	anImage->SetIsZoomable(Standard_True);

    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);  
    }
    {  // 4
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(50,40) ;
    anImage->SetTypeOfPlacement(Aspect_CP_NorthWest) ;
	anImage->SetIsZoomable(Standard_True);

    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);  
    }
    {  // 5
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(80,45) ;
    anImage->SetTypeOfPlacement(Aspect_CP_West) ;
	anImage->SetIsZoomable(Standard_True);
	anImage->SetScale(2);
    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);  
    }
    {  // 6 : Non Zoomable 
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(20,-20) ;
    anImage->SetTypeOfPlacement(Aspect_CP_NorthWest) ;

	anImage->SetIsZoomable(Standard_False);

    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);  
    }
    {  // 7 : Non Zoomable
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(0,0) ;
    anImage->SetOffset(60,-20) ; // new zoom center
    anImage->SetTypeOfPlacement(Aspect_CP_NorthWest) ;
	anImage->SetScale(0.5);
	anImage->SetIsZoomable(Standard_False);

    myAISInteractiveContext2D->Display(anImage,           // Display object
                                       Standard_False);  
    }
    FitAll2DViews(Standard_True); // Update Viewer
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_MultiImages;
  TCollection_AsciiString Message(" \
create a set of Sample2D_Image and display it :    \n\
------------------------------------------------------------------------------ \n\
  CFileDialog dlg(TRUE, \n\
                  NULL, \n\
                  NULL, \n\
                  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, \n\
                  \"image Files (*.bmp , *.gif , *.xwd)|*.bmp; *.gif; *.xwd; | all files (*.*)|*.*;||\", \n\
                  NULL ); \n\
  if (dlg.DoModal() == IDOK)  \n\
  { \n\
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT)); \n\
    CString filename = dlg.GetPathName(); \n\
    Standard_CString aFileName = (Standard_CString)(LPCTSTR)filename; \n\
    {  // 1 \n\
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName); \n\
 \n\
    anImage->SetCoord(40,50) ; \n\
    anImage->SetTypeOfPlacement(Aspect_CP_SouthEast) ; \n\
	anImage->SetIsZoomable(Standard_True); \n\
 \n\
    myAISInteractiveContext2D->Display(anImage,           // object \n\
                                        Standard_False);  // Redraw \n\
    } \n\
    //... \n\
} \n\
------------------------------------------------------------------------------ \n\
   after that the system call the SetContext Methods :                    \n\
------------------------------------------------------------------------------ \n\
void Sample2D_Image::SetContext(const Handle(AIS2D_InteractiveContext) theContext)) \n\
{\n\
\n\
  if(theContext.IsNull() || theContext->CurrentViewer().IsNull()) return; \n\
\n\
  //Set AIS2D_InteractiveContext and default Graphic2d_View \n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
  Graphic2d_GraphicObject::SetView(theContext->CurrentViewer()->View()); \n\
\n\
  Handle(GraphicSample2D_ImageFile) aGraphic2dImageFile =\n\
    new GraphicSample2D_ImageFile (aGrObj,\n\
			                 myFile,\n\
			                 myX, \n\
			                 myY,\n\
			                 myDx,\n\
			                 myDy,\n\
			                 myTypeOfPlacement,\n\
			                 myScale); \n\
  if (myIsZoomable)\n\
    aGraphic2dImageFile->SetZoomable(Standard_True);\n\
}\n\n");
  // Update The Result Dialog
  UpdateResultDialog(filename,Message);
  }
}

void C2DImageDoc::OnBUTTONTestImage() 
{
  CFileDialog dlg(TRUE,
                  NULL,
                  NULL,
                  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
                  "image Files (*.bmp , *.gif , *.xwd)|*.bmp; *.gif; *.xwd; | all files (*.*)|*.*;||", 
                  NULL );

  CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
  initdir += "\\Data";

  dlg.m_ofn.lpstrInitialDir = initdir;
  
  if (dlg.DoModal() == IDOK) 
  {
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
    CString filename = dlg.GetPathName();
    Standard_CString aFileName = (Standard_CString)(LPCTSTR)filename;
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);

    anImage->SetCoord(0,0) ;
    anImage->SetTypeOfPlacement(Aspect_CP_Center) ;
	anImage->SetIsZoomable(Standard_True);

    myAISInteractiveContext2D->Display(anImage,           // object
                                    Standard_True);  // Redraw
  
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Image;
  TCollection_AsciiString Message(" \
create a Sample2D_Image and display it :    \n\
------------------------------------------------------------------------------ \n\
  CFileDialog dlg(TRUE,   \n\
                       NULL,                                         \n\
                        NULL,                         \n\
                        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,\n\
                  \"image Files (*.bmp , *.gif , *.xwd)|*.bmp; *.gif; *.xwd; | all files (*.*)|*.*;||\", \n\
                             NULL );\n\
  if (dlg.DoModal() == IDOK) \n\
  {\n\
    SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));\n\
    CString filename = dlg.GetPathName();\n\
    Standard_CString aFileName = (Standard_CString)(LPCTSTR)filename;\n\
    Handle(Sample2D_Image) anImage = new Sample2D_Image(aFileName);\n\
\n\
    anImage->SetCoord(0,0) ;\n\
    anImage->SetTypeOfPlacement(Aspect_CP_Center) ;\n\
	anImage->SetIsZoomable(Standard_True);\n\
\n\
    myAISInteractiveContext2D->Display(anImage,           // Display object\n\
                                         Standard_True);  \n\
  }\n\
------------------------------------------------------------------------------ \n\
   after that the system call the SetContext method :                    \n\
------------------------------------------------------------------------------ \n\
void Sample2D_Image::SetContext(const Handle(AIS2D_InteractiveContext) theContext)) \n\
{\n\
  //Set AIS2D_InteractiveContext and default Graphic2d_View \n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
  Graphic2d_GraphicObject::SetView(theContext->CurrentViewer()->View()); \n\
\n\
  Handle(GraphicSample2D_ImageFile) aGraphic2dImageFile =\n\
    new GraphicSample2D_ImageFile (aGrObj,\n\
			                 myFile,\n\
			                 myX, \n\
			                 myY,\n\
			                 myDx,\n\
			                 myDy,\n\
			                 myTypeOfPlacement,\n\
			                 myScale); \n\
  if (myIsZoomable)\n\
    aGraphic2dImageFile->SetZoomable(Standard_True);\n\
}\n\n");

  // Update The Result Dialog
  UpdateResultDialog(filename,Message);
  }
}




