// DisplayAnimationDoc.h : interface of the CDisplayAnimationDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DISPLAYANIMATIONDOC_H__79840E86_1001_11D2_B8C1_0000F87A77C1__INCLUDED_)
#define AFX_DISPLAYANIMATIONDOC_H__79840E86_1001_11D2_B8C1_0000F87A77C1__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#include "AIS_ConnectedInteractive.hxx"
#include "Geom_Transformation.hxx"


class CDisplayAnimationDoc : public CDocument
{
public:

    void DragEvent      (const Standard_Integer  x       ,
	    			     const Standard_Integer  y       ,
		    		     const Standard_Integer  TheState,
                         const Handle(V3d_View)& aView   );
    void InputEvent     (const Standard_Integer  x       ,
	    			     const Standard_Integer  y       ,
                         const Handle(V3d_View)& aView   );  
    void MoveEvent      (const Standard_Integer  x       ,
                         const Standard_Integer  y       ,
                         const Handle(V3d_View)& aView   ); 
    void ShiftMoveEvent (const Standard_Integer  x       ,
                         const Standard_Integer  y       ,
                         const Handle(V3d_View)& aView   ); 
    void ShiftDragEvent (const Standard_Integer  x       ,
	    				 const Standard_Integer  y       ,
		    			 const Standard_Integer  TheState,
                         const Handle(V3d_View)& aView   ); 
    void ShiftInputEvent(const Standard_Integer  x       ,
	    				 const Standard_Integer  y       ,
                         const Handle(V3d_View)& aView   ); 
    void Popup          (const Standard_Integer  x       ,
		    			 const Standard_Integer  y       ,
                         const Handle(V3d_View)& aView   ); 

protected: // create from serialization only
	CDisplayAnimationDoc();
	DECLARE_DYNCREATE(CDisplayAnimationDoc)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDisplayAnimationDoc)
	public:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDisplayAnimationDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CDisplayAnimationDoc)
	afx_msg void OnShading();
	afx_msg void OnThread();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public :



private:
  Handle_V3d_Viewer myViewer;
  Handle_AIS_InteractiveContext myAISContext;
public :
  	Handle_AIS_InteractiveContext& GetAISContext(){ return myAISContext; };
	Handle_V3d_Viewer GetViewer()  { return myViewer; };



private :
	Handle_AIS_Shape myAisCrankArm     ;
	Handle_AIS_Shape myAisCylinderHead ;
	Handle_AIS_Shape myAisPropeller    ;
	Handle_AIS_Shape myAisPiston       ;
	Handle_AIS_Shape myAisEngineBlock  ;

	Standard_Real     myDeviation;
	Standard_Integer  myAngle;

public :
	void OnMyTimer();
	Standard_Integer myCount;
	Standard_Integer thread;

};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DISPLAYANIMATIONDOC_H__79840E86_1001_11D2_B8C1_0000F87A77C1__INCLUDED_)
