/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLTOKEN_HXX
#define _XMLOFF_XMLTOKEN_HXX

#include "sal/config.h"
#include "xmloff/dllapi.h"
#include <sal/types.h>

namespace rtl { class OUString; }


/**
 * Handling of tokens in XML:
 *
 * This header defines te enum ::xmloff::token::XMLTokenEnum containing one
 * value for every fixed string used in our XML files.
 *
 * Usage:
 * To obtain an OUString for a token, use the GetXMLToken() function.
 * To test equality of an OUString and a token, use IsXMLToken().
 * Additionally, XMLTokenEnum values may be passed to SvXMLExport::AddAttribute
 * methods and the SvXMLElementExport constructor.
 */

namespace xmloff { namespace token {


    /**
     * The enumeration of all XML tokens.
     */
    enum XMLTokenEnum
    {
        XML_TOKEN_START = 0,
        XML_TOKEN_INVALID = XML_TOKEN_START,

        // common xml
        XML_CDATA,
        XML_WS,
        XML_XML,
        XML_XMLNS,
        XML_XML_PI,
        XML_XML_DOCTYPE_PREFIX,
        XML_XML_DOCTYPE_SUFFIX,

        // namespace prefixes and names
        XML_N_XML,
        XML_NP_OFFICE,
        XML_N_OFFICE,
        XML_N_OFFICE_OLD,
        XML_NP_META,
        XML_N_META,
        XML_N_META_OLD,
        XML_NP_STYLE,
        XML_N_STYLE,
        XML_N_STYLE_OLD,
        XML_NP_NUMBER,
        XML_N_NUMBER,
        XML_N_NUMBER_OLD,
        XML_NP_TEXT,
        XML_N_TEXT,
        XML_N_TEXT_OLD,
        XML_NP_TABLE,
        XML_N_TABLE,
        XML_N_TABLE_OLD,
        XML_NP_DRAW,
        XML_N_DRAW,
        XML_NP_DR3D,
        XML_N_DR3D,
        XML_N_DRAW_OLD,
        XML_NP_PRESENTATION,
        XML_N_PRESENTATION,
        XML_N_PRESENTATION_OLD,
        XML_NP_CHART,
        XML_N_CHART,
        XML_NP_CONFIG,
        XML_N_CONFIG,
        XML_N_CHART_OLD,
        XML_NP_FO,
        XML_N_FO_OLD,
        XML_N_FO,
        XML_NP_XLINK,
        XML_N_XLINK,
        XML_N_XLINK_OLD,
        XML_NP_DC,
        XML_N_DC,
        XML_NP_SVG,
        XML_N_SVG,
        XML_NP_FORM,
        XML_N_FORM,
        XML_NP_SCRIPT,
        XML_N_SCRIPT,
        XML_NP_XFORMS_1_0,
        XML_N_XFORMS_1_0,
        XML_NP_XSD,
        XML_N_XSD,
        XML_NP_XSI,
        XML_N_XSI,

        XML_NP_BLOCK_LIST,
        XML_N_BLOCK_LIST,

        XML_NP_MATH,
        XML_N_MATH,

        XML_NP_VERSIONS_LIST,
        XML_N_VERSIONS_LIST,

        // erAck: 2008-04-09T20:02+0200  OpenFormula aka ODFF
        XML_NP_OF,
        XML_N_OF,

        // ODF 1.2 metadata: RDFa and GRDDL
        XML_NP_XHTML,
        XML_N_XHTML,
        XML_NP_GRDDL,
        XML_N_GRDDL,

        // ODF Enhanced namespaces
        XML_NP_OFFICE_EXT,
        XML_N_OFFICE_EXT,
        
        // units
        XML_UNIT_MM,
        XML_UNIT_M,
        XML_UNIT_KM,
        XML_UNIT_CM,
        XML_UNIT_PT,
        XML_UNIT_PC,
        XML_UNIT_FOOT,
        XML_UNIT_MILES,
        XML_UNIT_INCH,

        // any other
        XML_1,
        XML_10,
        XML_2,
        XML_3,
        XML_4,
        XML_5,
        XML_6,
        XML_7,
        XML_8,
        XML_9,
        XML_A_UPCASE,
        XML_I_UPCASE,
        XML_IBM437,
        XML_IBM850,
        XML_IBM860,
        XML_IBM861,
        XML_IBM863,
        XML_IBM865,
        XML_ISO_8859_1,
        XML_OLE2,
        XML__COLON,
        XML__EMPTY,
        XML__UNKNOWN_,

        XML_A,
        XML_ABBREVIATED_NAME,
        XML_ABOVE,
        XML_ABS,
        XML_ACCENT,
        XML_ACCENTUNDER,
        XML_ACCEPTANCE_STATE,
        XML_ACCEPTED,
        XML_ACTION,
        XML_ACTIVE,
        XML_ACTIVE_SPLIT_RANGE,
        XML_ACTIVE_TABLE,
        XML_ACTUATE,
        XML_ADD_IN,
        XML_ADD_IN_NAME,
        XML_ADDRESS,
        XML_ADJUSTMENT,
        XML_ALGORITHM,
        XML_ALIGN,
        XML_ALL,
        XML_ALLOW_EMPTY_CELL,
        XML_ALPHABETICAL_INDEX,
        XML_ALPHABETICAL_INDEX_AUTO_MARK_FILE,
        XML_ALPHABETICAL_INDEX_ENTRY_TEMPLATE,
        XML_ALPHABETICAL_INDEX_MARK,
        XML_ALPHABETICAL_INDEX_MARK_END,
        XML_ALPHABETICAL_INDEX_MARK_START,
        XML_ALPHABETICAL_INDEX_SOURCE,
        XML_ALPHABETICAL_SEPARATORS,
        XML_ALTERNATE,
        XML_AM_PM,
        XML_AMBIENT_COLOR,
        XML_ANCHOR_PAGE_NUMBER,
        XML_ANCHOR_TYPE,
        XML_AND,
        XML_ANIMATION,
        XML_ANIMATION_DELAY,
        XML_ANIMATION_DIRECTION,
        XML_ANIMATION_REPEAT,
        XML_ANIMATION_START_INSIDE,
        XML_ANIMATION_STEPS,
        XML_ANIMATION_STOP_INSIDE,
        XML_ANIMATIONS,
        XML_ANNOTATION,
        XML_ANNOTATIONS,
        XML_ANNOTE,
        XML_APPEAR,
        XML_APPLET,
        XML_APPLET_NAME,
        XML_APPLICATION_DATA,
        XML_APPLICATION_XML,
        XML_APPLY,
        XML_APPLY_STYLE_NAME,
        XML_AQUA,
        XML_ARC,
        XML_ARCCOS,
        XML_ARCHIVE,
        XML_ARCSIN,
        XML_ARCTAN,
        XML_AREA,
        XML_AREA_CIRCLE,
        XML_AREA_POLYGON,
        XML_AREA_RECTANGLE,
        XML_ARTICLE,
        XML_AS_CHAR,
        XML_ASCENDING,
        XML_ATTACHED_AXIS,
        XML_ATTRACTIVE,
        XML_AUTHOR,
        XML_AUTHOR_INITIALS,
        XML_AUTHOR_NAME,
        XML_AUTO,
        XML_AUTO_GROW_HEIGHT,
        XML_AUTO_GROW_WIDTH,
        XML_AUTO_RELOAD,
        XML_AUTO_TEXT,
        XML_AUTO_TEXT_EVENTS,
        XML_AUTO_TEXT_GROUP,
        XML_AUTO_TEXT_INDENT,
        XML_AUTO_UPDATE,
        XML_AUTOMATIC,
        XML_AUTOMATIC_FIND_LABELS,
        XML_AUTOMATIC_ORDER,
        XML_AUTOMATIC_STYLES,
        XML_AUTOMATIC_UPDATE,
        XML_AUTOSIZE,
        XML_AVERAGE,
        XML_AXIS,
        XML_BACK_SCALE,
        XML_BACKFACE_CULLING,
        XML_BACKGROUND,
        XML_BACKGROUND_COLOR,
        XML_BACKGROUND_IMAGE,
        XML_BACKGROUND_NO_REPEAT,
        XML_BACKGROUND_REPEAT,
        XML_BACKGROUND_STRETCH,
        XML_BAR,
        XML_BASE64BINARY,
        XML_BASE_CELL_ADDRESS,
        XML_BASELINE,
        XML_BEFORE_DATE_TIME,
        XML_BELOW,
        XML_BETWEEN_DATE_TIMES,
        XML_BEVEL,
        XML_BIBILIOGRAPHIC_TYPE,
        XML_BIBLIOGRAPHY,
        XML_BIBLIOGRAPHY_CONFIGURATION,
        XML_BIBLIOGRAPHY_DATA_FIELD,
        XML_BIBLIOGRAPHY_ENTRY_TEMPLATE,
        XML_BIBLIOGRAPHY_MARK,
        XML_BIBLIOGRAPHY_SOURCE,
        XML_BIBLIOGRAPHY_TYPE,
        XML_BIND_STYLES_TO_CONTENT,
        XML_BITMAP,
        XML_BLACK,
        XML_BLEND,
        XML_BLINKING,
        XML_BLOCK,
        XML_BLOCK_LIST,
        XML_BLUE,
        XML_BODY,
        XML_BOLD,
        XML_BOOK,
        XML_BOOKLET,
        XML_BOOKMARK,
        XML_BOOKMARK_END,
        XML_BOOKMARK_REF,
        XML_BOOKMARK_START,
        XML_BOOKTITLE,
        XML_BOOLEAN,
        XML_BOOLEAN_STYLE,
        XML_BOOLEAN_VALUE,
        XML_BORDER,
        XML_BORDER_BOTTOM,
        XML_BORDER_COLOR,
        XML_BORDER_LEFT,
        XML_BORDER_LINE_WIDTH,
        XML_BORDER_LINE_WIDTH_BOTTOM,
        XML_BORDER_LINE_WIDTH_LEFT,
        XML_BORDER_LINE_WIDTH_RIGHT,
        XML_BORDER_LINE_WIDTH_TOP,
        XML_BORDER_RIGHT,
        XML_BORDER_TOP,
        XML_BOTH,
        XML_BOTTOM,
        XML_BOTTOM_LEFT,
        XML_BOTTOM_PERCENT,
        XML_BOTTOM_RIGHT,
        XML_BOTTOM_VALUES,
        XML_BOTTOMARC,
        XML_BOTTOMCIRCLE,
        XML_BREAK_AFTER,
        XML_BREAK_BEFORE,
        XML_BREAK_INSIDE,
        XML_BUBBLE,
        XML_BULLET_CHAR,
        XML_BULLET_RELATIVE_SIZE,
        XML_BUTTON1,
        XML_BUTTON2,
        XML_BUTTON3,
        XML_BUTTON4,
        XML_BUTTONS,
        XML_BVAR,
        XML_C,
        XML_CALCULATION_SETTINGS,
        XML_CALENDAR,
        XML_CAPITALIZE_ENTRIES,
        XML_CAPTION,
        XML_CAPTION_POINT_X,
        XML_CAPTION_POINT_Y,
        XML_CAPTION_SEQUENCE_FORMAT,
        XML_CAPTION_SEQUENCE_NAME,
        XML_CASE_SENSITIVE,
        XML_CASEMAP_CAPITALIZE,
        XML_CASEMAP_LOWERCASE,
        XML_CASEMAP_NORMAL,
        XML_CASEMAP_SMALL_CAPS,
        XML_CASEMAP_UPPERCASE,
        XML_CATEGORIES,
        XML_CATEGORY,
        XML_CATEGORY_AND_VALUE,
        XML_CELL_ADDRESS,
        XML_CELL_CONTENT_CHANGE,
        XML_CELL_CONTENT_DELETION,
        XML_CELL_COUNT,
        XML_CELL_PROTECT,
        XML_CELL_RANGE_ADDRESS,
        XML_CELL_RANGE_ADDRESS_LIST,
        XML_CELL_RANGE_SOURCE,
        XML_CENTER,
        XML_CHAIN_NEXT_NAME,
        XML_CHANGE,
        XML_CHANGE_DELETION,
        XML_CHANGE_END,
        XML_CHANGE_ID,
        XML_CHANGE_INFO,
        XML_CHANGE_START,
        XML_CHANGE_TRACK_TABLE_CELL,
        XML_CHANGE_VIEW_CONDITIONS,
        XML_CHANGE_VIEW_SETTINGS,
        XML_CHANGED_REGION,
        XML_CHAPTER,
        XML_CHAR,
        XML_CHARACTER_COUNT,
        XML_CHART,
        XML_CHARTS,
        XML_CHECKERBOARD,
        XML_CHG_AUTHOR,
        XML_CHG_COMMENT,
        XML_CHG_DATE_TIME,
        XML_CI,
        XML_CIRCLE,
        XML_CITATION_BODY_STYLE_NAME,
        XML_CITATION_STYLE_NAME,
        XML_CLASS,
        XML_CLASS_ID,
        XML_CLIP,
        XML_CLOCKWISE,
        XML_CLOSE,
        XML_CLOSE_HORIZONTAL,
        XML_CLOSE_VERTICAL,
        XML_CM,
        XML_CN,
        XML_CODE,
        XML_CODEBASE,
        XML_COLLAPSE,
        XML_COLOR,
        XML_COLOR_INVERSION,
        XML_COLOR_MODE,
        XML_COLUMN,
        XML_COLUMN_COUNT,
        XML_COLUMN_GAP,
        XML_COLUMN_NAME,
        XML_COLUMN_SEP,
        XML_COLUMN_WIDTH,
        XML_COLUMNS,
        XML_COLUMNSPLIT_AUTO,
        XML_COLUMNSPLIT_AVOID,
        XML_COMBINE_ENTRIES,
        XML_COMBINE_ENTRIES_WITH_DASH,
        XML_COMBINE_ENTRIES_WITH_PP,
        XML_COMMA_SEPARATED,
        XML_COMMAND,
        XML_COMMENT,
        XML_COMPOSE,
        XML_COND_STYLE_NAME,
        XML_CONDITION,
        XML_CONDITION_SOURCE,
        XML_CONDITION_SOURCE_RANGE_ADDRESS,
        XML_CONDITIONAL_TEXT,
        XML_CONE,
        XML_CONFERENCE,
        XML_CONFIG_ITEM,
        XML_CONFIG_ITEM_MAP_ENTRY,
        XML_CONFIG_ITEM_MAP_INDEXED,
        XML_CONFIG_ITEM_MAP_NAMED,
        XML_CONFIG_ITEM_SET,
        XML_CONFIGURATION_SETTINGS,
        XML_CONJUGATE,
        XML_CONNECT_BARS,
        XML_CONNECTION_NAME,
        XML_CONNECTOR,
        XML_CONSECUTIVE_NUMBERING,
        XML_CONSOLIDATION,
        XML_CONSTANT,
        XML_CONTAINS_ERROR,
        XML_CONTAINS_HEADER,
        XML_CONTENT,
        XML_CONTENT_VALIDATION,
        XML_CONTENT_VALIDATION_NAME,
        XML_CONTENT_VALIDATIONS,
        XML_CONTINUE,
        XML_CONTINUE_NUMBERING,
        XML_CONTOUR_PATH,
        XML_CONTOUR_POLYGON,
        XML_CONTRAST,
        XML_CONTROL,
        XML_CONVERSION_MODE,
        XML_COPY_BACK,
        XML_COPY_FORMULAS,
        XML_COPY_OUTLINE_LEVELS,
        XML_COPY_RESULTS_ONLY,
        XML_COPY_STYLES,
        XML_CORNER_RADIUS,
        XML_CORRECT,
        XML_COS,
        XML_COSH,
        XML_COT,
        XML_COTH,
        XML_COUNT,
        XML_COUNT_EMPTY_LINES,
        XML_COUNT_IN_FLOATING_FRAMES,
        XML_COUNTER_CLOCKWISE,
        XML_COUNTERCLOCKWISE,
        XML_COUNTNUMS,
        XML_COUNTRY,
        XML_COUNTRY_ASIAN,
        XML_COUNTRY_COMPLEX,
        XML_COVERED_TABLE_CELL,
        XML_CREATE_DATE,
        XML_CREATE_DATE_STRING,
        XML_CREATION_DATE,
        XML_CREATION_TIME,
        XML_CREATOR,
        XML_CSC,
        XML_CSCH,
        XML_CUBE,
        XML_CUBOID,
        XML_CURRENCY,
        XML_CURRENCY_STYLE,
        XML_CURRENCY_SYMBOL,
        XML_CURRENT,
        XML_CURRENT_VALUE,
        XML_CURSOR_POSITION,
        XML_CURSOR_POSITION_X,
        XML_CURSOR_POSITION_Y,
        XML_CURVE,
        XML_CUSTOM1,
        XML_CUSTOM2,
        XML_CUSTOM3,
        XML_CUSTOM4,
        XML_CUSTOM5,
        XML_CUT,
        XML_CUT_OFFS,
        XML_CX,
        XML_CY,
        XML_CYLINDER,
        XML_D,
        XML_DASH,
        XML_DASHED,
        XML_DATA,
        XML_DATA_CELL_RANGE_ADDRESS,
        XML_DATA_LABEL_NUMBER,
        XML_DATA_LABEL_SYMBOL,
        XML_DATA_LABEL_TEXT,
        XML_DATA_PILOT_FIELD,
        XML_DATA_PILOT_LEVEL,
        XML_DATA_PILOT_MEMBER,
        XML_DATA_PILOT_MEMBERS,
        XML_DATA_PILOT_SUBTOTAL,
        XML_DATA_PILOT_SUBTOTALS,
        XML_DATA_PILOT_TABLE,
        XML_DATA_PILOT_TABLES,
        XML_DATA_POINT,
        XML_DATA_STYLE,
        XML_DATA_STYLE_NAME,
        XML_DATA_TYPE,
        XML_DATABASE_DISPLAY,
        XML_DATABASE_NAME,
        XML_DATABASE_NEXT,
        XML_DATABASE_RANGE,
        XML_DATABASE_RANGES,
        XML_DATABASE_ROW_NUMBER,
        XML_DATABASE_SELECT,
        XML_DATABASE_SOURCE_QUERY,
        XML_DATABASE_SOURCE_SQL,
        XML_DATABASE_SOURCE_TABLE,
        XML_DATE,
        XML_DATE_ADJUST,
        XML_DATE_STYLE,
        XML_DATE_TIME,
        XML_DATE_VALUE,
        XML_DATETIME,
        XML_DAY,
        XML_DAY_OF_WEEK,
        XML_DDE_APPLICATION,
        XML_DDE_CONNECTION,
        XML_DDE_CONNECTION_DECL,
        XML_DDE_CONNECTION_DECLS,
        XML_DDE_ITEM,
        XML_DDE_LINK,
        XML_DDE_LINKS,
        XML_DDE_SOURCE,
        XML_DDE_TOPIC,
        XML_DECIMAL_PLACES,
        XML_DECIMAL_REPLACEMENT,
        XML_DECLARE,
        XML_DECORATE_WORDS_ONLY,
        XML_DECORATIVE,
        XML_DEEP,
        XML_DEFAULT,
        XML_DEFAULT_CELL_STYLE_NAME,
        XML_DEFAULT_STYLE,
        XML_DEFAULT_STYLE_NAME,
        XML_DEGREE,
        XML_DELAY,
        XML_DELETION,
        XML_DELETIONS,
        XML_DEPENDENCE,
        XML_DEPENDENCES,
        XML_DEPENDENCIES,
        XML_DEPTH,
        XML_DESC,
        XML_DESCENDING,
        XML_DESCRIPTION,
        XML_DETECTIVE,
        XML_DETERMINANT,
        XML_DIFF,
        XML_DIFFUSE_COLOR,
        XML_DIM,
        XML_DIRECTION,
        XML_DISABLED,
        XML_DISC,
        XML_DISPLAY,
        XML_DISPLAY_BORDER,
        XML_DISPLAY_DETAILS,
        XML_DISPLAY_DUPLICATES,
        XML_DISPLAY_EMPTY,
        XML_DISPLAY_FILTER_BUTTONS,
        XML_DISPLAY_FORMULA,
        XML_DISPLAY_LABEL,
        XML_DISPLAY_LEVELS,
        XML_DISPLAY_NAME,
        XML_DISPLAY_OUTLINE_LEVEL,
        XML_DISSOLVE,
        XML_DISTANCE,
        XML_DISTANCE_AFTER_SEP,
        XML_DISTANCE_BEFORE_SEP,
        XML_DISTRIBUTE_LETTER,
        XML_DISTRIBUTE_SPACE,
        XML_DIVIDE,
        XML_DOCUMENT,
        XML_DOCUMENT_CONTENT,
        XML_DOCUMENT_META,
        XML_DOCUMENT_SETTINGS,
        XML_DOCUMENT_STATISTIC,
        XML_DOCUMENT_STYLES,
        XML_DOMAIN,
        XML_DOT,
        XML_DOTS1,
        XML_DOTS1_LENGTH,
        XML_DOTS2,
        XML_DOTS2_LENGTH,
        XML_DOTTED,
        XML_DOUBLE,
        XML_DOUBLE_SIDED,
        XML_DOWN,
        XML_DRAFT,
        XML_DRAW,
        XML_DRAW_ASPECT,
        XML_DRAWING,
        XML_DRAWINGS,
        XML_DRAWPOOL,
        XML_DROP_CAP,
        XML_DYNAMIC,
        XML_EDGE_ROUNDING,
        XML_EDITABLE,
        XML_EDITING_CYCLES,
        XML_EDITING_DURATION,
        XML_EDITION,
        XML_EDITOR,
        XML_EFFECT,
        XML_ELLIPSE,
        XML_EMAIL,
        XML_EMBED,
        XML_EMBEDDED_VISIBLE_AREA,
        XML_EMBOSSED,
        XML_EMISSIVE_COLOR,
        XML_EMPTY,
        XML_ENABLE_NUMBERING,
        XML_ENABLED,
        XML_ENCODING,
        XML_END,
        XML_END_ANGLE,
        XML_END_CELL_ADDRESS,
        XML_END_COLOR,
        XML_END_COLUMN,
        XML_END_GLUE_POINT,
        XML_END_GUIDE,
        XML_END_INTENSITY,
        XML_END_LINE_SPACING_HORIZONTAL,
        XML_END_LINE_SPACING_VERTICAL,
        XML_END_POSITION,
        XML_END_ROW,
        XML_END_SHAPE,
        XML_END_TABLE,
        XML_END_X,
        XML_END_Y,
        XML_ENDLESS,
        XML_ENDNOTE,
        XML_ENDNOTE_BODY,
        XML_ENDNOTE_CITATION,
        XML_ENDNOTE_REF,
        XML_ENDNOTES_CONFIGURATION,
        XML_ENGRAVED,
        XML_EQ,
        XML_EQUAL_AUTHOR,
        XML_EQUAL_COMMENT,
        XML_EQUAL_DATE,
        XML_ERA,
        XML_ERGO_SUM,
        XML_ERROR_CATEGORY,
        XML_ERROR_LOWER_INDICATOR,
        XML_ERROR_LOWER_LIMIT,
        XML_ERROR_MACRO,
        XML_ERROR_MARGIN,
        XML_ERROR_MESSAGE,
        XML_ERROR_PERCENTAGE,
        XML_ERROR_UPPER_INDICATOR,
        XML_ERROR_UPPER_LIMIT,
        XML_ESCAPEMENT_SUB,
        XML_ESCAPEMENT_SUPER,
        XML_EVEN_PAGE,
        XML_EVENT,
        XML_EVENT_NAME,
        XML_EVENTS,
        XML_EXECUTE,
        XML_EXECUTE_MACRO,
        XML_EXISTS,
        XML_EXP,
        XML_EXPONENTIAL,
        XML_EXPRESSION,
        XML_EXTRA,
        XML_EXTRUDE,
        XML_FACTORIAL,
        XML_FADE,
        XML_FADE_FROM_BOTTOM,
        XML_FADE_FROM_CENTER,
        XML_FADE_FROM_LEFT,
        XML_FADE_FROM_LOWERLEFT,
        XML_FADE_FROM_LOWERRIGHT,
        XML_FADE_FROM_RIGHT,
        XML_FADE_FROM_TOP,
        XML_FADE_FROM_UPPERLEFT,
        XML_FADE_FROM_UPPERRIGHT,
        XML_FADE_OUT,
        XML_FADE_TO_CENTER,
        XML_FALSE,
        XML_FAMILY,
        XML_FAST,
        XML_FIELD_NUMBER,
        XML_FILE_NAME,
        XML_FILL,
        XML_FILL_COLOR,
        XML_FILL_GRADIENT_NAME,
        XML_FILL_HATCH_NAME,
        XML_FILL_HATCH_SOLID,
        XML_FILL_IMAGE,
        XML_FILL_IMAGE_HEIGHT,
        XML_FILL_IMAGE_NAME,
        XML_FILL_IMAGE_REF_POINT,
        XML_FILL_IMAGE_REF_POINT_X,
        XML_FILL_IMAGE_REF_POINT_Y,
        XML_FILL_IMAGE_WIDTH,
        XML_FILTER,
        XML_FILTER_AND,
        XML_FILTER_CONDITION,
        XML_FILTER_NAME,
        XML_FILTER_OPTIONS,
        XML_FILTER_OR,
        XML_FIRST_DATE_TIME,
        XML_FIRST_PAGE,
        XML_FIRST_PAGE_NUMBER,
        XML_FIT_TO_CONTOUR,
        XML_FIT_TO_SIZE,
        XML_FIX,
        XML_FIXED,
        XML_FLAT,
        XML_FLOAT,
        XML_FLOATING_FRAME,
        XML_FLOOR,
        XML_FN,
        XML_FOCAL_LENGTH,
        XML_FONT_CHAR_WIDTH,
        XML_FONT_CHARSET,
        XML_FONT_CHARSET_ASIAN,
        XML_FONT_CHARSET_COMPLEX,
        XML_FONT_COLOR,
        XML_FONT_DECL,
        XML_FONT_DECLS,
        XML_FONT_FAMILY,
        XML_FONT_FAMILY_ASIAN,
        XML_FONT_FAMILY_COMPLEX,
        XML_FONT_FAMILY_GENERIC,
        XML_FONT_FAMILY_GENERIC_ASIAN,
        XML_FONT_FAMILY_GENERIC_COMPLEX,
        XML_FONT_KERNING,
        XML_FONT_NAME,
        XML_FONT_NAME_ASIAN,
        XML_FONT_NAME_COMPLEX,
        XML_FONT_PITCH,
        XML_FONT_PITCH_ASIAN,
        XML_FONT_PITCH_COMPLEX,
        XML_FONT_RELIEF,
        XML_FONT_SIZE,
        XML_FONT_SIZE_ASIAN,
        XML_FONT_SIZE_COMPLEX,
        XML_FONT_SIZE_REL,
        XML_FONT_SIZE_REL_ASIAN,
        XML_FONT_SIZE_REL_COMPLEX,
        XML_FONT_STYLE,
        XML_FONT_STYLE_ASIAN,
        XML_FONT_STYLE_COMPLEX,
        XML_FONT_STYLE_NAME,
        XML_FONT_STYLE_NAME_ASIAN,
        XML_FONT_STYLE_NAME_COMPLEX,
        XML_FONT_VARIANT,
        XML_FONT_WEIGHT,
        XML_FONT_WEIGHT_ASIAN,
        XML_FONT_WEIGHT_COMPLEX,
        XML_FONT_WIDTH,
        XML_FONT_WORD_LINE_MODE,
        XML_FONTFAMILY,
        XML_FONTSIZE,
        XML_FONTSTYLE,
        XML_FONTWEIGHT,
        XML_FONTWORK_ADJUST,
        XML_FONTWORK_DISTANCE,
        XML_FONTWORK_FORM,
        XML_FONTWORK_HIDE_FORM,
        XML_FONTWORK_MIRROR,
        XML_FONTWORK_OUTLINE,
        XML_FONTWORK_SHADOW,
        XML_FONTWORK_SHADOW_COLOR,
        XML_FONTWORK_SHADOW_OFFSET_X,
        XML_FONTWORK_SHADOW_OFFSET_Y,
        XML_FONTWORK_SHADOW_TRANSPARENCE,
        XML_FONTWORK_START,
        XML_FONTWORK_STYLE,
        XML_FOOTER,
        XML_FOOTER_LEFT,
        XML_FOOTER_STYLE,
        XML_FOOTNOTE,
        XML_FOOTNOTE_BODY,
        XML_FOOTNOTE_CITATION,
        XML_FOOTNOTE_CONTINUATION_NOTICE_BACKWARD,
        XML_FOOTNOTE_CONTINUATION_NOTICE_FORWARD,
        XML_FOOTNOTE_MAX_HEIGHT,
        XML_FOOTNOTE_REF,
        XML_FOOTNOTE_SEP,
        XML_FOOTNOTES_CONFIGURATION,
        XML_FOOTNOTES_POSITION,
        XML_FORALL,
        XML_FORCE_MANUAL,
        XML_FOREGROUND,
        XML_FOREIGN_OBJECT,
        XML_FORMAT_CHANGE,
        XML_FORMAT_SOURCE,
        XML_FORMS,
        XML_FORMULA,
        XML_FORMULA_HIDDEN,
        XML_FORMULAS,
        XML_FRACTION,
        XML_FRAME,
        XML_FRAME_CONTENT,
        XML_FRAME_DISPLAY_BORDER,
        XML_FRAME_DISPLAY_SCROLLBAR,
        XML_FRAME_END_MARGIN,
        XML_FRAME_MARGIN_HORIZONTAL,
        XML_FRAME_MARGIN_VERTICAL,
        XML_FRAME_NAME,
        XML_FRAME_START_MARGIN,
        XML_FREEZE,
        XML_FREEZE_POSITION,
        XML_FROM_ANOTHER_TABLE,
        XML_FROM_BOTTOM,
        XML_FROM_CENTER,
        XML_FROM_INSIDE,
        XML_FROM_LEFT,
        XML_FROM_LOWER_LEFT,
        XML_FROM_LOWER_RIGHT,
        XML_FROM_RIGHT,
        XML_FROM_SAME_TABLE,
        XML_FROM_TOP,
        XML_FROM_UPPER_LEFT,
        XML_FROM_UPPER_RIGHT,
        XML_FUCHSIA,
        XML_FULL,
        XML_FULL_SCREEN,
        XML_FUNCTION,
        XML_G,
        XML_GAMMA,
        XML_GAP,
        XML_GAP_WIDTH,
        XML_GCD,
        XML_GENERATOR,
        XML_GEQ,
        XML_GOURAUD,
        XML_GRADIENT,
        XML_GRADIENT_ANGLE,
        XML_GRADIENT_BORDER,
        XML_GRADIENT_STEP_COUNT,
        XML_GRADIENT_STYLE,
        XML_GRADIENTSTYLE_AXIAL,
        XML_GRADIENTSTYLE_ELLIPSOID,
        XML_GRADIENTSTYLE_LINEAR,
        XML_GRADIENTSTYLE_RADIAL,
        XML_GRADIENTSTYLE_RECTANGULAR,
        XML_GRADIENTSTYLE_SQUARE,
        XML_GRAND_TOTAL,
        XML_GRAPHIC,
        XML_GRAY,
        XML_GREEN,
        XML_GREYSCALE,
        XML_GRID,
        XML_GROOVE,
        XML_GROUP_BY_FIELD_NUMBER,
        XML_GROUP_NAME,
        XML_GROUPING,
        XML_GT,
        XML_GUIDE_DISTANCE,
        XML_GUIDE_OVERHANG,
        XML_H,
        XML_HANGING,
        XML_HAS_PERSISTENT_DATA,
        XML_HATCH,
        XML_HATCH_DISTANCE,
        XML_HATCH_STYLE,
        XML_HATCHSTYLE_DOUBLE,
        XML_HATCHSTYLE_SINGLE,
        XML_HATCHSTYLE_TRIPLE,
        XML_HEADER,
        XML_HEADER_LEFT,
        XML_HEADER_STYLE,
        XML_HEADERS,
        XML_HEIGHT,
        XML_HELP,
        XML_HELP_FILE_NAME,
        XML_HELP_ID,
        XML_HELP_MESSAGE,
        XML_HIDDEN,
        XML_HIDDEN_AND_PROTECTED,
        XML_HIDDEN_PARAGRAPH,
        XML_HIDDEN_TEXT,
        XML_HIDE,
        XML_HIDE_SHAPE,
        XML_HIDE_TEXT,
        XML_HIGHLIGHTED_RANGE,
        XML_HINT,
        XML_HORIZONTAL,
        XML_HORIZONTAL_LINES,
        // --> OD 2005-05-12 #i49139#
        // XML_HORIZONTAL_ON_LEFT_PAGES and XML_HORIZONTAL_ON_RIGHT_PAGES
        // are replaced by XML_HORIZONTAL_ON_EVEN and XML_HORIZONTAL_ON_ODD.
        // Usage is deprecated, but the old token are needed for the
        // OpenOffice.org file format import/export filter for the renaming
        XML_HORIZONTAL_ON_LEFT_PAGES,
        XML_HORIZONTAL_ON_RIGHT_PAGES,
        // <--
        XML_HORIZONTAL_POS,
        XML_HORIZONTAL_REL,
        XML_HORIZONTAL_SCROLLBAR_WIDTH,
        XML_HORIZONTAL_SEGMENTS,
        XML_HORIZONTAL_SPLIT_MODE,
        XML_HORIZONTAL_SPLIT_POSITION,
        XML_HORIZONTAL_STRIPES,
        XML_HOURS,
        XML_HOWPUBLISHED,
        XML_HREF,
        XML_HTML,
        XML_HYPERLINK_BEHAVIOUR,
        XML_HYPHENATE,
        XML_HYPHENATION_KEEP,
        XML_HYPHENATION_LADDER_COUNT,
        XML_HYPHENATION_PUSH_CHAR_COUNT,
        XML_HYPHENATION_REMAIN_CHAR_COUNT,
        XML_I,
        XML_ICON,
        XML_ID,
        XML_IDENT,
        XML_IDENTIFIER,
        XML_IDENTIFY_CATEGORIES,
        XML_IDEOGRAPH_ALPHA,
        XML_IGNORE_CASE,
        XML_IGNORE_EMPTY_ROWS,
        XML_ILLUSTRATION_INDEX,
        XML_ILLUSTRATION_INDEX_ENTRY_TEMPLATE,
        XML_ILLUSTRATION_INDEX_SOURCE,
        XML_IMAGE,
        XML_IMAGE_COUNT,
        XML_IMAGE_MAP,
        XML_IMPLIES,
        XML_IN,
        XML_IN_RANGE,
        XML_INBOOK,
        XML_INCOLLECTION,
        XML_INCREMENT,
        XML_INDEX,
        XML_INDEX_BODY,
        XML_INDEX_ENTRY_BIBLIOGRAPHY,
        XML_INDEX_ENTRY_CHAPTER,
        XML_INDEX_ENTRY_CHAPTER_NUMBER,
        XML_INDEX_ENTRY_LINK_END,
        XML_INDEX_ENTRY_LINK_START,
        XML_INDEX_ENTRY_PAGE_NUMBER,
        XML_INDEX_ENTRY_SPAN,
        XML_INDEX_ENTRY_TAB_STOP,
        XML_INDEX_ENTRY_TEMPLATE,
        XML_INDEX_ENTRY_TEXT,
        XML_INDEX_NAME,
        XML_INDEX_SCOPE,
        XML_INDEX_SOURCE_STYLE,
        XML_INDEX_SOURCE_STYLES,
        XML_INDEX_TITLE,
        XML_INDEX_TITLE_TEMPLATE,
        XML_INFORMATION,
        XML_INITIAL_CREATOR,
        XML_INPROCEEDINGS,
        XML_INSERTION,
        XML_INSERTION_CUT_OFF,
        XML_INSET,
        XML_INSIDE,
        XML_INSTITUTION,
        XML_INT,
        XML_INTENSITY,
        XML_INTERSECT,
        XML_INTERVAL,
        XML_INTERVAL_MAJOR,
        XML_INTERVAL_MINOR,
        XML_INTO_ENGLISH_NUMBER,
        XML_INVERSE,
        XML_IS_ACTIVE,
        XML_IS_DATA_LAYOUT_FIELD,
        XML_IS_HIDDEN,
        XML_IS_SELECTION,
        XML_ISBN,
        XML_ITALIC,
        XML_ITERATION,
        XML_JOURNAL,
        XML_JUSTIFIED,
        XML_JUSTIFY,
        XML_JUSTIFY_SINGLE_WORD,
        XML_KEEP_WITH_NEXT,
        XML_KERNING_NORMAL,
        XML_KEY,
        XML_KEY1,
        XML_KEY2,
        XML_KEYWORD,
        XML_KEYWORDS,
        XML_KIND,
        XML_KM,
        XML_LABEL,
        XML_LABEL_ARRANGEMENT,
        XML_LABEL_CELL_ADDRESS,
        XML_LABEL_CELL_RANGE_ADDRESS,
        XML_LABEL_RANGE,
        XML_LABEL_RANGES,
        XML_LAMBDA,
        XML_LANDSCAPE,
        XML_LANGUAGE,
        XML_LANGUAGE_ASIAN,
        XML_LANGUAGE_COMPLEX,
        XML_LASER,
        XML_LAST_COLUMN_SPANNED,
        XML_LAST_PAGE,
        XML_LAST_ROW_SPANNED,
        XML_LAYER,
        XML_LAYER_SET,
        XML_LEADER_CHAR,
        XML_LEFT,
        XML_LEFT_OUTSIDE,
        XML_LEFT_TOP_POSITION,
        XML_LEFTARC,
        XML_LEFTCIRCLE,
        XML_LEGEND,
        XML_LEGEND_POSITION,
        XML_LENGTH,
        XML_LEQ,
        XML_LET_TEXT,
        XML_KEEP_TEXT,
        XML_LETTER_KERNING,
        XML_LETTER_SPACING,
        XML_LETTERS,
        XML_LEVEL,
        XML_LIBRARY,
        XML_LIBRARY_EMBEDDED,
        XML_LIBRARY_LINKED,
        XML_LIGHT,
        XML_LIGHTING_MODE,
        XML_LIME,
        XML_LIMIT,
        XML_LINE,
        XML_LINE_BREAK,
        XML_LINE_DISTANCE,
        XML_LINE_HEIGHT,
        XML_LINE_HEIGHT_AT_LEAST,
        XML_LINE_NUMBER,
        XML_LINE_SKEW,
        XML_LINE_SPACING,
        XML_LINEAR,
        XML_LINENUMBERING_CONFIGURATION,
        XML_LINENUMBERING_SEPARATOR,
        XML_LINES,
        XML_LINES_USED,
        XML_LINK_TO_SOURCE_DATA,
        XML_LIST,
        XML_LIST_BLOCK,
        XML_LIST_HEADER,
        XML_LIST_INFO,
        XML_LIST_ITEM,
        XML_LIST_LEVEL,
        XML_LIST_LEVEL_STYLE_BULLET,
        XML_LIST_LEVEL_STYLE_IMAGE,
        XML_LIST_LEVEL_STYLE_NUMBER,
        XML_LIST_NAME,
        XML_LIST_STYLE,
        XML_LIST_STYLE_NAME,
        XML_LN,
        XML_LOCKED,
        XML_LOG,
        XML_LOGARITHMIC,
        XML_LOGBASE,
        XML_LONG,
        XML_LOWLIMIT,
        XML_LR_TB,
        XML_LT,
        XML_LTR,
        XML_LUMINANCE,
        XML_MACRO_NAME,
        XML_MACTION,
        XML_MAIN_ENTRY_STYLE_NAME,
        XML_MAJOR,
        XML_MALIGNGROUP,
        XML_MALIGNMARK,
        XML_MANUAL,
        XML_MAP,
        XML_MARGIN_BOTTOM,
        XML_MARGIN_LEFT,
        XML_MARGIN_RIGHT,
        XML_MARGIN_TOP,
        XML_MARGINS,
        XML_MARKER,
        XML_MARKER_END,
        XML_MARKER_END_CENTER,
        XML_MARKER_END_WIDTH,
        XML_MARKER_START,
        XML_MARKER_START_CENTER,
        XML_MARKER_START_WIDTH,
        XML_MAROON,
        XML_MASTER_PAGE,
        XML_MASTER_PAGE_NAME,
        XML_MASTER_STYLES,
        XML_MASTERSTHESIS,
        XML_MATCH,
        XML_MATH,
        XML_MATRIX,
        XML_MATRIX_COVERED,
        XML_MATRIXROW,
        XML_MAX,
        XML_MAX_EDGE,
        XML_MAX_HEIGHT,
        XML_MAX_WIDTH,
        XML_MAXIMUM,
        XML_MAXIMUM_DIFFERENCE,
        XML_MAY_BREAK_BETWEEN_ROWS,
        XML_MAY_SCRIPT,
        XML_MEAN,
        XML_MEAN_VALUE,
        XML_MEASURE,
        XML_MEASURE_ALIGN,
        XML_MEASURE_VERTICAL_ALIGN,
        XML_MEDIAN,
        XML_MEDIUM,
        XML_MERROR,
        XML_MESSAGE_TYPE,
        XML_META,
        XML_MFENCED,
        XML_MFRAC,
        XML_MI,
        XML_MIDDLE,
        XML_MIME_TYPE,
        XML_MIN,
        XML_MIN_DENOMINATOR_DIGITS,
        XML_MIN_EDGE,
        XML_MIN_EXPONENT_DIGITS,
        XML_MIN_HEIGHT,
        XML_MIN_INTEGER_DIGITS,
        XML_MIN_LABEL_DISTANCE,
        XML_MIN_LABEL_WIDTH,
        XML_MIN_LINE_HEIGHT,
        XML_MIN_NUMERATOR_DIGITS,
        XML_MIN_ROW_HEIGHT,
        XML_MIN_WIDTH,
        XML_MINIMUM,
        XML_MINOR,
        XML_MINUS,
        XML_MINUTES,
        XML_MIRROR,
        XML_MIRRORED,
        XML_MISC,
        XML_MITER,
        XML_MM,
        XML_MMULTISCRIPTS,
        XML_MN,
        XML_MO,
        XML_MODE,
        XML_MODERN,
        XML_MODIFICATION_DATE,
        XML_MODIFICATION_TIME,
        XML_MODULATE,
        XML_MODULE,
        XML_MOMENT,
        XML_MONO,
        XML_MONTH,
        XML_MOUSE_AS_PEN,
        XML_MOUSE_VISIBLE,
        XML_MOVE,
        XML_MOVE_FROM_BOTTOM,
        XML_MOVE_FROM_LEFT,
        XML_MOVE_FROM_RIGHT,
        XML_MOVE_FROM_TOP,
        XML_MOVE_PROTECT,
        XML_MOVE_SHORT,
        XML_MOVEMENT,
        XML_MOVEMENT_CUT_OFF,
        XML_MOVER,
        XML_MPADDED,
        XML_MPHANTOM,
        XML_MPRESCRIPTS,
        XML_MROOT,
        XML_MROW,
        XML_MS,
        XML_MSPACE,
        XML_MSQRT,
        XML_MSTYLE,
        XML_MSUB,
        XML_MSUBSUP,
        XML_MSUP,
        XML_MTABLE,
        XML_MTD,
        XML_MTEXT,
        XML_MTR,
        XML_MULTI_DELETION_SPANNED,
        XML_MUNDER,
        XML_MUNDEROVER,
        XML_NAME,
        XML_NAME_AND_EXTENSION,
        XML_NAMED_EXPRESSION,
        XML_NAMED_EXPRESSIONS,
        XML_NAMED_RANGE,
        XML_NAVY,
        XML_NEQ,
        XML_NEW,
        XML_NEXT,
        XML_NEXT_PAGE,
        XML_NEXT_STYLE_NAME,
        XML_NO_LIMIT,
        XML_NO_WRAP,
        XML_NOEMPTY,
        XML_NOHREF,
        XML_NOMATCH,
        XML_NONE,
        XML_NOPRTSUBSET,
        XML_NORMAL,
        XML_NORMALS_DIRECTION,
        XML_NORMALS_KIND,
        XML_NOT,
        XML_NOT_EQUAL_DATE,
        XML_NOTE,
        XML_NOTES,
        XML_NOTIN,
        XML_NOTSUBSET,
        XML_NULL_DATE,
        XML_NULL_YEAR,
        XML_NUM_FORMAT,
        XML_NUM_LETTER_SYNC,
        XML_NUM_PREFIX,
        XML_NUM_SUFFIX,
        XML_NUMBER,
        XML_NUMBER_AND_NAME,
        XML_NUMBER_COLUMNS_REPEATED,
        XML_NUMBER_COLUMNS_SPANNED,
        XML_NUMBER_LINES,
        XML_NUMBER_MATRIX_COLUMNS_SPANNED,
        XML_NUMBER_MATRIX_ROWS_SPANNED,
        XML_NUMBER_POSITION,
        XML_NUMBER_ROWS_REPEATED,
        XML_NUMBER_ROWS_SPANNED,
        XML_NUMBER_STYLE,
        XML_NUMBER_WRAPPED_PARAGRAPHS,
        XML_NUMBERED_ENTRIES,
        XML_OBJECT,
        XML_OBJECT_COUNT,
        XML_OBJECT_INDEX,
        XML_OBJECT_INDEX_ENTRY_TEMPLATE,
        XML_OBJECT_INDEX_SOURCE,
        XML_OBJECT_NAME,
        XML_OBJECT_OLE,
        XML_OBJECTS,
        XML_ODD_PAGE,
        XML_OFFSET,
        XML_OLIVE,
        XML_ONLOAD,
        XML_ONREQUEST,
        XML_ON_UPDATE_KEEP_SIZE,
        XML_ON_UPDATE_KEEP_STYLES,
        XML_ONLINE,
        XML_ONLINE_TEXT,
        XML_OPAQUE_BACKGROUND,
        XML_OPAQUE_FOREGROUND,
        XML_OPEN,
        XML_OPEN_HORIZONTAL,
        XML_OPEN_VERTICAL,
        XML_OPERATION,
        XML_OPERATOR,
        XML_OPTIMAL,
        XML_OR,
        XML_ORDER,
        XML_ORDERED_LIST,
        XML_ORGANIZATIONS,
        XML_ORIENTATION,
        XML_ORIENTATION_LANDSCAPE,
        XML_ORIENTATION_PORTRAIT,
        XML_ORIGIN,
        XML_ORPHANS,
        XML_OUTLINE_LEVEL,
        XML_OUTLINE_LEVEL_STYLE,
        XML_OUTLINE_STYLE,
        XML_OUTSET,
        XML_OUTSIDE,
        XML_OVERLAP,
        XML_P,
        XML_PACKAGE_NAME,
        XML_PADDING,
        XML_PADDING_BOTTOM,
        XML_PADDING_LEFT,
        XML_PADDING_RIGHT,
        XML_PADDING_TOP,
        XML_PAGE,
        XML_PAGE_ADJUST,
        XML_PAGE_BREAKS_ON_GROUP_CHANGE,
        XML_PAGE_CONTENT,
        XML_PAGE_CONTINUATION_STRING,
        XML_PAGE_COUNT,
        XML_PAGE_END_MARGIN,
        XML_PAGE_HEIGHT,
        XML_PAGE_MASTER,
        XML_PAGE_MASTER_NAME,
        XML_PAGE_NUMBER,
        XML_PAGE_START_MARGIN,
        XML_PAGE_STYLE_NAME,
        XML_PAGE_THUMBNAIL,
        XML_PAGE_USAGE,
        XML_PAGE_VARIABLE_GET,
        XML_PAGE_VARIABLE_SET,
        XML_PAGE_VIEW_ZOOM_VALUE,
        XML_PAGE_WIDTH,
        XML_PAGES,
        XML_PAPER_TRAY_NUMBER,
        XML_PARAGRAPH,
        XML_PARAGRAPH_CONTENT,
        XML_PARAGRAPH_COUNT,
        XML_PARAGRAPH_END_MARGIN,
        XML_PARAGRAPH_START_MARGIN,
        XML_PARALLEL,
        XML_PARAM,
        XML_PARENT_STYLE_NAME,
        XML_PARSE_SQL_STATEMENT,
        XML_PARSED,
        XML_PARTIALDIFF,
        XML_PASSWORD,
        XML_PASSWORT,
        XML_PATH,
        XML_PATH_ID,
        XML_PAUSE,
        XML_PENDING,
        XML_PERCENTAGE,
        XML_PERCENTAGE_STYLE,
        XML_PERSPECTIVE,
        XML_PHDTHESIS,
        XML_PHONG,
        XML_PIE_OFFSET,
        XML_PLACEHOLDER,
        XML_PLACEHOLDER_TYPE,
        XML_PLACING,
        XML_PLAIN_NUMBER,
        XML_PLAIN_NUMBER_AND_NAME,
        XML_PLAY_FULL,
        XML_PLOT_AREA,
        XML_PLUGIN,
        XML_PLUS,
        XML_POINTS,
        XML_POLYGON,
        XML_POLYLINE,
        XML_POLYNOMIAL,
        XML_POOL_ID,
        XML_PORTRAIT,
        XML_POSITION,
        XML_POSITION_BOTTOM,
        XML_POSITION_LEFT,
        XML_POSITION_RIGHT,
        XML_POSITION_TOP,
        XML_POSTURE_ITALIC,
        XML_POSTURE_NORMAL,
        XML_POSTURE_OBLIQUE,
        XML_POWER,
        XML_PRECISION_AS_SHOWN,
        XML_PREFIX,
        XML_PRESENTATION,
        XML_PRESENTATION_CHART,
        XML_PRESENTATION_GRAPHIC,
        XML_PRESENTATION_NOTES,
        XML_PRESENTATION_OBJECT,
        XML_PRESENTATION_ORGCHART,
        XML_PRESENTATION_OUTLINE,
        XML_PRESENTATION_PAGE,
        XML_PRESENTATION_PAGE_LAYOUT,
        XML_PRESENTATION_PAGE_LAYOUT_NAME,
        XML_PRESENTATION_SUBTITLE,
        XML_PRESENTATION_TABLE,
        XML_PRESENTATION_TITLE,
        XML_PREVIOUS,
        XML_PREVIOUS_PAGE,
        XML_PRINT,
        XML_PRINT_CONTENT,
        XML_PRINT_DATE,
        XML_PRINT_ORIENTATION,
        XML_PRINT_PAGE_ORDER,
        XML_PRINT_RANGE,
        XML_PRINT_RANGES,
        XML_PRINT_TIME,
        XML_PRINTABLE,
        XML_PRINTED_BY,
        XML_PROCEEDINGS,
        XML_PRODUCT,
        XML_PROJECTION,
        XML_PROPERTIES,
        XML_PROTECT,
        XML_PROTECT_CONTENT,
        XML_PROTECT_POSITION,
        XML_PROTECT_SIZE,
        XML_PROTECTED,
        XML_PROTECTION_KEY,
        XML_PRSUBSET,
        XML_PUBLISHER,
        XML_PUNCTUATION_WRAP,
        XML_PURPLE,
        XML_PYRAMID,
        XML_QUARTER,
        XML_QUERY_NAME,
        XML_QUO_VADIS,
        XML_QUOTIENT,
        XML_R,
        XML_RADAR,
        XML_RANDOM,
        XML_RANGE_ADDRESS,
        XML_RANGE_USABLE_AS,
        XML_RECREATE_ON_EDIT,
        XML_RECT,
        XML_RED,
        XML_REF_NAME,
        XML_REFERENCE,
        XML_REFERENCE_END,
        XML_REFERENCE_FORMAT,
        XML_REFERENCE_MARK,
        XML_REFERENCE_MARK_END,
        XML_REFERENCE_MARK_START,
        XML_REFERENCE_REF,
        XML_REFERENCE_START,
        XML_REFERENCE_TYPE,
        XML_REFRESH_DELAY,
        XML_REGION_CENTER,
        XML_REGION_LEFT,
        XML_REGION_RIGHT,
        XML_REGISTER_TRUE,
        XML_REGISTER_TRUTH_REF_STYLE_NAME,
        XML_REGRESSION_TYPE,
        XML_REJECTED,
        XML_REJECTING_CHANGE_ID,
        XML_REJECTION,
        XML_REL_COLUMN_WIDTH,
        XML_REL_HEIGHT,
        XML_REL_WIDTH,
        XML_RELATIVE,
        XML_RELATIVE_TAB_STOP_POSITION,
        XML_RELN,
        XML_REM,
        XML_REMOVE_DEPENDENTS,
        XML_REMOVE_PRECEDENTS,
        XML_REPEAT,
        XML_REPEAT_COLUMN,
        XML_REPEAT_ROW,
        XML_REPEATED,
        XML_REPLACE,
        XML_REPORT_TYPE,
        XML_RESTART_ON_PAGE,
        XML_REVISION,
        XML_RIDGE,
        XML_RIGHT,
        XML_RIGHT_OUTSIDE,
        XML_RIGHTARC,
        XML_RIGHTCIRCLE,
        XML_RING,
        XML_ROLE,
        XML_ROLL_FROM_BOTTOM,
        XML_ROLL_FROM_LEFT,
        XML_ROLL_FROM_RIGHT,
        XML_ROMAN,
        XML_ROOT,
        XML_ROTATE,
        XML_ROTATION,
        XML_ROTATION_ALIGN,
        XML_ROTATION_ANGLE,
        XML_ROUND,
        XML_ROW,
        XML_ROW_HEIGHT,
        XML_ROW_NUMBER,
        XML_ROWS,
        XML_RUBY,
        XML_RUBY_ALIGN,
        XML_RUBY_BASE,
        XML_RUBY_POSITION,
        XML_RUBY_TEXT,
        XML_RUN_THROUGH,
        XML_RX,
        XML_RY,
        XML_S,
        XML_SCALE,
        XML_SCALE_MIN,
        XML_SCALE_TEXT,
        XML_SCALE_TO,
        XML_SCALE_TO_PAGES,
        XML_SCATTER,
        XML_SCENARIO,
        XML_SCENARIO_RANGES,
        XML_SCENE,
        XML_SCHOOL,
        XML_SCIENTIFIC_NUMBER,
        XML_SCORE_SPACES,
        XML_SCRIPT,
        XML_SCROLL,
        XML_SDEV,
        XML_SEARCH_CRITERIA_MUST_APPLY_TO_WHOLE_CELL,
        XML_SEC,
        XML_SECH,
        XML_SECOND_DATE_TIME,
        XML_SECONDS,
        XML_SECTION,
        XML_SECTION_DESC,
        XML_SECTION_NAME,
        XML_SECTION_SOURCE,
        XML_SELECT_PAGE,
        XML_SELECTOR,
        XML_SEMANTICS,
        XML_SEMI_AUTOMATIC,
        XML_SENDER_CITY,
        XML_SENDER_COMPANY,
        XML_SENDER_COUNTRY,
        XML_SENDER_EMAIL,
        XML_SENDER_FAX,
        XML_SENDER_FIRSTNAME,
        XML_SENDER_INITIALS,
        XML_SENDER_LASTNAME,
        XML_SENDER_PHONE_PRIVATE,
        XML_SENDER_PHONE_WORK,
        XML_SENDER_POSITION,
        XML_SENDER_POSTAL_CODE,
        XML_SENDER_STATE_OR_PROVINCE,
        XML_SENDER_STREET,
        XML_SENDER_TITLE,
        XML_SEP,
        XML_SEPARATION_CHARACTER,
        XML_SEPARATOR,
        XML_SEQUENCE,
        XML_SEQUENCE_DECL,
        XML_SEQUENCE_DECLS,
        XML_SEQUENCE_REF,
        XML_SERIES,
        XML_SERIES_SOURCE,
        XML_SERVER_MAP,
        XML_SET,
        XML_SETDIFF,
        XML_SETTINGS,
        XML_SHADE_MODE,
        XML_SHADOW,
        XML_SHADOW_COLOR,
        XML_SHADOW_OFFSET_X,
        XML_SHADOW_OFFSET_Y,
        XML_SHADOW_SLANT,
        XML_SHADOW_TRANSPARENCY,
        XML_SHAPE,
        XML_SHAPE_ID,
        XML_SHAPES,
        XML_SHEET_NAME,
        XML_SHININESS,
        XML_SHORT,
        XML_SHOW,
        XML_SHOW_ACCEPTED_CHANGES,
        XML_SHOW_CHANGES,
        XML_SHOW_CHANGES_BY_AUTHOR,
        XML_SHOW_CHANGES_BY_AUTHOR_NAME,
        XML_SHOW_CHANGES_BY_COMMENT,
        XML_SHOW_CHANGES_BY_COMMENT_TEXT,
        XML_SHOW_CHANGES_BY_DATETIME,
        XML_SHOW_CHANGES_BY_DATETIME_FIRST_DATETIME,
        XML_SHOW_CHANGES_BY_DATETIME_MODE,
        XML_SHOW_CHANGES_BY_DATETIME_SECOND_DATETIME,
        XML_SHOW_CHANGES_BY_RANGES,
        XML_SHOW_CHANGES_BY_RANGES_LIST,
        XML_SHOW_LOGO,
        XML_SHOW_REJECTED_CHANGES,
        XML_SHOW_SHAPE,
        XML_SHOW_TEXT,
        XML_SHOW_UNIT,
        XML_SHOWS,
        XML_SIDE_BY_SIDE,
        XML_SILVER,
        XML_SIMPLE,
        XML_SIN,
        XML_SINCE_DATE_TIME,
        XML_SINCE_SAVE,
        XML_SINH,
        XML_SIZE,
        XML_SIZE_PROTECT,
        XML_SLANT,
        XML_SLANT_X,
        XML_SLANT_Y,
        XML_SLIDE,
        XML_SLOW,
        XML_SOLID,
        XML_SOLID_TYPE,
        XML_SORT,
        XML_SORT_ASCENDING,
        XML_SORT_BY,
        XML_SORT_BY_POSITION,
        XML_SORT_GROUPS,
        XML_SORT_KEY,
        XML_SOUND,
        XML_SOURCE_CELL_RANGE,
        XML_SOURCE_CELL_RANGE_ADDRESSES,
        XML_SOURCE_FIELD_NAME,
        XML_SOURCE_NAME,
        XML_SOURCE_RANGE_ADDRESS,
        XML_SOURCE_SERVICE,
        XML_SPACE_BEFORE,
        XML_SPAN,
        XML_SPECULAR,
        XML_SPECULAR_COLOR,
        XML_SPEED,
        XML_SPHERE,
        XML_SPIRAL,
        XML_SPIRAL_IN,
        XML_SPIRAL_INWARD_LEFT,
        XML_SPIRAL_INWARD_RIGHT,
        XML_SPIRAL_OUT,
        XML_SPIRAL_OUTWARD_LEFT,
        XML_SPIRAL_OUTWARD_RIGHT,
        XML_SPIRALIN_LEFT,
        XML_SPIRALIN_RIGHT,
        XML_SPIRALOUT_LEFT,
        XML_SPIRALOUT_RIGHT,
        XML_SPLINES,
        XML_SPLIT,
        XML_SPLIT_COLUMN,
        XML_SPLIT_POSITION,
        XML_SPLIT_ROW,
        XML_SPREADSHEET,
        XML_SQL_STATEMENT,
        XML_STACKED,
        XML_STAGGER_EVEN,
        XML_STAGGER_ODD,
        XML_STANDARD,
        XML_STANDARD_DEVIATION,
        XML_STARBASIC,
        XML_START,
        XML_START_ANGLE,
        XML_START_COLOR,
        XML_START_COLUMN,
        XML_START_GLUE_POINT,
        XML_START_GUIDE,
        XML_START_INTENSITY,
        XML_START_LINE_SPACING_HORIZONTAL,
        XML_START_LINE_SPACING_VERTICAL,
        XML_START_NUMBERING_AT,
        XML_START_PAGE,
        XML_START_POSITION,
        XML_START_ROW,
        XML_START_SCALE,
        XML_START_SHAPE,
        XML_START_TABLE,
        XML_START_VALUE,
        XML_START_WITH_NAVIGATOR,
        XML_STATISTICS,
        XML_STATUS,
        XML_STAY_ON_TOP,
        XML_STDEV,
        XML_STDEVP,
        XML_STEPS,
        XML_STOCK,
        XML_STOCK_UPDOWN_BARS,
        XML_STOCK_WITH_VOLUME,
        XML_STOP,
        XML_STRETCH,
        XML_STRETCH_FROM_BOTTOM,
        XML_STRETCH_FROM_LEFT,
        XML_STRETCH_FROM_RIGHT,
        XML_STRETCH_FROM_TOP,
        XML_STRETCHY,
        XML_STRICT,
        XML_STRING,
        XML_STRING_VALUE,
        XML_STRING_VALUE_IF_FALSE,
        XML_STRING_VALUE_IF_TRUE,
        XML_STRIPES,
        XML_STROKE,
        XML_STROKE_COLOR,
        XML_STROKE_DASH,
        XML_STROKE_LINEJOIN,
        XML_STROKE_OPACITY,
        XML_STROKE_WIDTH,
        XML_STRUCTURE_PROTECTED,
        XML_STYLE,
        XML_STYLE_NAME,
        XML_STYLES,
        XML_STYLESHEET,
        XML_SUB_TABLE,
        XML_SUBJECT,
        XML_SUBSET,
        XML_SUBTITLE,
        XML_SUBTOTAL_FIELD,
        XML_SUBTOTAL_RULE,
        XML_SUBTOTAL_RULES,
        XML_SUFFIX,
        XML_SUM,
        XML_SWISS,
        XML_SYMBOL,
        XML_SYMBOL_HEIGHT,
        XML_SYMBOL_IMAGE_NAME,
        XML_SYMBOL_WIDTH,
        XML_SYSTEM,
        XML_TAB_STOP,
        XML_TAB_STOP_DISTANCE,
        XML_TAB_STOPS,
        XML_TABLE,
        XML_TABLE_BACKGROUND,
        XML_TABLE_CELL,
        XML_TABLE_CENTERING,
        XML_TABLE_COLUMN,
        XML_TABLE_COLUMN_GROUP,
        XML_TABLE_COLUMNS,
        XML_TABLE_COUNT,
        XML_TABLE_HEADER,
        XML_TABLE_HEADER_COLUMNS,
        XML_TABLE_HEADER_ROWS,
        XML_TABLE_INDEX,
        XML_TABLE_INDEX_ENTRY_TEMPLATE,
        XML_TABLE_INDEX_SOURCE,
        XML_TABLE_NAME,
        XML_TABLE_NUMBER_LIST,
        XML_TABLE_OF_CONTENT,
        XML_TABLE_OF_CONTENT_ENTRY_TEMPLATE,
        XML_TABLE_OF_CONTENT_SOURCE,
        XML_TABLE_PAGE,
        XML_TABLE_ROW,
        XML_TABLE_ROW_GROUP,
        XML_TABLE_ROWS,
        XML_TABLE_SOURCE,
        XML_TABLE_VIEW,
        XML_TABLES,
        XML_TAN,
        XML_TANH,
        XML_TARGET_CELL_ADDRESS,
        XML_TARGET_FRAME_NAME,
        XML_TARGET_RANGE_ADDRESS,
        XML_TB_RL,
        XML_TEAL,
        XML_TECHREPORT,
        XML_TEMPLATE,
        XML_TEMPLATE_NAME,
        XML_TENDSTO,
        XML_TEX_FILTER,
        XML_TEX_GENERATION_MODE_X,
        XML_TEX_GENERATION_MODE_Y,
        XML_TEX_KIND,
        XML_TEX_MODE,
        XML_TEXT,
        XML_TEXT_ALIGN,
        XML_TEXT_ALIGN_LAST,
        XML_TEXT_ALIGN_SOURCE,
        XML_TEXT_AUTOSPACE,
        XML_TEXT_BACKGROUND_COLOR,
        XML_TEXT_BLINKING,
        XML_TEXT_BOX,
        XML_TEXT_COMBINE,
        XML_TEXT_COMBINE_END_CHAR,
        XML_TEXT_COMBINE_START_CHAR,
        XML_TEXT_CONTENT,
        XML_TEXT_CROSSING_OUT,
        XML_TEXT_EMPHASIZE,
        XML_TEXT_GLOBAL,
        XML_TEXT_INDENT,
        XML_TEXT_INPUT,
        XML_TEXT_OUTLINE,
        XML_TEXT_POSITION,
        XML_TEXT_ROTATION_ANGLE,
        XML_TEXT_ROTATION_SCALE,
        XML_TEXT_SCALE,
        XML_TEXT_SHADOW,
        XML_TEXT_STYLE,
        XML_TEXT_TRANSFORM,
        XML_TEXT_UNDERLINE,
        XML_TEXT_UNDERLINE_COLOR,
        XML_TEXTAREA_HORIZONTAL_ALIGN,
        XML_TEXTAREA_VERTICAL_ALIGN,
        XML_TEXTUAL,
        XML_THICK,
        XML_THIN,
        XML_THREE_DIMENSIONAL,
        XML_THUMBNAIL,
        XML_TICK_MARKS_MAJOR_INNER,
        XML_TICK_MARKS_MAJOR_OUTER,
        XML_TICK_MARKS_MINOR_INNER,
        XML_TICK_MARKS_MINOR_OUTER,
        XML_TILE_REPEAT_OFFSET,
        XML_TIME,
        XML_TIME_ADJUST,
        XML_TIME_STYLE,
        XML_TIME_VALUE,
        XML_TIMES,
        XML_TITLE,
        XML_TO_ANOTHER_TABLE,
        XML_TO_BOTTOM,
        XML_TO_CENTER,
        XML_TO_LEFT,
        XML_TO_LOWER_LEFT,
        XML_TO_LOWER_RIGHT,
        XML_TO_RIGHT,
        XML_TO_TOP,
        XML_TO_UPPER_LEFT,
        XML_TO_UPPER_RIGHT,
        XML_TOC_MARK,
        XML_TOC_MARK_END,
        XML_TOC_MARK_START,
        XML_TOP,
        XML_TOP_LEFT,
        XML_TOP_PERCENT,
        XML_TOP_RIGHT,
        XML_TOP_VALUES,
        XML_TOPARC,
        XML_TOPCIRCLE,
        XML_TRACE_DEPENDENTS,
        XML_TRACE_ERRORS,
        XML_TRACE_PRECEDENTS,
        XML_TRACK_CHANGES,
        XML_TRACKED_CHANGES,
        XML_TRACKED_CHANGES_VIEW_SETTINGS,
        XML_TRANSFORM,
        XML_TRANSITION_ON_CLICK,
        XML_TRANSPARENCY,
        XML_TRANSPARENCY_NAME,
        XML_TRANSPARENT,
        XML_TRANSPOSE,
        XML_TRUE,
        XML_TRUNCATE_ON_OVERFLOW,
        XML_TTB,
        XML_TYPE,
        XML_DOT_DASH,
        XML_DOT_DOT_DASH,
        XML_LONG_DASH,
        XML_SINGLE,
        XML_SMALL_WAVE,
        XML_WAVE,
        XML_UNFORMATTED_TEXT,
        XML_UNION,
        XML_UNIT,
        XML_UNORDERED_LIST,
        XML_UNPUBLISHED,
        XML_UP,
        XML_UPLIMIT,
        XML_UPRIGHT,
        XML_URL,
        XML_USE_CAPTION,
        XML_USE_CELL_PROTECTION,
        XML_USE_CHART_OBJECTS,
        XML_USE_CONDITION,
        XML_USE_DRAW_OBJECTS,
        XML_USE_FLOATING_FRAMES,
        XML_USE_GRAPHICS,
        XML_USE_IMAGE_OBJECTS,
        XML_USE_INDEX_MARKS,
        XML_USE_INDEX_SOURCE_STYLES,
        XML_USE_KEYS_AS_ENTRIES,
        XML_USE_LABEL,
        XML_USE_MATH_OBJECTS,
        XML_USE_OBJECTS,
        XML_USE_OPTIMAL_COLUMN_WIDTH,
        XML_USE_OPTIMAL_ROW_HEIGHT,
        XML_USE_OTHER_OBJECTS,
        XML_USE_SPREADSHEET_OBJECTS,
        XML_USE_STYLES,
        XML_USE_TABLES,
        XML_USE_WINDOW_FONT_COLOR,
        XML_USED_HIERARCHY,
        XML_USER_DEFINED,
        XML_USER_FIELD_DECL,
        XML_USER_FIELD_DECLS,
        XML_USER_FIELD_GET,
        XML_USER_FIELD_INPUT,
        XML_USER_INDEX,
        XML_USER_INDEX_ENTRY_TEMPLATE,
        XML_USER_INDEX_MARK,
        XML_USER_INDEX_MARK_END,
        XML_USER_INDEX_MARK_START,
        XML_USER_INDEX_SOURCE,
        XML_USER_TRANSFORMED,
        XML_USERNAME,
        XML_VALUE,
        XML_VALUE_TYPE,
        XML_VALUES_CELL_RANGE_ADDRESS,
        XML_VAR,
        XML_VARIABLE,
        XML_VARIABLE_DECL,
        XML_VARIABLE_DECLS,
        XML_VARIABLE_GET,
        XML_VARIABLE_INPUT,
        XML_VARIABLE_SET,
        XML_VARIANCE,
        XML_VARP,
        XML_VECTOR,
        XML_VERB,
        XML_VERSION,
        XML_VERSION_ENTRY,
        XML_VERSION_LIST,
        XML_VERTICAL,
        XML_VERTICAL_ALIGN,
        XML_VERTICAL_LINES,
        XML_VERTICAL_POS,
        XML_VERTICAL_REL,
        XML_VERTICAL_SEGMENTS,
        XML_VERTICAL_SPLIT_MODE,
        XML_VERTICAL_SPLIT_POSITION,
        XML_VERTICAL_STRIPES,
        XML_VIEW,
        XML_VIEWBOX,
        XML_VIEW_ID,
        XML_VIEW_SETTINGS,
        XML_VISIBILITY,
        XML_VISIBLE,
        XML_VISIBLE_AREA,
        XML_VISIBLE_AREA_HEIGHT,
        XML_VISIBLE_AREA_LEFT,
        XML_VISIBLE_AREA_TOP,
        XML_VISIBLE_AREA_WIDTH,
        XML_VISITED_STYLE_NAME,
        XML_VOLATILE,
        XML_VOLUME,
        XML_VPN,
        XML_VRP,
        XML_VUP,
        XML_WALL,
        XML_WARNING,
        XML_WATERMARK,
        XML_WAVYLINE,
        XML_WAVYLINE_FROM_BOTTOM,
        XML_WAVYLINE_FROM_LEFT,
        XML_WAVYLINE_FROM_RIGHT,
        XML_WAVYLINE_FROM_TOP,
        XML_WEEK_OF_YEAR,
        XML_WEIGHT_BOLD,
        XML_WEIGHT_NORMAL,
        XML_WHITE,
        XML_WHOLE_PAGE,
        XML_WIDOWS,
        XML_WIDTH,
        XML_WORD,
        XML_WORD_COUNT,
        XML_WRAP,
        XML_WRAP_CONTOUR,
        XML_WRAP_CONTOUR_MODE,
        XML_WRAP_OPTION,
        XML_WRITING_MODE,
        XML_WWW,
        XML_X,
        XML_X1,
        XML_X2,
        XML_X_MAC_ROMAN,
        XML_X_SYMBOL,
        XML_X_SYSTEM,
        XML_XOR,
        XML_Y,
        XML_Y1,
        XML_Y2,
        XML_YEAR,
        XML_YELLOW,
        XML_ZERO_VALUES,
        XML_ZINDEX,
        XML_ZOOM_TYPE,
        XML_ZOOM_VALUE,

        XML_ENABLE,
        XML_USE_REGULAR_EXPRESSIONS,
        XML_DATA_SOURCE_HAS_LABELS,
        XML_LINK_DATA_STYLE_TO_SOURCE,
        XML_SORT_ALGORITHM,
        XML_STRAIGHT_LINE,
        XML_ANGLED_LINE,
        XML_ANGLED_CONNECTOR_LINE,
        XML_APPLICATION_X_WWW_FORM_URLENCODED,
        XML_MULTIPART_FORMDATA,
        XML_APPLICATION_TEXT,
        XML_GET,
        XML_POST,
        XML_QUERY,
        XML_PARENT,
        XML_RECORDS,
        XML_PUSH,
        XML_SUBMIT,
        XML_RESET,
        XML_VALUE_LIST,
        XML_SQL,
        XML_SQL_PASS_THROUGH,
        XML_TABLE_FIELDS,
        XML_UNCHECKED,
        XML_CHECKED,
        XML_UNKNOWN,

        XML_ROLL_FROM_TOP,

        XML_BINARY_DATA,
        XML_NOTIFY_ON_UPDATE_OF_TABLE,

        XML_0,
        XML_PLAY,
        XML_HANDOUT_MASTER,
        XML_TEXT_STYLE_NAME,
        XML_ESCAPE_DIRECTION,
        XML_GLUE_POINT,
        XML_PRIMARY_X,
        XML_SECONDARY_X,
        XML_PRIMARY_Y,
        XML_SECONDARY_Y,
        XML_PRIMARY_Z,

        XML_CAPTION_TYPE,
        XML_CAPTION_ANGLE_TYPE,
        XML_CAPTION_ANGLE,
        XML_CAPTION_GAP,
        XML_CAPTION_ESCAPE_DIRECTION,
        XML_CAPTION_ESCAPE,
        XML_CAPTION_LINE_LENGTH,
        XML_CAPTION_FIT_LINE_LENGTH,
        XML_FREE,

        XML_TRANSITION_TYPE,
        XML_TRANSITION_STYLE,
        XML_TRANSITION_SPEED,
        XML_DURATION,
        XML_BACKGROUND_SIZE,
        XML_BACKGROUND_OBJECTS_VISIBLE,
        XML_BACKGROUND_VISIBLE,

		XML_MOVE_FROM_UPPERLEFT,
		XML_MOVE_FROM_UPPERRIGHT,
		XML_MOVE_FROM_LOWERRIGHT,
		XML_MOVE_FROM_LOWERLEFT,
		XML_UNCOVER_TO_LEFT,
		XML_UNCOVER_TO_UPPERLEFT,
		XML_UNCOVER_TO_TOP,
		XML_UNCOVER_TO_UPPERRIGHT,
		XML_UNCOVER_TO_RIGHT,
		XML_UNCOVER_TO_LOWERRIGHT,
		XML_UNCOVER_TO_BOTTOM,
		XML_UNCOVER_TO_LOWERLEFT,
		XML_VERTICAL_CHECKERBOARD,
		XML_HORIZONTAL_CHECKERBOARD,
        XML_NOTIFY_ON_UPDATE_OF_RANGES,
		XML_BYTE,
        XML_MACRO,
        XML_LOCATION,
        XML_APPLICATION,
        XML_SYMBOL_IMAGE,
        XML_TEXT_OVERLAP,
        XML_SPLINE_ORDER,
        XML_SPLINE_RESOLUTION,

        XML_PAPER_TRAY_NAME,

        XML_COLUMN_MAPPING,
        XML_ROW_MAPPING,

        XML_TABLE_FORMULA,

		XML_EMBEDDED_TEXT,

        XML_MERGE_LAST_PARAGRAPH,

        XML_STOCK_LOSS_MARKER,
        XML_STOCK_GAIN_MARKER,
        XML_STOCK_RANGE_LINE,

        XML_RL_TB,
        XML_TB_LR,
        XML_LR,
        XML_RL,
        XML_TB,

        XML_LAYOUT_GRID_COLOR,
        XML_LAYOUT_GRID_LINES,
        XML_LAYOUT_GRID_BASE_HEIGHT,
        XML_LAYOUT_GRID_RUBY_HEIGHT,
        XML_LAYOUT_GRID_MODE,
        XML_LAYOUT_GRID_RUBY_BELOW,
        XML_LAYOUT_GRID_PRINT,
        XML_LAYOUT_GRID_DISPLAY,

		//text grid enhancement for better CJK support
		XML_DEFAULT_PAGE_LAYOUT,
		XML_LAYOUT_GRID_STANDARD_MODE,
		XML_LAYOUT_GRID_BASE_WIDTH,
		XML_LAYOUT_GRID_SNAP_TO_CHARS,

        XML_SNAP_TO_LAYOUT_GRID,
        XML_DONT_BALANCE_TEXT_COLUMNS,

		XML_GLYPH_ORIENTATION_VERTICAL,

		XML_MARKED_INVALID,

        XML_REGRESSION_CURVE,
        XML_ERROR_INDICATOR,

        XML_TABLE_TYPE,

        XML_DISPLAY_FACTOR,

        XML_TRANSLITERATION_FORMAT,
        XML_TRANSLITERATION_LANGUAGE,
        XML_TRANSLITERATION_COUNTRY,
        XML_TRANSLITERATION_STYLE,

        XML_KEY1_PHONETIC,
        XML_KEY2_PHONETIC,
        XML_STRING_VALUE_PHONETIC,

        XML_BACKGROUND_TRANSPARENCY,
        XML_BACKGROUND_IMAGE_TRANSPARENCY,

        XML_DYNAMIC_SPACING,
        XML_MAIN_ENTRY,

        XML_USE_OUTLINE_LEVEL,

		// #107245# New 3D properties which are possible for lathe and extrude 3d objects
		XML_CLOSE_FRONT,
		XML_CLOSE_BACK,

        XML_DROPDOWN,
        XML_CURRENT_SELECTED,

        XML_JOIN_BORDER,

        XML_DISPLAY_LIST,
        XML_NO,
        XML_UNSORTED,
        XML_SORTED_ASCENDING,
		XML_FONT_INDEPENDENT_LINE_SPACING,

		XML_DATABASE,
		XML_DATASOURCE,
		XML_QUERIES,
		XML_REPORTS,
		XML_REPORT,
		XML_AS_TEMPLATE,

		XML_CONNECTION_RESOURCE,
		XML_SUPPRESS_VERSION_COLUMNS,
		XML_JAVA_DRIVER_CLASS,
		XML_EXTENSION,
		XML_IS_FIRST_ROW_HEADER_LINE,
		XML_SHOW_DELETED,
		XML_IS_TABLE_NAME_LENGTH_LIMITED,
		XML_SYSTEM_DRIVER_SETTINGS,
		XML_ENABLE_SQL92_CHECK,
		XML_APPEND_TABLE_ALIAS_NAME,
		XML_PARAMETER_NAME_SUBSTITUTION,
		XML_IGNORE_DRIVER_PRIVILEGES,
		XML_BOOLEAN_COMPARISON_MODE,
		XML_USE_CATALOG,
		XML_BASE_DN,
		XML_MAX_ROW_COUNT,
		XML_LOGIN,
		XML_USER_NAME,
		XML_IS_PASSWORD_REQUIRED,
		XML_LOGIN_TIMEOUT,
		XML_DELIMITER,
		XML_FIELD,
		XML_DECIMAL,
		XML_THOUSAND,
		XML_TABLE_FILTER,
		XML_TABLE_FILTER_PATTERN,
		XML_TABLE_TYPE_FILTER,
		XML_AUTO_INCREMENT,
		XML_ADDITIONAL_COLUMN_STATEMENT,
		XML_ROW_RETRIEVING_STATEMENT,
		XML_DATA_SOURCE_SETTINGS,
		XML_DATA_SOURCE_SETTING,
		XML_DATA_SOURCE_SETTING_VALUE,
		XML_DATA_SOURCE_SETTING_IS_LIST,
		XML_DATA_SOURCE_SETTING_TYPE,
		XML_DATA_SOURCE_SETTING_NAME,
		XML_COMPONENT,
		XML_COMPONENT_COLLECTION,
		XML_QUERY_COLLECTION,
		XML_UPDATE_TABLE,
		XML_FILTER_STATEMENT,
		XML_ORDER_STATEMENT,
		XML_ESCAPE_PROCESSING,
		XML_KEYS,
		XML_INDICES,
		XML_TYPE_NAME,
		XML_PRECISION,
		XML_IS_NULLABLE,
		XML_IS_AUTOINCREMENT,
		XML_DEFAULT_VALUE,
		XML_REFERENCED_TABLE_NAME,
		XML_UPDATE_RULE,
		XML_DELETE_RULE,
		XML_KEY_COLUMNS,
		XML_KEY_COLUMN,
		XML_RELATED_COLUMN_NAME,
		XML_CATALOG_NAME,
		XML_IS_UNIQUE,
		XML_IS_CLUSTERED,
		XML_INDEX_COLUMNS,
		XML_INDEX_COLUMN,
		XML_IS_ASCENDING,
		XML_SCHEMA_NAME,
		XML_NP_DB,
		XML_N_DB,
		XML_APPLY_FILTER,
		XML_APPLY_ORDER,
        XML_AUTOMATIC_PRINT_RANGE,

        XML_SELECTION,
        XML_SELECTION_INDEXES,

        XML_SCALE_TO_X,
        XML_SCALE_TO_Y,

        XML_KEEP_TOGETHER,

		XML_USE_HEADER_NAME,
		XML_USE_FOOTER_NAME,
		XML_USE_DATE_TIME_NAME,
		XML_DISPLAY_HEADER,
		XML_DISPLAY_FOOTER,
		XML_DISPLAY_PAGE_NUMBER,
		XML_DISPLAY_DATE_TIME,
		XML_SOURCE,
		XML_CURRENT_DATE,

		XML_HEADER_DECL,
		XML_FOOTER_DECL,
		XML_DATE_TIME_DECL,

        XML_SELECTED_PAGE,

        // DVO, OD 01.10.2003 #i18732
        XML_FLOW_WITH_TEXT,

        XML_WITH_TAB, // #i21237#

		XML_CUSTOM_SHAPE,
		XML_ENGINE,
		XML_ENHANCED_GEOMETRY,
		XML_TEXT_ROTATE_ANGLE,
		XML_MIRROR_VERTICAL,
		XML_MIRROR_HORIZONTAL,
		XML_EXTRUSION_ALLOWED,
		XML_TEXT_PATH_ALLOWED,
		XML_CONCENTRIC_GRADIENT_FILL_ALLOWED,
		XML_EXTRUSION,
		XML_EXTRUSION_BRIGHTNESS,
		XML_EXTRUSION_DEPTH,
		XML_EXTRUSION_DIFFUSION,
		XML_EXTRUSION_NUMBER_OF_LINE_SEGMENTS,
		XML_EXTRUSION_LIGHT_FACE,
		XML_EXTRUSION_FIRST_LIGHT_HARSH,
		XML_EXTRUSION_SECOND_LIGHT_HARSH,
		XML_EXTRUSION_FIRST_LIGHT_LEVEL,
		XML_EXTRUSION_SECOND_LIGHT_LEVEL,
		XML_EXTRUSION_FIRST_LIGHT_DIRECTION,
		XML_EXTRUSION_SECOND_LIGHT_DIRECTION,
		XML_EXTRUSION_METAL,
		XML_EXTRUSION_ROTATION_ANGLE,
		XML_EXTRUSION_ROTATION_CENTER,
		XML_EXTRUSION_SHININESS,
		XML_EXTRUSION_SKEW,
		XML_EXTRUSION_SPECULARITY,
		XML_EXTRUSION_PROJECTION_MODE,
		XML_EXTRUSION_VIEWPOINT,
		XML_EXTRUSION_ORIGIN,
		XML_EXTRUSION_COLOR,
		XML_SECONDARY_FILL_COLOR,
		XML_ENHANCED_PATH,
		XML_PATH_STRETCHPOINT_X,
		XML_PATH_STRETCHPOINT_Y,
		XML_TEXT_AREAS,
		XML_GLUE_POINTS,
		XML_GLUE_POINT_TYPE,
		XML_GLUE_POINT_LEAVING_DIRECTIONS,
		XML_TEXT_PATH,
		XML_TEXT_PATH_MODE,
		XML_TEXT_PATH_SCALE,
		XML_TEXT_PATH_SAME_LETTER_HEIGHTS,
		XML_MODIFIERS,
		XML_EQUATION,
		XML_XSTRETCH,
		XML_YSTRETCH,
		XML_HASSTROKE,
		XML_HASFILL,
		XML_LOGWIDTH,
		XML_LOGHEIGHT,
		XML_HANDLE,
		XML_HANDLE_MIRROR_VERTICAL,
		XML_HANDLE_MIRROR_HORIZONTAL,
		XML_HANDLE_SWITCHED,
		XML_HANDLE_POSITION,
		XML_HANDLE_RANGE_X_MINIMUM,
		XML_HANDLE_RANGE_X_MAXIMUM,
		XML_HANDLE_RANGE_Y_MINIMUM,
		XML_HANDLE_RANGE_Y_MAXIMUM,
		XML_HANDLE_POLAR,
		XML_HANDLE_RADIUS_RANGE_MINIMUM,
		XML_HANDLE_RADIUS_RANGE_MAXIMUM,
		XML_RECTANGLE,
		XML_ROUNDRECTANGLE,
		XML_OVAL,
		XML_CLOUD,
		XML_BOUNDINGCUBE,
		XML_WIREFRAME,
		XML_SEGMENTS,
        XML_WORD_WRAP,

        XML_COLLAPSING,
        XML_SEPARATING,
        XML_BORDER_MODEL,

        XML_DATA_PILOT_FIELD_REFERENCE,
        XML_MEMBER_DIFFERENCE,
        XML_MEMBER_PERCENTAGE,
        XML_MEMBER_PERCENTAGE_DIFFERENCE,
        XML_RUNNING_TOTAL,
        XML_ROW_PERCENTAGE,
        XML_COLUMN_PERCENTAGE,
        XML_TOTAL_PERCENTAGE,
        XML_FIELD_NAME,
        XML_MEMBER_TYPE,
        XML_NAMED,
        XML_MEMBER_NAME,
        XML_DISPLAY_MEMBER_MODE,
        XML_MEMBER_COUNT,
        XML_DATA_FIELD,
        XML_DATA_PILOT_DISPLAY_INFO,
        XML_SORT_MODE,
        XML_DATA_PILOT_SORT_INFO,
        XML_ADD_EMPTY_LINES,
        XML_TABULAR_LAYOUT,
        XML_OUTLINE_SUBTOTALS_TOP,
        XML_OUTLINE_SUBTOTALS_BOTTOM,
        XML_LAYOUT_MODE,
        XML_DATA_PILOT_LAYOUT_INFO,

        XML_SYMBOL_COLOR,

        XML_3D,
        XML_IMAGE_POSITION,
        XML_IMAGE_ALIGN,

        XML_DIAGONAL_BL_TR,
        XML_DIAGONAL_BL_TR_WIDTH,
        XML_DIAGONAL_TL_BR,
        XML_DIAGONAL_TL_BR_WIDTH,
        XML_REPEAT_CONTENT,
        XML_SHRINK_TO_FIT,

        // OD 2004-05-05 #i28701#
        XML_WRAP_INFLUENCE_ON_POSITION,
        // --> OD 2004-10-18 #i35017# - tokens have been renamed and
        // <XML_ITERATIVE> has been added
        XML_ONCE_SUCCESSIVE,
        XML_ONCE_CONCURRENT,
        // <--

		// Names for OOo format only
        XML_N_OFFICE_OOO,
        XML_N_META_OOO,
        XML_N_STYLE_OOO,
        XML_N_NUMBER_OOO,
        XML_N_TEXT_OOO,
        XML_N_TABLE_OOO,
        XML_N_DRAW_OOO,
        XML_N_DR3D_OOO,
        XML_N_PRESENTATION_OOO,
        XML_N_CHART_OOO,
        XML_N_CONFIG_OOO,
        XML_N_FORM_OOO,
        XML_N_SCRIPT_OOO,

        XML_GLOBAL,
        XML_NOTE_CLASS,
        XML_NOTE_CITATION,
        XML_NOTE_BODY,
        XML_NOTES_CONFIGURATION,
        XML_NOTE_REF,
        XML_IS_SUB_TABLE,
        XML_PAGE_LAYOUT,
        XML_PAGE_LAYOUT_NAME,
		XML_GRAPHIC_PROPERTIES,
		XML_DRAWING_PAGE_PROPERTIES,
		XML_PAGE_LAYOUT_PROPERTIES,
		XML_HEADER_FOOTER_PROPERTIES,
		XML_TEXT_PROPERTIES,
		XML_PARAGRAPH_PROPERTIES,
		XML_RUBY_PROPERTIES,
		XML_SECTION_PROPERTIES,
		XML_TABLE_PROPERTIES,
		XML_TABLE_COLUMN_PROPERTIES,
		XML_TABLE_ROW_PROPERTIES,
		XML_TABLE_CELL_PROPERTIES,
		XML_LIST_LEVEL_PROPERTIES,
		XML_CHART_PROPERTIES,
		XML_DRAWING_PAGE,
		XML_GRAPHICS,
		XML_TAB,
		XML_TEXT_UNDERLINE_MODE,
		XML_TEXT_LINE_THROUGH_MODE,
        XML_CONTINUOUS,
        XML_SKIP_WHITE_SPACE,
        XML_SCRIPTS,
        XML_FONT_FACE_DECLS,
        XML_FONT_FACE,
        XML_FONT_ADORNMENTS,
        XML_INCH,
        XML_SPACE_AFTER,
        XML_START_INDENT,
        XML_END_INDENT,

        // chart Oasis format additions
        XML_INTERVAL_MINOR_DIVISOR,
        XML_DATE_STRING,

        XML_TEXT_UNDERLINE_STYLE,
        XML_TEXT_UNDERLINE_TYPE,
        XML_TEXT_UNDERLINE_WIDTH,

        XML_TEXT_OVERLINE_TYPE,
        XML_TEXT_OVERLINE_STYLE,
        XML_TEXT_OVERLINE_WIDTH,
        XML_TEXT_OVERLINE_COLOR,
		XML_TEXT_OVERLINE_MODE,

        XML_TEXT_LINE_THROUGH_STYLE,
        XML_TEXT_LINE_THROUGH_TYPE,
        XML_TEXT_LINE_THROUGH_WIDTH,
        XML_TEXT_LINE_THROUGH_TEXT,

        XML_LEADER_STYLE,
        XML_LEADER_TEXT,

		XML_BOLD_DOTTED,
		XML_BOLD_DASH,
		XML_BOLD_LONG_DASH,
		XML_BOLD_DOT_DASH,
		XML_BOLD_DOT_DOT_DASH,
		XML_BOLD_WAVE,
		XML_DOUBLE_WAVE,
		XML_DOUBLE_LINE,
		XML_THICK_LINE,
		XML_SINGLE_LINE,
		XML_SLASH,
		XML_TEXT_LINE_THROUGH_COLOR,
		XML_TEXT_LINE_THROUGH_TEXT_STYLE,
        XML_LEADER_COLOR,
        XML_LEADER_TYPE,
        XML_LEADER_WIDTH,
        XML_LEADER_TEXT_STYLE,

		XML_OPACITY,
		XML_OPACITY_NAME,
		XML_SHADOW_OPACITY,
        XML_ALWAYS,
        XML_COUNT_IN_TEXT_BOXES,

        XML_NP_OOO,
        XML_N_OOO,
        XML_NP_OOOW,
        XML_N_OOOW,
        XML_NP_OOOC,
        XML_N_OOOC,
        XML_NP_DOM,
        XML_N_DOM,

		XML_EVENT_LISTENERS,
		XML_EVENT_LISTENER,

		XML_FORM,
		XML_VOID,
		XML_PROPERTY,
		XML_PROPERTY_NAME,
		XML_LIST_PROPERTY,
		XML_LIST_VALUE,
		XML_COLUMN_STYLE_NAME,

		XML_TEXTAREA,
		XML_FIXED_TEXT,
		XML_FILE,
		XML_FORMATTED_TEXT,
		XML_BUTTON,
		XML_CHECKBOX,
		XML_RADIO,
		XML_LISTBOX,
		XML_COMBOBOX,
		XML_IMAGE_FRAME,
		XML_VALUE_RANGE,
		XML_GENERIC_CONTROL,
		XML_SERVICE_NAME,
		XML_PROPERTY_TYPE,
		XML_INTEGER,
		XML_PROPERTY_IS_VOID,
		XML_PROPERTY_IS_LIST,
		XML_PROPERTY_VALUE,
		XML_MIMETYPE,
        XML_DATABASE_ROW_SELECT,
        XML_CONTROL_IMPLEMENTATION,
        XML_INTERPOLATION,
        XML_CUBIC_SPLINE,
        XML_B_SPLINE,
		XML_N_DB_OASIS,

        XML_SHOW_FILTER_BUTTON,
        XML_DRILL_DOWN_ON_DOUBLE_CLICK,
        XML_GROUPED_BY,
        XML_DAYS,
        XML_MONTHS,
        XML_QUARTERS,
        XML_YEARS,
        XML_DATE_START,
        XML_DATE_END,
        XML_STEP,
        XML_IS_GROUP_FIELD,
        XML_DATA_PILOT_GROUPS,
        XML_DATA_PILOT_GROUP,

        XML_JAPANESE_CANDLE_STICK,
        XML_NAMED_SYMBOL,
        XML_DIAMOND,
        XML_ARROW_DOWN,
        XML_ARROW_UP,
        XML_ARROW_RIGHT,
        XML_ARROW_LEFT,
        XML_BOW_TIE,
        XML_HOURGLASS,
        XML_SYMBOL_NAME,
        XML_SYMBOL_TYPE,
		XML_IMAGE_OPACITY, // #i25616#

		XML_DEFAULT_OUTLINE_LEVEL,
        XML_SHOW_DETAILS,
        XML_SHOW_EMPTY,
        XML_ITERATIVE,
		XML_uX,
        XML_NP_DLG,
        XML_N_DLG,
        XML_SCRIPT_DATA,
        XML_LIBRARIES,
        XML_SOURCE_CODE,
        XML_READONLY,

        XML_Z,
        XML_DIMENSION,
        XML_VALIDATION_NAME,

        // XForms tokens
        // already defined: XML_ACTION, XML_VERSION, XML_ENCODING,
        //                  XML_REPLACE, XML_SEPARATOR, XML_TYPE, XML_ID
        XML_MODEL,
        XML_SCHEMA,
        XML_BIND,
        XML_INSTANCE,
        XML_SUBMISSION,
        XML_REF,
        XML_SRC,
        XML_METHOD,
        XML_NODESET,
        XML_INDENT,
        XML_OMIT_XML_DECLARATION,
        XML_STANDALONE,
        XML_CDATA_SECTION_ELEMENTS,
        XML_REQUIRED,
        XML_RELEVANT,
        XML_CALCULATE,
        XML_CONSTRAINT,
        XML_MAXOCCURS, // maxOccurs
        XML_MINOCCURS, // minOccurs
        XML_P3PTYPE,
        XML_MEDIATYPE,
        XML_INCLUDENAMESPACEPREFIXES,

        // XForms/XSD Schema; these tokens use innerWordCapitalization
        // (already defined: XML_SCHEMA, XML_LENGTH, XML_ID)
        XML_BASE,
        XML_TARGETNAMESPACE, // targetNamespace
        XML_SIMPLETYPE, // simpleType
        XML_RESTRICTION,
        XML_MAXLENGTH, // maxLength
        XML_MINLENGTH, // minLength
        XML_MININCLUSIVE, // minInclusive
        XML_MINEXCLUSIVE, // minExclusive
        XML_MAXINCLUSIVE, // maxInclusive
        XML_MAXEXCLUSIVE, // maxExclusive
        XML_PATTERN,
        XML_ENUMERATION,
        XML_WHITESPACE, // whiteSpace
        XML_TOTALDIGITS, // totalDigits
        XML_FRACTIONDIGITS, // fractionDigits
        XML_PRESERVE,
        XML_ANYURI, // anyURI
        XML_DATETIME_XSD, // dateTime
        XML_MAIN_ETRY, // #i28755#

		// SMIL
		XML_REMOVE,
		XML_HOLD,
		XML_TRANSITION,
		XML_INHERIT,
		XML_FILLDEFAULT,
		XML_RESTART,
		XML_RESTARTDEFAULT,
		XML_WHENNOTACTIVE,
		XML_NEVER,
		XML_ACCELERATE,
		XML_DECELERATE,
		XML_AUTOREVERSE,
		XML_INDEFINITE,
		XML_REPEATCOUNT,
		XML_REPEATDUR,
		XML_ENDSYNC,
		XML_FIRST,
		XML_LAST,
		XML_MEDIA,
		XML_DUR,
		XML_BEGIN,
		XML_WHOLE,
		XML_FROM,
		XML_TO,
		XML_BY,
		XML_VALUES,
		XML_KEYTIMES,
		XML_KEYSPLINES,
		XML_CALCMODE,
		XML_DISCRETE,
		XML_PACED,
		XML_SPLINE,
		XML_ACCUMULATE,
		XML_ADDITIVE,
		XML_MULTIPLY,
		XML_ANIMATE,
		XML_ANIMATEMOTION,
		XML_ANIMATETRANSFORM,
		XML_ANIMATECOLOR,
		XML_TRANSITIONFILTER,
		XML_ATTRIBUTENAME,

		XML_NP_SMIL,
		XML_N_SMIL,

		XML_NP_ANIMATION,
		XML_N_ANIMATION,

		XML_PAR,
		XML_SEQ,

		XML_TRANSLATE,
		XML_SKEWX,
		XML_SKEWY,

		XML_AUDIO,

		XML_COLOR_INTERPOLATION,
		XML_COLOR_INTERPOLATION_DIRECTION,
		XML_HSL,
		XML_RGB,

		XML_BARWIPE,
		XML_BOXWIPE,
		XML_FOURBOXWIPE,
		XML_BARNDOORWIPE,
		XML_DIAGONALWIPE,
		XML_BOWTIEWIPE,
		XML_MISCDIAGONALWIPE,
		XML_VEEWIPE,
		XML_BARNVEEWIPE,
		XML_ZIGZAGWIPE,
		XML_BARNZIGZAGWIPE,
		XML_IRISWIPE,
		XML_TRIANGLEWIPE,
		XML_ARROWHEADWIPE,
		XML_PENTAGONWIPE,
		XML_HEXAGONWIPE,
		XML_ELLIPSEWIPE,
		XML_EYEWIPE,
		XML_ROUNDRECTWIPE,
		XML_STARWIPE,
		XML_MISCSHAPEWIPE,
		XML_CLOCKWIPE,
		XML_PINWHEELWIPE,
		XML_SINGLESWEEPWIPE,
		XML_FANWIPE,
		XML_DOUBLEFANWIPE,
		XML_DOUBLESWEEPWIPE,
		XML_SALOONDOORWIPE,
		XML_WINDSHIELDWIPE,
		XML_SNAKEWIPE,
		XML_SPIRALWIPE,
		XML_PARALLELSNAKESWIPE,
		XML_BOXSNAKESWIPE,
		XML_WATERFALLWIPE,
		XML_PUSHWIPE,
		XML_SLIDEWIPE,
		XML_BLINDSWIPE,
		XML_RANDOMBARWIPE,
		XML_CHECKERBOARDWIPE,
		XML_ZOOM,

		XML_LEFTTORIGHT,
		XML_TOPTOBOTTOM,
		XML_TOPLEFT,
		XML_TOPRIGHT,
		XML_BOTTOMRIGHT,
		XML_BOTTOMLEFT,
		XML_TOPCENTER,
		XML_RIGHTCENTER,
		XML_BOTTOMCENTER,
		XML_LEFTCENTER,
		XML_CORNERSIN,
		XML_CORNERSOUT,
		XML_DIAGONALBOTTOMLEFT,
		XML_DIAGONALTOPLEFT,
		XML_DOUBLEBARNDOOR,
		XML_DOUBLEDIAMOND,
		XML_FOURPOINT,
		XML_FIVEPOINT,
		XML_SIXPOINT,
		XML_HEART,
		XML_KEYHOLE,
		XML_CLOCKWISETWELVE,
		XML_CLOCKWISETHREE,
		XML_CLOCKWISESIX,
		XML_CLOCKWISENINE,
		XML_TWOBLADEVERTICAL,
		XML_TWOBLADEHORIZONTAL,
		XML_FOURBLADE,
		XML_CLOCKWISETOP,
		XML_CLOCKWISERIGHT,
		XML_CLOCKWISEBOTTOM,
		XML_CLOCKWISELEFT,
		XML_CLOCKWISETOPLEFT,
		XML_COUNTERCLOCKWISEBOTTOMLEFT,
		XML_CLOCKWISEBOTTOMRIGHT,
		XML_COUNTERCLOCKWISETOPRIGHT,
		XML_CENTERTOP,
		XML_CENTERRIGHT,
		XML_FANOUTVERTICAL,
		XML_FANOUTHORIZONTAL,
		XML_FANINVERTICAL,
		XML_FANINHORIZONTAL,
		XML_PARALLELVERTICAL,
		XML_PARALLELDIAGONAL,
		XML_OPPOSITEVERTICAL,
		XML_OPPOSITEHORIZONTAL,
		XML_PARALLELDIAGONALTOPLEFT,
		XML_PARALLELDIAGONALBOTTOMLEFT,
		XML_TOPLEFTHORIZONTAL,
		XML_TOPLEFTDIAGONAL,
        XML_TOPLEFTVERTICAL,
		XML_TOPRIGHTDIAGONAL,
		XML_BOTTOMRIGHTDIAGONAL,
		XML_BOTTOMLEFTDIAGONAL,
		XML_TOPLEFTCLOCKWISE,
		XML_TOPRIGHTCLOCKWISE,
		XML_BOTTOMRIGHTCLOCKWISE,
		XML_BOTTOMLEFTCLOCKWISE,
		XML_TOPLEFTCOUNTERCLOCKWISE,
		XML_TOPRIGHTCOUNTERCLOCKWISE,
		XML_BOTTOMRIGHTCOUNTERCLOCKWISE,
		XML_BOTTOMLEFTCOUNTERCLOCKWISE,
		XML_VERTICALTOPSAME,
		XML_VERTICALBOTTOMSAME,
		XML_VERTICALTOPLEFTOPPOSITE,
		XML_VERTICALBOTTOMLEFTOPPOSITE,
		XML_HORIZONTALLEFTSAME,
		XML_HORIZONTALRIGHTSAME,
		XML_HORIZONTALTOPLEFTOPPOSITE,
		XML_HORIZONTALTOPRIGHTOPPOSITE,
		XML_DIAGONALBOTTOMLEFTOPPOSITE,
		XML_DIAGONALTOPLEFTOPPOSITE,
		XML_TWOBOXTOP,
		XML_TWOBOXBOTTOM,
		XML_TWOBOXLEFT,
		XML_TWOBOXRIGHT,
		XML_FOURBOXVERTICAL,
		XML_FOURBOXHORIZONTAL,
		XML_VERTICALLEFT,
		XML_VERTICALRIGHT,
		XML_HORIZONTALLEFT,
		XML_HORIZONTALRIGHT,
		XML_FROMLEFT,
		XML_FROMTOP,
		XML_FROMRIGHT,
		XML_FROMBOTTOM,
		XML_CROSSFADE,
		XML_FADETOCOLOR,
		XML_FADEFROMCOLOR,
		XML_FADEOVERCOLOR,
		XML_THREEBLADE,
		XML_EIGHTBLADE,
		XML_ONEBLADE,
		XML_ACROSS,
		XML_COMBHORIZONTAL,
		XML_COMBVERTICAL,
		XML_ROTATEIN,
		XML_ROTATEOUT,
		XML_FROMTOPLEFT,
		XML_FROMTOPRIGHT,
		XML_FROMBOTTOMLEFT,
		XML_FROMBOTTOMRIGHT,

		XML_SUBTYPE,
		XML_OUT,

		XML_FORWARD,
		XML_REVERSE,

		XML_FADECOLOR,

		XML_ONBEGIN,
		XML_ONEND,
		XML_CLICK,
		XML_DOUBLECLICK,
		XML_MOUSEOVER,
		XML_MOUSEOUT,

		XML_NODE_TYPE,
		XML_PRESET_ID,
		XML_PRESET_SUB_TYPE,
		XML_PRESET_CLASS,
		XML_CUSTOM,
		XML_ENTRANCE,
		XML_EXIT,
		XML_EMPHASIS,
		XML_MOTION_PATH,
		XML_OLE_ACTION,
		XML_MEDIA_CALL,
		XML_ON_CLICK,
		XML_WITH_PREVIOUS,
		XML_AFTER_PREVIOUS,
		XML_MAIN_SEQUENCE,
		XML_TIMING_ROOT,
		XML_INTERACTIVE_SEQUENCE,

		XML_SUB_ITEM,
		XML_ITERATE_TYPE,
		XML_ITERATE_INTERVAL,
		XML_ITERATE,
		XML_BY_PARAGRAPH,
		XML_BY_WORD,
		XML_BY_LETTER,

		XML_AFTER_EFFECT,
		XML_MASTER,

		XML_GROUP_ID,
		XML_TARGETELEMENT,
		XML_TOGGLE_PAUSE,
		XML_MASTER_ELEMENT,
		XML_STOP_AUDIO,

		XML_AUDIO_LEVEL,

		XML_URN_OASIS_NAMES_TC,
		XML_OPENDOCUMENT,
		XML_1_0,

        XML_IS_LIST_HEADER,
		XML_N_SVG_COMPAT,
		XML_N_FO_COMPAT,
		XML_N_SMIL_COMPAT,
		XML_N_SMIL_OLD,
        XML_XFORMS_SUBMISSION,
        XML_XFORMS_LIST_SOURCE,

        XML_URI_W3_PREFIX,
        XML_URI_XFORMS_SUFFIX,

        // --> OD 2005-05-12 #i49139#
        // XML_HORIZONTAL_ON_LEFT_PAGES and XML_HORIZONTAL_ON_RIGHT_PAGES
        // are replaced by XML_HORIZONTAL_ON_EVEN and XML_HORIZONTAL_ON_ODD.
        XML_HORIZONTAL_ON_EVEN,
		// --> OJ 2005-09-01
		XML_N_RPT_OASIS,
		XML_N_RPT,
		XML_GROUP,
		XML_GROUPS		,
		XML_REPORT_HEADER,
		XML_PAGE_HEADER	,
		XML_DETAIL		,
		XML_PAGE_FOOTER	,
		XML_REPORT_FOOTER,
		XML_START_NEW_COLUMN			,
		XML_RESET_PAGE_NUMBER			,
		XML_PRINT_HEADER_ON_EACH_PAGE	,
		XML_GROUP_EXPRESSION			,
		XML_GROUP_HEADER				,
		XML_GROUP_FOOTER				,
		XML_HEADER_ON_NEW_PAGE,
		XML_FOOTER_ON_NEW_PAGE,
		XML_PAGE_PRINT_OPTION,
		XML_PRE_EVALUATED,
		XML_COMMAND_TYPE,
		XML_MASTER_FIELDS,
		XML_DETAIL_FIELDS,
		XML_CONDITIONAL_PRINT_EXPRESSION,
		XML_REPORT_COMPONENT,
		XML_PRINT_REPEATED_VALUES,
		XML_REPEAT_SECTION,
		XML_FORCE_NEW_COLUMN,
		XML_GROUP_ON,
		XML_FORCE_NEW_PAGE,
		XML_GROUP_INTERVAL,
		XML_PRINT_ONLY_WHEN_GROUP_CHANGE,
		XML_REPORT_ELEMENT,
		XML_LIST_SOURCE,
		XML_LIST_SOURCE_TYPE,
		XML_IMAGE_DATA,
		XML_SELECTED,
		XML_CURRENT_STATE,
		XML_IS_TRISTATE,
		XML_ALL_PAGES,
		XML_NOT_WITH_REPORT_HEADER,
		XML_NOT_WITH_REPORT_FOOTER,
		XML_NOT_WITH_REPORT_HEADER_NOR_FOOTER,
		XML_BEFORE_SECTION,
		XML_AFTER_SECTION,
		XML_BEFORE_AFTER_SECTION,
		XML_PREFIX_CHARACTERS,
		XML_QUARTAL,
		XML_WEEK,
		XML_WHOLE_GROUP,
		XML_WITH_FIRST_DETAIL,
		XML_TOP_DOWN,
		XML_BOTTOM_UP,
		XML_HOUR,
		XML_MINUTE,
		XML_NP_RPT,
		XML_FORMAT_CONDITION,
		XML_EXPRESSION1,
		XML_EXPRESSION2,
		XML_EQUAL,
		XML_NOT_EQUAL,
		XML_LESS,
		XML_GREATER,
		XML_LESS_EQUAL,
		XML_GREATER_EQUAL,
		XML_BETWEEN,
		XML_NOT_BETWEEN,
		XML_TABLE_TEMPLATE,
		XML_FIRST_ROW,
		XML_LAST_ROW,
		XML_FIRST_COLUMN,
		XML_LAST_COLUMN,
		XML_EVEN_ROWS,
		XML_ODD_ROWS,
		XML_EVEN_COLUMNS,
		XML_ODD_COLUMNS,
		// <--
        XML_HORIZONTAL_ON_ODD,
        // <--
        // --> OD 2005-10-10 #i45874#
        XML_RESTART_NUMBERING,
        // <--
        // --> FLR #i52127#
        XML_NUMBERED_PARAGRAPH,
        // <--
        XML_MASTER_DETAIL_FIELDS,
        XML_MASTER_DETAIL_FIELD,
        XML_SUB_DOCUMENT,
		XML_FIXED_CONTENT,
        XML_INITIAL_FORMULA,
        XML_DEEP_TRAVERSING,
		XML_PRESERVE_IRI,
        XML_SORT_BY_X_VALUES,
        XML_PAGE_CONTINUATION,
        XML_RIGHT_ANGLED_AXES,
        XML_SOFT_PAGE_BREAK,
        XML_USE_SOFT_PAGE_BREAKS,
        XML_PERCENTAGE_DATA_STYLE_NAME,
        XML_VALUE_AND_PERCENTAGE,
        XML_GROUP_BARS_PER_AXIS,
        XML_INCLUDE_HIDDEN_CELLS,
        XML_AUTOMATIC_POSITION,
        XML_AUTOMATIC_SIZE,
        XML_REVERSE_DIRECTION,
        XML_LABEL_SEPARATOR,
        XML_LABEL_POSITION,
        XML_AVOID_OVERLAP,
        XML_NEAR_ORIGIN,
        XML_DEPENDENCY,
        XML_NAV_ORDER,

		XML_USE_FIRST_ROW_STYLES,
		XML_USE_LAST_ROW_STYLES,
		XML_USE_FIRST_COLUMN_STYLES,
		XML_USE_LAST_COLUMN_STYLES,
		XML_USE_BANDING_ROWS_STYLES,
		XML_USE_BANDING_COLUMNS_STYLES,

		XML_AUTOMATIC_CONTENT,
        XML_DISPLAY_R_SQUARE,
        XML_DISPLAY_EQUATION,
        // db odf 12
        XML_TABLE_REPRESENTATIONS,
        XML_TABLE_REPRESENTATION,
        XML_SCHEMA_DEFINITION,
        XML_CONNECTION_DATA,
        XML_DATABASE_DESCRIPTION,
        XML_COMPOUND_DATABASE,
        XML_FILE_BASED_DATABASE,
        XML_SERVER_DATABASE,
        XML_MEDIA_TYPE,
        XML_HOSTNAME,
        XML_PORT,
        XML_LOCAL_SOCKET,
        XML_USE_SYSTEM_USER,
        XML_DRIVER_SETTINGS,
        XML_JAVA_CLASSPATH,
        XML_CHARACTER_SET,
        XML_APPLICATION_CONNECTION_SETTINGS,
        XML_TABLE_INCLUDE_FILTER,
		XML_DEFAULT_ROW_STYLE_NAME,
        XML_ANGLE_OFFSET,
        // --> OD 2007-09-14 #i81002#
        XML_NUMBER_NO_SUPERIOR,
        XML_NUMBER_ALL_SUPERIOR,
        // <--
        // --> OD 2008-01-15 #newlistlevelattrs#
        XML_LIST_LEVEL_POSITION_AND_SPACE_MODE,
        XML_LABEL_WIDTH_AND_POSITION,
        XML_LABEL_ALIGNMENT,
        XML_LIST_LEVEL_LABEL_ALIGNMENT,
        XML_LABEL_FOLLOWED_BY,
        XML_LISTTAB,
        XML_SPACE,
        XML_NOTHING,
        XML_LIST_TAB_STOP_POSITION,
        // <--
        XML_STANDARD_ERROR,
        XML_CELL_RANGE,
        XML_ERROR_LOWER_RANGE,
        XML_ERROR_UPPER_RANGE,

        // --> OD 2008-04-22 #refactorlists#
        XML_CONTINUE_LIST,
        XML_STYLE_OVERRIDE,
        // <--

        // fs: #i90243#
        XML_XFORM_MODEL_SETTINGS,

        // ODF 1.2 metadata
        XML_META_FIELD,
        XML_ABOUT,
        XML_DATATYPE,
        XML_TRANSFORMATION,

        // ODF 1.2 numbered-paragraph
        XML_LIST_ID,

        XML_TREAT_EMPTY_CELLS,
        XML_LEAVE_GAP,
        XML_USE_ZERO,
        XML_IGNORE,

        // enhanced fields
        XML_FIELDMARK,
        XML_FIELDMARK_START,
        XML_FIELDMARK_END,
        XML_N_FIELD,
        XML_NP_FIELD,

        XML_IMAGE_SCALE,
        XML_ISOTROPIC,
        XML_ANISOTROPIC,

        XML_AXIS_POSITION,
        XML_AXIS_LABEL_POSITION,
        XML_NEAR_AXIS,
        XML_NEAR_AXIS_OTHER_SIDE,
        XML_OUTSIDE_START,
        XML_OUTSIDE_END,
        XML_TICK_MARK_POSITION,
        XML_AT_LABELS,
        XML_AT_AXIS,
        XML_AT_LABELS_AND_AXIS,
        XML_FILLED_RADAR,
        XML_SURFACE,

        // MathML only
        XML_MATHVARIANT, 
        XML_MATHSIZE, 
        XML_MATHWEIGHT, 
        XML_MATHCOLOR,

        XML_CONTAINS,
        XML_DOES_NOT_CONTAIN,
        XML_BEGINS_WITH,
        XML_DOES_NOT_BEGIN_WITH,
        XML_ENDS_WITH,
        XML_DOES_NOT_END_WITH,

        XML_TOKEN_END
    };


    /// return the OUString representation for eToken
    XMLOFF_DLLPUBLIC const ::rtl::OUString& GetXMLToken(
        enum XMLTokenEnum eToken );

    /// compare eToken to the string
    XMLOFF_DLLPUBLIC sal_Bool IsXMLToken(
        const ::rtl::OUString& rString,
        enum XMLTokenEnum eToken );

    // gives all allocated memory for OUString* back
    XMLOFF_DLLPUBLIC void ResetTokens();

    XMLOFF_DLLPUBLIC void IncRescheduleCount();

    XMLOFF_DLLPUBLIC void DecRescheduleCount();


} }

#endif
