//                                               -*- C++ -*-
/**
 *  @file  ComparisonOperatorImplementation.cxx
 *  @brief Abstract top-level class for all ComparisonOperatorImplementation
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: ComparisonOperatorImplementation.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "ComparisonOperatorImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      CLASSNAMEINIT(ComparisonOperatorImplementation);

      /* Default constructor */
      ComparisonOperatorImplementation::ComparisonOperatorImplementation()
	: PersistentObject()
      {
	// Nothing to do
      }

      /* String converter */
      String ComparisonOperatorImplementation::__repr__() const {
	return OSS() << "class=" << ComparisonOperatorImplementation::GetClassName()
		     << " name=" << getName();
      }
  

      /* Here is the interface that all derived class must implement */

      /* Method save() stores the object through the StorageManager */
      void ComparisonOperatorImplementation::save(StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void ComparisonOperatorImplementation::load(StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
