//                                               -*- C++ -*-
/**
 *  @file  OSS.cxx
 *  @brief The class OSS streams out objects
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: OSS.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "OSS.hxx"
#include "PlatformInfo.hxx"

namespace OpenTURNS
{

  OSS::OSS(bool full) : oss_(), precision_(Base::Common::PlatformInfo::GetNumericalPrecision()), full_(full) {}

  OSS::operator std::string() const
  {
    return oss_.str();
  }

  void OSS::clear()
  {
    oss_.clear();
  }

} /* namespace OpenTURNS */
