//                                               -*- C++ -*-
/**
 *  @file  ComputedNumericalMathHessianImplementation.hxx
 *  @brief Abstract top-level class for all ComputedNumerical math hessians
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: ComputedNumericalMathHessianImplementation.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_COMPUTEDNUMERICALMATHHESSIANIMPLEMENTATION_HXX
#define OPENTURNS_COMPUTEDNUMERICALMATHHESSIANIMPLEMENTATION_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "Pointer.hxx"
#include "NumericalPoint.hxx"
#include "SymmetricTensor.hxx"
#include "WrapperFile.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /* Forward declaration */
      class WrapperObject;

      /**
       * @class ComputedNumericalMathHessianImplementation
       *
       * This class acts like an real numerical mathematical hessian
       * into the platform. It realizes the computation of the image tensor
       * of a vector (aka NumericalPoint) through the hessian. The
       * hessian may be loaded in an external way through a wrapper.
       */
      class ComputedNumericalMathHessianImplementation 
	: public NumericalMathHessianImplementation
      {
	CLASSNAME;

      public:

	/* Some typedefs to ease reading */
	typedef Common::WrapperInternalException                             WrapperInternalException;
	typedef NumericalMathHessianImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathHessianImplementation::InternalException        InternalException;
	typedef Common::Pointer<WrapperObject>                               InternalHessian;
	typedef NumericalMathHessianImplementation::NumericalPoint           NumericalPoint;
	typedef NumericalMathHessianImplementation::SymmetricTensor          SymmetricTensor;

	/** Default constructor */
	ComputedNumericalMathHessianImplementation(const String & name, const WrapperFile & file, void * p_state = 0)
	  /* throw(WrapperInternalException) */;

	/** Copy constructor */
	ComputedNumericalMathHessianImplementation(const ComputedNumericalMathHessianImplementation & other)
	  /* throw(WrapperInternalException) */;

	/** Virtual constructor */
	virtual ComputedNumericalMathHessianImplementation * clone() const;

	/** Destructor */
	virtual ~ComputedNumericalMathHessianImplementation();

	/** Comparison operator */
	Bool operator ==(const ComputedNumericalMathHessianImplementation & other) const;

	/** String converter */
	String __repr__() const;



	/* Here is the interface that all derived class must implement */
	
	/** Hessian method */
	virtual SymmetricTensor hessian(const NumericalPoint & in) const
	  /* throw(InvalidArgumentException,InternalException) */;

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

 	/** Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(StorageManager::Advocate & adv);

      protected:

	/** The function object that is linked to the external code */
	InternalHessian p_hessian_;

	/** State management */
    	void * getState() const;

      private:
	ComputedNumericalMathHessianImplementation() {};
	friend class Common::Factory<ComputedNumericalMathHessianImplementation>;

	/** A pointer to an internal structure that saves the state of the function into the wrapper */
	void * p_state_;

	/** A flag that is true when the gradient shares its internal state with its related function */
	Bool commonState_;

      }; /* class ComputedNumericalMathHessianImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPUTEDNUMERICALMATHHESSIANIMPLEMENTATION_HXX */
