//                                               -*- C++ -*-
/**
 *  @file  NearestPointCheckerResult.cxx
 *  @brief Result stores the result of a NearestPointChecker
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NearestPointCheckerResult.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "NearestPointChecker.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(NearestPointChecker::Result);

      /* Default constructor */
      NearestPointChecker::Result::Result():
	PersistentObject(),
	verifyingConstraintPoints_(NumericalSample(0,0)),
	verifyingConstraintValues_(NumericalSample(0,0)),
	violatingConstraintPoints_(NumericalSample(0,0)),
	violatingConstraintValues_(NumericalSample(0,0))
      {
	// Nothing to do
      }    

      /* Standard constructor */
      NearestPointChecker::Result::Result(const NumericalSample & verifyingConstraintPoints,
                                          const NumericalSample & verifyingConstraintValues,
					  const NumericalSample & violatingConstraintPoints,
					  const NumericalSample & violatingConstraintValues):
	PersistentObject(),
	verifyingConstraintPoints_(verifyingConstraintPoints),
	verifyingConstraintValues_(verifyingConstraintValues),
	violatingConstraintPoints_(violatingConstraintPoints),
	violatingConstraintValues_(violatingConstraintValues)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      NearestPointChecker::Result * NearestPointChecker::Result::clone() const
      {
	return new Result(*this);
      }

      /* verifyingConstraintPoints accessor */
      NearestPointChecker::NumericalSample  NearestPointChecker::Result::getVerifyingConstraintPoints() const
      {
	return verifyingConstraintPoints_;
      }

      /* verifyingConstraintValues accessor */
      NearestPointChecker::NumericalSample  NearestPointChecker::Result::getVerifyingConstraintValues() const
      {
	return verifyingConstraintValues_;
      }

      /* violatingConstraintPoints accessor */
      NearestPointChecker::NumericalSample  NearestPointChecker::Result::getViolatingConstraintPoints() const
      {
	return violatingConstraintPoints_;
      }

      /* violatingConstraintValues accessor */
      NearestPointChecker::NumericalSample  NearestPointChecker::Result::getViolatingConstraintValues() const
      {
	return violatingConstraintValues_;
      }

      /* verifyingConstraintPoints accessor */
      void NearestPointChecker::Result::setVerifyingConstraintPoints(const NumericalSample & verifyingConstraintPoints)
      {
	verifyingConstraintPoints_ = verifyingConstraintPoints;
      }

      /* verifyingConstraintValues accessor */
      void NearestPointChecker::Result::setVerifyingConstraintValues(const NumericalSample & verifyingConstraintValues)
      {
	verifyingConstraintValues_ = verifyingConstraintValues;
      }

      /* violatingConstraintPoints accessor */
      void NearestPointChecker::Result::setViolatingConstraintPoints(const NumericalSample & violatingConstraintPoints)
      {
	violatingConstraintPoints_ = violatingConstraintPoints;
      }

      /* violatingConstraintValues accessor */
      void NearestPointChecker::Result::setViolatingConstraintValues(const NumericalSample & violatingConstraintValues)
      {
	violatingConstraintValues_ = violatingConstraintValues;
      }

      /* String converter */
      String NearestPointChecker::Result::__repr__() const
      {
	OSS oss;
	oss << "class=" << NearestPointChecker::Result::GetClassName()
	    << " violatingConstraintPoints=" << violatingConstraintPoints_
            << " violatingConstraintValues=" << violatingConstraintValues_
	    << " verifyingConstraintPoints=" << verifyingConstraintPoints_
	    << " verifyingConstraintValues=" << verifyingConstraintValues_;
	return oss;
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */
