//                                               -*- C++ -*-
/**
 *  @file  RootStrategy.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: RootStrategy.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "RootStrategy.hxx"
#include "SafeAndSlow.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class RootStrategy
       */

      CLASSNAMEINIT(RootStrategy);

      /* Constructor with parameters */
      RootStrategy::RootStrategy(const RootStrategyImplementation & implementation)
	: Base::Common::TypedInterfaceObject<RootStrategyImplementation>(implementation.clone())
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      RootStrategy::RootStrategy(Implementation & p_implementation)
	: Base::Common::TypedInterfaceObject<RootStrategyImplementation>(p_implementation)
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      RootStrategy::RootStrategy()
	: Base::Common::TypedInterfaceObject<RootStrategyImplementation>(new SafeAndSlow())
      {
	// Nothing to do
      }

      /* Solve gives all the roots found applying the root strategy */
      RootStrategy::NumericalScalarCollection RootStrategy::solve(const NumericalMathFunction & function,
								  const NumericalScalar value)
      {
	return getImplementation()->solve(function, value);
      }

      /* Solver accessor */
      void RootStrategy::setSolver(const Solver & solver)
      {
	getImplementation()->setSolver(solver);
      }

      RootStrategy::Solver RootStrategy::getSolver() const
      {
	return getImplementation()->getSolver();
      }

      /* Maximum distance accessor */
      void RootStrategy::setMaximumDistance(const NumericalScalar maximumDistance)
      {
	getImplementation()->setMaximumDistance(maximumDistance);
      }

      NumericalScalar RootStrategy::getMaximumDistance() const
      {
	return getImplementation()->getMaximumDistance();
      }

      /* Step size accessor */
      void RootStrategy::setStepSize(const NumericalScalar stepSize)
      {
	getImplementation()->setStepSize(stepSize);
      }

      NumericalScalar RootStrategy::getStepSize() const
      {
	return getImplementation()->getStepSize();
      }

      /* Value of the performance function at the origin accessor */
      void RootStrategy::setOriginValue(const NumericalScalar originValue)
      {
	getImplementation()->setOriginValue(originValue);
      }

      NumericalScalar RootStrategy::getOriginValue() const
      {
	return getImplementation()->getOriginValue();
      }

      /* String converter */
      String RootStrategy::__repr__() const
      {
	OSS oss;
	oss << "class=" << RootStrategy::GetClassName()
	    << " implementation=" << getImplementation()->__repr__();
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
