//                                               -*- C++ -*-
/**
 *  @file  Wilks.hxx
 *  @brief Wilks is a static class that gives access to the computation of the sample size for guaranteed upper bound of quantile
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Wilks.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_WILKS_HXX
#define OPENTURNS_WILKS_HXX

#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {


      /**
       * @class Wilks
       */

      class Wilks
      {

      public:

	typedef Base::Common::InvalidArgumentException InvalidArgumentException;

	/** Maximum sample size accessor */
	static UnsignedLong ComputeSampleSize(const NumericalScalar quantileLevel, 
					      const NumericalScalar confidenceLevel, 
					      const UnsignedLong marginIndex=0)
	  /* throw(InvalidArgumentException) */;

      private:

	/** Default constructor */
	Wilks() {}

      } ; /* class Wilks */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_WILKS_HXX */
