//                                               -*- C++ -*-
/**
 *  @file  Copula.hxx
 *  @brief Abstract top-level class for all copula
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Copula.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_COPULA_HXX
#define OPENTURNS_COPULA_HXX

#include "Distribution.hxx"

namespace OpenTURNS {
  
  namespace Uncertainty {
    
    namespace Model {
      
      /*
       * @class Copula
       *
       * The class describes the probabilistic concept of distribution.
       * Instances of this class can produce samples following the
       * distribution, can compute PDF or CDF, etc.
       * They are the actual key component of RandomVectors.
       */
      class Copula 
	: public Distribution
      {
	CLASSNAME;
      public:
	
	typedef Distribution::Implementation Implementation;
	
	/* Default constructor */
	Copula();
	
	/* Constructor from distribution */
	Copula(const Distribution & distribution);
	
	/* Constructor from implementation */
	Copula(const DistributionImplementation & implementation,
	       const String & name = OT::DefaultName);
	
	/* Constructor from implementation */
	Copula(const Implementation & p_implementation,
	       const String & name = OT::DefaultName);

      }; /* class Copula */

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COPULA_HXX */
